// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const ObjectBrowser1Icon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g data-name="Object Browser" clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <g data-name="Grupo 1559">
        <g data-name="Grupo 1541" transform="translate(88.095 103.898)">
          <circle
            data-name="Elipse 57"
            cx={11.515}
            cy={11.515}
            r={11.515}
            transform="rotate(-10.901 280.738 -178.561)"
          />
          <rect
            data-name="Rect\xE1ngulo 805"
            width={24.592}
            height={20.853}
            rx={1.35}
            transform="translate(14.546 25.545)"
          />
          <path
            data-name="Trazado 365"
            d="M28.151 60.295a2.427 2.427 0 0 0-4.2 0l-9.1 15.761a2.425 2.425 0 0 0 2.1 3.64h18.2a2.43 2.43 0 0 0 2.105-3.64Z"
          />
          <path
            data-name="Trazado 366"
            d="M79.273 28.199a151.334 151.334 0 0 0-.187-17.51c-.395-4.294-2.262-7.942-6.512-9.468a15.5 15.5 0 0 0-1.836-.529 38.335 38.335 0 0 0-7.332-.658c-4.289-.125-8.57.136-12.855.116-8.582-.036-17.16.116-25.746.152H6.301a6.308 6.308 0 0 0-6.3 6.3v80.617a6.307 6.307 0 0 0 6.3 6.3h66.684a6.3 6.3 0 0 0 6.3-6.3V47.054c-.004-6.273-.168-12.584-.012-18.855Zm-7.648 53.334a5.435 5.435 0 0 1-5.434 5.439h-54.2a5.442 5.442 0 0 1-5.441-5.439V12.3a5.441 5.441 0 0 1 5.441-5.442h36.367v9.3a13.809 13.809 0 0 0 13.789 13.794h9.48Zm0-57.6h-9.48a7.781 7.781 0 0 1-7.773-7.777v-9.3h11.82a5.435 5.435 0 0 1 5.434 5.442Z"
          />
        </g>
        <path
          data-name="Trazado 367"
          d="M101.726 42.067c6.607 0 13.691 18.858 20.771 18.858h88.056a9.46 9.46 0 0 1 9.439 9.429v4.715H40.348V51.496h-.235a9.462 9.462 0 0 1 9.439-9.429h52.174m124.392 44.5a9.812 9.812 0 0 1 9.787 9.772l-10.03 107.756a9.811 9.811 0 0 1-9.787 9.771H39.671a9.808 9.808 0 0 1-9.787-9.771L20.093 96.339a9.813 9.813 0 0 1 9.791-9.772h196.233M101.725 21.999H49.551a29.549 29.549 0 0 0-29.533 29.5 20 20 0 0 0 .235 3.081v13.513A29.9 29.9 0 0 0-.002 96.344c0 .605.031 1.208.086 1.814l9.724 107.089a29.9 29.9 0 0 0 29.862 28.691h176.417a29.9 29.9 0 0 0 29.854-28.663l9.975-107.074c.051-.617.082-1.239.082-1.857a29.87 29.87 0 0 0-15.909-26.376 29.555 29.555 0 0 0-29.537-29.106h-81.5c-.4-.532-.786-1.059-1.123-1.517-5.1-6.906-12.8-17.342-26.2-17.342Z"
        />
      </g>
      <path data-name="Rect\xE1ngulo 875" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default ObjectBrowser1Icon;
