// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const TraceMenuIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 12 12"
    {...props}
  >
    <g id="trace-icon" transform="translate(0 0)">
      <path
        id="trace-icn"
        d="M-4327.66-381.522l2.667,2.932v5.186a.377.377,0,0,1-.383.368h-.566a.379.379,0,0,1-.384-.368v-4.614l-2.666-3.135v-3.477a.376.376,0,0,1,.382-.368h.567a.376.376,0,0,1,.383.368Zm2.667-3.109a.377.377,0,0,0-.383-.368h-.566a.378.378,0,0,0-.384.368v3.332l2.668,3.135v4.758a.377.377,0,0,0,.383.368h.567a.377.377,0,0,0,.382-.368v-5.33l-2.667-2.931Zm2.284-.368h-.567a.377.377,0,0,0-.383.368v1.827a.377.377,0,0,0,.383.368h.567a.377.377,0,0,0,.382-.368v-1.827A.377.377,0,0,0-4322.709-385Zm2.1,5.554h.568a.377.377,0,0,0,.383-.368v-4.817a.377.377,0,0,0-.383-.368h-.568a.377.377,0,0,0-.383.368v4.817A.377.377,0,0,0-4320.61-379.445Zm3.233-5.554h-.567a.377.377,0,0,0-.383.368v1.827a.377.377,0,0,0,.383.368h.567a.377.377,0,0,0,.384-.368v-1.827A.377.377,0,0,0-4317.376-385Zm0,8.117h-.567a.377.377,0,0,0-.383.368v3.108a.377.377,0,0,0,.383.368h.567a.377.377,0,0,0,.384-.368v-3.108A.377.377,0,0,0-4317.376-376.882Zm0-3.845h-.567a.377.377,0,0,0-.383.368v.828l-2.667,2.648v3.477a.377.377,0,0,0,.383.368h.568a.377.377,0,0,0,.383-.368v-2.622l2.667-3.135v-1.2A.377.377,0,0,0-4317.376-380.727Zm-10.667,2.136h-.567a.376.376,0,0,0-.382.368v4.817a.376.376,0,0,0,.382.368h.567a.376.376,0,0,0,.383-.368v-4.817A.376.376,0,0,0-4328.043-378.591Z"
        transform="translate(4328.993 384.999)"
      />
      <rect
        id="Rectángulo_880"
        data-name="Rectángulo 880"
        width="11.078"
        height="11.844"
        transform="translate(0.472 0.156)"
        fill="none"
      />
    </g>
  </svg>
);

export default TraceMenuIcon;
