// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const TenantsIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 394"
        d="M222.617 88.875a26.012 26.012 0 0 0-23.281 14.452l-44.307-6.454a74.856 74.856 0 0 0 2.892-20.607A74.732 74.732 0 0 0 83.285 1.439 74.732 74.732 0 0 0 8.643 76.266a74.763 74.763 0 0 0 65.415 74.236l-1.38 25.452c-.127-.006-.249-.019-.371-.019a18.44 18.44 0 0 0-18.42 18.46 18.441 18.441 0 0 0 18.42 18.466 18.443 18.443 0 0 0 18.42-18.466 18.459 18.459 0 0 0-7.851-15.108l1.535-28.223a74.164 74.164 0 0 0 32.006-7.749l39.5 51.413a36.849 36.849 0 0 0-10.488 25.784 36.884 36.884 0 0 0 36.84 36.927 36.88 36.88 0 0 0 36.834-36.927 36.881 36.881 0 0 0-36.834-36.931 36.539 36.539 0 0 0-18.137 4.811l-38.7-50.376a75.035 75.035 0 0 0 25.967-31.174l45.242 6.59c-.029.519-.078 1.032-.078 1.556a26.082 26.082 0 0 0 26.051 26.112 26.082 26.082 0 0 0 26.05-26.112 26.082 26.082 0 0 0-26.047-26.113Z"
      />
      <path
        data-name="Trazado 395"
        d="M181.396 256a38.679 38.679 0 0 1-38.636-38.643 38.393 38.393 0 0 1 9.576-25.436l-36.435-47.307a74.862 74.862 0 0 1-28.494 6.932l-1.318 24.217a20.571 20.571 0 0 1 7.657 15.975 20.545 20.545 0 0 1-20.52 20.514 20.54 20.54 0 0 1-20.518-20.514 20.549 20.549 0 0 1 18.6-20.432l1.125-20.571A75.865 75.865 0 0 1 8.2 75.818 75.907 75.907 0 0 1 84.02-.005a75.908 75.908 0 0 1 75.822 75.823 75.76 75.76 0 0 1-2.229 18.236l39.257 5.7a27.844 27.844 0 0 1 24.216-13.965 28.051 28.051 0 0 1 28.018 28.022 28.051 28.051 0 0 1-28.018 28.022 28.052 28.052 0 0 1-28.02-27.48l-40.61-5.9a76.059 76.059 0 0 1-23.551 28.463l35.308 45.854a38.644 38.644 0 0 1 17.18-4.049 38.678 38.678 0 0 1 38.633 38.634A38.678 38.678 0 0 1 181.396 256Zm-64.078-117.413 41.329 53.665-1.453 1.492a33.619 33.619 0 0 0-9.635 23.618 33.876 33.876 0 0 0 33.837 33.84 33.875 33.875 0 0 0 33.835-33.84 33.874 33.874 0 0 0-33.835-33.837 33.822 33.822 0 0 0-16.657 4.409l-1.814 1.027-40.89-53.094 2.092-1.434a71.22 71.22 0 0 0 24.718-29.586l.739-1.65 48.482 7.038-.133 2.2c-.049.739-.073 1.055-.073 1.381a23.253 23.253 0 0 0 23.227 23.225 23.249 23.249 0 0 0 23.222-23.225 23.246 23.246 0 0 0-23.222-23.224 23.1 23.1 0 0 0-20.759 12.852l-.776 1.549-48.012-6.975.759-2.639a71.253 71.253 0 0 0 2.749-19.559A71.1 71.1 0 0 0 84.022 4.794 71.1 71.1 0 0 0 12.999 75.82a71.061 71.061 0 0 0 62.243 70.465l2.225.273-1.608 29.524-2.318-.043h-.037a15.779 15.779 0 0 0-16 15.7 15.739 15.739 0 0 0 15.721 15.717 15.741 15.741 0 0 0 15.722-15.717 15.763 15.763 0 0 0-6.7-12.866l-1.09-.763 1.7-31.26 2.235-.033a70.305 70.305 0 0 0 30.455-7.355Z"
      />
      <path data-name="Rect\xE1ngulo 868" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default TenantsIcon;
