// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package bucket

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// MakeBucketCreatedCode is the HTTP code returned for type MakeBucketCreated
const MakeBucketCreatedCode int = 201

/*
MakeBucketCreated A successful response.

swagger:response makeBucketCreated
*/
type MakeBucketCreated struct {
}

// NewMakeBucketCreated creates MakeBucketCreated with default headers values
func NewMakeBucketCreated() *MakeBucketCreated {

	return &MakeBucketCreated{}
}

// WriteResponse to the client
func (o *MakeBucketCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(201)
}

/*
MakeBucketDefault Generic error response.

swagger:response makeBucketDefault
*/
type MakeBucketDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewMakeBucketDefault creates MakeBucketDefault with default headers values
func NewMakeBucketDefault(code int) *MakeBucketDefault {
	if code <= 0 {
		code = 500
	}

	return &MakeBucketDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the make bucket default response
func (o *MakeBucketDefault) WithStatusCode(code int) *MakeBucketDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the make bucket default response
func (o *MakeBucketDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the make bucket default response
func (o *MakeBucketDefault) WithPayload(payload *models.Error) *MakeBucketDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the make bucket default response
func (o *MakeBucketDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *MakeBucketDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
