// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package logging

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NewLogSearchParams creates a new LogSearchParams object
// with the default values initialized.
func NewLogSearchParams() LogSearchParams {

	var (
		// initialize parameters with default values

		orderDefault    = string("timeDesc")
		pageNoDefault   = int32(0)
		pageSizeDefault = int32(10)
	)

	return LogSearchParams{
		Order: &orderDefault,

		PageNo: &pageNoDefault,

		PageSize: &pageSizeDefault,
	}
}

// LogSearchParams contains all the bound params for the log search operation
// typically these are obtained from a http.Request
//
// swagger:parameters LogSearch
type LogSearchParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Filter Parameters
	  In: query
	  Collection Format: multi
	*/
	Fp []string
	/*
	  In: query
	  Default: "timeDesc"
	*/
	Order *string
	/*
	  In: query
	  Default: 0
	*/
	PageNo *int32
	/*
	  In: query
	  Default: 10
	*/
	PageSize *int32
	/*
	  In: query
	*/
	TimeStart *string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewLogSearchParams() beforehand.
func (o *LogSearchParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qFp, qhkFp, _ := qs.GetOK("fp")
	if err := o.bindFp(qFp, qhkFp, route.Formats); err != nil {
		res = append(res, err)
	}

	qOrder, qhkOrder, _ := qs.GetOK("order")
	if err := o.bindOrder(qOrder, qhkOrder, route.Formats); err != nil {
		res = append(res, err)
	}

	qPageNo, qhkPageNo, _ := qs.GetOK("pageNo")
	if err := o.bindPageNo(qPageNo, qhkPageNo, route.Formats); err != nil {
		res = append(res, err)
	}

	qPageSize, qhkPageSize, _ := qs.GetOK("pageSize")
	if err := o.bindPageSize(qPageSize, qhkPageSize, route.Formats); err != nil {
		res = append(res, err)
	}

	qTimeStart, qhkTimeStart, _ := qs.GetOK("timeStart")
	if err := o.bindTimeStart(qTimeStart, qhkTimeStart, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindFp binds and validates array parameter Fp from query.
//
// Arrays are parsed according to CollectionFormat: "multi" (defaults to "csv" when empty).
func (o *LogSearchParams) bindFp(rawData []string, hasKey bool, formats strfmt.Registry) error {
	// CollectionFormat: multi
	fpIC := rawData
	if len(fpIC) == 0 {
		return nil
	}

	var fpIR []string
	for _, fpIV := range fpIC {
		fpI := fpIV

		fpIR = append(fpIR, fpI)
	}

	o.Fp = fpIR

	return nil
}

// bindOrder binds and validates parameter Order from query.
func (o *LogSearchParams) bindOrder(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewLogSearchParams()
		return nil
	}
	o.Order = &raw

	if err := o.validateOrder(formats); err != nil {
		return err
	}

	return nil
}

// validateOrder carries on validations for parameter Order
func (o *LogSearchParams) validateOrder(formats strfmt.Registry) error {

	if err := validate.EnumCase("order", "query", *o.Order, []interface{}{"timeDesc", "timeAsc"}, true); err != nil {
		return err
	}

	return nil
}

// bindPageNo binds and validates parameter PageNo from query.
func (o *LogSearchParams) bindPageNo(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewLogSearchParams()
		return nil
	}

	value, err := swag.ConvertInt32(raw)
	if err != nil {
		return errors.InvalidType("pageNo", "query", "int32", raw)
	}
	o.PageNo = &value

	return nil
}

// bindPageSize binds and validates parameter PageSize from query.
func (o *LogSearchParams) bindPageSize(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewLogSearchParams()
		return nil
	}

	value, err := swag.ConvertInt32(raw)
	if err != nil {
		return errors.InvalidType("pageSize", "query", "int32", raw)
	}
	o.PageSize = &value

	return nil
}

// bindTimeStart binds and validates parameter TimeStart from query.
func (o *LogSearchParams) bindTimeStart(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.TimeStart = &raw

	return nil
}
