// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package object

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NewDeleteObjectParams creates a new DeleteObjectParams object
//
// There are no default values defined in the spec.
func NewDeleteObjectParams() DeleteObjectParams {

	return DeleteObjectParams{}
}

// DeleteObjectParams contains all the bound params for the delete object operation
// typically these are obtained from a http.Request
//
// swagger:parameters DeleteObject
type DeleteObjectParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*
	  In: query
	*/
	AllVersions *bool
	/*
	  Required: true
	  In: path
	*/
	BucketName string
	/*
	  In: query
	*/
	NonCurrentVersions *bool
	/*
	  Required: true
	  In: query
	*/
	Path string
	/*
	  In: query
	*/
	Recursive *bool
	/*
	  In: query
	*/
	VersionID *string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewDeleteObjectParams() beforehand.
func (o *DeleteObjectParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qAllVersions, qhkAllVersions, _ := qs.GetOK("all_versions")
	if err := o.bindAllVersions(qAllVersions, qhkAllVersions, route.Formats); err != nil {
		res = append(res, err)
	}

	rBucketName, rhkBucketName, _ := route.Params.GetOK("bucket_name")
	if err := o.bindBucketName(rBucketName, rhkBucketName, route.Formats); err != nil {
		res = append(res, err)
	}

	qNonCurrentVersions, qhkNonCurrentVersions, _ := qs.GetOK("non_current_versions")
	if err := o.bindNonCurrentVersions(qNonCurrentVersions, qhkNonCurrentVersions, route.Formats); err != nil {
		res = append(res, err)
	}

	qPath, qhkPath, _ := qs.GetOK("path")
	if err := o.bindPath(qPath, qhkPath, route.Formats); err != nil {
		res = append(res, err)
	}

	qRecursive, qhkRecursive, _ := qs.GetOK("recursive")
	if err := o.bindRecursive(qRecursive, qhkRecursive, route.Formats); err != nil {
		res = append(res, err)
	}

	qVersionID, qhkVersionID, _ := qs.GetOK("version_id")
	if err := o.bindVersionID(qVersionID, qhkVersionID, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindAllVersions binds and validates parameter AllVersions from query.
func (o *DeleteObjectParams) bindAllVersions(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("all_versions", "query", "bool", raw)
	}
	o.AllVersions = &value

	return nil
}

// bindBucketName binds and validates parameter BucketName from path.
func (o *DeleteObjectParams) bindBucketName(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.BucketName = raw

	return nil
}

// bindNonCurrentVersions binds and validates parameter NonCurrentVersions from query.
func (o *DeleteObjectParams) bindNonCurrentVersions(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("non_current_versions", "query", "bool", raw)
	}
	o.NonCurrentVersions = &value

	return nil
}

// bindPath binds and validates parameter Path from query.
func (o *DeleteObjectParams) bindPath(rawData []string, hasKey bool, formats strfmt.Registry) error {
	if !hasKey {
		return errors.Required("path", "query", rawData)
	}
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// AllowEmptyValue: false

	if err := validate.RequiredString("path", "query", raw); err != nil {
		return err
	}
	o.Path = raw

	return nil
}

// bindRecursive binds and validates parameter Recursive from query.
func (o *DeleteObjectParams) bindRecursive(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("recursive", "query", "bool", raw)
	}
	o.Recursive = &value

	return nil
}

// bindVersionID binds and validates parameter VersionID from query.
func (o *DeleteObjectParams) bindVersionID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.VersionID = &raw

	return nil
}
