/*
Slurm Rest API RO

API to access Slurm. Only GET requests are implemented.

API version: 0.0.38
Contact: sales@schedmd.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package v0038

import (
	"encoding/json"
)

// checks if the V0038DiagStatistics type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &V0038DiagStatistics{}

// V0038DiagStatistics Slurm statistics
type V0038DiagStatistics struct {
	// partition records packed
	PartsPacked *int32 `json:"parts_packed,omitempty"`
	// generation time
	ReqTime *int32 `json:"req_time,omitempty"`
	// data since
	ReqTimeStart *int32 `json:"req_time_start,omitempty"`
	// Server thread count
	ServerThreadCount *int32 `json:"server_thread_count,omitempty"`
	// Agent queue size
	AgentQueueSize *int32 `json:"agent_queue_size,omitempty"`
	// Agent count
	AgentCount *int32 `json:"agent_count,omitempty"`
	// Agent thread count
	AgentThreadCount *int32 `json:"agent_thread_count,omitempty"`
	// DBD Agent queue size
	DbdAgentQueueSize *int32 `json:"dbd_agent_queue_size,omitempty"`
	// Latency for 1000 calls to gettimeofday()
	GettimeofdayLatency *int32 `json:"gettimeofday_latency,omitempty"`
	// Main Schedule max cycle
	ScheduleCycleMax *int32 `json:"schedule_cycle_max,omitempty"`
	// Main Schedule last cycle
	ScheduleCycleLast *int32 `json:"schedule_cycle_last,omitempty"`
	// Main Schedule cycle iterations
	ScheduleCycleTotal *int32 `json:"schedule_cycle_total,omitempty"`
	// Average time for Schedule Max cycle
	ScheduleCycleMean *int32 `json:"schedule_cycle_mean,omitempty"`
	// Average depth for Schedule Max cycle
	ScheduleCycleMeanDepth *int32 `json:"schedule_cycle_mean_depth,omitempty"`
	// Main Schedule Cycles per minute
	ScheduleCyclePerMinute *int32 `json:"schedule_cycle_per_minute,omitempty"`
	// Main Schedule Last queue length
	ScheduleQueueLength *int32 `json:"schedule_queue_length,omitempty"`
	// Job submitted
	JobsSubmitted *int32 `json:"jobs_submitted,omitempty"`
	// Job started
	JobsStarted *int32 `json:"jobs_started,omitempty"`
	// Job completed
	JobsCompleted *int32 `json:"jobs_completed,omitempty"`
	// Job cancelled
	JobsCanceled *int32 `json:"jobs_canceled,omitempty"`
	// Job failed
	JobsFailed *int32 `json:"jobs_failed,omitempty"`
	// Job pending
	JobsPending *int32 `json:"jobs_pending,omitempty"`
	// Job running
	JobsRunning *int32 `json:"jobs_running,omitempty"`
	// Job states timestamp
	JobStatesTs *int32 `json:"job_states_ts,omitempty"`
	// Total backfilled jobs (since last slurm start)
	BfBackfilledJobs *int32 `json:"bf_backfilled_jobs,omitempty"`
	// Total backfilled jobs (since last stats cycle start)
	BfLastBackfilledJobs *int32 `json:"bf_last_backfilled_jobs,omitempty"`
	// Total backfilled heterogeneous job components
	BfBackfilledHetJobs *int32 `json:"bf_backfilled_het_jobs,omitempty"`
	// Backfill Schedule Total cycles
	BfCycleCounter *int32 `json:"bf_cycle_counter,omitempty"`
	// Backfill Schedule Mean cycle
	BfCycleMean *int32 `json:"bf_cycle_mean,omitempty"`
	// Backfill Schedule Max cycle time
	BfCycleMax *int32 `json:"bf_cycle_max,omitempty"`
	// Backfill Schedule Last depth cycle
	BfLastDepth *int32 `json:"bf_last_depth,omitempty"`
	// Backfill Schedule Mean cycle (try sched)
	BfLastDepthTry *int32 `json:"bf_last_depth_try,omitempty"`
	// Backfill Schedule Depth Mean
	BfDepthMean *int32 `json:"bf_depth_mean,omitempty"`
	// Backfill Schedule Depth Mean (try sched)
	BfDepthMeanTry *int32 `json:"bf_depth_mean_try,omitempty"`
	// Backfill Schedule Last cycle time
	BfCycleLast *int32 `json:"bf_cycle_last,omitempty"`
	// Backfill Schedule Last queue length
	BfQueueLen *int32 `json:"bf_queue_len,omitempty"`
	// Backfill Schedule Mean queue length
	BfQueueLenMean *int32 `json:"bf_queue_len_mean,omitempty"`
	// Backfill Schedule Last table size
	BfTableSize *int32 `json:"bf_table_size,omitempty"`
	// Backfill Schedule Mean table size
	BfTableSizeMean *int32 `json:"bf_table_size_mean,omitempty"`
	// Last cycle timestamp
	BfWhenLastCycle *int32 `json:"bf_when_last_cycle,omitempty"`
	// Backfill Schedule currently active
	BfActive *bool `json:"bf_active,omitempty"`
	// Remote Procedure Call statistics by message type
	RpcsByMessageType []V0038DiagRpcm `json:"rpcs_by_message_type,omitempty"`
	// Remote Procedure Call statistics by user
	RpcsByUser []V0038DiagRpcu `json:"rpcs_by_user,omitempty"`
}

// NewV0038DiagStatistics instantiates a new V0038DiagStatistics object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewV0038DiagStatistics() *V0038DiagStatistics {
	this := V0038DiagStatistics{}
	return &this
}

// NewV0038DiagStatisticsWithDefaults instantiates a new V0038DiagStatistics object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewV0038DiagStatisticsWithDefaults() *V0038DiagStatistics {
	this := V0038DiagStatistics{}
	return &this
}

// GetPartsPacked returns the PartsPacked field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetPartsPacked() int32 {
	if o == nil || IsNil(o.PartsPacked) {
		var ret int32
		return ret
	}
	return *o.PartsPacked
}

// GetPartsPackedOk returns a tuple with the PartsPacked field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetPartsPackedOk() (*int32, bool) {
	if o == nil || IsNil(o.PartsPacked) {
		return nil, false
	}
	return o.PartsPacked, true
}

// HasPartsPacked returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasPartsPacked() bool {
	if o != nil && !IsNil(o.PartsPacked) {
		return true
	}

	return false
}

// SetPartsPacked gets a reference to the given int32 and assigns it to the PartsPacked field.
func (o *V0038DiagStatistics) SetPartsPacked(v int32) {
	o.PartsPacked = &v
}

// GetReqTime returns the ReqTime field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetReqTime() int32 {
	if o == nil || IsNil(o.ReqTime) {
		var ret int32
		return ret
	}
	return *o.ReqTime
}

// GetReqTimeOk returns a tuple with the ReqTime field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetReqTimeOk() (*int32, bool) {
	if o == nil || IsNil(o.ReqTime) {
		return nil, false
	}
	return o.ReqTime, true
}

// HasReqTime returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasReqTime() bool {
	if o != nil && !IsNil(o.ReqTime) {
		return true
	}

	return false
}

// SetReqTime gets a reference to the given int32 and assigns it to the ReqTime field.
func (o *V0038DiagStatistics) SetReqTime(v int32) {
	o.ReqTime = &v
}

// GetReqTimeStart returns the ReqTimeStart field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetReqTimeStart() int32 {
	if o == nil || IsNil(o.ReqTimeStart) {
		var ret int32
		return ret
	}
	return *o.ReqTimeStart
}

// GetReqTimeStartOk returns a tuple with the ReqTimeStart field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetReqTimeStartOk() (*int32, bool) {
	if o == nil || IsNil(o.ReqTimeStart) {
		return nil, false
	}
	return o.ReqTimeStart, true
}

// HasReqTimeStart returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasReqTimeStart() bool {
	if o != nil && !IsNil(o.ReqTimeStart) {
		return true
	}

	return false
}

// SetReqTimeStart gets a reference to the given int32 and assigns it to the ReqTimeStart field.
func (o *V0038DiagStatistics) SetReqTimeStart(v int32) {
	o.ReqTimeStart = &v
}

// GetServerThreadCount returns the ServerThreadCount field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetServerThreadCount() int32 {
	if o == nil || IsNil(o.ServerThreadCount) {
		var ret int32
		return ret
	}
	return *o.ServerThreadCount
}

// GetServerThreadCountOk returns a tuple with the ServerThreadCount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetServerThreadCountOk() (*int32, bool) {
	if o == nil || IsNil(o.ServerThreadCount) {
		return nil, false
	}
	return o.ServerThreadCount, true
}

// HasServerThreadCount returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasServerThreadCount() bool {
	if o != nil && !IsNil(o.ServerThreadCount) {
		return true
	}

	return false
}

// SetServerThreadCount gets a reference to the given int32 and assigns it to the ServerThreadCount field.
func (o *V0038DiagStatistics) SetServerThreadCount(v int32) {
	o.ServerThreadCount = &v
}

// GetAgentQueueSize returns the AgentQueueSize field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetAgentQueueSize() int32 {
	if o == nil || IsNil(o.AgentQueueSize) {
		var ret int32
		return ret
	}
	return *o.AgentQueueSize
}

// GetAgentQueueSizeOk returns a tuple with the AgentQueueSize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetAgentQueueSizeOk() (*int32, bool) {
	if o == nil || IsNil(o.AgentQueueSize) {
		return nil, false
	}
	return o.AgentQueueSize, true
}

// HasAgentQueueSize returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasAgentQueueSize() bool {
	if o != nil && !IsNil(o.AgentQueueSize) {
		return true
	}

	return false
}

// SetAgentQueueSize gets a reference to the given int32 and assigns it to the AgentQueueSize field.
func (o *V0038DiagStatistics) SetAgentQueueSize(v int32) {
	o.AgentQueueSize = &v
}

// GetAgentCount returns the AgentCount field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetAgentCount() int32 {
	if o == nil || IsNil(o.AgentCount) {
		var ret int32
		return ret
	}
	return *o.AgentCount
}

// GetAgentCountOk returns a tuple with the AgentCount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetAgentCountOk() (*int32, bool) {
	if o == nil || IsNil(o.AgentCount) {
		return nil, false
	}
	return o.AgentCount, true
}

// HasAgentCount returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasAgentCount() bool {
	if o != nil && !IsNil(o.AgentCount) {
		return true
	}

	return false
}

// SetAgentCount gets a reference to the given int32 and assigns it to the AgentCount field.
func (o *V0038DiagStatistics) SetAgentCount(v int32) {
	o.AgentCount = &v
}

// GetAgentThreadCount returns the AgentThreadCount field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetAgentThreadCount() int32 {
	if o == nil || IsNil(o.AgentThreadCount) {
		var ret int32
		return ret
	}
	return *o.AgentThreadCount
}

// GetAgentThreadCountOk returns a tuple with the AgentThreadCount field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetAgentThreadCountOk() (*int32, bool) {
	if o == nil || IsNil(o.AgentThreadCount) {
		return nil, false
	}
	return o.AgentThreadCount, true
}

// HasAgentThreadCount returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasAgentThreadCount() bool {
	if o != nil && !IsNil(o.AgentThreadCount) {
		return true
	}

	return false
}

// SetAgentThreadCount gets a reference to the given int32 and assigns it to the AgentThreadCount field.
func (o *V0038DiagStatistics) SetAgentThreadCount(v int32) {
	o.AgentThreadCount = &v
}

// GetDbdAgentQueueSize returns the DbdAgentQueueSize field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetDbdAgentQueueSize() int32 {
	if o == nil || IsNil(o.DbdAgentQueueSize) {
		var ret int32
		return ret
	}
	return *o.DbdAgentQueueSize
}

// GetDbdAgentQueueSizeOk returns a tuple with the DbdAgentQueueSize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetDbdAgentQueueSizeOk() (*int32, bool) {
	if o == nil || IsNil(o.DbdAgentQueueSize) {
		return nil, false
	}
	return o.DbdAgentQueueSize, true
}

// HasDbdAgentQueueSize returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasDbdAgentQueueSize() bool {
	if o != nil && !IsNil(o.DbdAgentQueueSize) {
		return true
	}

	return false
}

// SetDbdAgentQueueSize gets a reference to the given int32 and assigns it to the DbdAgentQueueSize field.
func (o *V0038DiagStatistics) SetDbdAgentQueueSize(v int32) {
	o.DbdAgentQueueSize = &v
}

// GetGettimeofdayLatency returns the GettimeofdayLatency field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetGettimeofdayLatency() int32 {
	if o == nil || IsNil(o.GettimeofdayLatency) {
		var ret int32
		return ret
	}
	return *o.GettimeofdayLatency
}

// GetGettimeofdayLatencyOk returns a tuple with the GettimeofdayLatency field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetGettimeofdayLatencyOk() (*int32, bool) {
	if o == nil || IsNil(o.GettimeofdayLatency) {
		return nil, false
	}
	return o.GettimeofdayLatency, true
}

// HasGettimeofdayLatency returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasGettimeofdayLatency() bool {
	if o != nil && !IsNil(o.GettimeofdayLatency) {
		return true
	}

	return false
}

// SetGettimeofdayLatency gets a reference to the given int32 and assigns it to the GettimeofdayLatency field.
func (o *V0038DiagStatistics) SetGettimeofdayLatency(v int32) {
	o.GettimeofdayLatency = &v
}

// GetScheduleCycleMax returns the ScheduleCycleMax field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetScheduleCycleMax() int32 {
	if o == nil || IsNil(o.ScheduleCycleMax) {
		var ret int32
		return ret
	}
	return *o.ScheduleCycleMax
}

// GetScheduleCycleMaxOk returns a tuple with the ScheduleCycleMax field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetScheduleCycleMaxOk() (*int32, bool) {
	if o == nil || IsNil(o.ScheduleCycleMax) {
		return nil, false
	}
	return o.ScheduleCycleMax, true
}

// HasScheduleCycleMax returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasScheduleCycleMax() bool {
	if o != nil && !IsNil(o.ScheduleCycleMax) {
		return true
	}

	return false
}

// SetScheduleCycleMax gets a reference to the given int32 and assigns it to the ScheduleCycleMax field.
func (o *V0038DiagStatistics) SetScheduleCycleMax(v int32) {
	o.ScheduleCycleMax = &v
}

// GetScheduleCycleLast returns the ScheduleCycleLast field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetScheduleCycleLast() int32 {
	if o == nil || IsNil(o.ScheduleCycleLast) {
		var ret int32
		return ret
	}
	return *o.ScheduleCycleLast
}

// GetScheduleCycleLastOk returns a tuple with the ScheduleCycleLast field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetScheduleCycleLastOk() (*int32, bool) {
	if o == nil || IsNil(o.ScheduleCycleLast) {
		return nil, false
	}
	return o.ScheduleCycleLast, true
}

// HasScheduleCycleLast returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasScheduleCycleLast() bool {
	if o != nil && !IsNil(o.ScheduleCycleLast) {
		return true
	}

	return false
}

// SetScheduleCycleLast gets a reference to the given int32 and assigns it to the ScheduleCycleLast field.
func (o *V0038DiagStatistics) SetScheduleCycleLast(v int32) {
	o.ScheduleCycleLast = &v
}

// GetScheduleCycleTotal returns the ScheduleCycleTotal field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetScheduleCycleTotal() int32 {
	if o == nil || IsNil(o.ScheduleCycleTotal) {
		var ret int32
		return ret
	}
	return *o.ScheduleCycleTotal
}

// GetScheduleCycleTotalOk returns a tuple with the ScheduleCycleTotal field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetScheduleCycleTotalOk() (*int32, bool) {
	if o == nil || IsNil(o.ScheduleCycleTotal) {
		return nil, false
	}
	return o.ScheduleCycleTotal, true
}

// HasScheduleCycleTotal returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasScheduleCycleTotal() bool {
	if o != nil && !IsNil(o.ScheduleCycleTotal) {
		return true
	}

	return false
}

// SetScheduleCycleTotal gets a reference to the given int32 and assigns it to the ScheduleCycleTotal field.
func (o *V0038DiagStatistics) SetScheduleCycleTotal(v int32) {
	o.ScheduleCycleTotal = &v
}

// GetScheduleCycleMean returns the ScheduleCycleMean field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetScheduleCycleMean() int32 {
	if o == nil || IsNil(o.ScheduleCycleMean) {
		var ret int32
		return ret
	}
	return *o.ScheduleCycleMean
}

// GetScheduleCycleMeanOk returns a tuple with the ScheduleCycleMean field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetScheduleCycleMeanOk() (*int32, bool) {
	if o == nil || IsNil(o.ScheduleCycleMean) {
		return nil, false
	}
	return o.ScheduleCycleMean, true
}

// HasScheduleCycleMean returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasScheduleCycleMean() bool {
	if o != nil && !IsNil(o.ScheduleCycleMean) {
		return true
	}

	return false
}

// SetScheduleCycleMean gets a reference to the given int32 and assigns it to the ScheduleCycleMean field.
func (o *V0038DiagStatistics) SetScheduleCycleMean(v int32) {
	o.ScheduleCycleMean = &v
}

// GetScheduleCycleMeanDepth returns the ScheduleCycleMeanDepth field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetScheduleCycleMeanDepth() int32 {
	if o == nil || IsNil(o.ScheduleCycleMeanDepth) {
		var ret int32
		return ret
	}
	return *o.ScheduleCycleMeanDepth
}

// GetScheduleCycleMeanDepthOk returns a tuple with the ScheduleCycleMeanDepth field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetScheduleCycleMeanDepthOk() (*int32, bool) {
	if o == nil || IsNil(o.ScheduleCycleMeanDepth) {
		return nil, false
	}
	return o.ScheduleCycleMeanDepth, true
}

// HasScheduleCycleMeanDepth returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasScheduleCycleMeanDepth() bool {
	if o != nil && !IsNil(o.ScheduleCycleMeanDepth) {
		return true
	}

	return false
}

// SetScheduleCycleMeanDepth gets a reference to the given int32 and assigns it to the ScheduleCycleMeanDepth field.
func (o *V0038DiagStatistics) SetScheduleCycleMeanDepth(v int32) {
	o.ScheduleCycleMeanDepth = &v
}

// GetScheduleCyclePerMinute returns the ScheduleCyclePerMinute field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetScheduleCyclePerMinute() int32 {
	if o == nil || IsNil(o.ScheduleCyclePerMinute) {
		var ret int32
		return ret
	}
	return *o.ScheduleCyclePerMinute
}

// GetScheduleCyclePerMinuteOk returns a tuple with the ScheduleCyclePerMinute field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetScheduleCyclePerMinuteOk() (*int32, bool) {
	if o == nil || IsNil(o.ScheduleCyclePerMinute) {
		return nil, false
	}
	return o.ScheduleCyclePerMinute, true
}

// HasScheduleCyclePerMinute returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasScheduleCyclePerMinute() bool {
	if o != nil && !IsNil(o.ScheduleCyclePerMinute) {
		return true
	}

	return false
}

// SetScheduleCyclePerMinute gets a reference to the given int32 and assigns it to the ScheduleCyclePerMinute field.
func (o *V0038DiagStatistics) SetScheduleCyclePerMinute(v int32) {
	o.ScheduleCyclePerMinute = &v
}

// GetScheduleQueueLength returns the ScheduleQueueLength field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetScheduleQueueLength() int32 {
	if o == nil || IsNil(o.ScheduleQueueLength) {
		var ret int32
		return ret
	}
	return *o.ScheduleQueueLength
}

// GetScheduleQueueLengthOk returns a tuple with the ScheduleQueueLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetScheduleQueueLengthOk() (*int32, bool) {
	if o == nil || IsNil(o.ScheduleQueueLength) {
		return nil, false
	}
	return o.ScheduleQueueLength, true
}

// HasScheduleQueueLength returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasScheduleQueueLength() bool {
	if o != nil && !IsNil(o.ScheduleQueueLength) {
		return true
	}

	return false
}

// SetScheduleQueueLength gets a reference to the given int32 and assigns it to the ScheduleQueueLength field.
func (o *V0038DiagStatistics) SetScheduleQueueLength(v int32) {
	o.ScheduleQueueLength = &v
}

// GetJobsSubmitted returns the JobsSubmitted field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetJobsSubmitted() int32 {
	if o == nil || IsNil(o.JobsSubmitted) {
		var ret int32
		return ret
	}
	return *o.JobsSubmitted
}

// GetJobsSubmittedOk returns a tuple with the JobsSubmitted field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetJobsSubmittedOk() (*int32, bool) {
	if o == nil || IsNil(o.JobsSubmitted) {
		return nil, false
	}
	return o.JobsSubmitted, true
}

// HasJobsSubmitted returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasJobsSubmitted() bool {
	if o != nil && !IsNil(o.JobsSubmitted) {
		return true
	}

	return false
}

// SetJobsSubmitted gets a reference to the given int32 and assigns it to the JobsSubmitted field.
func (o *V0038DiagStatistics) SetJobsSubmitted(v int32) {
	o.JobsSubmitted = &v
}

// GetJobsStarted returns the JobsStarted field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetJobsStarted() int32 {
	if o == nil || IsNil(o.JobsStarted) {
		var ret int32
		return ret
	}
	return *o.JobsStarted
}

// GetJobsStartedOk returns a tuple with the JobsStarted field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetJobsStartedOk() (*int32, bool) {
	if o == nil || IsNil(o.JobsStarted) {
		return nil, false
	}
	return o.JobsStarted, true
}

// HasJobsStarted returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasJobsStarted() bool {
	if o != nil && !IsNil(o.JobsStarted) {
		return true
	}

	return false
}

// SetJobsStarted gets a reference to the given int32 and assigns it to the JobsStarted field.
func (o *V0038DiagStatistics) SetJobsStarted(v int32) {
	o.JobsStarted = &v
}

// GetJobsCompleted returns the JobsCompleted field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetJobsCompleted() int32 {
	if o == nil || IsNil(o.JobsCompleted) {
		var ret int32
		return ret
	}
	return *o.JobsCompleted
}

// GetJobsCompletedOk returns a tuple with the JobsCompleted field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetJobsCompletedOk() (*int32, bool) {
	if o == nil || IsNil(o.JobsCompleted) {
		return nil, false
	}
	return o.JobsCompleted, true
}

// HasJobsCompleted returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasJobsCompleted() bool {
	if o != nil && !IsNil(o.JobsCompleted) {
		return true
	}

	return false
}

// SetJobsCompleted gets a reference to the given int32 and assigns it to the JobsCompleted field.
func (o *V0038DiagStatistics) SetJobsCompleted(v int32) {
	o.JobsCompleted = &v
}

// GetJobsCanceled returns the JobsCanceled field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetJobsCanceled() int32 {
	if o == nil || IsNil(o.JobsCanceled) {
		var ret int32
		return ret
	}
	return *o.JobsCanceled
}

// GetJobsCanceledOk returns a tuple with the JobsCanceled field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetJobsCanceledOk() (*int32, bool) {
	if o == nil || IsNil(o.JobsCanceled) {
		return nil, false
	}
	return o.JobsCanceled, true
}

// HasJobsCanceled returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasJobsCanceled() bool {
	if o != nil && !IsNil(o.JobsCanceled) {
		return true
	}

	return false
}

// SetJobsCanceled gets a reference to the given int32 and assigns it to the JobsCanceled field.
func (o *V0038DiagStatistics) SetJobsCanceled(v int32) {
	o.JobsCanceled = &v
}

// GetJobsFailed returns the JobsFailed field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetJobsFailed() int32 {
	if o == nil || IsNil(o.JobsFailed) {
		var ret int32
		return ret
	}
	return *o.JobsFailed
}

// GetJobsFailedOk returns a tuple with the JobsFailed field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetJobsFailedOk() (*int32, bool) {
	if o == nil || IsNil(o.JobsFailed) {
		return nil, false
	}
	return o.JobsFailed, true
}

// HasJobsFailed returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasJobsFailed() bool {
	if o != nil && !IsNil(o.JobsFailed) {
		return true
	}

	return false
}

// SetJobsFailed gets a reference to the given int32 and assigns it to the JobsFailed field.
func (o *V0038DiagStatistics) SetJobsFailed(v int32) {
	o.JobsFailed = &v
}

// GetJobsPending returns the JobsPending field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetJobsPending() int32 {
	if o == nil || IsNil(o.JobsPending) {
		var ret int32
		return ret
	}
	return *o.JobsPending
}

// GetJobsPendingOk returns a tuple with the JobsPending field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetJobsPendingOk() (*int32, bool) {
	if o == nil || IsNil(o.JobsPending) {
		return nil, false
	}
	return o.JobsPending, true
}

// HasJobsPending returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasJobsPending() bool {
	if o != nil && !IsNil(o.JobsPending) {
		return true
	}

	return false
}

// SetJobsPending gets a reference to the given int32 and assigns it to the JobsPending field.
func (o *V0038DiagStatistics) SetJobsPending(v int32) {
	o.JobsPending = &v
}

// GetJobsRunning returns the JobsRunning field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetJobsRunning() int32 {
	if o == nil || IsNil(o.JobsRunning) {
		var ret int32
		return ret
	}
	return *o.JobsRunning
}

// GetJobsRunningOk returns a tuple with the JobsRunning field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetJobsRunningOk() (*int32, bool) {
	if o == nil || IsNil(o.JobsRunning) {
		return nil, false
	}
	return o.JobsRunning, true
}

// HasJobsRunning returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasJobsRunning() bool {
	if o != nil && !IsNil(o.JobsRunning) {
		return true
	}

	return false
}

// SetJobsRunning gets a reference to the given int32 and assigns it to the JobsRunning field.
func (o *V0038DiagStatistics) SetJobsRunning(v int32) {
	o.JobsRunning = &v
}

// GetJobStatesTs returns the JobStatesTs field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetJobStatesTs() int32 {
	if o == nil || IsNil(o.JobStatesTs) {
		var ret int32
		return ret
	}
	return *o.JobStatesTs
}

// GetJobStatesTsOk returns a tuple with the JobStatesTs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetJobStatesTsOk() (*int32, bool) {
	if o == nil || IsNil(o.JobStatesTs) {
		return nil, false
	}
	return o.JobStatesTs, true
}

// HasJobStatesTs returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasJobStatesTs() bool {
	if o != nil && !IsNil(o.JobStatesTs) {
		return true
	}

	return false
}

// SetJobStatesTs gets a reference to the given int32 and assigns it to the JobStatesTs field.
func (o *V0038DiagStatistics) SetJobStatesTs(v int32) {
	o.JobStatesTs = &v
}

// GetBfBackfilledJobs returns the BfBackfilledJobs field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfBackfilledJobs() int32 {
	if o == nil || IsNil(o.BfBackfilledJobs) {
		var ret int32
		return ret
	}
	return *o.BfBackfilledJobs
}

// GetBfBackfilledJobsOk returns a tuple with the BfBackfilledJobs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfBackfilledJobsOk() (*int32, bool) {
	if o == nil || IsNil(o.BfBackfilledJobs) {
		return nil, false
	}
	return o.BfBackfilledJobs, true
}

// HasBfBackfilledJobs returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfBackfilledJobs() bool {
	if o != nil && !IsNil(o.BfBackfilledJobs) {
		return true
	}

	return false
}

// SetBfBackfilledJobs gets a reference to the given int32 and assigns it to the BfBackfilledJobs field.
func (o *V0038DiagStatistics) SetBfBackfilledJobs(v int32) {
	o.BfBackfilledJobs = &v
}

// GetBfLastBackfilledJobs returns the BfLastBackfilledJobs field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfLastBackfilledJobs() int32 {
	if o == nil || IsNil(o.BfLastBackfilledJobs) {
		var ret int32
		return ret
	}
	return *o.BfLastBackfilledJobs
}

// GetBfLastBackfilledJobsOk returns a tuple with the BfLastBackfilledJobs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfLastBackfilledJobsOk() (*int32, bool) {
	if o == nil || IsNil(o.BfLastBackfilledJobs) {
		return nil, false
	}
	return o.BfLastBackfilledJobs, true
}

// HasBfLastBackfilledJobs returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfLastBackfilledJobs() bool {
	if o != nil && !IsNil(o.BfLastBackfilledJobs) {
		return true
	}

	return false
}

// SetBfLastBackfilledJobs gets a reference to the given int32 and assigns it to the BfLastBackfilledJobs field.
func (o *V0038DiagStatistics) SetBfLastBackfilledJobs(v int32) {
	o.BfLastBackfilledJobs = &v
}

// GetBfBackfilledHetJobs returns the BfBackfilledHetJobs field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfBackfilledHetJobs() int32 {
	if o == nil || IsNil(o.BfBackfilledHetJobs) {
		var ret int32
		return ret
	}
	return *o.BfBackfilledHetJobs
}

// GetBfBackfilledHetJobsOk returns a tuple with the BfBackfilledHetJobs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfBackfilledHetJobsOk() (*int32, bool) {
	if o == nil || IsNil(o.BfBackfilledHetJobs) {
		return nil, false
	}
	return o.BfBackfilledHetJobs, true
}

// HasBfBackfilledHetJobs returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfBackfilledHetJobs() bool {
	if o != nil && !IsNil(o.BfBackfilledHetJobs) {
		return true
	}

	return false
}

// SetBfBackfilledHetJobs gets a reference to the given int32 and assigns it to the BfBackfilledHetJobs field.
func (o *V0038DiagStatistics) SetBfBackfilledHetJobs(v int32) {
	o.BfBackfilledHetJobs = &v
}

// GetBfCycleCounter returns the BfCycleCounter field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfCycleCounter() int32 {
	if o == nil || IsNil(o.BfCycleCounter) {
		var ret int32
		return ret
	}
	return *o.BfCycleCounter
}

// GetBfCycleCounterOk returns a tuple with the BfCycleCounter field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfCycleCounterOk() (*int32, bool) {
	if o == nil || IsNil(o.BfCycleCounter) {
		return nil, false
	}
	return o.BfCycleCounter, true
}

// HasBfCycleCounter returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfCycleCounter() bool {
	if o != nil && !IsNil(o.BfCycleCounter) {
		return true
	}

	return false
}

// SetBfCycleCounter gets a reference to the given int32 and assigns it to the BfCycleCounter field.
func (o *V0038DiagStatistics) SetBfCycleCounter(v int32) {
	o.BfCycleCounter = &v
}

// GetBfCycleMean returns the BfCycleMean field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfCycleMean() int32 {
	if o == nil || IsNil(o.BfCycleMean) {
		var ret int32
		return ret
	}
	return *o.BfCycleMean
}

// GetBfCycleMeanOk returns a tuple with the BfCycleMean field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfCycleMeanOk() (*int32, bool) {
	if o == nil || IsNil(o.BfCycleMean) {
		return nil, false
	}
	return o.BfCycleMean, true
}

// HasBfCycleMean returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfCycleMean() bool {
	if o != nil && !IsNil(o.BfCycleMean) {
		return true
	}

	return false
}

// SetBfCycleMean gets a reference to the given int32 and assigns it to the BfCycleMean field.
func (o *V0038DiagStatistics) SetBfCycleMean(v int32) {
	o.BfCycleMean = &v
}

// GetBfCycleMax returns the BfCycleMax field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfCycleMax() int32 {
	if o == nil || IsNil(o.BfCycleMax) {
		var ret int32
		return ret
	}
	return *o.BfCycleMax
}

// GetBfCycleMaxOk returns a tuple with the BfCycleMax field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfCycleMaxOk() (*int32, bool) {
	if o == nil || IsNil(o.BfCycleMax) {
		return nil, false
	}
	return o.BfCycleMax, true
}

// HasBfCycleMax returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfCycleMax() bool {
	if o != nil && !IsNil(o.BfCycleMax) {
		return true
	}

	return false
}

// SetBfCycleMax gets a reference to the given int32 and assigns it to the BfCycleMax field.
func (o *V0038DiagStatistics) SetBfCycleMax(v int32) {
	o.BfCycleMax = &v
}

// GetBfLastDepth returns the BfLastDepth field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfLastDepth() int32 {
	if o == nil || IsNil(o.BfLastDepth) {
		var ret int32
		return ret
	}
	return *o.BfLastDepth
}

// GetBfLastDepthOk returns a tuple with the BfLastDepth field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfLastDepthOk() (*int32, bool) {
	if o == nil || IsNil(o.BfLastDepth) {
		return nil, false
	}
	return o.BfLastDepth, true
}

// HasBfLastDepth returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfLastDepth() bool {
	if o != nil && !IsNil(o.BfLastDepth) {
		return true
	}

	return false
}

// SetBfLastDepth gets a reference to the given int32 and assigns it to the BfLastDepth field.
func (o *V0038DiagStatistics) SetBfLastDepth(v int32) {
	o.BfLastDepth = &v
}

// GetBfLastDepthTry returns the BfLastDepthTry field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfLastDepthTry() int32 {
	if o == nil || IsNil(o.BfLastDepthTry) {
		var ret int32
		return ret
	}
	return *o.BfLastDepthTry
}

// GetBfLastDepthTryOk returns a tuple with the BfLastDepthTry field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfLastDepthTryOk() (*int32, bool) {
	if o == nil || IsNil(o.BfLastDepthTry) {
		return nil, false
	}
	return o.BfLastDepthTry, true
}

// HasBfLastDepthTry returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfLastDepthTry() bool {
	if o != nil && !IsNil(o.BfLastDepthTry) {
		return true
	}

	return false
}

// SetBfLastDepthTry gets a reference to the given int32 and assigns it to the BfLastDepthTry field.
func (o *V0038DiagStatistics) SetBfLastDepthTry(v int32) {
	o.BfLastDepthTry = &v
}

// GetBfDepthMean returns the BfDepthMean field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfDepthMean() int32 {
	if o == nil || IsNil(o.BfDepthMean) {
		var ret int32
		return ret
	}
	return *o.BfDepthMean
}

// GetBfDepthMeanOk returns a tuple with the BfDepthMean field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfDepthMeanOk() (*int32, bool) {
	if o == nil || IsNil(o.BfDepthMean) {
		return nil, false
	}
	return o.BfDepthMean, true
}

// HasBfDepthMean returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfDepthMean() bool {
	if o != nil && !IsNil(o.BfDepthMean) {
		return true
	}

	return false
}

// SetBfDepthMean gets a reference to the given int32 and assigns it to the BfDepthMean field.
func (o *V0038DiagStatistics) SetBfDepthMean(v int32) {
	o.BfDepthMean = &v
}

// GetBfDepthMeanTry returns the BfDepthMeanTry field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfDepthMeanTry() int32 {
	if o == nil || IsNil(o.BfDepthMeanTry) {
		var ret int32
		return ret
	}
	return *o.BfDepthMeanTry
}

// GetBfDepthMeanTryOk returns a tuple with the BfDepthMeanTry field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfDepthMeanTryOk() (*int32, bool) {
	if o == nil || IsNil(o.BfDepthMeanTry) {
		return nil, false
	}
	return o.BfDepthMeanTry, true
}

// HasBfDepthMeanTry returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfDepthMeanTry() bool {
	if o != nil && !IsNil(o.BfDepthMeanTry) {
		return true
	}

	return false
}

// SetBfDepthMeanTry gets a reference to the given int32 and assigns it to the BfDepthMeanTry field.
func (o *V0038DiagStatistics) SetBfDepthMeanTry(v int32) {
	o.BfDepthMeanTry = &v
}

// GetBfCycleLast returns the BfCycleLast field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfCycleLast() int32 {
	if o == nil || IsNil(o.BfCycleLast) {
		var ret int32
		return ret
	}
	return *o.BfCycleLast
}

// GetBfCycleLastOk returns a tuple with the BfCycleLast field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfCycleLastOk() (*int32, bool) {
	if o == nil || IsNil(o.BfCycleLast) {
		return nil, false
	}
	return o.BfCycleLast, true
}

// HasBfCycleLast returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfCycleLast() bool {
	if o != nil && !IsNil(o.BfCycleLast) {
		return true
	}

	return false
}

// SetBfCycleLast gets a reference to the given int32 and assigns it to the BfCycleLast field.
func (o *V0038DiagStatistics) SetBfCycleLast(v int32) {
	o.BfCycleLast = &v
}

// GetBfQueueLen returns the BfQueueLen field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfQueueLen() int32 {
	if o == nil || IsNil(o.BfQueueLen) {
		var ret int32
		return ret
	}
	return *o.BfQueueLen
}

// GetBfQueueLenOk returns a tuple with the BfQueueLen field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfQueueLenOk() (*int32, bool) {
	if o == nil || IsNil(o.BfQueueLen) {
		return nil, false
	}
	return o.BfQueueLen, true
}

// HasBfQueueLen returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfQueueLen() bool {
	if o != nil && !IsNil(o.BfQueueLen) {
		return true
	}

	return false
}

// SetBfQueueLen gets a reference to the given int32 and assigns it to the BfQueueLen field.
func (o *V0038DiagStatistics) SetBfQueueLen(v int32) {
	o.BfQueueLen = &v
}

// GetBfQueueLenMean returns the BfQueueLenMean field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfQueueLenMean() int32 {
	if o == nil || IsNil(o.BfQueueLenMean) {
		var ret int32
		return ret
	}
	return *o.BfQueueLenMean
}

// GetBfQueueLenMeanOk returns a tuple with the BfQueueLenMean field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfQueueLenMeanOk() (*int32, bool) {
	if o == nil || IsNil(o.BfQueueLenMean) {
		return nil, false
	}
	return o.BfQueueLenMean, true
}

// HasBfQueueLenMean returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfQueueLenMean() bool {
	if o != nil && !IsNil(o.BfQueueLenMean) {
		return true
	}

	return false
}

// SetBfQueueLenMean gets a reference to the given int32 and assigns it to the BfQueueLenMean field.
func (o *V0038DiagStatistics) SetBfQueueLenMean(v int32) {
	o.BfQueueLenMean = &v
}

// GetBfTableSize returns the BfTableSize field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfTableSize() int32 {
	if o == nil || IsNil(o.BfTableSize) {
		var ret int32
		return ret
	}
	return *o.BfTableSize
}

// GetBfTableSizeOk returns a tuple with the BfTableSize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfTableSizeOk() (*int32, bool) {
	if o == nil || IsNil(o.BfTableSize) {
		return nil, false
	}
	return o.BfTableSize, true
}

// HasBfTableSize returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfTableSize() bool {
	if o != nil && !IsNil(o.BfTableSize) {
		return true
	}

	return false
}

// SetBfTableSize gets a reference to the given int32 and assigns it to the BfTableSize field.
func (o *V0038DiagStatistics) SetBfTableSize(v int32) {
	o.BfTableSize = &v
}

// GetBfTableSizeMean returns the BfTableSizeMean field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfTableSizeMean() int32 {
	if o == nil || IsNil(o.BfTableSizeMean) {
		var ret int32
		return ret
	}
	return *o.BfTableSizeMean
}

// GetBfTableSizeMeanOk returns a tuple with the BfTableSizeMean field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfTableSizeMeanOk() (*int32, bool) {
	if o == nil || IsNil(o.BfTableSizeMean) {
		return nil, false
	}
	return o.BfTableSizeMean, true
}

// HasBfTableSizeMean returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfTableSizeMean() bool {
	if o != nil && !IsNil(o.BfTableSizeMean) {
		return true
	}

	return false
}

// SetBfTableSizeMean gets a reference to the given int32 and assigns it to the BfTableSizeMean field.
func (o *V0038DiagStatistics) SetBfTableSizeMean(v int32) {
	o.BfTableSizeMean = &v
}

// GetBfWhenLastCycle returns the BfWhenLastCycle field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfWhenLastCycle() int32 {
	if o == nil || IsNil(o.BfWhenLastCycle) {
		var ret int32
		return ret
	}
	return *o.BfWhenLastCycle
}

// GetBfWhenLastCycleOk returns a tuple with the BfWhenLastCycle field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfWhenLastCycleOk() (*int32, bool) {
	if o == nil || IsNil(o.BfWhenLastCycle) {
		return nil, false
	}
	return o.BfWhenLastCycle, true
}

// HasBfWhenLastCycle returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfWhenLastCycle() bool {
	if o != nil && !IsNil(o.BfWhenLastCycle) {
		return true
	}

	return false
}

// SetBfWhenLastCycle gets a reference to the given int32 and assigns it to the BfWhenLastCycle field.
func (o *V0038DiagStatistics) SetBfWhenLastCycle(v int32) {
	o.BfWhenLastCycle = &v
}

// GetBfActive returns the BfActive field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetBfActive() bool {
	if o == nil || IsNil(o.BfActive) {
		var ret bool
		return ret
	}
	return *o.BfActive
}

// GetBfActiveOk returns a tuple with the BfActive field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetBfActiveOk() (*bool, bool) {
	if o == nil || IsNil(o.BfActive) {
		return nil, false
	}
	return o.BfActive, true
}

// HasBfActive returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasBfActive() bool {
	if o != nil && !IsNil(o.BfActive) {
		return true
	}

	return false
}

// SetBfActive gets a reference to the given bool and assigns it to the BfActive field.
func (o *V0038DiagStatistics) SetBfActive(v bool) {
	o.BfActive = &v
}

// GetRpcsByMessageType returns the RpcsByMessageType field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetRpcsByMessageType() []V0038DiagRpcm {
	if o == nil || IsNil(o.RpcsByMessageType) {
		var ret []V0038DiagRpcm
		return ret
	}
	return o.RpcsByMessageType
}

// GetRpcsByMessageTypeOk returns a tuple with the RpcsByMessageType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetRpcsByMessageTypeOk() ([]V0038DiagRpcm, bool) {
	if o == nil || IsNil(o.RpcsByMessageType) {
		return nil, false
	}
	return o.RpcsByMessageType, true
}

// HasRpcsByMessageType returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasRpcsByMessageType() bool {
	if o != nil && !IsNil(o.RpcsByMessageType) {
		return true
	}

	return false
}

// SetRpcsByMessageType gets a reference to the given []V0038DiagRpcm and assigns it to the RpcsByMessageType field.
func (o *V0038DiagStatistics) SetRpcsByMessageType(v []V0038DiagRpcm) {
	o.RpcsByMessageType = v
}

// GetRpcsByUser returns the RpcsByUser field value if set, zero value otherwise.
func (o *V0038DiagStatistics) GetRpcsByUser() []V0038DiagRpcu {
	if o == nil || IsNil(o.RpcsByUser) {
		var ret []V0038DiagRpcu
		return ret
	}
	return o.RpcsByUser
}

// GetRpcsByUserOk returns a tuple with the RpcsByUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038DiagStatistics) GetRpcsByUserOk() ([]V0038DiagRpcu, bool) {
	if o == nil || IsNil(o.RpcsByUser) {
		return nil, false
	}
	return o.RpcsByUser, true
}

// HasRpcsByUser returns a boolean if a field has been set.
func (o *V0038DiagStatistics) HasRpcsByUser() bool {
	if o != nil && !IsNil(o.RpcsByUser) {
		return true
	}

	return false
}

// SetRpcsByUser gets a reference to the given []V0038DiagRpcu and assigns it to the RpcsByUser field.
func (o *V0038DiagStatistics) SetRpcsByUser(v []V0038DiagRpcu) {
	o.RpcsByUser = v
}

func (o V0038DiagStatistics) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o V0038DiagStatistics) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PartsPacked) {
		toSerialize["parts_packed"] = o.PartsPacked
	}
	if !IsNil(o.ReqTime) {
		toSerialize["req_time"] = o.ReqTime
	}
	if !IsNil(o.ReqTimeStart) {
		toSerialize["req_time_start"] = o.ReqTimeStart
	}
	if !IsNil(o.ServerThreadCount) {
		toSerialize["server_thread_count"] = o.ServerThreadCount
	}
	if !IsNil(o.AgentQueueSize) {
		toSerialize["agent_queue_size"] = o.AgentQueueSize
	}
	if !IsNil(o.AgentCount) {
		toSerialize["agent_count"] = o.AgentCount
	}
	if !IsNil(o.AgentThreadCount) {
		toSerialize["agent_thread_count"] = o.AgentThreadCount
	}
	if !IsNil(o.DbdAgentQueueSize) {
		toSerialize["dbd_agent_queue_size"] = o.DbdAgentQueueSize
	}
	if !IsNil(o.GettimeofdayLatency) {
		toSerialize["gettimeofday_latency"] = o.GettimeofdayLatency
	}
	if !IsNil(o.ScheduleCycleMax) {
		toSerialize["schedule_cycle_max"] = o.ScheduleCycleMax
	}
	if !IsNil(o.ScheduleCycleLast) {
		toSerialize["schedule_cycle_last"] = o.ScheduleCycleLast
	}
	if !IsNil(o.ScheduleCycleTotal) {
		toSerialize["schedule_cycle_total"] = o.ScheduleCycleTotal
	}
	if !IsNil(o.ScheduleCycleMean) {
		toSerialize["schedule_cycle_mean"] = o.ScheduleCycleMean
	}
	if !IsNil(o.ScheduleCycleMeanDepth) {
		toSerialize["schedule_cycle_mean_depth"] = o.ScheduleCycleMeanDepth
	}
	if !IsNil(o.ScheduleCyclePerMinute) {
		toSerialize["schedule_cycle_per_minute"] = o.ScheduleCyclePerMinute
	}
	if !IsNil(o.ScheduleQueueLength) {
		toSerialize["schedule_queue_length"] = o.ScheduleQueueLength
	}
	if !IsNil(o.JobsSubmitted) {
		toSerialize["jobs_submitted"] = o.JobsSubmitted
	}
	if !IsNil(o.JobsStarted) {
		toSerialize["jobs_started"] = o.JobsStarted
	}
	if !IsNil(o.JobsCompleted) {
		toSerialize["jobs_completed"] = o.JobsCompleted
	}
	if !IsNil(o.JobsCanceled) {
		toSerialize["jobs_canceled"] = o.JobsCanceled
	}
	if !IsNil(o.JobsFailed) {
		toSerialize["jobs_failed"] = o.JobsFailed
	}
	if !IsNil(o.JobsPending) {
		toSerialize["jobs_pending"] = o.JobsPending
	}
	if !IsNil(o.JobsRunning) {
		toSerialize["jobs_running"] = o.JobsRunning
	}
	if !IsNil(o.JobStatesTs) {
		toSerialize["job_states_ts"] = o.JobStatesTs
	}
	if !IsNil(o.BfBackfilledJobs) {
		toSerialize["bf_backfilled_jobs"] = o.BfBackfilledJobs
	}
	if !IsNil(o.BfLastBackfilledJobs) {
		toSerialize["bf_last_backfilled_jobs"] = o.BfLastBackfilledJobs
	}
	if !IsNil(o.BfBackfilledHetJobs) {
		toSerialize["bf_backfilled_het_jobs"] = o.BfBackfilledHetJobs
	}
	if !IsNil(o.BfCycleCounter) {
		toSerialize["bf_cycle_counter"] = o.BfCycleCounter
	}
	if !IsNil(o.BfCycleMean) {
		toSerialize["bf_cycle_mean"] = o.BfCycleMean
	}
	if !IsNil(o.BfCycleMax) {
		toSerialize["bf_cycle_max"] = o.BfCycleMax
	}
	if !IsNil(o.BfLastDepth) {
		toSerialize["bf_last_depth"] = o.BfLastDepth
	}
	if !IsNil(o.BfLastDepthTry) {
		toSerialize["bf_last_depth_try"] = o.BfLastDepthTry
	}
	if !IsNil(o.BfDepthMean) {
		toSerialize["bf_depth_mean"] = o.BfDepthMean
	}
	if !IsNil(o.BfDepthMeanTry) {
		toSerialize["bf_depth_mean_try"] = o.BfDepthMeanTry
	}
	if !IsNil(o.BfCycleLast) {
		toSerialize["bf_cycle_last"] = o.BfCycleLast
	}
	if !IsNil(o.BfQueueLen) {
		toSerialize["bf_queue_len"] = o.BfQueueLen
	}
	if !IsNil(o.BfQueueLenMean) {
		toSerialize["bf_queue_len_mean"] = o.BfQueueLenMean
	}
	if !IsNil(o.BfTableSize) {
		toSerialize["bf_table_size"] = o.BfTableSize
	}
	if !IsNil(o.BfTableSizeMean) {
		toSerialize["bf_table_size_mean"] = o.BfTableSizeMean
	}
	if !IsNil(o.BfWhenLastCycle) {
		toSerialize["bf_when_last_cycle"] = o.BfWhenLastCycle
	}
	if !IsNil(o.BfActive) {
		toSerialize["bf_active"] = o.BfActive
	}
	if !IsNil(o.RpcsByMessageType) {
		toSerialize["rpcs_by_message_type"] = o.RpcsByMessageType
	}
	if !IsNil(o.RpcsByUser) {
		toSerialize["rpcs_by_user"] = o.RpcsByUser
	}
	return toSerialize, nil
}

type NullableV0038DiagStatistics struct {
	value *V0038DiagStatistics
	isSet bool
}

func (v NullableV0038DiagStatistics) Get() *V0038DiagStatistics {
	return v.value
}

func (v *NullableV0038DiagStatistics) Set(val *V0038DiagStatistics) {
	v.value = val
	v.isSet = true
}

func (v NullableV0038DiagStatistics) IsSet() bool {
	return v.isSet
}

func (v *NullableV0038DiagStatistics) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableV0038DiagStatistics(val *V0038DiagStatistics) *NullableV0038DiagStatistics {
	return &NullableV0038DiagStatistics{value: val, isSet: true}
}

func (v NullableV0038DiagStatistics) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableV0038DiagStatistics) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


