/*
Slurm Rest API RO

API to access Slurm. Only GET requests are implemented.

API version: 0.0.38
Contact: sales@schedmd.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package v0038

import (
	"encoding/json"
)

// checks if the V0038NodeAllocation type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &V0038NodeAllocation{}

// V0038NodeAllocation struct for V0038NodeAllocation
type V0038NodeAllocation struct {
	// amount of assigned job memory
	Memory *int32 `json:"memory,omitempty"`
	// number of assigned job CPUs
	Cpus *int32 `json:"cpus,omitempty"`
	Sockets *V0038NodeAllocationSockets `json:"sockets,omitempty"`
	// node name
	Nodename *string `json:"nodename,omitempty"`
}

// NewV0038NodeAllocation instantiates a new V0038NodeAllocation object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewV0038NodeAllocation() *V0038NodeAllocation {
	this := V0038NodeAllocation{}
	return &this
}

// NewV0038NodeAllocationWithDefaults instantiates a new V0038NodeAllocation object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewV0038NodeAllocationWithDefaults() *V0038NodeAllocation {
	this := V0038NodeAllocation{}
	return &this
}

// GetMemory returns the Memory field value if set, zero value otherwise.
func (o *V0038NodeAllocation) GetMemory() int32 {
	if o == nil || IsNil(o.Memory) {
		var ret int32
		return ret
	}
	return *o.Memory
}

// GetMemoryOk returns a tuple with the Memory field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038NodeAllocation) GetMemoryOk() (*int32, bool) {
	if o == nil || IsNil(o.Memory) {
		return nil, false
	}
	return o.Memory, true
}

// HasMemory returns a boolean if a field has been set.
func (o *V0038NodeAllocation) HasMemory() bool {
	if o != nil && !IsNil(o.Memory) {
		return true
	}

	return false
}

// SetMemory gets a reference to the given int32 and assigns it to the Memory field.
func (o *V0038NodeAllocation) SetMemory(v int32) {
	o.Memory = &v
}

// GetCpus returns the Cpus field value if set, zero value otherwise.
func (o *V0038NodeAllocation) GetCpus() int32 {
	if o == nil || IsNil(o.Cpus) {
		var ret int32
		return ret
	}
	return *o.Cpus
}

// GetCpusOk returns a tuple with the Cpus field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038NodeAllocation) GetCpusOk() (*int32, bool) {
	if o == nil || IsNil(o.Cpus) {
		return nil, false
	}
	return o.Cpus, true
}

// HasCpus returns a boolean if a field has been set.
func (o *V0038NodeAllocation) HasCpus() bool {
	if o != nil && !IsNil(o.Cpus) {
		return true
	}

	return false
}

// SetCpus gets a reference to the given int32 and assigns it to the Cpus field.
func (o *V0038NodeAllocation) SetCpus(v int32) {
	o.Cpus = &v
}

// GetSockets returns the Sockets field value if set, zero value otherwise.
func (o *V0038NodeAllocation) GetSockets() V0038NodeAllocationSockets {
	if o == nil || IsNil(o.Sockets) {
		var ret V0038NodeAllocationSockets
		return ret
	}
	return *o.Sockets
}

// GetSocketsOk returns a tuple with the Sockets field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038NodeAllocation) GetSocketsOk() (*V0038NodeAllocationSockets, bool) {
	if o == nil || IsNil(o.Sockets) {
		return nil, false
	}
	return o.Sockets, true
}

// HasSockets returns a boolean if a field has been set.
func (o *V0038NodeAllocation) HasSockets() bool {
	if o != nil && !IsNil(o.Sockets) {
		return true
	}

	return false
}

// SetSockets gets a reference to the given V0038NodeAllocationSockets and assigns it to the Sockets field.
func (o *V0038NodeAllocation) SetSockets(v V0038NodeAllocationSockets) {
	o.Sockets = &v
}

// GetNodename returns the Nodename field value if set, zero value otherwise.
func (o *V0038NodeAllocation) GetNodename() string {
	if o == nil || IsNil(o.Nodename) {
		var ret string
		return ret
	}
	return *o.Nodename
}

// GetNodenameOk returns a tuple with the Nodename field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *V0038NodeAllocation) GetNodenameOk() (*string, bool) {
	if o == nil || IsNil(o.Nodename) {
		return nil, false
	}
	return o.Nodename, true
}

// HasNodename returns a boolean if a field has been set.
func (o *V0038NodeAllocation) HasNodename() bool {
	if o != nil && !IsNil(o.Nodename) {
		return true
	}

	return false
}

// SetNodename gets a reference to the given string and assigns it to the Nodename field.
func (o *V0038NodeAllocation) SetNodename(v string) {
	o.Nodename = &v
}

func (o V0038NodeAllocation) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o V0038NodeAllocation) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Memory) {
		toSerialize["memory"] = o.Memory
	}
	if !IsNil(o.Cpus) {
		toSerialize["cpus"] = o.Cpus
	}
	if !IsNil(o.Sockets) {
		toSerialize["sockets"] = o.Sockets
	}
	if !IsNil(o.Nodename) {
		toSerialize["nodename"] = o.Nodename
	}
	return toSerialize, nil
}

type NullableV0038NodeAllocation struct {
	value *V0038NodeAllocation
	isSet bool
}

func (v NullableV0038NodeAllocation) Get() *V0038NodeAllocation {
	return v.value
}

func (v *NullableV0038NodeAllocation) Set(val *V0038NodeAllocation) {
	v.value = val
	v.isSet = true
}

func (v NullableV0038NodeAllocation) IsSet() bool {
	return v.isSet
}

func (v *NullableV0038NodeAllocation) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableV0038NodeAllocation(val *V0038NodeAllocation) *NullableV0038NodeAllocation {
	return &NullableV0038NodeAllocation{value: val, isSet: true}
}

func (v NullableV0038NodeAllocation) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableV0038NodeAllocation) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


