// SPDX-FileCopyrightText: 2023 The Pion community <https://pion.ly>
// SPDX-License-Identifier: MIT

package extension

import "testing"

func FuzzUnmarshal(f *testing.F) {
	f.Add([]byte{0x00})
	f.Add([]byte{1, 6, 8, 3, 88, 12, 2, 47})
	f.Add([]byte{0x0, 0xa, 0x0, 0x4, 0x0, 0x2, 0x0, 0x1d})
	f.Add([]byte{0x00, 0x0b, 0x00, 0x02, 0x01, 0x00})
	f.Add([]byte{0x00, 0x0d, 0x00, 0x08, 0x00, 0x06, 0x04, 0x03, 0x05, 0x03, 0x06, 0x03})
	f.Add([]byte{0x00, 0x0e, 0x00, 0x05, 0x00, 0x02, 0x00, 0x01, 0x00})

	f.Fuzz(func(_ *testing.T, data []byte) {
		_, _ = Unmarshal(data)
	})
}
