// Copyright 2022-2025 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package main

import (
	"log"
	"path/filepath"

	"github.com/sacloud/iaas-api-go/internal/define"
	"github.com/sacloud/iaas-api-go/internal/tools"
)

const destination = "zz_api_ops.go"

func init() {
	log.SetFlags(0)
	log.SetPrefix("gen-api-op: ")
}

func main() {
	outputPath := filepath.Join(tools.ProjectRootPath(), destination)

	tools.WriteFileWithTemplate(&tools.TemplateConfig{
		OutputPath: outputPath,
		Template:   tmpl,
		Parameter:  define.APIs,
	})

	log.Printf("generated: %s\n", outputPath)
}

const tmpl = `// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-op'; DO NOT EDIT

package iaas

import (
	"context"
	"github.com/sacloud/packages-go/mutexkv"
	"github.com/sacloud/iaas-api-go/types"
)

var apiLocker = mutexkv.NewMutexKV()

func init() {
{{ range . }}
	SetClientFactoryFunc("{{.TypeName}}", func(caller APICaller) interface{} {
		return &{{ .TypeName }}Op {
			Client: caller,
			PathSuffix: "{{.GetPathSuffix}}",
			PathName: "{{.GetPathName}}",
		}
	})
{{ end -}}
}

{{ range . }}{{ $typeName := .TypeName }}{{$resource := .}}

/************************************************* 
* {{$typeName}}Op
*************************************************/

// {{ .TypeName }}Op implements {{ .TypeName }}API interface
type {{ .TypeName }}Op struct{
	// Client APICaller
    Client APICaller
	// PathSuffix is used when building URL
	PathSuffix string
	// PathName is used when building URL
	PathName string
}

// New{{ $typeName}}Op creates new {{ $typeName}}Op instance
func New{{ $typeName}}Op(caller APICaller) {{ $typeName}}API {
	return GetClientFactoryFunc("{{$typeName}}")(caller).({{$typeName}}API)
}

{{ range .Operations }}{{$returnErrStatement := .ReturnErrorStatement}}{{ $operationName := .MethodName }}
// {{ .MethodName }} is API call
func (o *{{ $typeName }}Op) {{ .MethodName }}(ctx context.Context{{if not $resource.IsGlobal}}, zone string{{end}}{{ range .Arguments }}, {{ .ArgName }} {{ .TypeName }}{{ end }}) {{.ResultsStatement}} {
	// build request URL
	pathBuildParameter := map[string]interface{}{
		"rootURL": SakuraCloudAPIRoot,
		"pathSuffix": o.PathSuffix,
		"pathName": o.PathName,
		{{- if $resource.IsGlobal }}
		"zone": APIDefaultZone,
		{{- else }}
		"zone": zone,
		{{- end }}
		{{- range .Arguments }}
		"{{.PathFormatName}}": {{.Name}},
		{{- end }}
	}

	url, err := buildURL("{{.GetPathFormat}}", pathBuildParameter)
	if err != nil {
		return {{ $returnErrStatement }}
	}
	{{ if .LockKeyFormat -}}
	lockKey, err := buildURL("{{.LockKeyFormat}}", pathBuildParameter)	
	if err != nil {
		return {{ $returnErrStatement }}
	}
	apiLocker.Lock(lockKey)
	defer apiLocker.Unlock(lockKey)
	{{ end -}}

	// build request body
	var body interface{}
{{ if .HasRequestEnvelope -}}
	v, err := o.transform{{.MethodName}}Args({{ range .Arguments }}{{ .ArgName }},{{ end }})
	if err != nil {
		return {{ $returnErrStatement }}
	}
	body = v
{{ end }}

	// do request
	{{ if .HasResponseEnvelope -}}
	data, err := o.Client.Do(ctx, "{{.Method}}", url, body)
	{{ else -}}
	_, err = o.Client.Do(ctx, "{{.Method}}", url, body)
	{{ end -}}
	if err != nil {
		return {{ $returnErrStatement }}
	}

	// build results
	{{ if .HasResponseEnvelope -}}
	results, err := o.transform{{.MethodName}}Results(data)
	if err != nil {
		return {{ $returnErrStatement }}
	}	
	return {{ .ReturnStatement }}
	{{ else }}
	return nil
	{{ end -}}
}
{{ end -}}
{{ end -}}
`
