// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: proto/signalfx_metrics.proto

package model

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
	proto "github.com/gogo/protobuf/proto"
	golang_proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = golang_proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type MetricType int32

const (
	//*
	// Numerical: Periodic, instantaneous measurement of some state.
	MetricType_GAUGE MetricType = 0
	//*
	// Numerical: Count of occurrences. Generally non-negative integers.
	MetricType_COUNTER MetricType = 1
	//*
	// String: Used for non-continuous quantities (that is, measurements where there is a fixed
	// set of meaningful values). This is essentially a special case of gauge.
	MetricType_ENUM MetricType = 2
	//*
	// Tracks a value that increases over time, where only the difference is important.
	MetricType_CUMULATIVE_COUNTER MetricType = 3
)

var MetricType_name = map[int32]string{
	0: "GAUGE",
	1: "COUNTER",
	2: "ENUM",
	3: "CUMULATIVE_COUNTER",
}

var MetricType_value = map[string]int32{
	"GAUGE":              0,
	"COUNTER":            1,
	"ENUM":               2,
	"CUMULATIVE_COUNTER": 3,
}

func (x MetricType) Enum() *MetricType {
	p := new(MetricType)
	*p = x
	return p
}

func (x MetricType) String() string {
	return proto.EnumName(MetricType_name, int32(x))
}

func (x *MetricType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(MetricType_value, data, "MetricType")
	if err != nil {
		return err
	}
	*x = MetricType(value)
	return nil
}

func (MetricType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{0}
}

//*
// Different categories of events supported
type EventCategory int32

const (
	//*
	// Created by user via UI or API, e.g. a deployment event
	EventCategory_USER_DEFINED EventCategory = 1000000
	//*
	// Output by anomaly detectors
	EventCategory_ALERT EventCategory = 100000
	//*
	// Audit trail events
	EventCategory_AUDIT EventCategory = 200000
	//*
	// Generated by analytics server
	EventCategory_JOB EventCategory = 300000
	//*
	// @deprecated
	// Event originated within collectd (deprecated in favor of AGENT)
	EventCategory_COLLECTD EventCategory = 400000
	//*
	// Service discovery event
	EventCategory_SERVICE_DISCOVERY EventCategory = 500000
	//*
	// Created by exception appenders to denote exceptional events
	EventCategory_EXCEPTION EventCategory = 700000
	//*
	// Event originated from an agent
	EventCategory_AGENT EventCategory = 2000000
)

var EventCategory_name = map[int32]string{
	1000000: "USER_DEFINED",
	100000:  "ALERT",
	200000:  "AUDIT",
	300000:  "JOB",
	400000:  "COLLECTD",
	500000:  "SERVICE_DISCOVERY",
	700000:  "EXCEPTION",
	2000000: "AGENT",
}

var EventCategory_value = map[string]int32{
	"USER_DEFINED":      1000000,
	"ALERT":             100000,
	"AUDIT":             200000,
	"JOB":               300000,
	"COLLECTD":          400000,
	"SERVICE_DISCOVERY": 500000,
	"EXCEPTION":         700000,
	"AGENT":             2000000,
}

func (x EventCategory) Enum() *EventCategory {
	p := new(EventCategory)
	*p = x
	return p
}

func (x EventCategory) String() string {
	return proto.EnumName(EventCategory_name, int32(x))
}

func (x *EventCategory) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(EventCategory_value, data, "EventCategory")
	if err != nil {
		return err
	}
	*x = EventCategory(value)
	return nil
}

func (EventCategory) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{1}
}

type Datum struct {
	StrValue             *string  `protobuf:"bytes,1,opt,name=strValue" json:"strValue,omitempty"`
	DoubleValue          *float64 `protobuf:"fixed64,2,opt,name=doubleValue" json:"doubleValue,omitempty"`
	IntValue             *int64   `protobuf:"varint,3,opt,name=intValue" json:"intValue,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Datum) Reset()         { *m = Datum{} }
func (m *Datum) String() string { return proto.CompactTextString(m) }
func (*Datum) ProtoMessage()    {}
func (*Datum) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{0}
}
func (m *Datum) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Datum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Datum.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Datum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Datum.Merge(m, src)
}
func (m *Datum) XXX_Size() int {
	return m.Size()
}
func (m *Datum) XXX_DiscardUnknown() {
	xxx_messageInfo_Datum.DiscardUnknown(m)
}

var xxx_messageInfo_Datum proto.InternalMessageInfo

func (m *Datum) GetStrValue() string {
	if m != nil && m.StrValue != nil {
		return *m.StrValue
	}
	return ""
}

func (m *Datum) GetDoubleValue() float64 {
	if m != nil && m.DoubleValue != nil {
		return *m.DoubleValue
	}
	return 0
}

func (m *Datum) GetIntValue() int64 {
	if m != nil && m.IntValue != nil {
		return *m.IntValue
	}
	return 0
}

type Dimension struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key" json:"key"`
	Value                string   `protobuf:"bytes,2,opt,name=value" json:"value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Dimension) Reset()         { *m = Dimension{} }
func (m *Dimension) String() string { return proto.CompactTextString(m) }
func (*Dimension) ProtoMessage()    {}
func (*Dimension) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{1}
}
func (m *Dimension) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Dimension) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Dimension.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Dimension) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Dimension.Merge(m, src)
}
func (m *Dimension) XXX_Size() int {
	return m.Size()
}
func (m *Dimension) XXX_DiscardUnknown() {
	xxx_messageInfo_Dimension.DiscardUnknown(m)
}

var xxx_messageInfo_Dimension proto.InternalMessageInfo

func (m *Dimension) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Dimension) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type DataPoint struct {
	Source               string       `protobuf:"bytes,1,opt,name=source" json:"source"`
	Metric               string       `protobuf:"bytes,2,opt,name=metric" json:"metric"`
	Timestamp            int64        `protobuf:"varint,3,opt,name=timestamp" json:"timestamp"`
	Value                Datum        `protobuf:"bytes,4,opt,name=value" json:"value"`
	MetricType           *MetricType  `protobuf:"varint,5,opt,name=metricType,enum=com.signalfx.metrics.model.MetricType" json:"metricType,omitempty"`
	Dimensions           []*Dimension `protobuf:"bytes,6,rep,name=dimensions" json:"dimensions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *DataPoint) Reset()         { *m = DataPoint{} }
func (m *DataPoint) String() string { return proto.CompactTextString(m) }
func (*DataPoint) ProtoMessage()    {}
func (*DataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{2}
}
func (m *DataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataPoint.Merge(m, src)
}
func (m *DataPoint) XXX_Size() int {
	return m.Size()
}
func (m *DataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_DataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_DataPoint proto.InternalMessageInfo

func (m *DataPoint) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *DataPoint) GetMetric() string {
	if m != nil {
		return m.Metric
	}
	return ""
}

func (m *DataPoint) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *DataPoint) GetValue() Datum {
	if m != nil {
		return m.Value
	}
	return Datum{}
}

func (m *DataPoint) GetMetricType() MetricType {
	if m != nil && m.MetricType != nil {
		return *m.MetricType
	}
	return MetricType_GAUGE
}

func (m *DataPoint) GetDimensions() []*Dimension {
	if m != nil {
		return m.Dimensions
	}
	return nil
}

type DataPointUploadMessage struct {
	Datapoints           []*DataPoint `protobuf:"bytes,1,rep,name=datapoints" json:"datapoints,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *DataPointUploadMessage) Reset()         { *m = DataPointUploadMessage{} }
func (m *DataPointUploadMessage) String() string { return proto.CompactTextString(m) }
func (*DataPointUploadMessage) ProtoMessage()    {}
func (*DataPointUploadMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{3}
}
func (m *DataPointUploadMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataPointUploadMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataPointUploadMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DataPointUploadMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataPointUploadMessage.Merge(m, src)
}
func (m *DataPointUploadMessage) XXX_Size() int {
	return m.Size()
}
func (m *DataPointUploadMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_DataPointUploadMessage.DiscardUnknown(m)
}

var xxx_messageInfo_DataPointUploadMessage proto.InternalMessageInfo

func (m *DataPointUploadMessage) GetDatapoints() []*DataPoint {
	if m != nil {
		return m.Datapoints
	}
	return nil
}

type PointValue struct {
	Timestamp            int64    `protobuf:"varint,3,opt,name=timestamp" json:"timestamp"`
	Value                Datum    `protobuf:"bytes,4,opt,name=value" json:"value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PointValue) Reset()         { *m = PointValue{} }
func (m *PointValue) String() string { return proto.CompactTextString(m) }
func (*PointValue) ProtoMessage()    {}
func (*PointValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{4}
}
func (m *PointValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PointValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PointValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PointValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PointValue.Merge(m, src)
}
func (m *PointValue) XXX_Size() int {
	return m.Size()
}
func (m *PointValue) XXX_DiscardUnknown() {
	xxx_messageInfo_PointValue.DiscardUnknown(m)
}

var xxx_messageInfo_PointValue proto.InternalMessageInfo

func (m *PointValue) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *PointValue) GetValue() Datum {
	if m != nil {
		return m.Value
	}
	return Datum{}
}

type Property struct {
	Key                  string         `protobuf:"bytes,1,opt,name=key" json:"key"`
	Value                *PropertyValue `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Property) Reset()         { *m = Property{} }
func (m *Property) String() string { return proto.CompactTextString(m) }
func (*Property) ProtoMessage()    {}
func (*Property) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{5}
}
func (m *Property) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Property) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Property.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Property) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Property.Merge(m, src)
}
func (m *Property) XXX_Size() int {
	return m.Size()
}
func (m *Property) XXX_DiscardUnknown() {
	xxx_messageInfo_Property.DiscardUnknown(m)
}

var xxx_messageInfo_Property proto.InternalMessageInfo

func (m *Property) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Property) GetValue() *PropertyValue {
	if m != nil {
		return m.Value
	}
	return nil
}

type PropertyValue struct {
	StrValue             *string  `protobuf:"bytes,1,opt,name=strValue" json:"strValue,omitempty"`
	DoubleValue          *float64 `protobuf:"fixed64,2,opt,name=doubleValue" json:"doubleValue,omitempty"`
	IntValue             *int64   `protobuf:"varint,3,opt,name=intValue" json:"intValue,omitempty"`
	BoolValue            *bool    `protobuf:"varint,4,opt,name=boolValue" json:"boolValue,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PropertyValue) Reset()         { *m = PropertyValue{} }
func (m *PropertyValue) String() string { return proto.CompactTextString(m) }
func (*PropertyValue) ProtoMessage()    {}
func (*PropertyValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{6}
}
func (m *PropertyValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PropertyValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PropertyValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PropertyValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PropertyValue.Merge(m, src)
}
func (m *PropertyValue) XXX_Size() int {
	return m.Size()
}
func (m *PropertyValue) XXX_DiscardUnknown() {
	xxx_messageInfo_PropertyValue.DiscardUnknown(m)
}

var xxx_messageInfo_PropertyValue proto.InternalMessageInfo

func (m *PropertyValue) GetStrValue() string {
	if m != nil && m.StrValue != nil {
		return *m.StrValue
	}
	return ""
}

func (m *PropertyValue) GetDoubleValue() float64 {
	if m != nil && m.DoubleValue != nil {
		return *m.DoubleValue
	}
	return 0
}

func (m *PropertyValue) GetIntValue() int64 {
	if m != nil && m.IntValue != nil {
		return *m.IntValue
	}
	return 0
}

func (m *PropertyValue) GetBoolValue() bool {
	if m != nil && m.BoolValue != nil {
		return *m.BoolValue
	}
	return false
}

type Event struct {
	EventType            string         `protobuf:"bytes,1,req,name=eventType" json:"eventType"`
	Dimensions           []*Dimension   `protobuf:"bytes,2,rep,name=dimensions" json:"dimensions,omitempty"`
	Properties           []*Property    `protobuf:"bytes,3,rep,name=properties" json:"properties,omitempty"`
	Category             *EventCategory `protobuf:"varint,4,opt,name=category,enum=com.signalfx.metrics.model.EventCategory" json:"category,omitempty"`
	Timestamp            int64          `protobuf:"varint,5,opt,name=timestamp" json:"timestamp"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{7}
}
func (m *Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return m.Size()
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetEventType() string {
	if m != nil {
		return m.EventType
	}
	return ""
}

func (m *Event) GetDimensions() []*Dimension {
	if m != nil {
		return m.Dimensions
	}
	return nil
}

func (m *Event) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *Event) GetCategory() EventCategory {
	if m != nil && m.Category != nil {
		return *m.Category
	}
	return EventCategory_USER_DEFINED
}

func (m *Event) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

type EventUploadMessage struct {
	Events               []*Event `protobuf:"bytes,1,rep,name=events" json:"events,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventUploadMessage) Reset()         { *m = EventUploadMessage{} }
func (m *EventUploadMessage) String() string { return proto.CompactTextString(m) }
func (*EventUploadMessage) ProtoMessage()    {}
func (*EventUploadMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_a21bf05b1b375569, []int{8}
}
func (m *EventUploadMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EventUploadMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EventUploadMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EventUploadMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventUploadMessage.Merge(m, src)
}
func (m *EventUploadMessage) XXX_Size() int {
	return m.Size()
}
func (m *EventUploadMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_EventUploadMessage.DiscardUnknown(m)
}

var xxx_messageInfo_EventUploadMessage proto.InternalMessageInfo

func (m *EventUploadMessage) GetEvents() []*Event {
	if m != nil {
		return m.Events
	}
	return nil
}

func init() {
	proto.RegisterEnum("com.signalfx.metrics.model.MetricType", MetricType_name, MetricType_value)
	golang_proto.RegisterEnum("com.signalfx.metrics.model.MetricType", MetricType_name, MetricType_value)
	proto.RegisterEnum("com.signalfx.metrics.model.EventCategory", EventCategory_name, EventCategory_value)
	golang_proto.RegisterEnum("com.signalfx.metrics.model.EventCategory", EventCategory_name, EventCategory_value)
	proto.RegisterType((*Datum)(nil), "com.signalfx.metrics.model.Datum")
	golang_proto.RegisterType((*Datum)(nil), "com.signalfx.metrics.model.Datum")
	proto.RegisterType((*Dimension)(nil), "com.signalfx.metrics.model.Dimension")
	golang_proto.RegisterType((*Dimension)(nil), "com.signalfx.metrics.model.Dimension")
	proto.RegisterType((*DataPoint)(nil), "com.signalfx.metrics.model.DataPoint")
	golang_proto.RegisterType((*DataPoint)(nil), "com.signalfx.metrics.model.DataPoint")
	proto.RegisterType((*DataPointUploadMessage)(nil), "com.signalfx.metrics.model.DataPointUploadMessage")
	golang_proto.RegisterType((*DataPointUploadMessage)(nil), "com.signalfx.metrics.model.DataPointUploadMessage")
	proto.RegisterType((*PointValue)(nil), "com.signalfx.metrics.model.PointValue")
	golang_proto.RegisterType((*PointValue)(nil), "com.signalfx.metrics.model.PointValue")
	proto.RegisterType((*Property)(nil), "com.signalfx.metrics.model.Property")
	golang_proto.RegisterType((*Property)(nil), "com.signalfx.metrics.model.Property")
	proto.RegisterType((*PropertyValue)(nil), "com.signalfx.metrics.model.PropertyValue")
	golang_proto.RegisterType((*PropertyValue)(nil), "com.signalfx.metrics.model.PropertyValue")
	proto.RegisterType((*Event)(nil), "com.signalfx.metrics.model.Event")
	golang_proto.RegisterType((*Event)(nil), "com.signalfx.metrics.model.Event")
	proto.RegisterType((*EventUploadMessage)(nil), "com.signalfx.metrics.model.EventUploadMessage")
	golang_proto.RegisterType((*EventUploadMessage)(nil), "com.signalfx.metrics.model.EventUploadMessage")
}

func init() { proto.RegisterFile("proto/signalfx_metrics.proto", fileDescriptor_a21bf05b1b375569) }
func init() {
	golang_proto.RegisterFile("proto/signalfx_metrics.proto", fileDescriptor_a21bf05b1b375569)
}

var fileDescriptor_a21bf05b1b375569 = []byte{
	// 695 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x53, 0x3f, 0x6f, 0xd3, 0x5e,
	0x14, 0xed, 0x4b, 0xea, 0xfc, 0xe2, 0x9b, 0xb6, 0x3f, 0xf3, 0x84, 0xda, 0x28, 0xaa, 0x82, 0x6b,
	0x01, 0x0a, 0x1d, 0x82, 0x94, 0x8d, 0xa1, 0xaa, 0x5a, 0xfb, 0xb5, 0x0a, 0xca, 0x9f, 0xea, 0xd5,
	0x8e, 0x80, 0x25, 0x72, 0x93, 0x47, 0x64, 0x91, 0xe4, 0x59, 0xb6, 0x53, 0x11, 0xa6, 0x0e, 0x48,
	0x88, 0x01, 0xb1, 0x33, 0x55, 0x62, 0xe0, 0x13, 0x30, 0xb0, 0x55, 0x4c, 0x1d, 0xf9, 0x00, 0x08,
	0x55, 0xe5, 0x8b, 0x20, 0xdb, 0xb1, 0x13, 0x23, 0x1a, 0x2a, 0xa4, 0x6e, 0x7e, 0xe7, 0xde, 0x73,
	0xee, 0xbb, 0xc7, 0xe7, 0xc1, 0xba, 0xed, 0x70, 0x8f, 0x3f, 0x74, 0xad, 0xde, 0xd0, 0xec, 0x3f,
	0x7f, 0xd9, 0x1e, 0x30, 0xcf, 0xb1, 0x3a, 0x6e, 0x39, 0x80, 0x71, 0xa1, 0xc3, 0x07, 0xe5, 0xa8,
	0x56, 0x8e, 0x6a, 0x03, 0xde, 0x65, 0xfd, 0xc2, 0xed, 0x1e, 0xef, 0xf1, 0x90, 0xed, 0x7f, 0x85,
	0x0c, 0xc5, 0x04, 0x41, 0x33, 0xbd, 0xd1, 0x00, 0x17, 0x20, 0xeb, 0x7a, 0x4e, 0xcb, 0xec, 0x8f,
	0x58, 0x1e, 0xc9, 0xa8, 0x24, 0xd2, 0xf8, 0x8c, 0x65, 0xc8, 0x75, 0xf9, 0xe8, 0xa8, 0xcf, 0xc2,
	0x72, 0x4a, 0x46, 0x25, 0x44, 0x67, 0x21, 0x9f, 0x6d, 0x0d, 0xbd, 0xb0, 0x9c, 0x96, 0x51, 0x29,
	0x4d, 0xe3, 0xb3, 0xb2, 0x0d, 0xa2, 0x66, 0x0d, 0xd8, 0xd0, 0xb5, 0xf8, 0x10, 0xaf, 0x42, 0xfa,
	0x05, 0x1b, 0x87, 0x13, 0x76, 0x17, 0xcf, 0x7f, 0xdc, 0x59, 0xa0, 0x3e, 0x80, 0x0b, 0x20, 0x1c,
	0xc7, 0xe2, 0x51, 0x25, 0x84, 0x94, 0x2f, 0x29, 0x10, 0x35, 0xd3, 0x33, 0x0f, 0xb8, 0x35, 0xf4,
	0xf0, 0x3a, 0x64, 0x5c, 0x3e, 0x72, 0x3a, 0x2c, 0x21, 0x32, 0xc1, 0xfc, 0x6a, 0xb8, 0x76, 0x42,
	0x68, 0x82, 0x61, 0x05, 0x44, 0xcf, 0x1a, 0x30, 0xd7, 0x33, 0x07, 0x76, 0x78, 0xcf, 0x49, 0xc3,
	0x14, 0xc6, 0x5b, 0xd1, 0x4d, 0x16, 0x65, 0x54, 0xca, 0x55, 0x36, 0xca, 0x57, 0x7b, 0x5a, 0x0e,
	0xac, 0x4b, 0x5c, 0x16, 0xef, 0x01, 0x84, 0x3d, 0xfa, 0xd8, 0x66, 0x79, 0x41, 0x46, 0xa5, 0x95,
	0xca, 0xfd, 0x79, 0x1a, 0xf5, 0xb8, 0x9b, 0xce, 0x30, 0x31, 0x01, 0xe8, 0x46, 0xae, 0xb9, 0xf9,
	0x8c, 0x9c, 0x2e, 0xe5, 0x2a, 0xf7, 0xe6, 0xde, 0x25, 0xea, 0xa6, 0x33, 0x44, 0xa5, 0x0d, 0xab,
	0xb1, 0x75, 0x86, 0xdd, 0xe7, 0x66, 0xb7, 0xce, 0x5c, 0xd7, 0xec, 0x85, 0x03, 0x4c, 0xcf, 0xb4,
	0xfd, 0x8a, 0x9b, 0x47, 0xd7, 0x18, 0x10, 0xe9, 0xd0, 0x19, 0xa2, 0xc2, 0x01, 0x02, 0x30, 0xcc,
	0xc1, 0xcd, 0x1b, 0xac, 0x74, 0x20, 0x7b, 0xe0, 0x70, 0x9b, 0x39, 0xde, 0xf8, 0xca, 0x34, 0x6d,
	0xcf, 0xa6, 0x29, 0x57, 0x79, 0x30, 0x6f, 0x44, 0x24, 0x16, 0x2c, 0x10, 0x0d, 0x79, 0x83, 0x60,
	0x39, 0x51, 0xb8, 0xb9, 0xf7, 0x81, 0xd7, 0x41, 0x3c, 0xe2, 0xbc, 0xdf, 0x8a, 0x3d, 0xc9, 0xd2,
	0x29, 0xa0, 0x7c, 0x4c, 0x81, 0x40, 0x8e, 0xd9, 0xd0, 0xf3, 0xbd, 0x65, 0xfe, 0x47, 0x10, 0x2c,
	0x24, 0xa7, 0xe2, 0x95, 0xa7, 0xf0, 0x6f, 0xa9, 0x49, 0xfd, 0x63, 0x6a, 0xb0, 0x06, 0x60, 0x87,
	0xdb, 0x5b, 0xcc, 0xcd, 0xa7, 0x03, 0x99, 0xbb, 0xd7, 0x31, 0x91, 0xce, 0xf0, 0x30, 0x81, 0x6c,
	0xc7, 0xf4, 0x58, 0x8f, 0x3b, 0xe3, 0x60, 0xaf, 0x95, 0xf9, 0x3f, 0x22, 0xd8, 0x52, 0x9d, 0x10,
	0x68, 0x4c, 0x4d, 0x66, 0x4a, 0xf8, 0x63, 0xa6, 0x94, 0x26, 0xe0, 0x80, 0x9e, 0x8c, 0xf8, 0x23,
	0xc8, 0x04, 0xd6, 0x44, 0xf1, 0xde, 0xf8, 0xeb, 0x78, 0x3a, 0x21, 0x6c, 0xee, 0x01, 0x4c, 0x1f,
	0x26, 0x16, 0x41, 0xd8, 0xdf, 0x31, 0xf6, 0x89, 0xb4, 0x80, 0x73, 0xf0, 0x9f, 0xda, 0x34, 0x1a,
	0x3a, 0xa1, 0x12, 0xc2, 0x59, 0x58, 0x24, 0x0d, 0xa3, 0x2e, 0xa5, 0xf0, 0x2a, 0x60, 0xd5, 0xa8,
	0x1b, 0xb5, 0x1d, 0xbd, 0xda, 0x22, 0xed, 0xa8, 0x23, 0xbd, 0xf9, 0x1e, 0xc1, 0x72, 0x62, 0x31,
	0x8c, 0x61, 0xc9, 0x38, 0x24, 0xb4, 0xad, 0x91, 0xbd, 0x6a, 0x83, 0x68, 0xd2, 0xd9, 0xeb, 0x2d,
	0x9c, 0x03, 0x61, 0xa7, 0x46, 0xa8, 0x2e, 0x9d, 0xbe, 0xcb, 0x04, 0x07, 0x43, 0xab, 0xea, 0xd2,
	0xd9, 0x87, 0x25, 0x2c, 0x42, 0xfa, 0x71, 0x73, 0x57, 0xba, 0xf8, 0x84, 0xf1, 0x0a, 0x64, 0xd5,
	0x66, 0xad, 0x46, 0x54, 0x5d, 0x93, 0x4e, 0x3e, 0xe7, 0xf1, 0x1a, 0xdc, 0x3a, 0x24, 0xb4, 0x55,
	0x55, 0x49, 0x5b, 0xab, 0x1e, 0xaa, 0xcd, 0x16, 0xa1, 0x4f, 0xa5, 0xd3, 0xaf, 0x45, 0xfc, 0x3f,
	0x88, 0xe4, 0x89, 0x4a, 0x0e, 0xf4, 0x6a, 0xb3, 0x21, 0x5d, 0x7c, 0xdf, 0x0c, 0x14, 0xf7, 0x49,
	0x43, 0x97, 0x4e, 0xde, 0xbe, 0xda, 0x5d, 0x3b, 0xbf, 0x2c, 0xa2, 0x6f, 0x97, 0x45, 0x74, 0x71,
	0x59, 0x44, 0x67, 0x3f, 0x8b, 0xe8, 0x99, 0x10, 0x18, 0xf0, 0x2b, 0x00, 0x00, 0xff, 0xff, 0x0a,
	0xf5, 0x8f, 0xeb, 0x5b, 0x06, 0x00, 0x00,
}

func (m *Datum) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Datum) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Datum) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IntValue != nil {
		i = encodeVarintSignalfxMetrics(dAtA, i, uint64(*m.IntValue))
		i--
		dAtA[i] = 0x18
	}
	if m.DoubleValue != nil {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.DoubleValue))))
		i--
		dAtA[i] = 0x11
	}
	if m.StrValue != nil {
		i -= len(*m.StrValue)
		copy(dAtA[i:], *m.StrValue)
		i = encodeVarintSignalfxMetrics(dAtA, i, uint64(len(*m.StrValue)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Dimension) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Dimension) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Dimension) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	i -= len(m.Value)
	copy(dAtA[i:], m.Value)
	i = encodeVarintSignalfxMetrics(dAtA, i, uint64(len(m.Value)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Key)
	copy(dAtA[i:], m.Key)
	i = encodeVarintSignalfxMetrics(dAtA, i, uint64(len(m.Key)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *DataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Dimensions) > 0 {
		for iNdEx := len(m.Dimensions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Dimensions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSignalfxMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.MetricType != nil {
		i = encodeVarintSignalfxMetrics(dAtA, i, uint64(*m.MetricType))
		i--
		dAtA[i] = 0x28
	}
	{
		size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintSignalfxMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	i = encodeVarintSignalfxMetrics(dAtA, i, uint64(m.Timestamp))
	i--
	dAtA[i] = 0x18
	i -= len(m.Metric)
	copy(dAtA[i:], m.Metric)
	i = encodeVarintSignalfxMetrics(dAtA, i, uint64(len(m.Metric)))
	i--
	dAtA[i] = 0x12
	i -= len(m.Source)
	copy(dAtA[i:], m.Source)
	i = encodeVarintSignalfxMetrics(dAtA, i, uint64(len(m.Source)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *DataPointUploadMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataPointUploadMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DataPointUploadMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Datapoints) > 0 {
		for iNdEx := len(m.Datapoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Datapoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSignalfxMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PointValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PointValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PointValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	{
		size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintSignalfxMetrics(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x22
	i = encodeVarintSignalfxMetrics(dAtA, i, uint64(m.Timestamp))
	i--
	dAtA[i] = 0x18
	return len(dAtA) - i, nil
}

func (m *Property) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Property) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Property) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSignalfxMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Key)
	copy(dAtA[i:], m.Key)
	i = encodeVarintSignalfxMetrics(dAtA, i, uint64(len(m.Key)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *PropertyValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PropertyValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PropertyValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.BoolValue != nil {
		i--
		if *m.BoolValue {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.IntValue != nil {
		i = encodeVarintSignalfxMetrics(dAtA, i, uint64(*m.IntValue))
		i--
		dAtA[i] = 0x18
	}
	if m.DoubleValue != nil {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(*m.DoubleValue))))
		i--
		dAtA[i] = 0x11
	}
	if m.StrValue != nil {
		i -= len(*m.StrValue)
		copy(dAtA[i:], *m.StrValue)
		i = encodeVarintSignalfxMetrics(dAtA, i, uint64(len(*m.StrValue)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Event) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	i = encodeVarintSignalfxMetrics(dAtA, i, uint64(m.Timestamp))
	i--
	dAtA[i] = 0x28
	if m.Category != nil {
		i = encodeVarintSignalfxMetrics(dAtA, i, uint64(*m.Category))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Properties) > 0 {
		for iNdEx := len(m.Properties) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Properties[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSignalfxMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Dimensions) > 0 {
		for iNdEx := len(m.Dimensions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Dimensions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSignalfxMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	i -= len(m.EventType)
	copy(dAtA[i:], m.EventType)
	i = encodeVarintSignalfxMetrics(dAtA, i, uint64(len(m.EventType)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *EventUploadMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventUploadMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EventUploadMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Events) > 0 {
		for iNdEx := len(m.Events) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Events[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSignalfxMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintSignalfxMetrics(dAtA []byte, offset int, v uint64) int {
	offset -= sovSignalfxMetrics(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Datum) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StrValue != nil {
		l = len(*m.StrValue)
		n += 1 + l + sovSignalfxMetrics(uint64(l))
	}
	if m.DoubleValue != nil {
		n += 9
	}
	if m.IntValue != nil {
		n += 1 + sovSignalfxMetrics(uint64(*m.IntValue))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Dimension) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	n += 1 + l + sovSignalfxMetrics(uint64(l))
	l = len(m.Value)
	n += 1 + l + sovSignalfxMetrics(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Source)
	n += 1 + l + sovSignalfxMetrics(uint64(l))
	l = len(m.Metric)
	n += 1 + l + sovSignalfxMetrics(uint64(l))
	n += 1 + sovSignalfxMetrics(uint64(m.Timestamp))
	l = m.Value.Size()
	n += 1 + l + sovSignalfxMetrics(uint64(l))
	if m.MetricType != nil {
		n += 1 + sovSignalfxMetrics(uint64(*m.MetricType))
	}
	if len(m.Dimensions) > 0 {
		for _, e := range m.Dimensions {
			l = e.Size()
			n += 1 + l + sovSignalfxMetrics(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataPointUploadMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Datapoints) > 0 {
		for _, e := range m.Datapoints {
			l = e.Size()
			n += 1 + l + sovSignalfxMetrics(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PointValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovSignalfxMetrics(uint64(m.Timestamp))
	l = m.Value.Size()
	n += 1 + l + sovSignalfxMetrics(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Property) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	n += 1 + l + sovSignalfxMetrics(uint64(l))
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovSignalfxMetrics(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PropertyValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StrValue != nil {
		l = len(*m.StrValue)
		n += 1 + l + sovSignalfxMetrics(uint64(l))
	}
	if m.DoubleValue != nil {
		n += 9
	}
	if m.IntValue != nil {
		n += 1 + sovSignalfxMetrics(uint64(*m.IntValue))
	}
	if m.BoolValue != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Event) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.EventType)
	n += 1 + l + sovSignalfxMetrics(uint64(l))
	if len(m.Dimensions) > 0 {
		for _, e := range m.Dimensions {
			l = e.Size()
			n += 1 + l + sovSignalfxMetrics(uint64(l))
		}
	}
	if len(m.Properties) > 0 {
		for _, e := range m.Properties {
			l = e.Size()
			n += 1 + l + sovSignalfxMetrics(uint64(l))
		}
	}
	if m.Category != nil {
		n += 1 + sovSignalfxMetrics(uint64(*m.Category))
	}
	n += 1 + sovSignalfxMetrics(uint64(m.Timestamp))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EventUploadMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovSignalfxMetrics(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSignalfxMetrics(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSignalfxMetrics(x uint64) (n int) {
	return sovSignalfxMetrics(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Datum) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSignalfxMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Datum: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Datum: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StrValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.StrValue = &s
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.DoubleValue = &v2
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntValue", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IntValue = &v
		default:
			iNdEx = preIndex
			skippy, err := skipSignalfxMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Dimension) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSignalfxMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Dimension: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Dimension: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSignalfxMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSignalfxMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metric", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metric = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricType", wireType)
			}
			var v MetricType
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= MetricType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MetricType = &v
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dimensions = append(m.Dimensions, &Dimension{})
			if err := m.Dimensions[len(m.Dimensions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSignalfxMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataPointUploadMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSignalfxMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataPointUploadMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataPointUploadMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Datapoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Datapoints = append(m.Datapoints, &DataPoint{})
			if err := m.Datapoints[len(m.Datapoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSignalfxMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PointValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSignalfxMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PointValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PointValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSignalfxMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Property) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSignalfxMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Property: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Property: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &PropertyValue{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSignalfxMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PropertyValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSignalfxMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PropertyValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PropertyValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StrValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.StrValue = &s
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			v2 := float64(math.Float64frombits(v))
			m.DoubleValue = &v2
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntValue", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IntValue = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.BoolValue = &b
		default:
			iNdEx = preIndex
			skippy, err := skipSignalfxMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSignalfxMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EventType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Dimensions = append(m.Dimensions, &Dimension{})
			if err := m.Dimensions[len(m.Dimensions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, &Property{})
			if err := m.Properties[len(m.Properties)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Category", wireType)
			}
			var v EventCategory
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= EventCategory(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Category = &v
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			m.Timestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSignalfxMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("eventType")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventUploadMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSignalfxMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventUploadMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventUploadMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, &Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSignalfxMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSignalfxMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSignalfxMetrics(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSignalfxMetrics
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSignalfxMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSignalfxMetrics
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupSignalfxMetrics
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthSignalfxMetrics
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthSignalfxMetrics        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSignalfxMetrics          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupSignalfxMetrics = fmt.Errorf("proto: unexpected end of group")
)
