#!/usr/bin/env bash

cd "$(dirname $(realpath $0))"

ASSERTIONS=($(
  go tool nm "$(go list -export -f '{{.Export}}' github.com/smartystreets/assertions)" |\
    awk '/ T github\.com\/smartystreets\/assertions\.Should/{split($3, a, "."); print a[3]}' |\
    sort | uniq))

(
  echo "package convey"
  echo
  echo "// DO NOT EDIT: generated by update_assertions.sh"
  echo
  echo "//go:generate ./update_assertions.sh"
  echo
  echo "import \"github.com/smartystreets/assertions\""
  echo
  echo "// These assertions are forwarded from github.com/smartystreets/assertions"
  echo "// in order to make convey self-contained."
  echo "var ("

  for assertion in "${ASSERTIONS[@]}"
  do
    echo "  $assertion = assertions.$assertion"
  done

  echo ")"
) > ./assertions.go

go fmt ./assertions.go
