# Community

Substrait is developed as a consensus-driven open source product under the Apache 2.0
license. Development is done in the open leveraging GitHub issues and PRs.

## Get In Touch

[Mailing List/Google Group](https://groups.google.com/g/substrait)
: We use the mailing list to discuss questions, formulate plans and collaborate asynchronously.

[Slack Channel]({{versions.slackinvitelink}})
: The developers of Substrait frequent the Slack channel. You can get an
  invite to the channel by following [this link]({{versions.slackinvitelink}}).

[GitHub Issues](https://github.com/substrait-io/substrait/issues)
: Substrait is developed via GitHub issues and pull requests. If you see a problem
  or want to enhance the product, we suggest you file a GitHub issue for developers to
  review.

[Twitter](https://twitter.com/substrait_io)
: The [@substrait_io](https://twitter.com/substrait_io) account on Twitter is our official account. Follow-up to keep
  to date on what is happening with Substrait!

[Docs](https://github.com/substrait-io/substrait/tree/main/site/docs)
: Our website is all maintained in our source repository. If there is something you think
  can be improved, feel free to fork our repository and post a pull request.

Meetings
: Our community meets every other week on Wednesday.
<iframe src="https://calendar.google.com/calendar/embed?height=400&wkst=1&bgcolor=%23ffffff&ctz=America%2FLos_Angeles&mode=AGENDA&showNav=0&showDate=0&showPrint=0&showTabs=0&showTz=1&showCalendars=1&showTitle=1&src=OWx1NWhmbGgxZ2dqa2JrbzBoYm9tZnRlNGtAZ3JvdXAuY2FsZW5kYXIuZ29vZ2xlLmNvbQ&color=%23D81B60" style="border:solid 1px #777" width="800" height="400" frameborder="0" scrolling="no"></iframe>


## Talks
Want to learn more about Substrait? Try the following presentations and slide decks.

* Substrait: A Common Representation for Data Compute Plans (Jacques Nadeau, April 2022) [[slides](https://docs.google.com/presentation/d/1H89iwnnmHZ2oMgGpFon9Rv_fJ60RWE0c9drHCZAL8Bw)]

## Citation

If you use Substrait in your research, please cite it using the following BibTeX entry:

```bibtex
@misc{substrait,
  author = {substrait-io},
  title = {Substrait: Cross-Language Serialization for Relational Algebra},
  year = {2021},
  month = {8},
  day = {31},
  publisher = {GitHub},
  journal = {GitHub repository},
  howpublished = {\url{https://github.com/substrait-io/substrait}}
}
```

## Contribution

All contributors are welcome to Substrait.   If you want to join the project, open a PR or get in touch with us as [above](#get-in-touch).


## Principles

* Be inclusive and open to all.
* Ensure a diverse set of contributors that come from multiple data backgrounds to maximize general utility.
* Build a specification based on open consensus.
* Avoid over-reliance/coupling to any single technology.
* Make the specification and all tools freely available on a permissive license (ApacheV2)
