;; Tests for i16x8 arithmetic operations on major boundary values and all special values.


(module
  (func (export "i16x8.q15mulr_sat_s") (param v128 v128) (result v128) (i16x8.q15mulr_sat_s (local.get 0) (local.get 1)))
)


;; i16x8.q15mulr_sat_s
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                             (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                             (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                             (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 16383 16383 16383 16383 16383 16383 16383 16383)
                                             (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                             (v128.const i16x8 8192 8192 8192 8192 8192 8192 8192 8192))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384)
                                             (v128.const i16x8 16384 16384 16384 16384 16384 16384 16384 16384))
                                             (v128.const i16x8 8192 8192 8192 8192 8192 8192 8192 8192))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 -16383 -16383 -16383 -16383 -16383 -16383 -16383 -16383)
                                             (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                             (v128.const i16x8 8192 8192 8192 8192 8192 8192 8192 8192))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384)
                                             (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                             (v128.const i16x8 8192 8192 8192 8192 8192 8192 8192 8192))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 -16385 -16385 -16385 -16385 -16385 -16385 -16385 -16385)
                                             (v128.const i16x8 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384))
                                             (v128.const i16x8 8193 8193 8193 8193 8193 8193 8193 8193))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 32765 32765 32765 32765 32765 32765 32765 32765)
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766)
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 32768 32768 32768 32768 32768 32768 32768 32768)
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
                                             (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 -32766 -32766 -32766 -32766 -32766 -32766 -32766 -32766)
                                             (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767)
                                             (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                             (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767)
                                             (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                             (v128.const i16x8 32766 32766 32766 32766 32766 32766 32766 32766))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                             (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                             (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768)
                                             (v128.const i16x8 -32767 -32767 -32767 -32767 -32767 -32767 -32767 -32767))
                                             (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                             (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                             (v128.const i16x8 32767 32767 32767 32767 32767 32767 32767 32767))
                                             (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                             (v128.const i16x8 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768))
                                             (v128.const i16x8 1 1 1 1 1 1 1 1))
(assert_return (invoke "i16x8.q15mulr_sat_s" (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535)
                                             (v128.const i16x8 65535 65535 65535 65535 65535 65535 65535 65535))
                                             (v128.const i16x8 0 0 0 0 0 0 0 0))

;; type check
(assert_invalid (module (func (result v128) (i16x8.q15mulr_sat_s (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $i16x8.q15mulr_sat_s-1st-arg-empty (result v128)
      (i16x8.q15mulr_sat_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.q15mulr_sat_s-arg-empty (result v128)
      (i16x8.q15mulr_sat_s)
    )
  )
  "type mismatch"
)

