// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/organizationmanager/v1/saml/federation_service.proto

package saml

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	FederationService_Get_FullMethodName                    = "/yandex.cloud.organizationmanager.v1.saml.FederationService/Get"
	FederationService_List_FullMethodName                   = "/yandex.cloud.organizationmanager.v1.saml.FederationService/List"
	FederationService_Create_FullMethodName                 = "/yandex.cloud.organizationmanager.v1.saml.FederationService/Create"
	FederationService_Update_FullMethodName                 = "/yandex.cloud.organizationmanager.v1.saml.FederationService/Update"
	FederationService_Delete_FullMethodName                 = "/yandex.cloud.organizationmanager.v1.saml.FederationService/Delete"
	FederationService_AddUserAccounts_FullMethodName        = "/yandex.cloud.organizationmanager.v1.saml.FederationService/AddUserAccounts"
	FederationService_DeleteUserAccounts_FullMethodName     = "/yandex.cloud.organizationmanager.v1.saml.FederationService/DeleteUserAccounts"
	FederationService_ListUserAccounts_FullMethodName       = "/yandex.cloud.organizationmanager.v1.saml.FederationService/ListUserAccounts"
	FederationService_ListOperations_FullMethodName         = "/yandex.cloud.organizationmanager.v1.saml.FederationService/ListOperations"
	FederationService_GetDomain_FullMethodName              = "/yandex.cloud.organizationmanager.v1.saml.FederationService/GetDomain"
	FederationService_ListDomains_FullMethodName            = "/yandex.cloud.organizationmanager.v1.saml.FederationService/ListDomains"
	FederationService_AddDomain_FullMethodName              = "/yandex.cloud.organizationmanager.v1.saml.FederationService/AddDomain"
	FederationService_ValidateDomain_FullMethodName         = "/yandex.cloud.organizationmanager.v1.saml.FederationService/ValidateDomain"
	FederationService_DeleteDomain_FullMethodName           = "/yandex.cloud.organizationmanager.v1.saml.FederationService/DeleteDomain"
	FederationService_SuspendUserAccounts_FullMethodName    = "/yandex.cloud.organizationmanager.v1.saml.FederationService/SuspendUserAccounts"
	FederationService_ReactivateUserAccounts_FullMethodName = "/yandex.cloud.organizationmanager.v1.saml.FederationService/ReactivateUserAccounts"
)

// FederationServiceClient is the client API for FederationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing federations.
type FederationServiceClient interface {
	// Returns the specified federation.
	//
	// To get the list of available federations, make a [List] request.
	Get(ctx context.Context, in *GetFederationRequest, opts ...grpc.CallOption) (*Federation, error)
	// Retrieves the list of federations in the specified organization.
	List(ctx context.Context, in *ListFederationsRequest, opts ...grpc.CallOption) (*ListFederationsResponse, error)
	// Creates a federation in the specified organization.
	Create(ctx context.Context, in *CreateFederationRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified federation.
	Update(ctx context.Context, in *UpdateFederationRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified federation.
	Delete(ctx context.Context, in *DeleteFederationRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Adds users to the specified federation.
	AddUserAccounts(ctx context.Context, in *AddFederatedUserAccountsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes users from the specified federation.
	DeleteUserAccounts(ctx context.Context, in *DeleteFederatedUserAccountsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists users for the specified federation.
	ListUserAccounts(ctx context.Context, in *ListFederatedUserAccountsRequest, opts ...grpc.CallOption) (*ListFederatedUserAccountsResponse, error)
	// Lists operations for the specified federation.
	ListOperations(ctx context.Context, in *ListFederationOperationsRequest, opts ...grpc.CallOption) (*ListFederationOperationsResponse, error)
	// Returns the specified domain in the federation.
	//
	// To get the list of available domains, make a [ListDomains] request.
	GetDomain(ctx context.Context, in *GetFederationDomainRequest, opts ...grpc.CallOption) (*Domain, error)
	// Retrieves the list of domains in the specified federation.
	ListDomains(ctx context.Context, in *ListFederationDomainsRequest, opts ...grpc.CallOption) (*ListFederationDomainsResponse, error)
	// Adds a domain to the specified federation.
	AddDomain(ctx context.Context, in *AddFederationDomainRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Validates a domain in the specified federation.
	ValidateDomain(ctx context.Context, in *ValidateFederationDomainRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified domain from the federation.
	DeleteDomain(ctx context.Context, in *DeleteFederationDomainRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Suspend federated user accounts.
	// Method skips non-existent federated user accounts and returns ones that were actually suspended.
	SuspendUserAccounts(ctx context.Context, in *SuspendFederatedUserAccountsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Reactivate federated user accounts.
	// Method skips non-existent federated user accounts and returns ones that were actually reactivated.
	ReactivateUserAccounts(ctx context.Context, in *ReactivateFederatedUserAccountsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type federationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFederationServiceClient(cc grpc.ClientConnInterface) FederationServiceClient {
	return &federationServiceClient{cc}
}

func (c *federationServiceClient) Get(ctx context.Context, in *GetFederationRequest, opts ...grpc.CallOption) (*Federation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Federation)
	err := c.cc.Invoke(ctx, FederationService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) List(ctx context.Context, in *ListFederationsRequest, opts ...grpc.CallOption) (*ListFederationsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListFederationsResponse)
	err := c.cc.Invoke(ctx, FederationService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) Create(ctx context.Context, in *CreateFederationRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FederationService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) Update(ctx context.Context, in *UpdateFederationRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FederationService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) Delete(ctx context.Context, in *DeleteFederationRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FederationService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) AddUserAccounts(ctx context.Context, in *AddFederatedUserAccountsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FederationService_AddUserAccounts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) DeleteUserAccounts(ctx context.Context, in *DeleteFederatedUserAccountsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FederationService_DeleteUserAccounts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) ListUserAccounts(ctx context.Context, in *ListFederatedUserAccountsRequest, opts ...grpc.CallOption) (*ListFederatedUserAccountsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListFederatedUserAccountsResponse)
	err := c.cc.Invoke(ctx, FederationService_ListUserAccounts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) ListOperations(ctx context.Context, in *ListFederationOperationsRequest, opts ...grpc.CallOption) (*ListFederationOperationsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListFederationOperationsResponse)
	err := c.cc.Invoke(ctx, FederationService_ListOperations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) GetDomain(ctx context.Context, in *GetFederationDomainRequest, opts ...grpc.CallOption) (*Domain, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Domain)
	err := c.cc.Invoke(ctx, FederationService_GetDomain_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) ListDomains(ctx context.Context, in *ListFederationDomainsRequest, opts ...grpc.CallOption) (*ListFederationDomainsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListFederationDomainsResponse)
	err := c.cc.Invoke(ctx, FederationService_ListDomains_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) AddDomain(ctx context.Context, in *AddFederationDomainRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FederationService_AddDomain_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) ValidateDomain(ctx context.Context, in *ValidateFederationDomainRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FederationService_ValidateDomain_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) DeleteDomain(ctx context.Context, in *DeleteFederationDomainRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FederationService_DeleteDomain_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) SuspendUserAccounts(ctx context.Context, in *SuspendFederatedUserAccountsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FederationService_SuspendUserAccounts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *federationServiceClient) ReactivateUserAccounts(ctx context.Context, in *ReactivateFederatedUserAccountsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, FederationService_ReactivateUserAccounts_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FederationServiceServer is the server API for FederationService service.
// All implementations should embed UnimplementedFederationServiceServer
// for forward compatibility.
//
// A set of methods for managing federations.
type FederationServiceServer interface {
	// Returns the specified federation.
	//
	// To get the list of available federations, make a [List] request.
	Get(context.Context, *GetFederationRequest) (*Federation, error)
	// Retrieves the list of federations in the specified organization.
	List(context.Context, *ListFederationsRequest) (*ListFederationsResponse, error)
	// Creates a federation in the specified organization.
	Create(context.Context, *CreateFederationRequest) (*operation.Operation, error)
	// Updates the specified federation.
	Update(context.Context, *UpdateFederationRequest) (*operation.Operation, error)
	// Deletes the specified federation.
	Delete(context.Context, *DeleteFederationRequest) (*operation.Operation, error)
	// Adds users to the specified federation.
	AddUserAccounts(context.Context, *AddFederatedUserAccountsRequest) (*operation.Operation, error)
	// Deletes users from the specified federation.
	DeleteUserAccounts(context.Context, *DeleteFederatedUserAccountsRequest) (*operation.Operation, error)
	// Lists users for the specified federation.
	ListUserAccounts(context.Context, *ListFederatedUserAccountsRequest) (*ListFederatedUserAccountsResponse, error)
	// Lists operations for the specified federation.
	ListOperations(context.Context, *ListFederationOperationsRequest) (*ListFederationOperationsResponse, error)
	// Returns the specified domain in the federation.
	//
	// To get the list of available domains, make a [ListDomains] request.
	GetDomain(context.Context, *GetFederationDomainRequest) (*Domain, error)
	// Retrieves the list of domains in the specified federation.
	ListDomains(context.Context, *ListFederationDomainsRequest) (*ListFederationDomainsResponse, error)
	// Adds a domain to the specified federation.
	AddDomain(context.Context, *AddFederationDomainRequest) (*operation.Operation, error)
	// Validates a domain in the specified federation.
	ValidateDomain(context.Context, *ValidateFederationDomainRequest) (*operation.Operation, error)
	// Deletes the specified domain from the federation.
	DeleteDomain(context.Context, *DeleteFederationDomainRequest) (*operation.Operation, error)
	// Suspend federated user accounts.
	// Method skips non-existent federated user accounts and returns ones that were actually suspended.
	SuspendUserAccounts(context.Context, *SuspendFederatedUserAccountsRequest) (*operation.Operation, error)
	// Reactivate federated user accounts.
	// Method skips non-existent federated user accounts and returns ones that were actually reactivated.
	ReactivateUserAccounts(context.Context, *ReactivateFederatedUserAccountsRequest) (*operation.Operation, error)
}

// UnimplementedFederationServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedFederationServiceServer struct{}

func (UnimplementedFederationServiceServer) Get(context.Context, *GetFederationRequest) (*Federation, error) {
	return nil, status.Error(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedFederationServiceServer) List(context.Context, *ListFederationsRequest) (*ListFederationsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedFederationServiceServer) Create(context.Context, *CreateFederationRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedFederationServiceServer) Update(context.Context, *UpdateFederationRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedFederationServiceServer) Delete(context.Context, *DeleteFederationRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedFederationServiceServer) AddUserAccounts(context.Context, *AddFederatedUserAccountsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method AddUserAccounts not implemented")
}
func (UnimplementedFederationServiceServer) DeleteUserAccounts(context.Context, *DeleteFederatedUserAccountsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method DeleteUserAccounts not implemented")
}
func (UnimplementedFederationServiceServer) ListUserAccounts(context.Context, *ListFederatedUserAccountsRequest) (*ListFederatedUserAccountsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ListUserAccounts not implemented")
}
func (UnimplementedFederationServiceServer) ListOperations(context.Context, *ListFederationOperationsRequest) (*ListFederationOperationsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ListOperations not implemented")
}
func (UnimplementedFederationServiceServer) GetDomain(context.Context, *GetFederationDomainRequest) (*Domain, error) {
	return nil, status.Error(codes.Unimplemented, "method GetDomain not implemented")
}
func (UnimplementedFederationServiceServer) ListDomains(context.Context, *ListFederationDomainsRequest) (*ListFederationDomainsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ListDomains not implemented")
}
func (UnimplementedFederationServiceServer) AddDomain(context.Context, *AddFederationDomainRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method AddDomain not implemented")
}
func (UnimplementedFederationServiceServer) ValidateDomain(context.Context, *ValidateFederationDomainRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method ValidateDomain not implemented")
}
func (UnimplementedFederationServiceServer) DeleteDomain(context.Context, *DeleteFederationDomainRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method DeleteDomain not implemented")
}
func (UnimplementedFederationServiceServer) SuspendUserAccounts(context.Context, *SuspendFederatedUserAccountsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method SuspendUserAccounts not implemented")
}
func (UnimplementedFederationServiceServer) ReactivateUserAccounts(context.Context, *ReactivateFederatedUserAccountsRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method ReactivateUserAccounts not implemented")
}
func (UnimplementedFederationServiceServer) testEmbeddedByValue() {}

// UnsafeFederationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FederationServiceServer will
// result in compilation errors.
type UnsafeFederationServiceServer interface {
	mustEmbedUnimplementedFederationServiceServer()
}

func RegisterFederationServiceServer(s grpc.ServiceRegistrar, srv FederationServiceServer) {
	// If the following call panics, it indicates UnimplementedFederationServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&FederationService_ServiceDesc, srv)
}

func _FederationService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).Get(ctx, req.(*GetFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFederationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).List(ctx, req.(*ListFederationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).Create(ctx, req.(*CreateFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).Update(ctx, req.(*UpdateFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFederationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).Delete(ctx, req.(*DeleteFederationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_AddUserAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddFederatedUserAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).AddUserAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_AddUserAccounts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).AddUserAccounts(ctx, req.(*AddFederatedUserAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_DeleteUserAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFederatedUserAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).DeleteUserAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_DeleteUserAccounts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).DeleteUserAccounts(ctx, req.(*DeleteFederatedUserAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_ListUserAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFederatedUserAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).ListUserAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_ListUserAccounts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).ListUserAccounts(ctx, req.(*ListFederatedUserAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFederationOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_ListOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).ListOperations(ctx, req.(*ListFederationOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_GetDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFederationDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).GetDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_GetDomain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).GetDomain(ctx, req.(*GetFederationDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_ListDomains_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFederationDomainsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).ListDomains(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_ListDomains_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).ListDomains(ctx, req.(*ListFederationDomainsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_AddDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddFederationDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).AddDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_AddDomain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).AddDomain(ctx, req.(*AddFederationDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_ValidateDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateFederationDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).ValidateDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_ValidateDomain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).ValidateDomain(ctx, req.(*ValidateFederationDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_DeleteDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFederationDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).DeleteDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_DeleteDomain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).DeleteDomain(ctx, req.(*DeleteFederationDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_SuspendUserAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuspendFederatedUserAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).SuspendUserAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_SuspendUserAccounts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).SuspendUserAccounts(ctx, req.(*SuspendFederatedUserAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FederationService_ReactivateUserAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReactivateFederatedUserAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FederationServiceServer).ReactivateUserAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FederationService_ReactivateUserAccounts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FederationServiceServer).ReactivateUserAccounts(ctx, req.(*ReactivateFederatedUserAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FederationService_ServiceDesc is the grpc.ServiceDesc for FederationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FederationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.organizationmanager.v1.saml.FederationService",
	HandlerType: (*FederationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _FederationService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _FederationService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _FederationService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _FederationService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _FederationService_Delete_Handler,
		},
		{
			MethodName: "AddUserAccounts",
			Handler:    _FederationService_AddUserAccounts_Handler,
		},
		{
			MethodName: "DeleteUserAccounts",
			Handler:    _FederationService_DeleteUserAccounts_Handler,
		},
		{
			MethodName: "ListUserAccounts",
			Handler:    _FederationService_ListUserAccounts_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _FederationService_ListOperations_Handler,
		},
		{
			MethodName: "GetDomain",
			Handler:    _FederationService_GetDomain_Handler,
		},
		{
			MethodName: "ListDomains",
			Handler:    _FederationService_ListDomains_Handler,
		},
		{
			MethodName: "AddDomain",
			Handler:    _FederationService_AddDomain_Handler,
		},
		{
			MethodName: "ValidateDomain",
			Handler:    _FederationService_ValidateDomain_Handler,
		},
		{
			MethodName: "DeleteDomain",
			Handler:    _FederationService_DeleteDomain_Handler,
		},
		{
			MethodName: "SuspendUserAccounts",
			Handler:    _FederationService_SuspendUserAccounts_Handler,
		},
		{
			MethodName: "ReactivateUserAccounts",
			Handler:    _FederationService_ReactivateUserAccounts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/organizationmanager/v1/saml/federation_service.proto",
}
