// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/resourcemanager/v1/cloud_service.proto

package resourcemanager

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetCloudRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Cloud resource to return.
	// To get the cloud ID, use a [CloudService.List] request.
	CloudId       string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetCloudRequest) Reset() {
	*x = GetCloudRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCloudRequest) ProtoMessage() {}

func (x *GetCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCloudRequest.ProtoReflect.Descriptor instead.
func (*GetCloudRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetCloudRequest) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

type ListCloudsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size],
	// the service returns a [ListCloudsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Default value: 100.
	PageSize int64 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. Set [page_token]
	// to the [ListCloudsResponse.next_page_token]
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// The expression must specify:
	// 1. The field name. Currently you can use filtering only on the [Cloud.name] field.
	// 2. An `=` operator.
	// 3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// ID of the organization to list clouds in.
	// To get the organization ID, use a [yandex.cloud.organizationmanager.v1.OrganizationService.List] request.
	OrganizationId string `protobuf:"bytes,4,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ListCloudsRequest) Reset() {
	*x = ListCloudsRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCloudsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudsRequest) ProtoMessage() {}

func (x *ListCloudsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudsRequest.ProtoReflect.Descriptor instead.
func (*ListCloudsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListCloudsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCloudsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCloudsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCloudsRequest) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

type ListCloudsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of Cloud resources.
	Clouds []*Cloud `protobuf:"bytes,1,rep,name=clouds,proto3" json:"clouds,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListCloudsRequest.page_size], use
	// the [next_page_token] as the value
	// for the [ListCloudsRequest.page_token] query parameter
	// in the next list request. Each subsequent list request will have its own
	// [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListCloudsResponse) Reset() {
	*x = ListCloudsResponse{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCloudsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudsResponse) ProtoMessage() {}

func (x *ListCloudsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudsResponse.ProtoReflect.Descriptor instead.
func (*ListCloudsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListCloudsResponse) GetClouds() []*Cloud {
	if x != nil {
		return x.Clouds
	}
	return nil
}

func (x *ListCloudsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateCloudRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the organization to create a cloud in.
	// To get the organization ID, use a [yandex.cloud.organizationmanager.v1.OrganizationService.List] request.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Name of the cloud.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the cloud.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as “ key:value “ pairs.
	Labels        map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateCloudRequest) Reset() {
	*x = CreateCloudRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCloudRequest) ProtoMessage() {}

func (x *CreateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCloudRequest.ProtoReflect.Descriptor instead.
func (*CreateCloudRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateCloudRequest) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

func (x *CreateCloudRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateCloudRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateCloudRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type CreateCloudMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the cloud that is being created.
	CloudId       string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateCloudMetadata) Reset() {
	*x = CreateCloudMetadata{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCloudMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCloudMetadata) ProtoMessage() {}

func (x *CreateCloudMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCloudMetadata.ProtoReflect.Descriptor instead.
func (*CreateCloudMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateCloudMetadata) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

type ListCloudOperationsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Cloud resource to list operations for.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than [page_size], the service returns a [ListCloudOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	// Acceptable values are 0 to 1000, inclusive. Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. Set [page_token]
	// to the [ListCloudOperationsResponse.next_page_token]
	// returned by a previous list request to get the next page of results.
	PageToken     string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListCloudOperationsRequest) Reset() {
	*x = ListCloudOperationsRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCloudOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudOperationsRequest) ProtoMessage() {}

func (x *ListCloudOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListCloudOperationsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListCloudOperationsRequest) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

func (x *ListCloudOperationsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCloudOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

type ListCloudOperationsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of operations for the specified cloud.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// This token allows you to get the next page of results for list requests. If the number of results
	// is larger than [ListCloudOperationsRequest.page_size], use the [next_page_token] as the value
	// for the [ListCloudOperationsRequest.page_token] query parameter in the next list request.
	// Each subsequent list request will have its own [next_page_token] to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListCloudOperationsResponse) Reset() {
	*x = ListCloudOperationsResponse{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCloudOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudOperationsResponse) ProtoMessage() {}

func (x *ListCloudOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListCloudOperationsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListCloudOperationsResponse) GetOperations() []*operation.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListCloudOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type UpdateCloudRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the cloud to update.
	// To get the cloud ID, use a [CloudService.List] request.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// Field mask that specifies which fields of the cloud are going to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Name of the cloud.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the cloud.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as “ key:value “ pairs.
	Labels        map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateCloudRequest) Reset() {
	*x = UpdateCloudRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCloudRequest) ProtoMessage() {}

func (x *UpdateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCloudRequest.ProtoReflect.Descriptor instead.
func (*UpdateCloudRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateCloudRequest) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

func (x *UpdateCloudRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateCloudRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateCloudRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *UpdateCloudRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type UpdateCloudMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the cloud that is being updated.
	CloudId       string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateCloudMetadata) Reset() {
	*x = UpdateCloudMetadata{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateCloudMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCloudMetadata) ProtoMessage() {}

func (x *UpdateCloudMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCloudMetadata.ProtoReflect.Descriptor instead.
func (*UpdateCloudMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateCloudMetadata) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

type DeleteCloudRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the cloud to delete.
	// To get the cloud ID, use a [CloudService.List] request.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// The timestamp after which the process of deleting the cloud should begin.
	// Until this timestamp, the cloud goes into the PENDING_DELETION state and all resources in this
	// cloud are stopped. In this state, it is possible to cancel the delete operation without any loss.
	// After this timestamp, the status of the cloud will become DELETING and the process of deleting
	// all the resources  of the cloud will be started. If [delete_after] is not specified it will be
	// (now + 24 hours). To initiate an immediate deletion [delete_after] must be <= now.
	DeleteAfter   *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=delete_after,json=deleteAfter,proto3" json:"delete_after,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteCloudRequest) Reset() {
	*x = DeleteCloudRequest{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCloudRequest) ProtoMessage() {}

func (x *DeleteCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCloudRequest.ProtoReflect.Descriptor instead.
func (*DeleteCloudRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteCloudRequest) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

func (x *DeleteCloudRequest) GetDeleteAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteAfter
	}
	return nil
}

type DeleteCloudMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the cloud that is being deleted.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// The timestamp after which the process of deleting the cloud should begin.
	DeleteAfter *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=delete_after,json=deleteAfter,proto3" json:"delete_after,omitempty"`
	// Information about operation cancellation
	CancelledBy   string                 `protobuf:"bytes,3,opt,name=cancelled_by,json=cancelledBy,proto3" json:"cancelled_by,omitempty"`
	CancelledAt   *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=cancelled_at,json=cancelledAt,proto3" json:"cancelled_at,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteCloudMetadata) Reset() {
	*x = DeleteCloudMetadata{}
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCloudMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCloudMetadata) ProtoMessage() {}

func (x *DeleteCloudMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCloudMetadata.ProtoReflect.Descriptor instead.
func (*DeleteCloudMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteCloudMetadata) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

func (x *DeleteCloudMetadata) GetDeleteAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteAfter
	}
	return nil
}

func (x *DeleteCloudMetadata) GetCancelledBy() string {
	if x != nil {
		return x.CancelledBy
	}
	return ""
}

func (x *DeleteCloudMetadata) GetCancelledAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelledAt
	}
	return nil
}

var File_yandex_cloud_resourcemanager_v1_cloud_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDesc = "" +
	"\n" +
	"3yandex/cloud/resourcemanager/v1/cloud_service.proto\x12\x1fyandex.cloud.resourcemanager.v1\x1a\x1cgoogle/api/annotations.proto\x1a google/protobuf/field_mask.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a+yandex/cloud/resourcemanager/v1/cloud.proto\x1a yandex/cloud/api/operation.proto\x1a yandex/cloud/access/access.proto\x1a&yandex/cloud/operation/operation.proto\x1a\x1dyandex/cloud/validation.proto\":\n" +
	"\x0fGetCloudRequest\x12'\n" +
	"\bcloud_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\acloudId\"\xbe\x01\n" +
	"\x11ListCloudsRequest\x12'\n" +
	"\tpage_size\x18\x01 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12)\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\n" +
	"\x8a\xc81\x06<=2000R\tpageToken\x12\"\n" +
	"\x06filter\x18\x03 \x01(\tB\n" +
	"\x8a\xc81\x06<=1000R\x06filter\x121\n" +
	"\x0forganization_id\x18\x04 \x01(\tB\b\x8a\xc81\x04<=50R\x0eorganizationId\"|\n" +
	"\x12ListCloudsResponse\x12>\n" +
	"\x06clouds\x18\x01 \x03(\v2&.yandex.cloud.resourcemanager.v1.CloudR\x06clouds\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x85\x03\n" +
	"\x12CreateCloudRequest\x125\n" +
	"\x0forganization_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\x0eorganizationId\x129\n" +
	"\x04name\x18\x02 \x01(\tB%\xe8\xc71\x01\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x04name\x12+\n" +
	"\vdescription\x18\x03 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x94\x01\n" +
	"\x06labels\x18\x04 \x03(\v2?.yandex.cloud.resourcemanager.v1.CreateCloudRequest.LabelsEntryB;\xf2\xc71\v[-_0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x18\x12\x10[a-z][-_0-9a-z]*\x1a\x041-63R\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"0\n" +
	"\x13CreateCloudMetadata\x12\x19\n" +
	"\bcloud_id\x18\x01 \x01(\tR\acloudId\"\x99\x01\n" +
	"\x1aListCloudOperationsRequest\x12'\n" +
	"\bcloud_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\acloudId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x06<=1000R\bpageSize\x12)\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\n" +
	"\x8a\xc81\x06<=2000R\tpageToken\"\x88\x01\n" +
	"\x1bListCloudOperationsResponse\x12A\n" +
	"\n" +
	"operations\x18\x01 \x03(\v2!.yandex.cloud.operation.OperationR\n" +
	"operations\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xb2\x03\n" +
	"\x12UpdateCloudRequest\x12'\n" +
	"\bcloud_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\acloudId\x12;\n" +
	"\vupdate_mask\x18\x02 \x01(\v2\x1a.google.protobuf.FieldMaskR\n" +
	"updateMask\x127\n" +
	"\x04name\x18\x03 \x01(\tB#\xf2\xc71\x1f[a-z]([-a-z0-9]{0,61}[a-z0-9])?R\x04name\x12+\n" +
	"\vdescription\x18\x04 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x94\x01\n" +
	"\x06labels\x18\x05 \x03(\v2?.yandex.cloud.resourcemanager.v1.UpdateCloudRequest.LabelsEntryB;\xf2\xc71\v[-_0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x18\x12\x10[a-z][-_0-9a-z]*\x1a\x041-63R\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"0\n" +
	"\x13UpdateCloudMetadata\x12\x19\n" +
	"\bcloud_id\x18\x01 \x01(\tR\acloudId\"|\n" +
	"\x12DeleteCloudRequest\x12'\n" +
	"\bcloud_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\acloudId\x12=\n" +
	"\fdelete_after\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\vdeleteAfter\"\xd1\x01\n" +
	"\x13DeleteCloudMetadata\x12\x19\n" +
	"\bcloud_id\x18\x01 \x01(\tR\acloudId\x12=\n" +
	"\fdelete_after\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\vdeleteAfter\x12!\n" +
	"\fcancelled_by\x18\x03 \x01(\tR\vcancelledBy\x12=\n" +
	"\fcancelled_at\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\vcancelledAt2\xb0\x13\n" +
	"\fCloudService\x12\x8f\x01\n" +
	"\x03Get\x120.yandex.cloud.resourcemanager.v1.GetCloudRequest\x1a&.yandex.cloud.resourcemanager.v1.Cloud\".\x82\xd3\xe4\x93\x02(\x12&/resource-manager/v1/clouds/{cloud_id}\x12\x94\x01\n" +
	"\x04List\x122.yandex.cloud.resourcemanager.v1.ListCloudsRequest\x1a3.yandex.cloud.resourcemanager.v1.ListCloudsResponse\"#\x82\xd3\xe4\x93\x02\x1d\x12\x1b/resource-manager/v1/clouds\x12\xa8\x01\n" +
	"\x06Create\x123.yandex.cloud.resourcemanager.v1.CreateCloudRequest\x1a!.yandex.cloud.operation.Operation\"F\xb2\xd2*\x1c\n" +
	"\x13CreateCloudMetadata\x12\x05Cloud\x82\xd3\xe4\x93\x02 :\x01*\"\x1b/resource-manager/v1/clouds\x12\xb3\x01\n" +
	"\x06Update\x123.yandex.cloud.resourcemanager.v1.UpdateCloudRequest\x1a!.yandex.cloud.operation.Operation\"Q\xb2\xd2*\x1c\n" +
	"\x13UpdateCloudMetadata\x12\x05Cloud\x82\xd3\xe4\x93\x02+:\x01*2&/resource-manager/v1/clouds/{cloud_id}\x12\xc0\x01\n" +
	"\x06Delete\x123.yandex.cloud.resourcemanager.v1.DeleteCloudRequest\x1a!.yandex.cloud.operation.Operation\"^\xb2\xd2*,\n" +
	"\x13DeleteCloudMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02(*&/resource-manager/v1/clouds/{cloud_id}\x12\xc6\x01\n" +
	"\x0eListOperations\x12;.yandex.cloud.resourcemanager.v1.ListCloudOperationsRequest\x1a<.yandex.cloud.resourcemanager.v1.ListCloudOperationsResponse\"9\x82\xd3\xe4\x93\x023\x121/resource-manager/v1/clouds/{cloud_id}/operations\x12\xbb\x01\n" +
	"\x12ListAccessBindings\x12..yandex.cloud.access.ListAccessBindingsRequest\x1a/.yandex.cloud.access.ListAccessBindingsResponse\"D\x82\xd3\xe4\x93\x02>\x12</resource-manager/v1/clouds/{resource_id}:listAccessBindings\x12\xfa\x01\n" +
	"\x11SetAccessBindings\x12-.yandex.cloud.access.SetAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x92\x01\xb2\xd2*H\n" +
	" access.SetAccessBindingsMetadata\x12$access.AccessBindingsOperationResult\x82\xd3\xe4\x93\x02@:\x01*\";/resource-manager/v1/clouds/{resource_id}:setAccessBindings\x12\x86\x02\n" +
	"\x14UpdateAccessBindings\x120.yandex.cloud.access.UpdateAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x98\x01\xb2\xd2*K\n" +
	"#access.UpdateAccessBindingsMetadata\x12$access.AccessBindingsOperationResult\x82\xd3\xe4\x93\x02C:\x01*\">/resource-manager/v1/clouds/{resource_id}:updateAccessBindings\x12\xd3\x01\n" +
	"\x18ListAccessPolicyBindings\x124.yandex.cloud.access.ListAccessPolicyBindingsRequest\x1a5.yandex.cloud.access.ListAccessPolicyBindingsResponse\"J\x82\xd3\xe4\x93\x02D\x12B/resource-manager/v1/clouds/{resource_id}:listAccessPolicyBindings\x12\xf1\x01\n" +
	"\x10BindAccessPolicy\x12,.yandex.cloud.access.BindAccessPolicyRequest\x1a!.yandex.cloud.operation.Operation\"\x8b\x01\xb2\xd2*B\n" +
	"\x1faccess.BindAccessPolicyMetadata\x12\x1faccess.BindAccessPolicyResponse\x82\xd3\xe4\x93\x02?:\x01*\":/resource-manager/v1/clouds/{resource_id}:bindAccessPolicy\x12\xfb\x01\n" +
	"\x12UnbindAccessPolicy\x12..yandex.cloud.access.UnbindAccessPolicyRequest\x1a!.yandex.cloud.operation.Operation\"\x91\x01\xb2\xd2*F\n" +
	"!access.UnbindAccessPolicyMetadata\x12!access.UnbindAccessPolicyResponse\x82\xd3\xe4\x93\x02A:\x01*\"</resource-manager/v1/clouds/{resource_id}:unbindAccessPolicyBz\n" +
	"#yandex.cloud.api.resourcemanager.v1ZSgithub.com/yandex-cloud/go-genproto/yandex/cloud/resourcemanager/v1;resourcemanagerb\x06proto3"

var (
	file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescData []byte
)

func file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDesc), len(file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDesc)))
	})
	return file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDescData
}

var file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_yandex_cloud_resourcemanager_v1_cloud_service_proto_goTypes = []any{
	(*GetCloudRequest)(nil),                         // 0: yandex.cloud.resourcemanager.v1.GetCloudRequest
	(*ListCloudsRequest)(nil),                       // 1: yandex.cloud.resourcemanager.v1.ListCloudsRequest
	(*ListCloudsResponse)(nil),                      // 2: yandex.cloud.resourcemanager.v1.ListCloudsResponse
	(*CreateCloudRequest)(nil),                      // 3: yandex.cloud.resourcemanager.v1.CreateCloudRequest
	(*CreateCloudMetadata)(nil),                     // 4: yandex.cloud.resourcemanager.v1.CreateCloudMetadata
	(*ListCloudOperationsRequest)(nil),              // 5: yandex.cloud.resourcemanager.v1.ListCloudOperationsRequest
	(*ListCloudOperationsResponse)(nil),             // 6: yandex.cloud.resourcemanager.v1.ListCloudOperationsResponse
	(*UpdateCloudRequest)(nil),                      // 7: yandex.cloud.resourcemanager.v1.UpdateCloudRequest
	(*UpdateCloudMetadata)(nil),                     // 8: yandex.cloud.resourcemanager.v1.UpdateCloudMetadata
	(*DeleteCloudRequest)(nil),                      // 9: yandex.cloud.resourcemanager.v1.DeleteCloudRequest
	(*DeleteCloudMetadata)(nil),                     // 10: yandex.cloud.resourcemanager.v1.DeleteCloudMetadata
	nil,                                             // 11: yandex.cloud.resourcemanager.v1.CreateCloudRequest.LabelsEntry
	nil,                                             // 12: yandex.cloud.resourcemanager.v1.UpdateCloudRequest.LabelsEntry
	(*Cloud)(nil),                                   // 13: yandex.cloud.resourcemanager.v1.Cloud
	(*operation.Operation)(nil),                     // 14: yandex.cloud.operation.Operation
	(*fieldmaskpb.FieldMask)(nil),                   // 15: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                   // 16: google.protobuf.Timestamp
	(*access.ListAccessBindingsRequest)(nil),        // 17: yandex.cloud.access.ListAccessBindingsRequest
	(*access.SetAccessBindingsRequest)(nil),         // 18: yandex.cloud.access.SetAccessBindingsRequest
	(*access.UpdateAccessBindingsRequest)(nil),      // 19: yandex.cloud.access.UpdateAccessBindingsRequest
	(*access.ListAccessPolicyBindingsRequest)(nil),  // 20: yandex.cloud.access.ListAccessPolicyBindingsRequest
	(*access.BindAccessPolicyRequest)(nil),          // 21: yandex.cloud.access.BindAccessPolicyRequest
	(*access.UnbindAccessPolicyRequest)(nil),        // 22: yandex.cloud.access.UnbindAccessPolicyRequest
	(*access.ListAccessBindingsResponse)(nil),       // 23: yandex.cloud.access.ListAccessBindingsResponse
	(*access.ListAccessPolicyBindingsResponse)(nil), // 24: yandex.cloud.access.ListAccessPolicyBindingsResponse
}
var file_yandex_cloud_resourcemanager_v1_cloud_service_proto_depIdxs = []int32{
	13, // 0: yandex.cloud.resourcemanager.v1.ListCloudsResponse.clouds:type_name -> yandex.cloud.resourcemanager.v1.Cloud
	11, // 1: yandex.cloud.resourcemanager.v1.CreateCloudRequest.labels:type_name -> yandex.cloud.resourcemanager.v1.CreateCloudRequest.LabelsEntry
	14, // 2: yandex.cloud.resourcemanager.v1.ListCloudOperationsResponse.operations:type_name -> yandex.cloud.operation.Operation
	15, // 3: yandex.cloud.resourcemanager.v1.UpdateCloudRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 4: yandex.cloud.resourcemanager.v1.UpdateCloudRequest.labels:type_name -> yandex.cloud.resourcemanager.v1.UpdateCloudRequest.LabelsEntry
	16, // 5: yandex.cloud.resourcemanager.v1.DeleteCloudRequest.delete_after:type_name -> google.protobuf.Timestamp
	16, // 6: yandex.cloud.resourcemanager.v1.DeleteCloudMetadata.delete_after:type_name -> google.protobuf.Timestamp
	16, // 7: yandex.cloud.resourcemanager.v1.DeleteCloudMetadata.cancelled_at:type_name -> google.protobuf.Timestamp
	0,  // 8: yandex.cloud.resourcemanager.v1.CloudService.Get:input_type -> yandex.cloud.resourcemanager.v1.GetCloudRequest
	1,  // 9: yandex.cloud.resourcemanager.v1.CloudService.List:input_type -> yandex.cloud.resourcemanager.v1.ListCloudsRequest
	3,  // 10: yandex.cloud.resourcemanager.v1.CloudService.Create:input_type -> yandex.cloud.resourcemanager.v1.CreateCloudRequest
	7,  // 11: yandex.cloud.resourcemanager.v1.CloudService.Update:input_type -> yandex.cloud.resourcemanager.v1.UpdateCloudRequest
	9,  // 12: yandex.cloud.resourcemanager.v1.CloudService.Delete:input_type -> yandex.cloud.resourcemanager.v1.DeleteCloudRequest
	5,  // 13: yandex.cloud.resourcemanager.v1.CloudService.ListOperations:input_type -> yandex.cloud.resourcemanager.v1.ListCloudOperationsRequest
	17, // 14: yandex.cloud.resourcemanager.v1.CloudService.ListAccessBindings:input_type -> yandex.cloud.access.ListAccessBindingsRequest
	18, // 15: yandex.cloud.resourcemanager.v1.CloudService.SetAccessBindings:input_type -> yandex.cloud.access.SetAccessBindingsRequest
	19, // 16: yandex.cloud.resourcemanager.v1.CloudService.UpdateAccessBindings:input_type -> yandex.cloud.access.UpdateAccessBindingsRequest
	20, // 17: yandex.cloud.resourcemanager.v1.CloudService.ListAccessPolicyBindings:input_type -> yandex.cloud.access.ListAccessPolicyBindingsRequest
	21, // 18: yandex.cloud.resourcemanager.v1.CloudService.BindAccessPolicy:input_type -> yandex.cloud.access.BindAccessPolicyRequest
	22, // 19: yandex.cloud.resourcemanager.v1.CloudService.UnbindAccessPolicy:input_type -> yandex.cloud.access.UnbindAccessPolicyRequest
	13, // 20: yandex.cloud.resourcemanager.v1.CloudService.Get:output_type -> yandex.cloud.resourcemanager.v1.Cloud
	2,  // 21: yandex.cloud.resourcemanager.v1.CloudService.List:output_type -> yandex.cloud.resourcemanager.v1.ListCloudsResponse
	14, // 22: yandex.cloud.resourcemanager.v1.CloudService.Create:output_type -> yandex.cloud.operation.Operation
	14, // 23: yandex.cloud.resourcemanager.v1.CloudService.Update:output_type -> yandex.cloud.operation.Operation
	14, // 24: yandex.cloud.resourcemanager.v1.CloudService.Delete:output_type -> yandex.cloud.operation.Operation
	6,  // 25: yandex.cloud.resourcemanager.v1.CloudService.ListOperations:output_type -> yandex.cloud.resourcemanager.v1.ListCloudOperationsResponse
	23, // 26: yandex.cloud.resourcemanager.v1.CloudService.ListAccessBindings:output_type -> yandex.cloud.access.ListAccessBindingsResponse
	14, // 27: yandex.cloud.resourcemanager.v1.CloudService.SetAccessBindings:output_type -> yandex.cloud.operation.Operation
	14, // 28: yandex.cloud.resourcemanager.v1.CloudService.UpdateAccessBindings:output_type -> yandex.cloud.operation.Operation
	24, // 29: yandex.cloud.resourcemanager.v1.CloudService.ListAccessPolicyBindings:output_type -> yandex.cloud.access.ListAccessPolicyBindingsResponse
	14, // 30: yandex.cloud.resourcemanager.v1.CloudService.BindAccessPolicy:output_type -> yandex.cloud.operation.Operation
	14, // 31: yandex.cloud.resourcemanager.v1.CloudService.UnbindAccessPolicy:output_type -> yandex.cloud.operation.Operation
	20, // [20:32] is the sub-list for method output_type
	8,  // [8:20] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_yandex_cloud_resourcemanager_v1_cloud_service_proto_init() }
func file_yandex_cloud_resourcemanager_v1_cloud_service_proto_init() {
	if File_yandex_cloud_resourcemanager_v1_cloud_service_proto != nil {
		return
	}
	file_yandex_cloud_resourcemanager_v1_cloud_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDesc), len(file_yandex_cloud_resourcemanager_v1_cloud_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_resourcemanager_v1_cloud_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_resourcemanager_v1_cloud_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_resourcemanager_v1_cloud_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_resourcemanager_v1_cloud_service_proto = out.File
	file_yandex_cloud_resourcemanager_v1_cloud_service_proto_goTypes = nil
	file_yandex_cloud_resourcemanager_v1_cloud_service_proto_depIdxs = nil
}
