// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/video/v1/episode_service.proto

package video

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	EpisodeService_Get_FullMethodName           = "/yandex.cloud.video.v1.EpisodeService/Get"
	EpisodeService_List_FullMethodName          = "/yandex.cloud.video.v1.EpisodeService/List"
	EpisodeService_BatchGet_FullMethodName      = "/yandex.cloud.video.v1.EpisodeService/BatchGet"
	EpisodeService_Create_FullMethodName        = "/yandex.cloud.video.v1.EpisodeService/Create"
	EpisodeService_Update_FullMethodName        = "/yandex.cloud.video.v1.EpisodeService/Update"
	EpisodeService_Delete_FullMethodName        = "/yandex.cloud.video.v1.EpisodeService/Delete"
	EpisodeService_BatchDelete_FullMethodName   = "/yandex.cloud.video.v1.EpisodeService/BatchDelete"
	EpisodeService_PerformAction_FullMethodName = "/yandex.cloud.video.v1.EpisodeService/PerformAction"
	EpisodeService_GetPlayerURL_FullMethodName  = "/yandex.cloud.video.v1.EpisodeService/GetPlayerURL"
	EpisodeService_GetManifests_FullMethodName  = "/yandex.cloud.video.v1.EpisodeService/GetManifests"
)

// EpisodeServiceClient is the client API for EpisodeService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Episode management service.
// Provides methods for creating, retrieving, updating, and deleting episodes,
// which represent specific time segments of streams
// that can be individually accessed, managed, and published.
type EpisodeServiceClient interface {
	// Retrieves detailed information about a specific episode by its ID.
	// Returns all episode metadata, status, and related information.
	Get(ctx context.Context, in *GetEpisodeRequest, opts ...grpc.CallOption) (*Episode, error)
	// Lists all episodes associated with a specific stream or stream line with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(ctx context.Context, in *ListEpisodesRequest, opts ...grpc.CallOption) (*ListEpisodesResponse, error)
	// Retrieves multiple episodes by their IDs in a specific channel in a single request.
	// This is more efficient than making multiple Get requests when retrieving several episodes.
	BatchGet(ctx context.Context, in *BatchGetEpisodesRequest, opts ...grpc.CallOption) (*BatchGetEpisodesResponse, error)
	// Creates a new episode associated with a stream or stream line.
	// Episodes can be configured with various settings including title, description,
	// time boundaries, and access rights.
	Create(ctx context.Context, in *CreateEpisodeRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates an existing episode's metadata and settings.
	// Only fields specified in the field_mask will be updated.
	Update(ctx context.Context, in *UpdateEpisodeRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes a specific episode by its ID.
	Delete(ctx context.Context, in *DeleteEpisodeRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes multiple episodes associated with a specific stream or stream line in a single request.
	// This is more efficient than making multiple Delete requests when removing several episodes.
	BatchDelete(ctx context.Context, in *BatchDeleteEpisodesRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Performs a specific action on an episode, such as publishing or unpublishing.
	PerformAction(ctx context.Context, in *PerformEpisodeActionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Generates a player URL for watching the episode.
	// The URL can include player parameters such as autoplay, mute, and visibility of interface controls.
	// For episodes with signed URL access, an expiration duration can be specified.
	GetPlayerURL(ctx context.Context, in *GetEpisodePlayerURLRequest, opts ...grpc.CallOption) (*GetEpisodePlayerURLResponse, error)
	// Retrieves the manifest URLs for the episode's media content.
	// Manifests provide players with necessary information
	// for streaming the content with different quality levels and formats.
	GetManifests(ctx context.Context, in *GetEpisodeManifestsRequest, opts ...grpc.CallOption) (*GetEpisodeManifestsResponse, error)
}

type episodeServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEpisodeServiceClient(cc grpc.ClientConnInterface) EpisodeServiceClient {
	return &episodeServiceClient{cc}
}

func (c *episodeServiceClient) Get(ctx context.Context, in *GetEpisodeRequest, opts ...grpc.CallOption) (*Episode, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Episode)
	err := c.cc.Invoke(ctx, EpisodeService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *episodeServiceClient) List(ctx context.Context, in *ListEpisodesRequest, opts ...grpc.CallOption) (*ListEpisodesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListEpisodesResponse)
	err := c.cc.Invoke(ctx, EpisodeService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *episodeServiceClient) BatchGet(ctx context.Context, in *BatchGetEpisodesRequest, opts ...grpc.CallOption) (*BatchGetEpisodesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BatchGetEpisodesResponse)
	err := c.cc.Invoke(ctx, EpisodeService_BatchGet_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *episodeServiceClient) Create(ctx context.Context, in *CreateEpisodeRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, EpisodeService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *episodeServiceClient) Update(ctx context.Context, in *UpdateEpisodeRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, EpisodeService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *episodeServiceClient) Delete(ctx context.Context, in *DeleteEpisodeRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, EpisodeService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *episodeServiceClient) BatchDelete(ctx context.Context, in *BatchDeleteEpisodesRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, EpisodeService_BatchDelete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *episodeServiceClient) PerformAction(ctx context.Context, in *PerformEpisodeActionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, EpisodeService_PerformAction_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *episodeServiceClient) GetPlayerURL(ctx context.Context, in *GetEpisodePlayerURLRequest, opts ...grpc.CallOption) (*GetEpisodePlayerURLResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetEpisodePlayerURLResponse)
	err := c.cc.Invoke(ctx, EpisodeService_GetPlayerURL_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *episodeServiceClient) GetManifests(ctx context.Context, in *GetEpisodeManifestsRequest, opts ...grpc.CallOption) (*GetEpisodeManifestsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetEpisodeManifestsResponse)
	err := c.cc.Invoke(ctx, EpisodeService_GetManifests_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EpisodeServiceServer is the server API for EpisodeService service.
// All implementations should embed UnimplementedEpisodeServiceServer
// for forward compatibility.
//
// Episode management service.
// Provides methods for creating, retrieving, updating, and deleting episodes,
// which represent specific time segments of streams
// that can be individually accessed, managed, and published.
type EpisodeServiceServer interface {
	// Retrieves detailed information about a specific episode by its ID.
	// Returns all episode metadata, status, and related information.
	Get(context.Context, *GetEpisodeRequest) (*Episode, error)
	// Lists all episodes associated with a specific stream or stream line with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(context.Context, *ListEpisodesRequest) (*ListEpisodesResponse, error)
	// Retrieves multiple episodes by their IDs in a specific channel in a single request.
	// This is more efficient than making multiple Get requests when retrieving several episodes.
	BatchGet(context.Context, *BatchGetEpisodesRequest) (*BatchGetEpisodesResponse, error)
	// Creates a new episode associated with a stream or stream line.
	// Episodes can be configured with various settings including title, description,
	// time boundaries, and access rights.
	Create(context.Context, *CreateEpisodeRequest) (*operation.Operation, error)
	// Updates an existing episode's metadata and settings.
	// Only fields specified in the field_mask will be updated.
	Update(context.Context, *UpdateEpisodeRequest) (*operation.Operation, error)
	// Deletes a specific episode by its ID.
	Delete(context.Context, *DeleteEpisodeRequest) (*operation.Operation, error)
	// Deletes multiple episodes associated with a specific stream or stream line in a single request.
	// This is more efficient than making multiple Delete requests when removing several episodes.
	BatchDelete(context.Context, *BatchDeleteEpisodesRequest) (*operation.Operation, error)
	// Performs a specific action on an episode, such as publishing or unpublishing.
	PerformAction(context.Context, *PerformEpisodeActionRequest) (*operation.Operation, error)
	// Generates a player URL for watching the episode.
	// The URL can include player parameters such as autoplay, mute, and visibility of interface controls.
	// For episodes with signed URL access, an expiration duration can be specified.
	GetPlayerURL(context.Context, *GetEpisodePlayerURLRequest) (*GetEpisodePlayerURLResponse, error)
	// Retrieves the manifest URLs for the episode's media content.
	// Manifests provide players with necessary information
	// for streaming the content with different quality levels and formats.
	GetManifests(context.Context, *GetEpisodeManifestsRequest) (*GetEpisodeManifestsResponse, error)
}

// UnimplementedEpisodeServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedEpisodeServiceServer struct{}

func (UnimplementedEpisodeServiceServer) Get(context.Context, *GetEpisodeRequest) (*Episode, error) {
	return nil, status.Error(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedEpisodeServiceServer) List(context.Context, *ListEpisodesRequest) (*ListEpisodesResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedEpisodeServiceServer) BatchGet(context.Context, *BatchGetEpisodesRequest) (*BatchGetEpisodesResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method BatchGet not implemented")
}
func (UnimplementedEpisodeServiceServer) Create(context.Context, *CreateEpisodeRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedEpisodeServiceServer) Update(context.Context, *UpdateEpisodeRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedEpisodeServiceServer) Delete(context.Context, *DeleteEpisodeRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedEpisodeServiceServer) BatchDelete(context.Context, *BatchDeleteEpisodesRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method BatchDelete not implemented")
}
func (UnimplementedEpisodeServiceServer) PerformAction(context.Context, *PerformEpisodeActionRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method PerformAction not implemented")
}
func (UnimplementedEpisodeServiceServer) GetPlayerURL(context.Context, *GetEpisodePlayerURLRequest) (*GetEpisodePlayerURLResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetPlayerURL not implemented")
}
func (UnimplementedEpisodeServiceServer) GetManifests(context.Context, *GetEpisodeManifestsRequest) (*GetEpisodeManifestsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetManifests not implemented")
}
func (UnimplementedEpisodeServiceServer) testEmbeddedByValue() {}

// UnsafeEpisodeServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EpisodeServiceServer will
// result in compilation errors.
type UnsafeEpisodeServiceServer interface {
	mustEmbedUnimplementedEpisodeServiceServer()
}

func RegisterEpisodeServiceServer(s grpc.ServiceRegistrar, srv EpisodeServiceServer) {
	// If the following call panics, it indicates UnimplementedEpisodeServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&EpisodeService_ServiceDesc, srv)
}

func _EpisodeService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEpisodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EpisodeServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EpisodeService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EpisodeServiceServer).Get(ctx, req.(*GetEpisodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EpisodeService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEpisodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EpisodeServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EpisodeService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EpisodeServiceServer).List(ctx, req.(*ListEpisodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EpisodeService_BatchGet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetEpisodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EpisodeServiceServer).BatchGet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EpisodeService_BatchGet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EpisodeServiceServer).BatchGet(ctx, req.(*BatchGetEpisodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EpisodeService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEpisodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EpisodeServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EpisodeService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EpisodeServiceServer).Create(ctx, req.(*CreateEpisodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EpisodeService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEpisodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EpisodeServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EpisodeService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EpisodeServiceServer).Update(ctx, req.(*UpdateEpisodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EpisodeService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEpisodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EpisodeServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EpisodeService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EpisodeServiceServer).Delete(ctx, req.(*DeleteEpisodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EpisodeService_BatchDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEpisodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EpisodeServiceServer).BatchDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EpisodeService_BatchDelete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EpisodeServiceServer).BatchDelete(ctx, req.(*BatchDeleteEpisodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EpisodeService_PerformAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PerformEpisodeActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EpisodeServiceServer).PerformAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EpisodeService_PerformAction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EpisodeServiceServer).PerformAction(ctx, req.(*PerformEpisodeActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EpisodeService_GetPlayerURL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEpisodePlayerURLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EpisodeServiceServer).GetPlayerURL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EpisodeService_GetPlayerURL_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EpisodeServiceServer).GetPlayerURL(ctx, req.(*GetEpisodePlayerURLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EpisodeService_GetManifests_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEpisodeManifestsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EpisodeServiceServer).GetManifests(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EpisodeService_GetManifests_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EpisodeServiceServer).GetManifests(ctx, req.(*GetEpisodeManifestsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EpisodeService_ServiceDesc is the grpc.ServiceDesc for EpisodeService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EpisodeService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.video.v1.EpisodeService",
	HandlerType: (*EpisodeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _EpisodeService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _EpisodeService_List_Handler,
		},
		{
			MethodName: "BatchGet",
			Handler:    _EpisodeService_BatchGet_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _EpisodeService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _EpisodeService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _EpisodeService_Delete_Handler,
		},
		{
			MethodName: "BatchDelete",
			Handler:    _EpisodeService_BatchDelete_Handler,
		},
		{
			MethodName: "PerformAction",
			Handler:    _EpisodeService_PerformAction_Handler,
		},
		{
			MethodName: "GetPlayerURL",
			Handler:    _EpisodeService_GetPlayerURL_Handler,
		},
		{
			MethodName: "GetManifests",
			Handler:    _EpisodeService_GetManifests_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/video/v1/episode_service.proto",
}
