// Code generated by sdkgen-v2. DO NOT EDIT.
package workloadsdk

import (
	"context"

	workload "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1/workload"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	sdkop "github.com/yandex-cloud/go-sdk/v2/pkg/operation"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	proto "google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/reflect/protoreflect"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// FederatedCredentialClient provides methods for managing FederatedCredential resources of Yandex.Cloud Workload.
type FederatedCredentialClient interface {
	FederatedCredentialClientIterator
	Get(context.Context, *workload.GetFederatedCredentialRequest, ...grpc.CallOption) (*workload.FederatedCredential, error)
	List(context.Context, *workload.ListFederatedCredentialsRequest, ...grpc.CallOption) (*workload.ListFederatedCredentialsResponse, error)
	Create(context.Context, *workload.CreateFederatedCredentialRequest, ...grpc.CallOption) (*FederatedCredentialCreateOperation, error)
	Delete(context.Context, *workload.DeleteFederatedCredentialRequest, ...grpc.CallOption) (*FederatedCredentialDeleteOperation, error)
}

var _ FederatedCredentialClient = federatedCredentialClient{}

type federatedCredentialClient struct {
	connector transport.Connector
}

// NewFederatedCredentialClient returns FederatedCredentialClient implementation.
func NewFederatedCredentialClient(connector transport.Connector) FederatedCredentialClient {
	return federatedCredentialClient{connector}
}

// Get is an operation of Yandex.Cloud Workload FederatedCredential service.
func (c federatedCredentialClient) Get(ctx context.Context, in *workload.GetFederatedCredentialRequest, opts ...grpc.CallOption) (*workload.FederatedCredential, error) {
	connection, err := c.connector.GetConnection(ctx, FederatedCredentialGet, opts...)
	if err != nil {
		return nil, err
	}
	return workload.NewFederatedCredentialServiceClient(connection).Get(ctx, in, opts...)
}

// List is an operation of Yandex.Cloud Workload FederatedCredential service.
func (c federatedCredentialClient) List(ctx context.Context, in *workload.ListFederatedCredentialsRequest, opts ...grpc.CallOption) (*workload.ListFederatedCredentialsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, FederatedCredentialList, opts...)
	if err != nil {
		return nil, err
	}
	return workload.NewFederatedCredentialServiceClient(connection).List(ctx, in, opts...)
}

// FederatedCredentialCreateOperation is used to monitor the state of Create operations.
type FederatedCredentialCreateOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *FederatedCredentialCreateOperation) Metadata() *workload.CreateFederatedCredentialMetadata {
	return o.Operation.Metadata().(*workload.CreateFederatedCredentialMetadata)
}

// Response retrieves the operation response.
func (o *FederatedCredentialCreateOperation) Response() *workload.FederatedCredential {
	return o.Operation.Response().(*workload.FederatedCredential)
}

// Wait polls the operation until it's done.
func (o *FederatedCredentialCreateOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*workload.FederatedCredential, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*workload.FederatedCredential)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *FederatedCredentialCreateOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*workload.FederatedCredential, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*workload.FederatedCredential)
	return response, err
}

// Create is an operation of Yandex.Cloud Workload FederatedCredential service.
// It returns an object which should be used to monitor the operation state.
func (c federatedCredentialClient) Create(ctx context.Context, in *workload.CreateFederatedCredentialRequest, opts ...grpc.CallOption) (*FederatedCredentialCreateOperation, error) {
	connection, err := c.connector.GetConnection(ctx, FederatedCredentialCreate, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := workload.NewFederatedCredentialServiceClient(connection).Create(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*workload.CreateFederatedCredentialMetadata).GetFederatedCredentialId()
		},
		MetadataType: (*workload.CreateFederatedCredentialMetadata)(nil),
		ResponseType: (*workload.FederatedCredential)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &FederatedCredentialCreateOperation{*op}, nil
}

// FederatedCredentialDeleteOperation is used to monitor the state of Delete operations.
type FederatedCredentialDeleteOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *FederatedCredentialDeleteOperation) Metadata() *workload.DeleteFederatedCredentialMetadata {
	return o.Operation.Metadata().(*workload.DeleteFederatedCredentialMetadata)
}

// Response retrieves the operation response.
func (o *FederatedCredentialDeleteOperation) Response() *emptypb.Empty {
	return o.Operation.Response().(*emptypb.Empty)
}

// Wait polls the operation until it's done.
func (o *FederatedCredentialDeleteOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *FederatedCredentialDeleteOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// Delete is an operation of Yandex.Cloud Workload FederatedCredential service.
// It returns an object which should be used to monitor the operation state.
func (c federatedCredentialClient) Delete(ctx context.Context, in *workload.DeleteFederatedCredentialRequest, opts ...grpc.CallOption) (*FederatedCredentialDeleteOperation, error) {
	connection, err := c.connector.GetConnection(ctx, FederatedCredentialDelete, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := workload.NewFederatedCredentialServiceClient(connection).Delete(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*workload.DeleteFederatedCredentialMetadata).GetFederatedCredentialId()
		},
		MetadataType: (*workload.DeleteFederatedCredentialMetadata)(nil),
		ResponseType: (*emptypb.Empty)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &FederatedCredentialDeleteOperation{*op}, nil
}

// pollOperation returns the current state of the polled operation.
func (c federatedCredentialClient) pollOperation(ctx context.Context, operationId string, opts ...grpc.CallOption) (sdkop.YCOperation, error) {
	connection, err := c.connector.GetConnection(ctx, FederatedCredentialOperationPoller, opts...)
	if err != nil {
		return nil, err
	}
	return operation.NewOperationServiceClient(connection).Get(ctx, &operation.GetOperationRequest{OperationId: operationId}, opts...)
}

var (
	FederatedCredentialGet             = protoreflect.FullName("yandex.cloud.iam.v1.workload.FederatedCredentialService.Get")
	FederatedCredentialList            = protoreflect.FullName("yandex.cloud.iam.v1.workload.FederatedCredentialService.List")
	FederatedCredentialCreate          = protoreflect.FullName("yandex.cloud.iam.v1.workload.FederatedCredentialService.Create")
	FederatedCredentialDelete          = protoreflect.FullName("yandex.cloud.iam.v1.workload.FederatedCredentialService.Delete")
	FederatedCredentialOperationPoller = protoreflect.FullName("yandex.cloud.operation.OperationService.Get")
)
