/*
 * ZGrab Copyright 2015 Regents of the University of Michigan
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package keys

import (
	"crypto/rsa"
	"encoding/json"
	"math/big"
	"testing"

	. "gopkg.in/check.v1"
)

func TestRSA(t *testing.T) { TestingT(t) }

var test4096Modulus = []byte{0xD4, 0x0C, 0xE0, 0x39, 0x57, 0xAA, 0x36, 0x31, 0x89, 0x38, 0xD0, 0xDE, 0x36, 0xFF, 0xDF, 0x03, 0xD7, 0x98, 0xA5, 0xD9, 0x21, 0x98, 0xA4, 0x94, 0xBE, 0x2B, 0x22, 0x5B, 0x9A, 0xFF, 0x94, 0x75, 0xEA, 0x7E, 0x2E, 0x13, 0x59, 0x83, 0x2E, 0x34, 0x2E, 0xF0, 0x3B, 0x14, 0x83, 0x8F, 0xAB, 0x84, 0x51, 0x74, 0xA6, 0x0F, 0xE9, 0x69, 0x21, 0x8A, 0xEC, 0x8D, 0x1F, 0xCF, 0x73, 0x88, 0xAA, 0x75, 0xF4, 0x8D, 0x56, 0xD2, 0xEA, 0xBE, 0x49, 0xB2, 0xE6, 0x16, 0xC1, 0x4D, 0x9A, 0x2D, 0x78, 0x59, 0xFA, 0xE9, 0x32, 0xF3, 0x59, 0xA7, 0x95, 0xFB, 0x44, 0x3D, 0x88, 0xC7, 0xCE, 0x08, 0xE9, 0xE4, 0xAD, 0x93, 0x3F, 0x44, 0x49, 0xEF, 0x06, 0x0A, 0x16, 0xC9, 0xF9, 0x5B, 0xEB, 0x1F, 0x74, 0xCB, 0x68, 0x33, 0xCC, 0xB1, 0x2A, 0x8C, 0xA6, 0x18, 0x43, 0xC9, 0x9A, 0xD2, 0x36, 0x7E, 0x9F, 0x45, 0x04, 0xE6, 0xED, 0x7E, 0x02, 0x48, 0x7A, 0x8C, 0xEE, 0x84, 0x14, 0x08, 0xEC, 0x3C, 0x49, 0xFC, 0xE9, 0x68, 0xFE, 0xE5, 0x41, 0x4D, 0x6D, 0x1B, 0xCF, 0xE6, 0x1D, 0xC9, 0xCA, 0x4B, 0x09, 0xE3, 0xB5, 0x73, 0x2B, 0xF4, 0xA5, 0xEF, 0x05, 0x2B, 0x29, 0x49, 0xC8, 0xE6, 0xE7, 0x0C, 0xBA, 0xE4, 0x4F, 0xE9, 0x0F, 0xAA, 0x52, 0xFB, 0xA5, 0x01, 0x85, 0x8B, 0x03, 0x22, 0x17, 0xCF, 0xD5, 0x0F, 0x52, 0xE9, 0xFE, 0xAE, 0x89, 0x28, 0x8F, 0x13, 0x34, 0x5F, 0x3E, 0xD2, 0xFC, 0x3E, 0x27, 0x86, 0x37, 0xD2, 0x15, 0xFE, 0x36, 0x9C, 0xF6, 0x18, 0x8F, 0x09, 0xC4, 0x1F, 0x93, 0x57, 0xCE, 0x73, 0x70, 0xFA, 0xF6, 0x05, 0x8C, 0xA8, 0x70, 0xE0, 0x08, 0xF4, 0xFD, 0xA7, 0xFA, 0x08, 0x80, 0x46, 0xD7, 0xF7, 0x6B, 0xF6, 0x3B, 0xDF, 0xA4, 0x3E, 0xAC, 0xD1, 0x8D, 0x5D, 0xA9, 0x85, 0xFE, 0xC6, 0x41, 0x57, 0x25, 0x48, 0xDF, 0x26, 0xD5, 0x4C, 0xEF, 0xB2, 0xB8, 0x1A, 0xAA, 0x4E, 0x9F, 0x12, 0x80, 0xFC, 0x1D, 0x0E, 0x45, 0x65, 0xBF, 0x77, 0x9F, 0x8E, 0x1E, 0x9D, 0xBD, 0x8F, 0xA8, 0x6F, 0xD6, 0x22, 0x70, 0x87, 0x3D, 0x92, 0xF8, 0x85, 0x75, 0x8C, 0xFA, 0xE6, 0x39, 0x56, 0x3B, 0x51, 0x4D, 0xAE, 0x69, 0x44, 0x19, 0x5E, 0xA5, 0x36, 0xD5, 0x60, 0x61, 0xE4, 0x8B, 0x2F, 0xAF, 0xB2, 0x55, 0xC1, 0x59, 0xF0, 0x32, 0xA6, 0xCC, 0x92, 0x19, 0x25, 0xED, 0x91, 0x15, 0x4F, 0x43, 0x7F, 0xB7, 0x0E, 0x3C, 0x42, 0x31, 0xCA, 0x5E, 0xCA, 0xC0, 0x5C, 0xDE, 0xB8, 0x95, 0x5C, 0x08, 0xDF, 0x15, 0xE3, 0x05, 0x3A, 0xBC, 0xA9, 0x57, 0xF1, 0x6F, 0xA6, 0xBB, 0xA6, 0x14, 0x43, 0xDE, 0x62, 0xD4, 0x91, 0xAC, 0x73, 0x7A, 0x4D, 0x09, 0xBC, 0xF6, 0xD0, 0xB7, 0xA9, 0xEE, 0x6E, 0x00, 0xE4, 0x9A, 0x14, 0x39, 0x30, 0xBE, 0xBC, 0x33, 0x66, 0x4A, 0xD3, 0x3F, 0xC8, 0x12, 0x73, 0x75, 0x62, 0x75, 0x0E, 0xDA, 0xEB, 0x77, 0xBA, 0x6D, 0x4F, 0x2F, 0x44, 0x58, 0xD8, 0x89, 0xE2, 0xDF, 0xE4, 0x89, 0x6B, 0xC0, 0x4F, 0xF0, 0xB3, 0xEE, 0x44, 0x65, 0xCF, 0xA4, 0xA6, 0x1A, 0x0F, 0x1A, 0x08, 0xC3, 0xF5, 0xB0, 0x23, 0x10, 0x3B, 0xF2, 0xC2, 0x82, 0x2B, 0x73, 0xA7, 0x18, 0x31, 0x92, 0x86, 0x59, 0x36, 0x65, 0xF8, 0xF1, 0xD0, 0x29, 0x8F, 0x6B, 0x05, 0x3F, 0xCD, 0x56, 0x30, 0xD2, 0x08, 0x12, 0x49, 0x4D, 0x20, 0xC3, 0xB5, 0x8C, 0x48, 0x5C, 0x02, 0xAE, 0x0C, 0x09, 0x47, 0xBD, 0xE5, 0xE9, 0xE7, 0x0C, 0x27, 0xC7, 0x15, 0xCE, 0xC7, 0x3F, 0x87, 0x22, 0x20, 0xE8, 0x6D, 0x8D, 0x8A, 0x6E, 0x73, 0xF1, 0x04, 0x9F, 0x55, 0xA2, 0xF6, 0xB6, 0x10, 0x42, 0x3E, 0xE2, 0x70, 0x98, 0x7F}

type RSASuite struct {
	pk4096 *RSAPublicKey
}

var _ = Suite(&RSASuite{})

func (s *RSASuite) SetUpTest(c *C) {
	s.pk4096 = new(RSAPublicKey)
	s.pk4096.PublicKey = new(rsa.PublicKey)
	s.pk4096.E = 65537
	s.pk4096.N = big.NewInt(0).SetBytes(test4096Modulus)
}

func (s *RSASuite) TestEncodeDecode(c *C) {
	b, err := json.Marshal(s.pk4096)
	c.Assert(err, IsNil)
	c.Assert(b, NotNil)
	var dec RSAPublicKey
	err = json.Unmarshal(b, &dec)
	c.Assert(err, IsNil)
	c.Check(&dec, DeepEquals, s.pk4096)
}
