// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigAnyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesAnyValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigAnyValue()
				CopyOrigAnyValue(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigAnyValue(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigAnyValueUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigAnyValue()
	UnmarshalJSONOrigAnyValue(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigAnyValue(), dest)
}

func TestMarshalAndUnmarshalJSONOrigAnyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesAnyValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigAnyValue(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigAnyValue()
				UnmarshalJSONOrigAnyValue(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigAnyValue(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigAnyValueFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesAnyValue() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigAnyValue()
			require.Error(t, UnmarshalProtoOrigAnyValue(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigAnyValueUnknown(t *testing.T) {
	dest := NewOrigAnyValue()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigAnyValue(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigAnyValue(), dest)
}

func TestMarshalAndUnmarshalProtoOrigAnyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesAnyValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigAnyValue(src))
				gotSize := MarshalProtoOrigAnyValue(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigAnyValue()
				require.NoError(t, UnmarshalProtoOrigAnyValue(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigAnyValue(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufAnyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesAnyValue() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigAnyValue(src))
			gotSize := MarshalProtoOrigAnyValue(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.AnyValue{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigAnyValue()
			require.NoError(t, UnmarshalProtoOrigAnyValue(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesAnyValue() map[string][]byte {
	return map[string][]byte{
		"invalid_field": {0x02},

		"StringValue/wrong_wire_type": {0xc},
		"StringValue/missing_value":   {0xa},

		"BoolValue/wrong_wire_type": {0x14},
		"BoolValue/missing_value":   {0x10},

		"IntValue/wrong_wire_type": {0x1c},
		"IntValue/missing_value":   {0x18},

		"DoubleValue/wrong_wire_type": {0x24},
		"DoubleValue/missing_value":   {0x21},

		"ArrayValue/wrong_wire_type": {0x2c},
		"ArrayValue/missing_value":   {0x2a},

		"KvlistValue/wrong_wire_type": {0x34},
		"KvlistValue/missing_value":   {0x32},

		"BytesValue/wrong_wire_type": {0x3c},
		"BytesValue/missing_value":   {0x3a},
	}
}

func genTestEncodingValuesAnyValue() map[string]*otlpcommon.AnyValue {
	return map[string]*otlpcommon.AnyValue{
		"empty":               NewOrigAnyValue(),
		"StringValue/default": {Value: &otlpcommon.AnyValue_StringValue{StringValue: ""}},
		"StringValue/test":    {Value: &otlpcommon.AnyValue_StringValue{StringValue: "test_stringvalue"}},
		"BoolValue/default":   {Value: &otlpcommon.AnyValue_BoolValue{BoolValue: false}},
		"BoolValue/test":      {Value: &otlpcommon.AnyValue_BoolValue{BoolValue: true}},
		"IntValue/default":    {Value: &otlpcommon.AnyValue_IntValue{IntValue: int64(0)}},
		"IntValue/test":       {Value: &otlpcommon.AnyValue_IntValue{IntValue: int64(13)}},
		"DoubleValue/default": {Value: &otlpcommon.AnyValue_DoubleValue{DoubleValue: float64(0)}},
		"DoubleValue/test":    {Value: &otlpcommon.AnyValue_DoubleValue{DoubleValue: float64(3.1415926)}},
		"ArrayValue/default":  {Value: &otlpcommon.AnyValue_ArrayValue{ArrayValue: &otlpcommon.ArrayValue{}}},
		"ArrayValue/test":     {Value: &otlpcommon.AnyValue_ArrayValue{ArrayValue: GenTestOrigArrayValue()}},
		"KvlistValue/default": {Value: &otlpcommon.AnyValue_KvlistValue{KvlistValue: &otlpcommon.KeyValueList{}}},
		"KvlistValue/test":    {Value: &otlpcommon.AnyValue_KvlistValue{KvlistValue: GenTestOrigKeyValueList()}},
		"BytesValue/default":  {Value: &otlpcommon.AnyValue_BytesValue{BytesValue: nil}},
		"BytesValue/test":     {Value: &otlpcommon.AnyValue_BytesValue{BytesValue: []byte{1, 2, 3}}},
	}
}
