// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
)

func TestCopyOrigResourceSpansSlice(t *testing.T) {
	src := []*otlptrace.ResourceSpans{}
	dest := []*otlptrace.ResourceSpans{}
	// Test CopyTo empty
	dest = CopyOrigResourceSpansSlice(dest, src)
	assert.Equal(t, []*otlptrace.ResourceSpans{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestResourceSpansSlice()
	dest = CopyOrigResourceSpansSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceSpansSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigResourceSpansSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceSpansSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigResourceSpansSlice(dest, []*otlptrace.ResourceSpans{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigResourceSpansSlice(dest, src)
	assert.Equal(t, GenerateOrigTestResourceSpansSlice(), dest)
}
