// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/apps/drive/labels/v2/label_permission.proto

package labels

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Roles are concentric with subsequent role.
type LabelPermission_LabelRole int32

const (
	// Unknown role.
	LabelPermission_LABEL_ROLE_UNSPECIFIED LabelPermission_LabelRole = 0
	// A reader can read the label and associated metadata applied to Drive
	// items.
	LabelPermission_READER LabelPermission_LabelRole = 1
	// An applier can write associated metadata on Drive items in which they
	// also have write access to. Implies `READER`.
	LabelPermission_APPLIER LabelPermission_LabelRole = 2
	// An organizer can pin this label in shared drives they manage
	// and add new appliers to the label.
	LabelPermission_ORGANIZER LabelPermission_LabelRole = 3
	// Editors can make any update including deleting the label which
	// also deletes the associated Drive item metadata. Implies `APPLIER`.
	LabelPermission_EDITOR LabelPermission_LabelRole = 4
)

// Enum value maps for LabelPermission_LabelRole.
var (
	LabelPermission_LabelRole_name = map[int32]string{
		0: "LABEL_ROLE_UNSPECIFIED",
		1: "READER",
		2: "APPLIER",
		3: "ORGANIZER",
		4: "EDITOR",
	}
	LabelPermission_LabelRole_value = map[string]int32{
		"LABEL_ROLE_UNSPECIFIED": 0,
		"READER":                 1,
		"APPLIER":                2,
		"ORGANIZER":              3,
		"EDITOR":                 4,
	}
)

func (x LabelPermission_LabelRole) Enum() *LabelPermission_LabelRole {
	p := new(LabelPermission_LabelRole)
	*p = x
	return p
}

func (x LabelPermission_LabelRole) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LabelPermission_LabelRole) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_labels_v2_label_permission_proto_enumTypes[0].Descriptor()
}

func (LabelPermission_LabelRole) Type() protoreflect.EnumType {
	return &file_google_apps_drive_labels_v2_label_permission_proto_enumTypes[0]
}

func (x LabelPermission_LabelRole) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LabelPermission_LabelRole.Descriptor instead.
func (LabelPermission_LabelRole) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_label_permission_proto_rawDescGZIP(), []int{0, 0}
}

// The permission that applies to a principal (user, group, audience) on a
// label.
type LabelPermission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The principal this permission applies to. Must be either an email, user,
	// group, or audience.
	// Example:
	// * people/12345
	// * groups/45678
	// * audiences/default
	//
	// Types that are assignable to Principal:
	//
	//	*LabelPermission_Person
	//	*LabelPermission_Group
	//	*LabelPermission_Audience
	Principal isLabelPermission_Principal `protobuf_oneof:"principal"`
	// Resource name of this permission.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies the email address for a user or group pricinpal. Not populated
	// for audience principals. User and Group permissions may only be inserted
	// using email address. On update requests, if email address is specified,
	// no principal should be specified.
	Email string `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
	// The role the principal should have.
	Role LabelPermission_LabelRole `protobuf:"varint,6,opt,name=role,proto3,enum=google.apps.drive.labels.v2.LabelPermission_LabelRole" json:"role,omitempty"`
}

func (x *LabelPermission) Reset() {
	*x = LabelPermission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2_label_permission_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelPermission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelPermission) ProtoMessage() {}

func (x *LabelPermission) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2_label_permission_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelPermission.ProtoReflect.Descriptor instead.
func (*LabelPermission) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_label_permission_proto_rawDescGZIP(), []int{0}
}

func (m *LabelPermission) GetPrincipal() isLabelPermission_Principal {
	if m != nil {
		return m.Principal
	}
	return nil
}

func (x *LabelPermission) GetPerson() string {
	if x, ok := x.GetPrincipal().(*LabelPermission_Person); ok {
		return x.Person
	}
	return ""
}

func (x *LabelPermission) GetGroup() string {
	if x, ok := x.GetPrincipal().(*LabelPermission_Group); ok {
		return x.Group
	}
	return ""
}

func (x *LabelPermission) GetAudience() string {
	if x, ok := x.GetPrincipal().(*LabelPermission_Audience); ok {
		return x.Audience
	}
	return ""
}

func (x *LabelPermission) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LabelPermission) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *LabelPermission) GetRole() LabelPermission_LabelRole {
	if x != nil {
		return x.Role
	}
	return LabelPermission_LABEL_ROLE_UNSPECIFIED
}

type isLabelPermission_Principal interface {
	isLabelPermission_Principal()
}

type LabelPermission_Person struct {
	// Person resource name.
	Person string `protobuf:"bytes,3,opt,name=person,proto3,oneof"`
}

type LabelPermission_Group struct {
	// Group resource name.
	Group string `protobuf:"bytes,4,opt,name=group,proto3,oneof"`
}

type LabelPermission_Audience struct {
	// Audience to grant a role to. The magic value of `audiences/default` may
	// be used to apply the role to the default audience in the context of the
	// organization that owns the Label.
	Audience string `protobuf:"bytes,5,opt,name=audience,proto3,oneof"`
}

func (*LabelPermission_Person) isLabelPermission_Principal() {}

func (*LabelPermission_Group) isLabelPermission_Principal() {}

func (*LabelPermission_Audience) isLabelPermission_Principal() {}

var File_google_apps_drive_labels_v2_label_permission_proto protoreflect.FileDescriptor

var file_google_apps_drive_labels_v2_label_permission_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76,
	0x32, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe0, 0x03, 0x0a,
	0x0f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x3b, 0x0a, 0x06, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x21, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x65, 0x72,
	0x73, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x12, 0x38, 0x0a,
	0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41,
	0x1d, 0x0a, 0x1b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00,
	0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1c, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x61, 0x75, 0x64,
	0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x12,
	0x4a, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x22, 0x5b, 0x0a, 0x09, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4c, 0x41, 0x42, 0x45,
	0x4c, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x45, 0x52, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06,
	0x45, 0x44, 0x49, 0x54, 0x4f, 0x52, 0x10, 0x04, 0x3a, 0x58, 0xea, 0x41, 0x55, 0x0a, 0x2a, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x7d, 0x2f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x7d, 0x42, 0x0b, 0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x42,
	0xb3, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x2e, 0x76, 0x32, 0x42, 0x14, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x3b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0xa2, 0x02,
	0x04, 0x44, 0x4c, 0x42, 0x4c, 0xea, 0x41, 0x2d, 0x0a, 0x1b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x0e, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_drive_labels_v2_label_permission_proto_rawDescOnce sync.Once
	file_google_apps_drive_labels_v2_label_permission_proto_rawDescData = file_google_apps_drive_labels_v2_label_permission_proto_rawDesc
)

func file_google_apps_drive_labels_v2_label_permission_proto_rawDescGZIP() []byte {
	file_google_apps_drive_labels_v2_label_permission_proto_rawDescOnce.Do(func() {
		file_google_apps_drive_labels_v2_label_permission_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_drive_labels_v2_label_permission_proto_rawDescData)
	})
	return file_google_apps_drive_labels_v2_label_permission_proto_rawDescData
}

var file_google_apps_drive_labels_v2_label_permission_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_apps_drive_labels_v2_label_permission_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_apps_drive_labels_v2_label_permission_proto_goTypes = []interface{}{
	(LabelPermission_LabelRole)(0), // 0: google.apps.drive.labels.v2.LabelPermission.LabelRole
	(*LabelPermission)(nil),        // 1: google.apps.drive.labels.v2.LabelPermission
}
var file_google_apps_drive_labels_v2_label_permission_proto_depIdxs = []int32{
	0, // 0: google.apps.drive.labels.v2.LabelPermission.role:type_name -> google.apps.drive.labels.v2.LabelPermission.LabelRole
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_apps_drive_labels_v2_label_permission_proto_init() }
func file_google_apps_drive_labels_v2_label_permission_proto_init() {
	if File_google_apps_drive_labels_v2_label_permission_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_apps_drive_labels_v2_label_permission_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelPermission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_apps_drive_labels_v2_label_permission_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*LabelPermission_Person)(nil),
		(*LabelPermission_Group)(nil),
		(*LabelPermission_Audience)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_drive_labels_v2_label_permission_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_drive_labels_v2_label_permission_proto_goTypes,
		DependencyIndexes: file_google_apps_drive_labels_v2_label_permission_proto_depIdxs,
		EnumInfos:         file_google_apps_drive_labels_v2_label_permission_proto_enumTypes,
		MessageInfos:      file_google_apps_drive_labels_v2_label_permission_proto_msgTypes,
	}.Build()
	File_google_apps_drive_labels_v2_label_permission_proto = out.File
	file_google_apps_drive_labels_v2_label_permission_proto_rawDesc = nil
	file_google_apps_drive_labels_v2_label_permission_proto_goTypes = nil
	file_google_apps_drive_labels_v2_label_permission_proto_depIdxs = nil
}
