// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/gorethink/gorethink.v3"
	"gopkg.in/gorethink/gorethink.v3/internal/compare"
)

// Tests manipulation operations on arrays
func TestTransformArraySuite(t *testing.T) {
	suite.Run(t, new(TransformArraySuite))
}

type TransformArraySuite struct {
	suite.Suite

	session *r.Session
}

func (suite *TransformArraySuite) SetupTest() {
	suite.T().Log("Setting up TransformArraySuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("test").Exec(suite.session)
	err = r.DBCreate("test").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Wait().Exec(suite.session)
	suite.Require().NoError(err)

}

func (suite *TransformArraySuite) TearDownSuite() {
	suite.T().Log("Tearing down TransformArraySuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DBDrop("test").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *TransformArraySuite) TestCases() {
	suite.T().Log("Running TransformArraySuite: Tests manipulation operations on arrays")

	// transform/array.yaml line #5
	// arr = r.expr([1, 2, 3])
	suite.T().Log("Possibly executing: var arr r.Term = r.Expr([]interface{}{1, 2, 3})")

	arr := r.Expr([]interface{}{1, 2, 3})
	_ = arr // Prevent any noused variable errors

	// transform/array.yaml line #6
	// dupe_arr = r.expr([1, 1, 2, 3])
	suite.T().Log("Possibly executing: var dupe_arr r.Term = r.Expr([]interface{}{1, 1, 2, 3})")

	dupe_arr := r.Expr([]interface{}{1, 1, 2, 3})
	_ = dupe_arr // Prevent any noused variable errors

	// transform/array.yaml line #7
	// objArr = r.expr([{'a':1, 'b':'a'}, {'a':2, 'b':'b'}, {'a':3, 'b':'c'}])
	suite.T().Log("Possibly executing: var objArr r.Term = r.Expr([]interface{}{map[interface{}]interface{}{'a': 1, 'b': 'a', }, map[interface{}]interface{}{'a': 2, 'b': 'b', }, map[interface{}]interface{}{'a': 3, 'b': 'c', }})")

	objArr := r.Expr([]interface{}{map[interface{}]interface{}{"a": 1, "b": "a"}, map[interface{}]interface{}{"a": 2, "b": "b"}, map[interface{}]interface{}{"a": 3, "b": "c"}})
	_ = objArr // Prevent any noused variable errors

	// transform/array.yaml line #8
	// nestedObjArr = r.expr([{'a':1, 'b':{'c':1}}, {'a':2, 'b':{'c':2}}, {'a':3, 'b':{'c':3}}])
	suite.T().Log("Possibly executing: var nestedObjArr r.Term = r.Expr([]interface{}{map[interface{}]interface{}{'a': 1, 'b': map[interface{}]interface{}{'c': 1, }, }, map[interface{}]interface{}{'a': 2, 'b': map[interface{}]interface{}{'c': 2, }, }, map[interface{}]interface{}{'a': 3, 'b': map[interface{}]interface{}{'c': 3, }, }})")

	nestedObjArr := r.Expr([]interface{}{map[interface{}]interface{}{"a": 1, "b": map[interface{}]interface{}{"c": 1}}, map[interface{}]interface{}{"a": 2, "b": map[interface{}]interface{}{"c": 2}}, map[interface{}]interface{}{"a": 3, "b": map[interface{}]interface{}{"c": 3}}})
	_ = nestedObjArr // Prevent any noused variable errors

	{
		// transform/array.yaml line #12
		/* [1,2,3,4] */
		var expected_ []interface{} = []interface{}{1, 2, 3, 4}
		/* arr.append(4) */

		suite.T().Log("About to run line #12: arr.Append(4)")

		runAndAssert(suite.Suite, expected_, arr.Append(4), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #12")
	}

	{
		// transform/array.yaml line #14
		/* [1,2,3,'a'] */
		var expected_ []interface{} = []interface{}{1, 2, 3, "a"}
		/* arr.append('a') */

		suite.T().Log("About to run line #14: arr.Append('a')")

		runAndAssert(suite.Suite, expected_, arr.Append("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #14")
	}

	{
		// transform/array.yaml line #19
		/* [0,1,2,3] */
		var expected_ []interface{} = []interface{}{0, 1, 2, 3}
		/* arr.prepend(0) */

		suite.T().Log("About to run line #19: arr.Prepend(0)")

		runAndAssert(suite.Suite, expected_, arr.Prepend(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #19")
	}

	{
		// transform/array.yaml line #21
		/* ['a',1,2,3] */
		var expected_ []interface{} = []interface{}{"a", 1, 2, 3}
		/* arr.prepend('a') */

		suite.T().Log("About to run line #21: arr.Prepend('a')")

		runAndAssert(suite.Suite, expected_, arr.Prepend("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #21")
	}

	{
		// transform/array.yaml line #26
		/* [3] */
		var expected_ []interface{} = []interface{}{3}
		/* arr.difference([1,2,2]) */

		suite.T().Log("About to run line #26: arr.Difference([]interface{}{1, 2, 2})")

		runAndAssert(suite.Suite, expected_, arr.Difference([]interface{}{1, 2, 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #26")
	}

	{
		// transform/array.yaml line #28
		/* [1,2,3] */
		var expected_ []interface{} = []interface{}{1, 2, 3}
		/* arr.difference([]) */

		suite.T().Log("About to run line #28: arr.Difference([]interface{}{})")

		runAndAssert(suite.Suite, expected_, arr.Difference([]interface{}{}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #28")
	}

	{
		// transform/array.yaml line #30
		/* [1,2,3] */
		var expected_ []interface{} = []interface{}{1, 2, 3}
		/* arr.difference(["foo", "bar"]) */

		suite.T().Log("About to run line #30: arr.Difference([]interface{}{'foo', 'bar'})")

		runAndAssert(suite.Suite, expected_, arr.Difference([]interface{}{"foo", "bar"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #30")
	}

	{
		// transform/array.yaml line #34
		/* [1,2,3] */
		var expected_ []interface{} = []interface{}{1, 2, 3}
		/* dupe_arr.set_insert(1) */

		suite.T().Log("About to run line #34: dupe_arr.SetInsert(1)")

		runAndAssert(suite.Suite, expected_, dupe_arr.SetInsert(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #34")
	}

	{
		// transform/array.yaml line #36
		/* [1,2,3,4] */
		var expected_ []interface{} = []interface{}{1, 2, 3, 4}
		/* dupe_arr.set_insert(4) */

		suite.T().Log("About to run line #36: dupe_arr.SetInsert(4)")

		runAndAssert(suite.Suite, expected_, dupe_arr.SetInsert(4), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #36")
	}

	{
		// transform/array.yaml line #39
		/* [1,2,3,4,5] */
		var expected_ []interface{} = []interface{}{1, 2, 3, 4, 5}
		/* dupe_arr.set_union([3,4,5,5]) */

		suite.T().Log("About to run line #39: dupe_arr.SetUnion([]interface{}{3, 4, 5, 5})")

		runAndAssert(suite.Suite, expected_, dupe_arr.SetUnion([]interface{}{3, 4, 5, 5}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #39")
	}

	{
		// transform/array.yaml line #41
		/* [1,2,3,5,6] */
		var expected_ []interface{} = []interface{}{1, 2, 3, 5, 6}
		/* dupe_arr.set_union([5,6]) */

		suite.T().Log("About to run line #41: dupe_arr.SetUnion([]interface{}{5, 6})")

		runAndAssert(suite.Suite, expected_, dupe_arr.SetUnion([]interface{}{5, 6}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #41")
	}

	{
		// transform/array.yaml line #44
		/* [1,2] */
		var expected_ []interface{} = []interface{}{1, 2}
		/* dupe_arr.set_intersection([1,1,1,2,2]) */

		suite.T().Log("About to run line #44: dupe_arr.SetIntersection([]interface{}{1, 1, 1, 2, 2})")

		runAndAssert(suite.Suite, expected_, dupe_arr.SetIntersection([]interface{}{1, 1, 1, 2, 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #44")
	}

	{
		// transform/array.yaml line #46
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* dupe_arr.set_intersection(["foo"]) */

		suite.T().Log("About to run line #46: dupe_arr.SetIntersection([]interface{}{'foo'})")

		runAndAssert(suite.Suite, expected_, dupe_arr.SetIntersection([]interface{}{"foo"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #46")
	}

	{
		// transform/array.yaml line #49
		/* [2,3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* dupe_arr.set_difference([1,1,1,10]) */

		suite.T().Log("About to run line #49: dupe_arr.SetDifference([]interface{}{1, 1, 1, 10})")

		runAndAssert(suite.Suite, expected_, dupe_arr.SetDifference([]interface{}{1, 1, 1, 10}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #49")
	}

	{
		// transform/array.yaml line #51
		/* [1,3] */
		var expected_ []interface{} = []interface{}{1, 3}
		/* dupe_arr.set_difference([2]) */

		suite.T().Log("About to run line #51: dupe_arr.SetDifference([]interface{}{2})")

		runAndAssert(suite.Suite, expected_, dupe_arr.SetDifference([]interface{}{2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #51")
	}

	{
		// transform/array.yaml line #58
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* arr[1:3] */

		suite.T().Log("About to run line #58: arr.Slice(1, 3)")

		runAndAssert(suite.Suite, expected_, arr.Slice(1, 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #58")
	}

	{
		// transform/array.yaml line #59
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* arr.slice(1, 3) */

		suite.T().Log("About to run line #59: arr.Slice(1, 3)")

		runAndAssert(suite.Suite, expected_, arr.Slice(1, 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #59")
	}

	{
		// transform/array.yaml line #60
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* arr.slice(1, 2, right_bound='closed') */

		suite.T().Log("About to run line #60: arr.Slice(1, 2).OptArgs(r.SliceOpts{RightBound: 'closed', })")

		runAndAssert(suite.Suite, expected_, arr.Slice(1, 2).OptArgs(r.SliceOpts{RightBound: "closed"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #60")
	}

	{
		// transform/array.yaml line #72
		/* [1,2] */
		var expected_ []interface{} = []interface{}{1, 2}
		/* arr[:2] */

		suite.T().Log("About to run line #72: arr.Slice(0, 2)")

		runAndAssert(suite.Suite, expected_, arr.Slice(0, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #72")
	}

	{
		// transform/array.yaml line #73
		/* [1,2] */
		var expected_ []interface{} = []interface{}{1, 2}
		/* arr.slice(0,2) */

		suite.T().Log("About to run line #73: arr.Slice(0, 2)")

		runAndAssert(suite.Suite, expected_, arr.Slice(0, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #73")
	}

	{
		// transform/array.yaml line #81
		/* [2,3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* arr[1:] */

		suite.T().Log("About to run line #81: arr.Slice(1, -1, r.SliceOpts{RightBound: 'closed'})")

		runAndAssert(suite.Suite, expected_, arr.Slice(1, -1, r.SliceOpts{RightBound: "closed"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #81")
	}

	{
		// transform/array.yaml line #82
		/* [2,3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* arr.slice(1) */

		suite.T().Log("About to run line #82: arr.Slice(1)")

		runAndAssert(suite.Suite, expected_, arr.Slice(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #82")
	}

	{
		// transform/array.yaml line #89
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* arr.slice(-2, -1) */

		suite.T().Log("About to run line #89: arr.Slice(-2, -1)")

		runAndAssert(suite.Suite, expected_, arr.Slice(-2, -1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #89")
	}

	{
		// transform/array.yaml line #95
		/* [2,3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* arr.skip(1) */

		suite.T().Log("About to run line #95: arr.Skip(1)")

		runAndAssert(suite.Suite, expected_, arr.Skip(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #95")
	}

	{
		// transform/array.yaml line #97
		/* [3] */
		var expected_ []interface{} = []interface{}{3}
		/* arr.skip(2) */

		suite.T().Log("About to run line #97: arr.Skip(2)")

		runAndAssert(suite.Suite, expected_, arr.Skip(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #97")
	}

	{
		// transform/array.yaml line #99
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* arr.skip(12) */

		suite.T().Log("About to run line #99: arr.Skip(12)")

		runAndAssert(suite.Suite, expected_, arr.Skip(12), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #99")
	}

	{
		// transform/array.yaml line #104
		/* [1,2] */
		var expected_ []interface{} = []interface{}{1, 2}
		/* arr.limit(2) */

		suite.T().Log("About to run line #104: arr.Limit(2)")

		runAndAssert(suite.Suite, expected_, arr.Limit(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #104")
	}

	{
		// transform/array.yaml line #106
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* arr.limit(0) */

		suite.T().Log("About to run line #106: arr.Limit(0)")

		runAndAssert(suite.Suite, expected_, arr.Limit(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #106")
	}

	{
		// transform/array.yaml line #108
		/* [1,2,3] */
		var expected_ []interface{} = []interface{}{1, 2, 3}
		/* arr.limit(12) */

		suite.T().Log("About to run line #108: arr.Limit(12)")

		runAndAssert(suite.Suite, expected_, arr.Limit(12), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #108")
	}

	{
		// transform/array.yaml line #113
		/* [{'a':1, 'b':'a'}, {'a':2, 'b':'b'}, {'a':3, 'b':'c'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1, "b": "a"}, map[interface{}]interface{}{"a": 2, "b": "b"}, map[interface{}]interface{}{"a": 3, "b": "c"}}
		/* objArr.pluck('a', 'b') */

		suite.T().Log("About to run line #113: objArr.Pluck('a', 'b')")

		runAndAssert(suite.Suite, expected_, objArr.Pluck("a", "b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #113")
	}

	{
		// transform/array.yaml line #115
		/* [{'a':1}, {'a':2}, {'a':3}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}, map[interface{}]interface{}{"a": 2}, map[interface{}]interface{}{"a": 3}}
		/* objArr.pluck('a') */

		suite.T().Log("About to run line #115: objArr.Pluck('a')")

		runAndAssert(suite.Suite, expected_, objArr.Pluck("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #115")
	}

	{
		// transform/array.yaml line #117
		/* [{}, {}, {}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{}, map[interface{}]interface{}{}}
		/* objArr.pluck() */

		suite.T().Log("About to run line #117: objArr.Pluck()")

		runAndAssert(suite.Suite, expected_, objArr.Pluck(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #117")
	}

	// transform/array.yaml line #121
	// wftst = objArr.union(objArr.pluck('a')).union(objArr.pluck('b')).union([{'a':null}])
	suite.T().Log("Possibly executing: var wftst r.Term = objArr.Union(objArr.Pluck('a')).Union(objArr.Pluck('b')).Union([]interface{}{map[interface{}]interface{}{'a': nil, }})")

	wftst := objArr.Union(objArr.Pluck("a")).Union(objArr.Pluck("b")).Union([]interface{}{map[interface{}]interface{}{"a": nil}})
	_ = wftst // Prevent any noused variable errors

	{
		// transform/array.yaml line #122
		/* ([{'a':1},{'a':2},{'a':3},{'a':1},{'a':2},{'a':3}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}, map[interface{}]interface{}{"a": 2}, map[interface{}]interface{}{"a": 3}, map[interface{}]interface{}{"a": 1}, map[interface{}]interface{}{"a": 2}, map[interface{}]interface{}{"a": 3}}
		/* wftst.with_fields('a') */

		suite.T().Log("About to run line #122: wftst.WithFields('a')")

		runAndAssert(suite.Suite, expected_, wftst.WithFields("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #122")
	}

	{
		// transform/array.yaml line #124
		/* ([{'b':'a'},{'b':'b'},{'b':'c'},{'b':'a'},{'b':'b'},{'b':'c'}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"b": "a"}, map[interface{}]interface{}{"b": "b"}, map[interface{}]interface{}{"b": "c"}, map[interface{}]interface{}{"b": "a"}, map[interface{}]interface{}{"b": "b"}, map[interface{}]interface{}{"b": "c"}}
		/* wftst.with_fields('b') */

		suite.T().Log("About to run line #124: wftst.WithFields('b')")

		runAndAssert(suite.Suite, expected_, wftst.WithFields("b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #124")
	}

	{
		// transform/array.yaml line #126
		/* ([{'a':1,'b':'a'},{'a':2,'b':'b'},{'a':3,'b':'c'}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1, "b": "a"}, map[interface{}]interface{}{"a": 2, "b": "b"}, map[interface{}]interface{}{"a": 3, "b": "c"}}
		/* wftst.with_fields('a', 'b') */

		suite.T().Log("About to run line #126: wftst.WithFields('a', 'b')")

		runAndAssert(suite.Suite, expected_, wftst.WithFields("a", "b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #126")
	}

	{
		// transform/array.yaml line #128
		/* [{}, {}, {}, {}, {}, {}, {}, {}, {}, {}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{}, map[interface{}]interface{}{}, map[interface{}]interface{}{}, map[interface{}]interface{}{}, map[interface{}]interface{}{}, map[interface{}]interface{}{}, map[interface{}]interface{}{}, map[interface{}]interface{}{}, map[interface{}]interface{}{}}
		/* wftst.with_fields() */

		suite.T().Log("About to run line #128: wftst.WithFields()")

		runAndAssert(suite.Suite, expected_, wftst.WithFields(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #128")
	}

	// transform/array.yaml line #131
	// wftst2 = nestedObjArr.union(objArr.pluck({'b':'missing'})).union(nestedObjArr.pluck({'b':'c'}))
	suite.T().Log("Possibly executing: var wftst2 r.Term = nestedObjArr.Union(objArr.Pluck(map[interface{}]interface{}{'b': 'missing', })).Union(nestedObjArr.Pluck(map[interface{}]interface{}{'b': 'c', }))")

	wftst2 := nestedObjArr.Union(objArr.Pluck(map[interface{}]interface{}{"b": "missing"})).Union(nestedObjArr.Pluck(map[interface{}]interface{}{"b": "c"}))
	_ = wftst2 // Prevent any noused variable errors

	{
		// transform/array.yaml line #132
		/* ([{'b':{'c':1}}, {'b':{'c':2}}, {'b':{'c':3}}, {'b':{'c':1}}, {'b':{'c':2}}, {'b':{'c':3}}]) */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"b": map[interface{}]interface{}{"c": 1}}, map[interface{}]interface{}{"b": map[interface{}]interface{}{"c": 2}}, map[interface{}]interface{}{"b": map[interface{}]interface{}{"c": 3}}, map[interface{}]interface{}{"b": map[interface{}]interface{}{"c": 1}}, map[interface{}]interface{}{"b": map[interface{}]interface{}{"c": 2}}, map[interface{}]interface{}{"b": map[interface{}]interface{}{"c": 3}}}
		/* wftst2.with_fields({'b':'c'}) */

		suite.T().Log("About to run line #132: wftst2.WithFields(map[interface{}]interface{}{'b': 'c', })")

		runAndAssert(suite.Suite, expected_, wftst2.WithFields(map[interface{}]interface{}{"b": "c"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #132")
	}

	{
		// transform/array.yaml line #135
		/* err("ReqlQueryLogicError", "Invalid path argument `1`.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Invalid path argument `1`.")
		/* wftst.with_fields(1) */

		suite.T().Log("About to run line #135: wftst.WithFields(1)")

		runAndAssert(suite.Suite, expected_, wftst.WithFields(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #135")
	}

	{
		// transform/array.yaml line #137
		/* err("ReqlQueryLogicError", "Cannot perform has_fields on a non-object non-sequence `1`.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot perform has_fields on a non-object non-sequence `1`.")
		/* r.expr(1).with_fields() */

		suite.T().Log("About to run line #137: r.Expr(1).WithFields()")

		runAndAssert(suite.Suite, expected_, r.Expr(1).WithFields(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #137")
	}

	{
		// transform/array.yaml line #142
		/* [{}, {}, {}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{}, map[interface{}]interface{}{}, map[interface{}]interface{}{}}
		/* objArr.without('a', 'b') */

		suite.T().Log("About to run line #142: objArr.Without('a', 'b')")

		runAndAssert(suite.Suite, expected_, objArr.Without("a", "b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #142")
	}

	{
		// transform/array.yaml line #144
		/* [{'b':'a'}, {'b':'b'}, {'b':'c'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"b": "a"}, map[interface{}]interface{}{"b": "b"}, map[interface{}]interface{}{"b": "c"}}
		/* objArr.without('a') */

		suite.T().Log("About to run line #144: objArr.Without('a')")

		runAndAssert(suite.Suite, expected_, objArr.Without("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #144")
	}

	{
		// transform/array.yaml line #146
		/* [{'a':1, 'b':'a'}, {'a':2, 'b':'b'}, {'a':3, 'b':'c'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1, "b": "a"}, map[interface{}]interface{}{"a": 2, "b": "b"}, map[interface{}]interface{}{"a": 3, "b": "c"}}
		/* objArr.without() */

		suite.T().Log("About to run line #146: objArr.Without()")

		runAndAssert(suite.Suite, expected_, objArr.Without(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #146")
	}

	{
		// transform/array.yaml line #151
		/* [2,3,4] */
		var expected_ []interface{} = []interface{}{2, 3, 4}
		/* arr.map(lambda v: v + 1) */

		suite.T().Log("About to run line #151: arr.Map(func(v r.Term) interface{} { return r.Add(v, 1)})")

		runAndAssert(suite.Suite, expected_, arr.Map(func(v r.Term) interface{} { return r.Add(v, 1) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #151")
	}

	{
		// transform/array.yaml line #161
		/* 6 */
		var expected_ int = 6
		/* arr.reduce(lambda a, b: a + b) */

		suite.T().Log("About to run line #161: arr.Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, arr.Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #161")
	}

	{
		// transform/array.yaml line #166
		/* 6 */
		var expected_ int = 6
		/* arr.reduce(lambda a, b:a + b) */

		suite.T().Log("About to run line #166: arr.Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, arr.Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #166")
	}

	{
		// transform/array.yaml line #171
		/* 12 */
		var expected_ int = 12
		/* arr.union(arr).reduce(lambda a, b: a + b) */

		suite.T().Log("About to run line #171: arr.Union(arr).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, arr.Union(arr).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #171")
	}

	{
		// transform/array.yaml line #176
		/* 12 */
		var expected_ int = 12
		/* arr.union(arr).reduce(lambda a, b:a + b) */

		suite.T().Log("About to run line #176: arr.Union(arr).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, arr.Union(arr).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #176")
	}

	{
		// transform/array.yaml line #183
		/* [{'a':2, 'b':'b'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 2, "b": "b"}}
		/* objArr.filter(lambda row: row['b'] == 'b') */

		suite.T().Log("About to run line #183: objArr.Filter(func(row r.Term) interface{} { return row.AtIndex('b').Eq('b')})")

		runAndAssert(suite.Suite, expected_, objArr.Filter(func(row r.Term) interface{} { return row.AtIndex("b").Eq("b") }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #183")
	}

	{
		// transform/array.yaml line #190
		/* [1,2,1,2,1,2] */
		var expected_ []interface{} = []interface{}{1, 2, 1, 2, 1, 2}
		/* arr.concat_map(lambda v: [1,2]) */

		suite.T().Log("About to run line #190: arr.ConcatMap(func(v r.Term) interface{} { return []interface{}{1, 2}})")

		runAndAssert(suite.Suite, expected_, arr.ConcatMap(func(v r.Term) interface{} { return []interface{}{1, 2} }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #190")
	}

	{
		// transform/array.yaml line #194
		/* [{'v':1}, {'v2':2}, {'v':2}, {'v2':3}, {'v':3}, {'v2':4}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"v": 1}, map[interface{}]interface{}{"v2": 2}, map[interface{}]interface{}{"v": 2}, map[interface{}]interface{}{"v2": 3}, map[interface{}]interface{}{"v": 3}, map[interface{}]interface{}{"v2": 4}}
		/* arr.concat_map(lambda v: [{'v':v}, {'v2':v + 1}]) */

		suite.T().Log("About to run line #194: arr.ConcatMap(func(v r.Term) interface{} { return []interface{}{map[interface{}]interface{}{'v': v, }, map[interface{}]interface{}{'v2': r.Add(v, 1), }}})")

		runAndAssert(suite.Suite, expected_, arr.ConcatMap(func(v r.Term) interface{} {
			return []interface{}{map[interface{}]interface{}{"v": v}, map[interface{}]interface{}{"v2": r.Add(v, 1)}}
		}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #194")
	}

	{
		// transform/array.yaml line #201
		/* [{'a':1, 'b':'a'}, {'a':2, 'b':'b'}, {'a':3, 'b':'c'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1, "b": "a"}, map[interface{}]interface{}{"a": 2, "b": "b"}, map[interface{}]interface{}{"a": 3, "b": "c"}}
		/* objArr.order_by('b') */

		suite.T().Log("About to run line #201: objArr.OrderBy('b')")

		runAndAssert(suite.Suite, expected_, objArr.OrderBy("b"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #201")
	}

	{
		// transform/array.yaml line #205
		/* [{'a':3, 'b':'c'}, {'a':2, 'b':'b'}, {'a':1, 'b':'a'}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 3, "b": "c"}, map[interface{}]interface{}{"a": 2, "b": "b"}, map[interface{}]interface{}{"a": 1, "b": "a"}}
		/* objArr.order_by(r.desc('b')) */

		suite.T().Log("About to run line #205: objArr.OrderBy(r.Desc('b'))")

		runAndAssert(suite.Suite, expected_, objArr.OrderBy(r.Desc("b")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #205")
	}

	{
		// transform/array.yaml line #208
		/* [{'-a':1},{'-a':2}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"-a": 1}, map[interface{}]interface{}{"-a": 2}}
		/* r.expr([{'-a':1},{'-a':2}]).order_by('-a') */

		suite.T().Log("About to run line #208: r.Expr([]interface{}{map[interface{}]interface{}{'-a': 1, }, map[interface{}]interface{}{'-a': 2, }}).OrderBy('-a')")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{map[interface{}]interface{}{"-a": 1}, map[interface{}]interface{}{"-a": 2}}).OrderBy("-a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #208")
	}

	{
		// transform/array.yaml line #216
		/* [1,2,3,4] */
		var expected_ []interface{} = []interface{}{1, 2, 3, 4}
		/* r.expr([1,1,2,2,2,3,4]).distinct() */

		suite.T().Log("About to run line #216: r.Expr([]interface{}{1, 1, 2, 2, 2, 3, 4}).Distinct()")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 1, 2, 2, 2, 3, 4}).Distinct(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #216")
	}

	{
		// transform/array.yaml line #223
		/* 3 */
		var expected_ int = 3
		/* objArr.count() */

		suite.T().Log("About to run line #223: objArr.Count()")

		runAndAssert(suite.Suite, expected_, objArr.Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #223")
	}

	{
		// transform/array.yaml line #228
		/* [1, 2, 3, {'a':1, 'b':'a'}, {'a':2, 'b':'b'}, {'a':3, 'b':'c'}] */
		var expected_ []interface{} = []interface{}{1, 2, 3, map[interface{}]interface{}{"a": 1, "b": "a"}, map[interface{}]interface{}{"a": 2, "b": "b"}, map[interface{}]interface{}{"a": 3, "b": "c"}}
		/* arr.union(objArr) */

		suite.T().Log("About to run line #228: arr.Union(objArr)")

		runAndAssert(suite.Suite, expected_, arr.Union(objArr), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #228")
	}

	{
		// transform/array.yaml line #234
		/* 2 */
		var expected_ int = 2
		/* arr[1] */

		suite.T().Log("About to run line #234: arr.AtIndex(1)")

		runAndAssert(suite.Suite, expected_, arr.AtIndex(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #234")
	}

	{
		// transform/array.yaml line #235
		/* 2 */
		var expected_ int = 2
		/* arr.nth(1) */

		suite.T().Log("About to run line #235: arr.Nth(1)")

		runAndAssert(suite.Suite, expected_, arr.Nth(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #235")
	}

	{
		// transform/array.yaml line #238
		/* 1 */
		var expected_ int = 1
		/* arr[0] */

		suite.T().Log("About to run line #238: arr.AtIndex(0)")

		runAndAssert(suite.Suite, expected_, arr.AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #238")
	}

	{
		// transform/array.yaml line #245
		/* true */
		var expected_ bool = true
		/* r.expr([]).is_empty() */

		suite.T().Log("About to run line #245: r.Expr([]interface{}{}).IsEmpty()")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{}).IsEmpty(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #245")
	}

	{
		// transform/array.yaml line #247
		/* false */
		var expected_ bool = false
		/* arr.is_empty() */

		suite.T().Log("About to run line #247: arr.IsEmpty()")

		runAndAssert(suite.Suite, expected_, arr.IsEmpty(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #247")
	}

	{
		// transform/array.yaml line #251
		/* true */
		var expected_ bool = true
		/* arr.contains(2) */

		suite.T().Log("About to run line #251: arr.Contains(2)")

		runAndAssert(suite.Suite, expected_, arr.Contains(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #251")
	}

	{
		// transform/array.yaml line #253
		/* true */
		var expected_ bool = true
		/* arr.contains(2, 3) */

		suite.T().Log("About to run line #253: arr.Contains(2, 3)")

		runAndAssert(suite.Suite, expected_, arr.Contains(2, 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #253")
	}

	{
		// transform/array.yaml line #255
		/* false */
		var expected_ bool = false
		/* arr.contains(4) */

		suite.T().Log("About to run line #255: arr.Contains(4)")

		runAndAssert(suite.Suite, expected_, arr.Contains(4), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #255")
	}

	{
		// transform/array.yaml line #257
		/* false */
		var expected_ bool = false
		/* arr.contains(2, 4) */

		suite.T().Log("About to run line #257: arr.Contains(2, 4)")

		runAndAssert(suite.Suite, expected_, arr.Contains(2, 4), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #257")
	}

	{
		// transform/array.yaml line #259
		/* false */
		var expected_ bool = false
		/* arr.contains(2, 2) */

		suite.T().Log("About to run line #259: arr.Contains(2, 2)")

		runAndAssert(suite.Suite, expected_, arr.Contains(2, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #259")
	}

	{
		// transform/array.yaml line #261
		/* true */
		var expected_ bool = true
		/* arr.union(arr).contains(2, 2) */

		suite.T().Log("About to run line #261: arr.Union(arr).Contains(2, 2)")

		runAndAssert(suite.Suite, expected_, arr.Union(arr).Contains(2, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #261")
	}

	{
		// transform/array.yaml line #265
		/* true */
		var expected_ bool = true
		/* arr.contains(lambda x:x == 2) */

		suite.T().Log("About to run line #265: arr.Contains(func(x r.Term) interface{} { return r.Eq(x, 2)})")

		runAndAssert(suite.Suite, expected_, arr.Contains(func(x r.Term) interface{} { return r.Eq(x, 2) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #265")
	}

	{
		// transform/array.yaml line #269
		/* true */
		var expected_ bool = true
		/* arr.contains(lambda x:x == 2, lambda x:x==3) */

		suite.T().Log("About to run line #269: arr.Contains(func(x r.Term) interface{} { return r.Eq(x, 2)}, func(x r.Term) interface{} { return r.Eq(x, 3)})")

		runAndAssert(suite.Suite, expected_, arr.Contains(func(x r.Term) interface{} { return r.Eq(x, 2) }, func(x r.Term) interface{} { return r.Eq(x, 3) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #269")
	}

	{
		// transform/array.yaml line #273
		/* false */
		var expected_ bool = false
		/* arr.contains(lambda x:x == 4) */

		suite.T().Log("About to run line #273: arr.Contains(func(x r.Term) interface{} { return r.Eq(x, 4)})")

		runAndAssert(suite.Suite, expected_, arr.Contains(func(x r.Term) interface{} { return r.Eq(x, 4) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #273")
	}

	{
		// transform/array.yaml line #277
		/* false */
		var expected_ bool = false
		/* arr.contains(lambda x:x == 2, lambda x:x==4) */

		suite.T().Log("About to run line #277: arr.Contains(func(x r.Term) interface{} { return r.Eq(x, 2)}, func(x r.Term) interface{} { return r.Eq(x, 4)})")

		runAndAssert(suite.Suite, expected_, arr.Contains(func(x r.Term) interface{} { return r.Eq(x, 2) }, func(x r.Term) interface{} { return r.Eq(x, 4) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #277")
	}

	{
		// transform/array.yaml line #281
		/* false */
		var expected_ bool = false
		/* arr.contains(lambda x:x == 2, lambda x:x==2) */

		suite.T().Log("About to run line #281: arr.Contains(func(x r.Term) interface{} { return r.Eq(x, 2)}, func(x r.Term) interface{} { return r.Eq(x, 2)})")

		runAndAssert(suite.Suite, expected_, arr.Contains(func(x r.Term) interface{} { return r.Eq(x, 2) }, func(x r.Term) interface{} { return r.Eq(x, 2) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #281")
	}

	{
		// transform/array.yaml line #285
		/* true */
		var expected_ bool = true
		/* arr.union(arr).contains(lambda x:x == 2, lambda x:x==2) */

		suite.T().Log("About to run line #285: arr.Union(arr).Contains(func(x r.Term) interface{} { return r.Eq(x, 2)}, func(x r.Term) interface{} { return r.Eq(x, 2)})")

		runAndAssert(suite.Suite, expected_, arr.Union(arr).Contains(func(x r.Term) interface{} { return r.Eq(x, 2) }, func(x r.Term) interface{} { return r.Eq(x, 2) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #285")
	}

	{
		// transform/array.yaml line #290
		/* [1, 3] */
		var expected_ []interface{} = []interface{}{1, 3}
		/* r.expr([{'a':1},{'b':2},{'a':3,'c':4}])['a'] */

		suite.T().Log("About to run line #290: r.Expr([]interface{}{map[interface{}]interface{}{'a': 1, }, map[interface{}]interface{}{'b': 2, }, map[interface{}]interface{}{'a': 3, 'c': 4, }}).AtIndex('a')")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{map[interface{}]interface{}{"a": 1}, map[interface{}]interface{}{"b": 2}, map[interface{}]interface{}{"a": 3, "c": 4}}).AtIndex("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #290")
	}

	{
		// transform/array.yaml line #293
		/* err("ReqlQueryLogicError", "Cannot perform bracket on a non-object non-sequence `\"a\"`.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot perform bracket on a non-object non-sequence `\"a\"`.")
		/* r.expr([{'a':1},'a',{'b':2},{'a':3,'c':4}])['a'] */

		suite.T().Log("About to run line #293: r.Expr([]interface{}{map[interface{}]interface{}{'a': 1, }, 'a', map[interface{}]interface{}{'b': 2, }, map[interface{}]interface{}{'a': 3, 'c': 4, }}).AtIndex('a')")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{map[interface{}]interface{}{"a": 1}, "a", map[interface{}]interface{}{"b": 2}, map[interface{}]interface{}{"a": 3, "c": 4}}).AtIndex("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #293")
	}
}
