-- v5 (compatible with v3+): Add buffer for history sync notifications
CREATE TABLE whatsapp_history_sync_notification (
    -- only: sqlite (line commented)
--	rowid         INTEGER PRIMARY KEY,
    -- only: postgres
    rowid         BIGINT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY,

    bridge_id     TEXT  NOT NULL,
    user_login_id TEXT  NOT NULL,
    data          bytea NOT NULL,

    CONSTRAINT whatsapp_history_sync_notification_user_login_fkey FOREIGN KEY (bridge_id, user_login_id)
        REFERENCES user_login (bridge_id, id) ON UPDATE CASCADE ON DELETE CASCADE
);
CREATE INDEX whatsapp_history_sync_notification_login_idx ON whatsapp_history_sync_notification (bridge_id, user_login_id);
