/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.JavaEvaluator;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.spi.debugger.jpda.Evaluator;
import org.openide.util.NbBundle;

class JPDAWatchImpl
extends AbstractVariable
implements JPDAWatch {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;

    JPDAWatchImpl(JPDADebuggerImpl debugger, Watch watch, PrimitiveValue v) {
        super(debugger, v, "" + watch + (v instanceof ObjectReference ? "^" : ""));
        this.debugger = debugger;
        this.watch = watch;
    }

    JPDAWatchImpl(JPDADebuggerImpl debugger, Watch watch, Throwable exception) {
        super(debugger, null, "" + watch);
        Throwable t;
        this.debugger = debugger;
        this.watch = watch;
        this.exceptionDescription = exception.getLocalizedMessage();
        if (this.exceptionDescription == null) {
            this.exceptionDescription = exception.getMessage();
        }
        if ((t = exception.getCause()) != null && exception instanceof InvalidExpressionException && ((InvalidExpressionException)exception).hasApplicationTarget()) {
            StringWriter s = new StringWriter();
            PrintWriter p = new PrintWriter(s);
            t.printStackTrace(p);
            p.close();
            this.exceptionDescription = this.exceptionDescription + " \n" + s.toString();
        }
    }

    public Watch getWatch() {
        return this.watch;
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String expression) {
        this.watch.setExpression(expression);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    @Override
    protected void setInnerValue(Value v) {
        super.setInnerValue(v);
        this.exceptionDescription = null;
    }

    static EvaluationContext.VariableInfo getInfo(JPDADebuggerImpl debugger, Value v) {
        Session s = debugger.getSession();
        Evaluator e = (Evaluator)s.lookupFirst(s.getCurrentLanguage(), Evaluator.class);
        if (e == null) {
            e = (Evaluator)s.lookupFirst("Java", Evaluator.class);
        }
        if (!(e instanceof JavaEvaluator)) {
            return null;
        }
        return ((JavaEvaluator)e).getValueContainer(v);
    }

    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        EvaluationContext.VariableInfo vi = JPDAWatchImpl.getInfo(this.debugger, this.getInnerValue());
        if (vi != null) {
            try {
                vi.setValue(value);
            }
            catch (IllegalStateException isex) {
                if (isex.getCause() instanceof InvalidExpressionException) {
                    throw (InvalidExpressionException)isex.getCause();
                }
                throw new InvalidExpressionException((Throwable)isex);
            }
        } else {
            throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
        }
    }

    public String getToStringValue() throws InvalidExpressionException {
        return AbstractObjectVariable.getToStringValue(this.getInnerValue(), this.getDebugger(), 0);
    }

    void setException(String exceptionDescription) {
        this.setInnerValue(null);
        this.exceptionDescription = exceptionDescription;
    }

    @Override
    public JPDAWatchImpl clone() {
        JPDAWatchImpl clon = this.exceptionDescription == null ? new JPDAWatchImpl(this.getDebugger(), this.watch, (PrimitiveValue)this.getJDIValue()) : new JPDAWatchImpl(this.getDebugger(), this.watch, new Exception(this.exceptionDescription));
        return clon;
    }
}

