/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Dialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class VersioningInfo {
    public static void show(HashMap<File, Map<String, String>> properties) {
        PropertySheet ps = new PropertySheet();
        ps.setNodes((Node[])new VersioningInfoNode[]{new VersioningInfoNode(properties)});
        DialogDescriptor dd = new DialogDescriptor((Object)ps, NbBundle.getMessage(VersioningInfo.class, (String)"MSG_VersioningInfo_title"), true, 2, DialogDescriptor.OK_OPTION, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.addWindowListener(new DialogBoundsPreserver(NbPreferences.forModule(VersioningInfo.class), "versioning.util.versioningInfo"));
        dialog.setVisible(true);
    }

    private static class VersioningInfoNode
    extends AbstractNode {
        private final HashMap<File, Map<String, String>> properties;
        private final String name;
        private final String desc;

        public VersioningInfoNode(HashMap<File, Map<String, String>> properties) {
            super(Children.LEAF);
            this.properties = properties;
            this.name = NbBundle.getMessage(VersioningInfo.class, (String)"MSG_VersioningInfoNode_name");
            this.desc = NbBundle.getMessage(VersioningInfo.class, (String)"MSG_VersioningInfoNode_desc");
        }

        protected Sheet createSheet() {
            Sheet sheet = new Sheet();
            for (Map.Entry<File, Map<String, String>> e : this.properties.entrySet()) {
                Map<String, String> fileProps = e.getValue();
                Sheet.Set ps = new Sheet.Set();
                ps.setName(e.getKey().getAbsolutePath());
                ps.setDisplayName(e.getKey().getName());
                ps.setShortDescription(e.getKey().getAbsolutePath());
                Node.Property[] props = new Node.Property[fileProps.size()];
                int i = 0;
                for (Map.Entry<String, String> prop : fileProps.entrySet()) {
                    String value = prop.getValue();
                    if (value == null) {
                        Logger.getLogger(VersioningInfo.class.getName()).log(Level.INFO, "null value for property {0}", prop.getKey());
                        value = NbBundle.getMessage(VersioningInfo.class, (String)"MSG_VersioningInfoNode_unknownvalue");
                    }
                    props[i++] = new VersioningInfoProperty(prop.getKey(), value);
                }
                ps.put(props);
                sheet.put(ps);
            }
            return sheet;
        }

        public String getName() {
            return this.name;
        }

        public String getShortDescription() {
            return this.desc;
        }
    }

    private static class VersioningInfoProperty
    extends PropertySupport.ReadOnly<String> {
        private final String value;

        public VersioningInfoProperty(String name, String value) {
            super(name, String.class, name, value);
            this.value = value;
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return this.value;
        }
    }
}

