/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerStorage;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.ppoints.Bundle;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointReport;
import org.netbeans.modules.profiler.ppoints.ui.TakeSnapshotCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.v2.SnapshotsWindow;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class TakeSnapshotProfilingPoint
extends CodeProfilingPoint.Single
implements PropertyChangeListener {
    static final String PROPERTY_TYPE = "p_snapshot";
    public static final String TYPE_PROFDATA_KEY = "profdata";
    public static final String TYPE_HEAPDUMP_KEY = "heapdump";
    static final String PROPERTY_TARGET = "p_target";
    public static final String TARGET_PROJECT_KEY = "project";
    public static final String TARGET_CUSTOM_KEY = "custom";
    static final String PROPERTY_CUSTOM_FILE = "p_file";
    static final String PROPERTY_RESET_RESULTS = "p_reset_results";
    private static final String SNAPSHOT_LOCATION_URLMASK = "file:";
    private static final String ANNOTATION_ENABLED = "takeSnapshotProfilingPoint";
    private static final String ANNOTATION_DISABLED = "takeSnapshotProfilingPointD";
    private Annotation annotation;
    private List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private String snapshotFile = System.getProperty("java.io.tmpdir");
    private String snapshotTarget = "project";
    private String snapshotType = "profdata";
    private WeakReference<Report> reportReference;
    private boolean resetResults = false;

    public TakeSnapshotProfilingPoint(String name, CodeProfilingPoint.Location location, Lookup.Provider project, ProfilingPointFactory factory) {
        super(name, location, project, factory);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    public void setResetResults(boolean resetResults) {
        if (this.resetResults == resetResults) {
            return;
        }
        this.resetResults = resetResults;
        this.getChangeSupport().firePropertyChange(PROPERTY_RESET_RESULTS, !this.resetResults, this.resetResults);
    }

    public boolean getResetResults() {
        return this.resetResults;
    }

    public void setSnapshotFile(String snapshotFile) {
        if (snapshotFile == null || !new File(snapshotFile).exists()) {
            return;
        }
        if (this.snapshotFile != null && new File(this.snapshotFile).equals(new File(snapshotFile))) {
            return;
        }
        String oldSnapshotFile = this.snapshotFile;
        this.snapshotFile = snapshotFile;
        this.getChangeSupport().firePropertyChange(PROPERTY_CUSTOM_FILE, oldSnapshotFile, snapshotFile);
    }

    public String getSnapshotFile() {
        return this.snapshotFile;
    }

    public void setSnapshotTarget(String snapshotTarget) {
        if (!snapshotTarget.equals(TARGET_PROJECT_KEY) && !snapshotTarget.equals(TARGET_CUSTOM_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot target category: " + snapshotTarget);
        }
        if (this.snapshotTarget.equals(snapshotTarget)) {
            return;
        }
        String oldSnapshotTarget = this.snapshotTarget;
        this.snapshotTarget = snapshotTarget;
        this.getChangeSupport().firePropertyChange(PROPERTY_TARGET, oldSnapshotTarget, snapshotTarget);
    }

    public String getSnapshotTarget() {
        return this.snapshotTarget;
    }

    public void setSnapshotType(String snapshotType) {
        if (snapshotType == null || !snapshotType.equals(TYPE_PROFDATA_KEY) && !snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            throw new IllegalArgumentException("Invalid snapshot type: " + snapshotType);
        }
        if (this.snapshotType.equals(snapshotType)) {
            return;
        }
        String oldSnapshotType = this.snapshotType;
        this.snapshotType = snapshotType;
        this.getChangeSupport().firePropertyChange(PROPERTY_TYPE, oldSnapshotType, snapshotType);
    }

    public String getSnapshotType() {
        return this.snapshotType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return !this.results.isEmpty();
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Report report = TakeSnapshotProfilingPoint.this.getReport(false);
                if (report != null) {
                    report.close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Report report = this.getReport(false);
        if (report != null) {
            if (evt.getPropertyName() == "p_name") {
                report.refreshProperties();
            }
            report.refresh();
        }
    }

    @Override
    public void showResults(URL url) {
        Report topComponent = this.getReport(true);
        topComponent.open();
        topComponent.requestActive();
    }

    @Override
    protected CodeProfilingPoint.Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new Annotation();
        }
        return this.annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                int size = this.results.size();
                long timeStamp = this.results.get(size - 1).getTimestamp();
                String time = Utils.formatProfilingPointTime(timeStamp);
                return size == 1 ? Bundle.TakeSnapshotProfilingPoint_OneHitString(time) : Bundle.TakeSnapshotProfilingPoint_NHitsString(size, time);
            }
            return Bundle.TakeSnapshotProfilingPoint_NoResultsString();
        }
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel c) {
        TakeSnapshotCustomizer customizer = (TakeSnapshotCustomizer)c;
        customizer.setPPName(this.getName());
        customizer.setPPLocation(this.getLocation());
        customizer.setPPType(TYPE_PROFDATA_KEY.equals(this.getSnapshotType()));
        customizer.setPPTarget(TARGET_PROJECT_KEY.equals(this.getSnapshotTarget()));
        customizer.setPPFile(this.getSnapshotFile());
        customizer.setPPResetResults(this.getResetResults());
    }

    @Override
    String getServerHandlerClassName() {
        if (this.getSnapshotType().equals(TYPE_HEAPDUMP_KEY)) {
            return "org.netbeans.lib.profiler.server.TakeHeapdumpProfilingPointHandler";
        }
        if (this.getResetResults()) {
            return "org.netbeans.lib.profiler.server.TakeSnapshotWithResetProfilingPointHandler";
        }
        return "org.netbeans.lib.profiler.server.TakeSnapshotProfilingPointHandler";
    }

    @Override
    String getServerInfo() {
        if (this.getSnapshotType().equals(TYPE_HEAPDUMP_KEY)) {
            try {
                return FileUtil.toFile((FileObject)this.getSnapshotDirectory()).getAbsolutePath();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(65536, (Throwable)ex);
            }
        }
        return null;
    }

    FileObject getSnapshotDirectory() throws IOException {
        if (this.snapshotTarget.equals(TARGET_PROJECT_KEY)) {
            return ProfilerStorage.getProjectFolder((Lookup.Provider)this.getProject(), (boolean)true);
        }
        File f = new File(this.snapshotFile);
        f.mkdirs();
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)f));
    }

    @Override
    void setValues(ValidityAwarePanel c) {
        TakeSnapshotCustomizer customizer = (TakeSnapshotCustomizer)c;
        this.setName(customizer.getPPName());
        this.setLocation(customizer.getPPLocation());
        this.setSnapshotType(customizer.getPPType() ? TYPE_PROFDATA_KEY : TYPE_HEAPDUMP_KEY);
        this.setSnapshotTarget(customizer.getPPTarget() ? TARGET_PROJECT_KEY : TARGET_CUSTOM_KEY);
        this.setSnapshotFile(customizer.getPPFile());
        this.setResetResults(customizer.getPPResetResults());
        Utils.checkLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(RuntimeProfilingPoint.HitEvent hitEvent, int index) {
        String snapshotFilename;
        if (this.snapshotType.equals(TYPE_HEAPDUMP_KEY)) {
            TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
            snapshotFilename = runner.getProfilingSessionStatus().remoteProfiling ? Bundle.TakeSnapshotProfilingPoint_RemoteUnsupportedMsg() : (!runner.hasSupportedJDKForHeapDump() ? Bundle.TakeSnapshotProfilingPoint_NoDataJdkMsg() : this.takeHeapdumpHit(hitEvent.getTimestamp()));
        } else {
            snapshotFilename = this.takeSnapshotHit();
        }
        Object object = this.resultsSync;
        synchronized (object) {
            if (ProfilingPointsManager.getDefault().belowMaxHits(this.results.size())) {
                this.results.add(new Result(hitEvent.getTimestamp(), hitEvent.getThreadId(), snapshotFilename));
            }
        }
        this.getChangeSupport().firePropertyChange("p_results", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean change = this.hasResults();
            this.results.clear();
            if (change) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private Report getReport(boolean create) {
        Report report;
        Report report2 = report = this.reportReference == null ? null : (Report)((Object)this.reportReference.get());
        if (report == null && create) {
            report = new Report();
            this.reportReference = new WeakReference<Report>(report);
        }
        return report;
    }

    private File constructHeapDumpFile(long time) throws IOException {
        String name = ResultsManager.getDefault().getDefaultHeapDumpFileName(time) + "." + "hprof";
        File dir = FileUtil.toFile((FileObject)this.getSnapshotDirectory());
        return new File(dir.getAbsoluteFile(), name);
    }

    private String takeHeapdumpHit(long time) {
        try {
            File heapdumpFile = this.constructHeapDumpFile(time);
            if (heapdumpFile.exists()) {
                File fixedHeapdumpFile = this.constructHeapDumpFile(Utils.getTimeInMillis(time));
                heapdumpFile.renameTo(fixedHeapdumpFile);
                FileObject folder = FileUtil.toFileObject((File)fixedHeapdumpFile.getParentFile());
                SnapshotsWindow.instance().refreshFolder(folder, true);
                return fixedHeapdumpFile.toURI().toURL().toExternalForm();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
            return Bundle.TakeSnapshotProfilingPoint_NoDataAvailableMsg();
        }
        return Bundle.TakeSnapshotProfilingPoint_NoDataAvailableMsg();
    }

    private static LoadedSnapshot takeSnapshot() throws CPUResultsSnapshot.NoDataAvailableException {
        return ResultsManager.getDefault().prepareSnapshot();
    }

    private String takeSnapshotHit() {
        LoadedSnapshot loadedSnapshot = null;
        String snapshotFilename = null;
        try {
            loadedSnapshot = TakeSnapshotProfilingPoint.takeSnapshot();
        }
        catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
            // empty catch block
        }
        if (loadedSnapshot != null) {
            try {
                FileObject snapshotDirectory = this.getSnapshotDirectory();
                FileObject profFile = snapshotDirectory.createData(ResultsManager.getDefault().getDefaultSnapshotFileName(loadedSnapshot), "nps");
                ResultsManager.getDefault().saveSnapshot(loadedSnapshot, profFile);
                snapshotFilename = FileUtil.toFile((FileObject)profFile).toURI().toURL().toExternalForm();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(65536, (Throwable)e);
            }
        }
        return snapshotFilename == null ? Bundle.TakeSnapshotProfilingPoint_NoDataAvailableMsg() : snapshotFilename;
    }

    private class Report
    extends ProfilingPointReport {
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void refresh() {
            StringBuilder headerAreaTextBuilder = new StringBuilder();
            headerAreaTextBuilder.append(this.getHeaderName());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderType());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderEnabled());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderProject());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderLocation());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderMode());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderTarget());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderResetResults());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(headerAreaTextBuilder.toString());
            StringBuilder dataAreaTextBuilder = new StringBuilder();
            Object object = TakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (TakeSnapshotProfilingPoint.this.results.isEmpty()) {
                    dataAreaTextBuilder.append(ProfilingPointReport.getNoDataHint(TakeSnapshotProfilingPoint.this));
                } else {
                    for (int i = 0; i < TakeSnapshotProfilingPoint.this.results.size(); ++i) {
                        dataAreaTextBuilder.append("&nbsp;&nbsp;");
                        dataAreaTextBuilder.append(this.getDataResultItem(i));
                        dataAreaTextBuilder.append("<br>");
                    }
                    ProfilingPointsManager m = ProfilingPointsManager.getDefault();
                    if (!m.belowMaxHits(TakeSnapshotProfilingPoint.this.results.size())) {
                        dataAreaTextBuilder.append(m.getTruncatedResultsText());
                    }
                }
            }
            this.dataArea.setText(dataAreaTextBuilder.toString());
        }

        void refreshProperties() {
            this.setName(TakeSnapshotProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)TakeSnapshotProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(Bundle.TakeSnapshotProfilingPoint_ReportAccessDescr(this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int index) {
            Object object = TakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)TakeSnapshotProfilingPoint.this.results.get(index);
                String resultString = result.getResultString();
                String snapshotInformation = resultString.startsWith(TakeSnapshotProfilingPoint.SNAPSHOT_LOCATION_URLMASK) ? "<a href='" + resultString + "'>" + Bundle.TakeSnapshotProfilingPoint_OpenSnapshotString() + "</a>" : resultString;
                return Bundle.TakeSnapshotProfilingPoint_HitString(index + 1, Utils.formatProfilingPointTimeHiRes(result.getTimestamp()), snapshotInformation);
            }
        }

        private String getHeaderEnabled() {
            return Bundle.TakeSnapshotProfilingPoint_HeaderEnabledString(TakeSnapshotProfilingPoint.this.isEnabled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = TakeSnapshotProfilingPoint.this.resultsSync;
            synchronized (object) {
                return Bundle.TakeSnapshotProfilingPoint_HeaderHitsString(TakeSnapshotProfilingPoint.this.results.size());
            }
        }

        private String getHeaderLocation() {
            CodeProfilingPoint.Location location = TakeSnapshotProfilingPoint.this.getLocation();
            String shortFileName = new File(location.getFile()).getName();
            int lineNumber = location.getLine();
            return Bundle.TakeSnapshotProfilingPoint_HeaderLocationString(shortFileName, lineNumber);
        }

        private String getHeaderMode() {
            return TakeSnapshotProfilingPoint.this.getSnapshotType().equals(TakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) ? Bundle.TakeSnapshotProfilingPoint_HeaderModeDataString() : Bundle.TakeSnapshotProfilingPoint_HeaderModeDumpString();
        }

        private String getHeaderName() {
            return "<h2><b>" + TakeSnapshotProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return Bundle.TakeSnapshotProfilingPoint_HeaderProjectString(ProjectUtilities.getDisplayName((Lookup.Provider)TakeSnapshotProfilingPoint.this.getProject()));
        }

        private String getHeaderResetResults() {
            return Bundle.TakeSnapshotProfilingPoint_HeaderResetResultsString(TakeSnapshotProfilingPoint.this.getResetResults());
        }

        private String getHeaderTarget() {
            return TakeSnapshotProfilingPoint.this.getSnapshotTarget().equals(TakeSnapshotProfilingPoint.TARGET_PROJECT_KEY) ? Bundle.TakeSnapshotProfilingPoint_HeaderTargetProjectString() : Bundle.TakeSnapshotProfilingPoint_HeaderTargetCustomString(TakeSnapshotProfilingPoint.this.getSnapshotFile());
        }

        private String getHeaderType() {
            return Bundle.TakeSnapshotProfilingPoint_HeaderTypeString(TakeSnapshotProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel contentsPanel = new JPanel(new BorderLayout());
            contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.setOpaque(true);
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    Utils.openLocation(TakeSnapshotProfilingPoint.this.getLocation());
                }
            };
            JScrollPane headerAreaScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            headerAreaScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            headerAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            contentsPanel.add((Component)headerAreaScrollPane, "North");
            this.dataArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    File resolvedFile = null;
                    try {
                        resolvedFile = new File(url.toURI());
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    File snapshotFile = resolvedFile;
                    if (snapshotFile != null && snapshotFile.exists()) {
                        String type = TakeSnapshotProfilingPoint.this.getSnapshotType();
                        if (type.equals(TakeSnapshotProfilingPoint.TYPE_PROFDATA_KEY) || type.equals(TakeSnapshotProfilingPoint.TYPE_HEAPDUMP_KEY)) {
                            ResultsManager.getDefault().openSnapshot(snapshotFile);
                        }
                    } else {
                        ProfilerDialogs.displayWarning((String)Bundle.TakeSnapshotProfilingPoint_SnapshotNotAvailableMsg());
                    }
                }
            };
            JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder tb = new TitledBorder(Bundle.TakeSnapshotProfilingPoint_DataString());
            tb.setTitleFont(Utils.getTitledBorderFont(tb).deriveFont(1));
            tb.setTitleColor(UIManager.getColor("Label.foreground"));
            dataAreaScrollPane.setBorder(tb);
            dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            dataAreaScrollPane.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.add((Component)dataAreaScrollPane, "Center");
            this.add(contentsPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private class Annotation
    extends CodeProfilingPoint.Annotation {
        private Annotation() {
        }

        public String getAnnotationType() {
            return TakeSnapshotProfilingPoint.this.isEnabled() ? TakeSnapshotProfilingPoint.ANNOTATION_ENABLED : TakeSnapshotProfilingPoint.ANNOTATION_DISABLED;
        }

        public String getShortDescription() {
            return TakeSnapshotProfilingPoint.this.getName();
        }

        @Override
        public CodeProfilingPoint profilingPoint() {
            return TakeSnapshotProfilingPoint.this;
        }
    }

    private static class Result {
        private final String resultString;
        private final int threadId;
        private final long timestamp;

        public Result(long timestamp, int threadId, String resultString) {
            this.timestamp = timestamp;
            this.threadId = threadId;
            this.resultString = resultString;
        }

        public String getResultString() {
            return this.resultString;
        }

        public int getThreadID() {
            return this.threadId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

