/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.moduletask.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.Reader;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.Writer;

public final class ConstantPool {
    private CPInfo[] entries;

    ConstantPool(Reader in) throws IOException {
        int cnt = in.readUnsignedShort();
        this.entries = new CPInfo[cnt];
        int[] increment = new int[1];
        for (int i = 1; i < cnt; i += increment[0]) {
            this.entries[i] = this.readInfo(in, increment);
        }
    }

    void write(Writer out) throws IOException {
        out.writeUnsignedShort(this.entries.length);
        for (int i = 0; i < this.entries.length; ++i) {
            CPInfo entry = this.entries[i];
            if (entry == null) continue;
            entry.write(out);
        }
    }

    public CPInfo get(int index) {
        if (index < 0 || index >= this.entries.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.entries[index];
    }

    public int add(CPInfo constant) {
        for (int i = 0; i < this.entries.length; ++i) {
            if (!constant.equals(this.entries[i])) continue;
            return i;
        }
        this.entries = Arrays.copyOf(this.entries, this.entries.length + 1);
        this.entries[this.entries.length - 1] = constant;
        return this.entries.length - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.entries.length; ++i) {
            CPInfo info = this.entries[i];
            if (info == null) continue;
            sb.append(i).append('\t').append(this.entries[i]).append('\n');
        }
        return sb.toString();
    }

    private CPInfo readInfo(Reader in, int[] increment) throws IOException {
        int tag = in.readUnsignedByte();
        ConstantKind c = ConstantKind.fromTag(tag);
        increment[0] = 1;
        switch (c) {
            case CONSTANT_Class: {
                return new CPClass(this, in);
            }
            case CONSTANT_Fieldref: {
                return new CPFieldref(this, in);
            }
            case CONSTANT_Methodref: {
                return new CPMethodref(this, in);
            }
            case CONSTANT_InterfaceMethodref: {
                return new CPInterfaceMethodref(this, in);
            }
            case CONSTANT_String: {
                return new CPString(this, in);
            }
            case CONSTANT_Integer: {
                return new CPInteger(this, in);
            }
            case CONSTANT_Float: {
                return new CPFloat(this, in);
            }
            case CONSTANT_Long: {
                increment[0] = 2;
                return new CPLong(this, in);
            }
            case CONSTANT_Double: {
                increment[0] = 2;
                return new CPDouble(this, in);
            }
            case CONSTANT_NameAndType: {
                return new CPNameAndType(this, in);
            }
            case CONSTANT_Utf8: {
                return new CPUtf8(this, in);
            }
            case CONSTANT_MethodHandle: {
                return new CPMethodHandle(this, in);
            }
            case CONSTANT_MethodType: {
                return new CPMethodType(this, in);
            }
            case CONSTANT_ConstantDynamic: {
                return new CPConstantDynamic(this, in);
            }
            case CONSTANT_InvokeDynamic: {
                return new CPInvokeDynamic(this, in);
            }
            case CONSTANT_Module: {
                return new CPModule(this, in);
            }
            case CONSTANT_Package: {
                return new CPPackage(this, in);
            }
        }
        throw new IllegalArgumentException("Unknown ConstantPool constant: " + (Object)((Object)c));
    }

    public static abstract class CPInfo {
        private final ConstantPool owner;
        private final ConstantKind tag;

        CPInfo(ConstantPool owner, ConstantKind tag) {
            this.owner = owner;
            this.tag = tag;
        }

        public ConstantKind getTag() {
            return this.tag;
        }

        public Object getValue() {
            return null;
        }

        ConstantPool getOwner() {
            return this.owner;
        }

        void write(Writer out) throws IOException {
            out.writeUnsignedByte(this.getTag().getTag());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CPInfo)) {
                return false;
            }
            return this.tag == ((CPInfo)obj).tag;
        }

        public int hashCode() {
            return this.tag.getTag();
        }

        public String toString() {
            return this.tag.toString();
        }
    }

    public static enum ConstantKind {
        CONSTANT_Class(7),
        CONSTANT_Fieldref(9),
        CONSTANT_Methodref(10),
        CONSTANT_InterfaceMethodref(11),
        CONSTANT_String(8),
        CONSTANT_Integer(3),
        CONSTANT_Float(4),
        CONSTANT_Long(5),
        CONSTANT_Double(6),
        CONSTANT_NameAndType(12),
        CONSTANT_Utf8(1),
        CONSTANT_MethodHandle(15),
        CONSTANT_MethodType(16),
        CONSTANT_ConstantDynamic(17),
        CONSTANT_InvokeDynamic(18),
        CONSTANT_Module(19),
        CONSTANT_Package(20);

        private static final Map<Integer, ConstantKind> byTag;
        private final int tag;

        private ConstantKind(int tag) {
            this.tag = tag;
        }

        public int getTag() {
            return this.tag;
        }

        public static ConstantKind fromTag(int tag) {
            ConstantKind k = byTag.get(tag);
            if (k != null) {
                return k;
            }
            throw new IllegalArgumentException("Unknown ConstantPool constant:" + tag);
        }

        static {
            HashMap<Integer, ConstantKind> m = new HashMap<Integer, ConstantKind>();
            for (ConstantKind c : ConstantKind.values()) {
                m.put(c.getTag(), c);
            }
            byTag = Collections.unmodifiableMap(m);
        }
    }

    public static final class CPClass
    extends CPUTF8Ref {
        public CPClass(ConstantPool owner, int nameIndex) {
            super(owner, ConstantKind.CONSTANT_Class, nameIndex);
        }

        CPClass(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_Class, in.readUnsignedShort());
        }
    }

    public static class CPFieldref
    extends CPInfo {
        private final int classIndex;
        private final int nameAndTypeIndex;

        CPFieldref(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_Fieldref);
            this.classIndex = in.readUnsignedShort();
            this.nameAndTypeIndex = in.readUnsignedShort();
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeUnsignedShort(this.classIndex);
            out.writeUnsignedShort(this.nameAndTypeIndex);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPFieldref)) {
                return false;
            }
            CPFieldref fld = (CPFieldref)obj;
            return this.classIndex == fld.classIndex && this.nameAndTypeIndex == fld.nameAndTypeIndex;
        }

        @Override
        public String toString() {
            return String.format("%s class: %d, nameAndType: %d", super.toString(), this.classIndex, this.nameAndTypeIndex);
        }
    }

    public static class CPMethodref
    extends CPInfo {
        private final int classIndex;
        private final int nameAndTypeIndex;

        CPMethodref(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_Methodref);
            this.classIndex = in.readUnsignedShort();
            this.nameAndTypeIndex = in.readUnsignedShort();
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeUnsignedShort(this.classIndex);
            out.writeUnsignedShort(this.nameAndTypeIndex);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPMethodref)) {
                return false;
            }
            CPMethodref m = (CPMethodref)obj;
            return this.classIndex == m.classIndex && this.nameAndTypeIndex == m.nameAndTypeIndex;
        }

        @Override
        public String toString() {
            return String.format("%s class: %d, nameAndType: %d", super.toString(), this.classIndex, this.nameAndTypeIndex);
        }
    }

    public static class CPInterfaceMethodref
    extends CPInfo {
        private final int classIndex;
        private final int nameAndTypeIndex;

        CPInterfaceMethodref(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_InterfaceMethodref);
            this.classIndex = in.readUnsignedShort();
            this.nameAndTypeIndex = in.readUnsignedShort();
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeUnsignedShort(this.classIndex);
            out.writeUnsignedShort(this.nameAndTypeIndex);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPInterfaceMethodref)) {
                return false;
            }
            CPInterfaceMethodref m = (CPInterfaceMethodref)obj;
            return this.classIndex == m.classIndex && this.nameAndTypeIndex == m.nameAndTypeIndex;
        }

        @Override
        public String toString() {
            return String.format("%s class: %d, nameAndType: %d", super.toString(), this.classIndex, this.nameAndTypeIndex);
        }
    }

    public static class CPString
    extends CPUTF8Ref {
        CPString(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_String, in.readUnsignedShort());
        }
    }

    public static class CPInteger
    extends CPInfo {
        private final int value;

        CPInteger(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_Integer);
            this.value = in.readInt();
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeInt(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPInteger)) {
                return false;
            }
            return this.value == ((CPInteger)obj).value;
        }

        @Override
        public String toString() {
            return String.format("%s 0x%x", super.toString(), this.value);
        }
    }

    public static class CPFloat
    extends CPInfo {
        private final int value;

        CPFloat(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_Float);
            this.value = in.readInt();
        }

        @Override
        public Object getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value));
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeInt(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPFloat)) {
                return false;
            }
            return this.value == ((CPFloat)obj).value;
        }

        @Override
        public String toString() {
            return String.format("%s %f", super.toString(), (Float)this.getValue());
        }
    }

    public static class CPLong
    extends CPInfo {
        private final int highBytes;
        private final int lowBytes;

        CPLong(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_Long);
            this.highBytes = in.readInt();
            this.lowBytes = in.readInt();
        }

        @Override
        public Object getValue() {
            return (long)this.highBytes << 32 | (long)this.lowBytes & 0xFFFFFFFFL;
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeInt(this.highBytes);
            out.writeInt(this.lowBytes);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPLong)) {
                return false;
            }
            CPLong l = (CPLong)obj;
            return this.highBytes == l.highBytes && this.lowBytes == l.lowBytes;
        }

        @Override
        public String toString() {
            return String.format("%s 0x%x", super.toString(), (Long)this.getValue());
        }
    }

    public static class CPDouble
    extends CPInfo {
        private final int highBytes;
        private final int lowBytes;

        CPDouble(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_Double);
            this.highBytes = in.readInt();
            this.lowBytes = in.readInt();
        }

        @Override
        public Object getValue() {
            return Double.longBitsToDouble((long)this.highBytes << 32 | (long)this.lowBytes & 0xFFFFFFFFL);
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeInt(this.highBytes);
            out.writeInt(this.lowBytes);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPDouble)) {
                return false;
            }
            CPDouble d = (CPDouble)obj;
            return this.highBytes == d.highBytes && this.lowBytes == d.lowBytes;
        }

        @Override
        public String toString() {
            return String.format("%s %f", super.toString(), (Double)this.getValue());
        }
    }

    public static class CPNameAndType
    extends CPInfo {
        private final int nameIndex;
        private final int descriptorIndex;

        CPNameAndType(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_NameAndType);
            this.nameIndex = in.readUnsignedShort();
            this.descriptorIndex = in.readUnsignedShort();
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeUnsignedShort(this.nameIndex);
            out.writeUnsignedShort(this.descriptorIndex);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPNameAndType)) {
                return false;
            }
            CPNameAndType l = (CPNameAndType)obj;
            return this.nameIndex == l.nameIndex && this.descriptorIndex == l.descriptorIndex;
        }

        @Override
        public String toString() {
            return String.format("%s name: %d, type: %d", super.toString(), this.nameIndex, this.descriptorIndex);
        }
    }

    public static class CPUtf8
    extends CPInfo {
        private final byte[] bytes;

        public CPUtf8(ConstantPool owner, String str) throws IOException {
            super(owner, ConstantKind.CONSTANT_Utf8);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (DataOutputStream out = new DataOutputStream(bos);){
                out.writeUTF(str);
            }
            byte[] arr = bos.toByteArray();
            this.bytes = Arrays.copyOfRange(arr, 2, arr.length);
        }

        CPUtf8(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_Utf8);
            int length = in.readUnsignedShort();
            this.bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                this.bytes[i] = in.readByte();
            }
        }

        @Override
        public Object getValue() {
            return new String(this.bytes, Charset.forName("UTF-8"));
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeUnsignedShort(this.bytes.length);
            for (int i = 0; i < this.bytes.length; ++i) {
                out.writeByte(this.bytes[i]);
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPUtf8)) {
                return false;
            }
            CPUtf8 s = (CPUtf8)obj;
            return Arrays.equals(this.bytes, s.bytes);
        }

        @Override
        public String toString() {
            return String.format("%s %s", super.toString(), this.getValue());
        }
    }

    public static class CPMethodHandle
    extends CPInfo {
        private final int referenceKind;
        private final int referenceIndex;

        CPMethodHandle(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_MethodHandle);
            this.referenceKind = in.readUnsignedByte();
            this.referenceIndex = in.readUnsignedShort();
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeUnsignedByte(this.referenceKind);
            out.writeUnsignedShort(this.referenceIndex);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPMethodHandle)) {
                return false;
            }
            CPMethodHandle h = (CPMethodHandle)obj;
            return this.referenceKind == h.referenceKind && this.referenceIndex == h.referenceIndex;
        }

        @Override
        public String toString() {
            return String.format("%s kind: %x, reference: %d", super.toString(), this.referenceKind, this.referenceIndex);
        }
    }

    public static class CPMethodType
    extends CPInfo {
        private final int descriptorIndex;

        CPMethodType(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_MethodType);
            this.descriptorIndex = in.readUnsignedShort();
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeUnsignedShort(this.descriptorIndex);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPMethodType)) {
                return false;
            }
            return this.descriptorIndex == ((CPMethodType)obj).descriptorIndex;
        }

        @Override
        public String toString() {
            return String.format("%s %d", super.toString(), this.descriptorIndex);
        }
    }

    public static class CPConstantDynamic
    extends CPInfo {
        private final int bootstrapMethodAttrIndex;
        private final int nameAndTypeIndex;

        CPConstantDynamic(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_ConstantDynamic);
            this.bootstrapMethodAttrIndex = in.readUnsignedShort();
            this.nameAndTypeIndex = in.readUnsignedShort();
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeUnsignedShort(this.bootstrapMethodAttrIndex);
            out.writeUnsignedShort(this.nameAndTypeIndex);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPConstantDynamic)) {
                return false;
            }
            CPConstantDynamic i = (CPConstantDynamic)obj;
            return this.bootstrapMethodAttrIndex == i.bootstrapMethodAttrIndex && this.nameAndTypeIndex == i.nameAndTypeIndex;
        }

        @Override
        public String toString() {
            return String.format("%s bootstrapMethod: %d, nameAndType: %d", super.toString(), this.bootstrapMethodAttrIndex, this.nameAndTypeIndex);
        }
    }

    public static class CPInvokeDynamic
    extends CPInfo {
        private final int bootstrapMethodAttrIndex;
        private final int nameAndTypeIndex;

        CPInvokeDynamic(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_InvokeDynamic);
            this.bootstrapMethodAttrIndex = in.readUnsignedShort();
            this.nameAndTypeIndex = in.readUnsignedShort();
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeUnsignedShort(this.bootstrapMethodAttrIndex);
            out.writeUnsignedShort(this.nameAndTypeIndex);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPInvokeDynamic)) {
                return false;
            }
            CPInvokeDynamic i = (CPInvokeDynamic)obj;
            return this.bootstrapMethodAttrIndex == i.bootstrapMethodAttrIndex && this.nameAndTypeIndex == i.nameAndTypeIndex;
        }

        @Override
        public String toString() {
            return String.format("%s bootstrapMethod: %d, nameAndType: %d", super.toString(), this.bootstrapMethodAttrIndex, this.nameAndTypeIndex);
        }
    }

    public static class CPModule
    extends CPUTF8Ref {
        CPModule(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_Module, in.readUnsignedShort());
        }
    }

    public static class CPPackage
    extends CPUTF8Ref {
        CPPackage(ConstantPool owner, Reader in) throws IOException {
            super(owner, ConstantKind.CONSTANT_Package, in.readUnsignedShort());
        }
    }

    public static abstract class CPUTF8Ref
    extends CPInfo {
        private final int nameIndex;

        public CPUTF8Ref(ConstantPool owner, ConstantKind kind, int nameIndex) {
            super(owner, kind);
            this.nameIndex = nameIndex;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        @Override
        public Object getValue() {
            CPInfo info = this.getOwner().get(this.nameIndex);
            return info == null ? null : info.getValue();
        }

        @Override
        void write(Writer out) throws IOException {
            super.write(out);
            out.writeUnsignedShort(this.nameIndex);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj) || !(obj instanceof CPUTF8Ref)) {
                return false;
            }
            return this.nameIndex == ((CPUTF8Ref)obj).nameIndex;
        }

        @Override
        public String toString() {
            return String.format("%s %d", super.toString(), this.nameIndex);
        }
    }
}

