/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.lsp.client.options.MarkOccurencesOptionsPanelController;
import org.netbeans.modules.lsp.client.options.MarkOccurencesSettings;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MarkOccurencesPanel
extends JPanel {
    private static final boolean DEFAULT_VALUE = true;
    private List<JCheckBox> boxes;
    private MarkOccurencesOptionsPanelController controller;
    private boolean changed = false;
    private JCheckBox keepMarks;
    private JCheckBox onOffCheckBox;

    public MarkOccurencesPanel(MarkOccurencesOptionsPanelController controller) {
        this.initComponents();
        this.fillBoxes();
        this.addListeners();
        this.load(controller);
    }

    public void load(MarkOccurencesOptionsPanelController controller) {
        this.controller = controller;
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            box.setSelected(node.getBoolean(box.getActionCommand(), true));
        }
        this.componentsSetEnabled();
        this.changed = false;
    }

    public void store() {
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            boolean original;
            boolean value = box.isSelected();
            if (value == (original = node.getBoolean(box.getActionCommand(), true))) continue;
            node.putBoolean(box.getActionCommand(), value);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.changed = false;
    }

    public boolean changed() {
        return this.changed;
    }

    private void initComponents() {
        this.onOffCheckBox = new JCheckBox();
        this.keepMarks = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.onOffCheckBox, (String)NbBundle.getMessage(MarkOccurencesPanel.class, (String)"CTL_OnOff_CheckBox"));
        this.onOffCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.onOffCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.onOffCheckBox, gridBagConstraints);
        this.onOffCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"ACSD_OnOff_CB"));
        Mnemonics.setLocalizedText((AbstractButton)this.keepMarks, (String)NbBundle.getBundle(MarkOccurencesPanel.class).getString("CTL_KeepMarks_CheckBox"));
        this.keepMarks.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.keepMarks.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 8, 0);
        this.add((Component)this.keepMarks, gridBagConstraints);
        this.keepMarks.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"ACSD_Marks_CB"));
    }

    private void fillBoxes() {
        this.boxes = new ArrayList<JCheckBox>();
        this.boxes.add(this.onOffCheckBox);
        this.boxes.add(this.keepMarks);
        this.onOffCheckBox.setActionCommand("OnOff");
        this.keepMarks.setActionCommand("KeepMarks");
    }

    private void addListeners() {
        CheckChangeListener cl = new CheckChangeListener();
        for (JCheckBox box : this.boxes) {
            box.addChangeListener(cl);
        }
    }

    private void componentsSetEnabled() {
        for (int i = 1; i < this.boxes.size(); ++i) {
            this.boxes.get(i).setEnabled(this.onOffCheckBox.isSelected());
        }
    }

    private void fireChanged() {
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox box : this.boxes) {
            if (node.getBoolean(box.getActionCommand(), true) == box.isSelected()) continue;
            this.changed = true;
            return;
        }
        this.changed = false;
    }

    private class CheckChangeListener
    implements ChangeListener {
        private CheckChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource().equals(MarkOccurencesPanel.this.onOffCheckBox)) {
                MarkOccurencesPanel.this.componentsSetEnabled();
            }
            MarkOccurencesPanel.this.fireChanged();
        }
    }
}

