/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.html.knockout.KODataBindContext;
import org.openide.util.Pair;

public class KOTemplateContext {
    private final LinkedList<StackItem> scripts = new LinkedList();
    private boolean isScriptStart;
    private boolean isId;

    public Pair<Boolean, String> process(@NonNull Token<HTMLTokenId> token) {
        switch ((HTMLTokenId)token.id()) {
            case TAG_OPEN: {
                this.isScriptStart = false;
                if (!"script".equals(token.text().toString())) break;
                this.isScriptStart = true;
                this.scripts.push(new StackItem());
                break;
            }
            case TAG_CLOSE_SYMBOL: {
                if (this.isScriptStart && !this.scripts.isEmpty() && this.scripts.peek().getId() != null) {
                    return Pair.of((Object)true, (Object)this.scripts.peek().getId());
                }
                this.isScriptStart = false;
            }
            case TAG_CLOSE: {
                StackItem item;
                if (!"script".equals(token.text().toString()) || this.scripts.isEmpty() || (item = this.scripts.pop()).getId() == null) break;
                return Pair.of((Object)false, (Object)item.getId());
            }
            case ARGUMENT: {
                if (!this.isScriptStart) break;
                this.isId = false;
                if (!"id".equals(token.text().toString())) break;
                this.isId = true;
                break;
            }
            case VALUE: 
            case VALUE_CSS: {
                CharSequence text;
                if (!this.isScriptStart || !this.isId || (text = token.text()).length() <= 2 || this.scripts.isEmpty()) break;
                this.scripts.peek().setId(token.text().subSequence(1, text.length() - 1).toString());
                break;
            }
        }
        return null;
    }

    @CheckForNull
    public String getCurrentScriptId() {
        if (this.scripts.isEmpty()) {
            return null;
        }
        for (StackItem item : this.scripts) {
            if (item.getId() == null) continue;
            return item.getId();
        }
        return null;
    }

    public void clear() {
        this.scripts.clear();
        this.isScriptStart = false;
        this.isId = false;
    }

    private static class StackItem {
        private String id;

        private StackItem() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class TemplateUsage {
        private final KODataBindContext context;
        private final Set<String> parentTemplatesNames = new HashSet<String>();

        public TemplateUsage(KODataBindContext context) {
            this.context = context;
        }

        public KODataBindContext getContext() {
            return this.context;
        }

        public void addParentTemplateName(String name) {
            this.parentTemplatesNames.add(name);
        }

        public Set<String> getParentTemplatesNames() {
            return Collections.unmodifiableSet(this.parentTemplatesNames);
        }

        public String getParentTemplateName() {
            if (this.parentTemplatesNames.isEmpty()) {
                return null;
            }
            return this.parentTemplatesNames.iterator().next();
        }
    }
}

