/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.junit.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNodeAction;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.junit.ui.api.JUnitTestMethodNode;
import org.netbeans.modules.maven.junit.ui.Bundle;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class MavenJUnitTestMethodNode
extends JUnitTestMethodNode {
    public MavenJUnitTestMethodNode(Testcase testcase, Project project, Lookup lookup, String projectType, String testingFramework) {
        super(testcase, project, lookup, projectType, testingFramework);
    }

    public MavenJUnitTestMethodNode(Testcase testcase, Project project, String projectType, String testingFramework) {
        super(testcase, project, projectType, testingFramework);
    }

    public Action[] getActions(boolean context) {
        ArrayList<Object> actions = new ArrayList<Object>();
        FileObject testFO = this.getTestcaseFileObject();
        if (testFO != null) {
            ActionProvider actionProvider;
            boolean unitTest = this.getTestcase().getType() == null || "UNIT".equals(this.getTestcase().getType());
            boolean integrationTest = "INTEGRATION".equals(this.getTestcase().getType());
            Project suiteProject = FileOwnerQuery.getOwner((FileObject)testFO);
            if (suiteProject != null && (actionProvider = (ActionProvider)suiteProject.getLookup().lookup(ActionProvider.class)) != null) {
                String mName = this.testcase.getName();
                String tcName = this.testcase.getClassName();
                if (tcName != null && mName.startsWith(tcName) && mName.charAt(tcName.length()) == '.') {
                    mName = mName.substring(tcName.length() + 1);
                }
                SingleMethod methodSpec = new SingleMethod(testFO, mName);
                Lookup nodeContext = Lookups.singleton((Object)methodSpec);
                for (String action : actionProvider.getSupportedActions()) {
                    if (unitTest && action.equals("run.single.method") && actionProvider.isActionEnabled(action, nodeContext)) {
                        actions.add(new TestMethodNodeAction(actionProvider, nodeContext, "run.single.method", Bundle.LBL_RerunTest()));
                    }
                    if (unitTest && action.equals("debug.single.method") && actionProvider.isActionEnabled(action, nodeContext)) {
                        actions.add(new TestMethodNodeAction(actionProvider, nodeContext, "debug.single.method", Bundle.LBL_DebugTest()));
                    }
                    if (integrationTest && action.equals("integration-test.single") && actionProvider.isActionEnabled(action, nodeContext)) {
                        actions.add(new TestMethodNodeAction(actionProvider, nodeContext, "integration-test.single", Bundle.LBL_RerunTest()));
                    }
                    if (!integrationTest || !action.equals("debug.integration-test.single") || !actionProvider.isActionEnabled(action, nodeContext)) continue;
                    actions.add(new TestMethodNodeAction(actionProvider, nodeContext, "debug.integration-test.single", Bundle.LBL_DebugTest()));
                }
            }
        }
        actions.sort((a, b) -> {
            String aName = (String)a.getValue("Name");
            String bName = (String)b.getValue("Name");
            if (aName == null) {
                aName = "";
            }
            if (bName == null) {
                bName = "";
            }
            return aName.compareTo(bName);
        });
        Action preferred = this.getPreferredAction();
        if (preferred != null) {
            actions.add(0, preferred);
        }
        actions.addAll(Arrays.asList(super.getActions(context)));
        return actions.toArray(new Action[0]);
    }

    public FileObject getTestcaseFileObject() {
        LineConvertors.FileLocator fileLocator = (LineConvertors.FileLocator)this.getProject().getLookup().lookup(LineConvertors.FileLocator.class);
        if (fileLocator == null) {
            Logger.getLogger(MavenJUnitTestMethodNode.class.getName()).log(Level.WARNING, "no LineConvertors.FileLocator available for project {0}", this.getProject().getProjectDirectory());
        }
        if (this.testcase == null) {
            Logger.getLogger(MavenJUnitTestMethodNode.class.getName()).log(Level.WARNING, "null tescase in MavenJUnitTestMethodNode for project {0}", this.getProject().getProjectDirectory());
        }
        String location = this.testcase != null ? this.testcase.getLocation() : null;
        return fileLocator != null && location != null ? fileLocator.find(location) : null;
    }
}

