/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerCompile;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerGeneral;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerJarContent;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.j2ee.earproject.ui.customizer.CustomizerRun;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EarCompositePanelProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String SOURCES = "Sources";
    static final String LIBRARIES = "Libraries";
    private static final String EAR = "Ear";
    public static final String RUN = "Run";
    public static final String COMPILE = "Compile";
    private String name;

    public EarCompositePanelProvider(String name) {
        this.name = name;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        ResourceBundle bundle = NbBundle.getBundle(CustomizerProviderImpl.class);
        ProjectCustomizer.Category toReturn = null;
        if (SOURCES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)SOURCES, (String)bundle.getString("LBL_Config_Sources"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (LIBRARIES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)LIBRARIES, (String)bundle.getString("LBL_Config_Libraries"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (EAR.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)EAR, (String)bundle.getString("LBL_Config_Ear"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (RUN.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)RUN, (String)bundle.getString("LBL_Config_Run"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (COMPILE.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)COMPILE, (String)bundle.getString("LBL_Config_Compile"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        }
        assert (toReturn != null) : "No category for name:" + this.name;
        return toReturn;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        String nm = category.getName();
        EarProjectProperties uiProps = (EarProjectProperties)context.lookup(EarProjectProperties.class);
        if (SOURCES.equals(nm)) {
            return new CustomizerGeneral(uiProps);
        }
        if (LIBRARIES.equals(nm)) {
            return new CustomizerLibraries(uiProps);
        }
        if (EAR.equals(nm)) {
            return new CustomizerJarContent(uiProps);
        }
        if (RUN.equals(nm)) {
            return new CustomizerRun(uiProps);
        }
        if (COMPILE.equals(nm)) {
            return new CustomizerCompile(uiProps);
        }
        return new JPanel();
    }

    public static EarCompositePanelProvider createSources() {
        return new EarCompositePanelProvider(SOURCES);
    }

    public static EarCompositePanelProvider createLibraries() {
        return new EarCompositePanelProvider(LIBRARIES);
    }

    public static EarCompositePanelProvider createEar() {
        return new EarCompositePanelProvider(EAR);
    }

    public static EarCompositePanelProvider createRun() {
        return new EarCompositePanelProvider(RUN);
    }

    public static EarCompositePanelProvider createCompile() {
        return new EarCompositePanelProvider(COMPILE);
    }
}

