/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.ProfilingEventListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.FlatProfileBuilder;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.TimeCollector;
import org.netbeans.lib.profiler.results.locks.LockProfilingResultListener;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.SwingWorker;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.WireIO;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ProfilingMonitor;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.ServerStateMonitor;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.ProgressDisplayer;
import org.netbeans.modules.profiler.spi.SessionListener;
import org.netbeans.modules.profiler.ui.ProfilerProgressDisplayer;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public abstract class NetBeansProfiler
extends Profiler {
    private static final Logger LOGGER = Logger.getLogger(NetBeansProfiler.class.getName());
    private static boolean initialized = false;
    boolean shouldDisplayDialog = true;
    private final ProfilerIDESettings ideSettings = ProfilerIDESettings.getInstance();
    private ProfilingMonitor monitor = null;
    private TargetAppRunner targetAppRunner;
    private FileObject profiledSingleFile;
    private final ProfilerEngineSettings sharedSettings;
    private final Object setupLock = new Object();
    private ProfilingSettings lastProfilingSettings;
    private Lookup.Provider profiledProject = null;
    private SessionSettings lastSessionSettings;
    private StringBuilder logMsgs = new StringBuilder();
    private ThreadsDataManager threadsManager;
    private VMTelemetryDataManager vmTelemetryManager;
    private VMTelemetryModels vmTelemetryModels;
    private boolean calibrating = false;
    private boolean threadsMonitoringEnabled = false;
    private boolean lockContentionMonitoringEnabled = false;
    private boolean waitDialogOpen = false;
    private int lastMode = 1;
    private int profilingMode = 1;
    private int profilingState = 1;

    public NetBeansProfiler() {
        boolean initFailed = false;
        this.sharedSettings = new ProfilerEngineSettings();
        try {
            String libsDir = this.getLibsDir();
            if (libsDir == null) {
                throw new IOException(Bundle.NetBeansProfiler_CannotFindLibsMsg());
            }
            this.sharedSettings.initialize(libsDir);
            this.sharedSettings.setSeparateConsole(System.getProperty("org.netbeans.profiler.separateConsole") != null);
            this.sharedSettings.setTargetWindowRemains(System.getProperty("org.netbeans.profiler.targetWindowRemains") != null);
        }
        catch (RuntimeException e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.displayError((String)e.getMessage());
            initFailed = true;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, Bundle.NetBeansProfiler_EngineInitFailedMsg(e.getLocalizedMessage()));
            initFailed = true;
        }
        if (!initFailed) {
            initialized = true;
            new ServerStateMonitor(this);
        }
    }

    public static NetBeansProfiler getDefaultNB() {
        return (NetBeansProfiler)NetBeansProfiler.getDefault();
    }

    public static boolean isInitialized() {
        NetBeansProfiler.getDefaultNB();
        return initialized;
    }

    public int getAgentState(String host, int port, int agentId) {
        if (this.profilingState == 4 && port == this.getTargetAppRunner().getProfilerEngineSettings().getPortNo()) {
            if (this.getTargetAppRunner().getProfilerClient().getCurrentAgentId() == agentId) {
                return 3;
            }
            return 4;
        }
        Properties agentProps = this.getAgentProperties(port);
        if (agentProps == null) {
            return 0;
        }
        try {
            int id = Integer.parseInt(agentProps.getProperty("agent.id"));
            if (id == agentId) {
                String dynamic = agentProps.getProperty("dynamic");
                if (dynamic == null || "false".equals(dynamic)) {
                    return 2;
                }
                return 1;
            }
            return 4;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public SessionSettings getCurrentSessionSettings() {
        return this.lastSessionSettings;
    }

    public GlobalProfilingSettings getGlobalProfilingSettings() {
        return this.ideSettings;
    }

    public ProfilingSettings getLastProfilingSettings() {
        return this.lastProfilingSettings;
    }

    public abstract String getLibsDir();

    public int getPlatformArchitecture(String platformName) {
        JavaPlatform platform = JavaPlatform.getJavaPlatformById((String)platformName);
        return platform.getPlatformArchitecture();
    }

    public String getPlatformJDKVersion(String platformName) {
        JavaPlatform platform = JavaPlatform.getJavaPlatformById((String)platformName);
        return platform.getPlatformJDKVersion();
    }

    public String getPlatformJavaFile(String platformName) {
        JavaPlatform platform = JavaPlatform.getJavaPlatformById((String)platformName);
        return platform.getPlatformJavaFile();
    }

    public int getProfilingMode() {
        return this.profilingMode;
    }

    public int getProfilingState() {
        return this.profilingState;
    }

    public int getServerState() {
        if (this.monitor != null) {
            return this.monitor.getServerState();
        }
        return 0;
    }

    public int getServerProgress() {
        if (this.monitor != null) {
            return this.monitor.getServerProgress();
        }
        return -1;
    }

    public synchronized TargetAppRunner getTargetAppRunner() {
        if (initialized) {
            if (this.targetAppRunner == null) {
                this.targetAppRunner = new TargetAppRunner(this.sharedSettings, (AppStatusHandler)new IDEAppStatusHandler(), this.getProfilingPointsManager());
                this.targetAppRunner.addProfilingEventListener(new ProfilingEventListener(){

                    public void targetAppStarted() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.changeStateTo(4);
                    }

                    public void targetAppStopped() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.changeStateTo(16);
                    }

                    public void targetAppSuspended() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.changeStateTo(8);
                    }

                    public void targetAppResumed() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.changeStateTo(4);
                    }

                    public void attachedToTarget() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.changeStateTo(4);
                    }

                    public void detachedFromTarget() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.getMonitor().stopDisplayingVM();
                        NetBeansProfiler.this.changeStateTo(1);
                    }

                    public void targetVMTerminated() {
                        if (NetBeansProfiler.this.calibrating) {
                            return;
                        }
                        NetBeansProfiler.this.getMonitor().stopDisplayingVM();
                        NetBeansProfiler.this.changeStateTo(1);
                    }
                });
            }
            return this.targetAppRunner;
        }
        return null;
    }

    public synchronized ThreadsDataManager getThreadsManager() {
        if (this.threadsManager == null) {
            this.threadsManager = new ThreadsDataManager();
        }
        return this.threadsManager;
    }

    public void setThreadsMonitoringEnabled(boolean enabled) {
        this.getThreadsManager().setThreadsMonitoringEnabled(enabled);
        if (this.threadsMonitoringEnabled == enabled) {
            return;
        }
        this.threadsMonitoringEnabled = enabled;
        this.fireThreadsMonitoringChange();
    }

    public boolean getThreadsMonitoringEnabled() {
        return this.threadsMonitoringEnabled;
    }

    public void setLockContentionMonitoringEnabled(boolean enabled) {
        TargetAppRunner runner;
        ProfilerEngineSettings settings;
        if (this.lockContentionMonitoringEnabled == enabled) {
            return;
        }
        if (this.getProfilingState() == 4 && (settings = (runner = this.getTargetAppRunner()).getProfilerEngineSettings()).isLockContentionMonitoringEnabled() != enabled && runner.targetJVMIsAlive()) {
            settings.setLockContentionMonitoringEnabled(enabled);
            try {
                runner.getProfilerClient().sendSetInstrumentationParamsCmd(true);
            }
            catch (ClientUtils.TargetAppOrVMTerminated ex) {
                settings.setLockContentionMonitoringEnabled(!enabled);
                ProfilerDialogs.displayError((String)ex.getMessage());
                return;
            }
        }
        this.lockContentionMonitoringEnabled = enabled;
        this.fireLockContentionMonitoringChange();
    }

    public boolean getLockContentionMonitoringEnabled() {
        return this.lockContentionMonitoringEnabled;
    }

    public synchronized VMTelemetryModels getVMTelemetryModels() {
        if (this.vmTelemetryModels == null) {
            this.vmTelemetryModels = new VMTelemetryModels(this.getVMTelemetryManager());
        }
        return this.vmTelemetryModels;
    }

    public synchronized VMTelemetryDataManager getVMTelemetryManager() {
        if (this.vmTelemetryManager == null) {
            this.vmTelemetryManager = new VMTelemetryDataManager();
        }
        return this.vmTelemetryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attachToApp(ProfilingSettings profilingSettings, AttachSettings attachSettings) {
        this.profilingMode = 0;
        ProgressHandle ph = ProgressHandle.createHandle((String)Bundle.NetBeansProfiler_StartingSession());
        ph.setInitialDelay(500);
        ph.start();
        try {
            if (this.getProfilingState() != 1) {
                if (this.lastMode == 0) {
                    this.detachFromApp();
                } else if (this.getTargetAppRunner().targetJVMIsAlive()) {
                    this.getTargetAppRunner().terminateTargetJVM();
                }
            }
            this.lastProfilingSettings = profilingSettings;
            this.lastSessionSettings = null;
            this.lastMode = 0;
            ProfilerEngineSettings sSettings = this.getTargetAppRunner().getProfilerEngineSettings();
            profilingSettings.applySettings(sSettings);
            attachSettings.applySettings(sSettings);
            NetBeansProfiler.logActionConfig("attachToApp", profilingSettings, null, attachSettings, (GenericFilter)sSettings.getInstrumentationFilter());
            this.changeStateTo(2);
            this.cleanupBeforeProfiling(sSettings);
            this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
            this.setLockContentionMonitoringEnabled(profilingSettings.getLockContentionMonitoringEnabled());
            if (this.shouldOpenWindowsOnProfilingStart()) {
                CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NetBeansProfiler.this.openWindowsOnProfilingStart();
                    }
                });
            }
            if (attachSettings.isDirect()) {
                boolean success = false;
                if (this.prepareInstrumentation(profilingSettings)) {
                    boolean bl = success = this.getTargetAppRunner().initiateSession(1, false) && this.getTargetAppRunner().attachToTargetVMOnStartup();
                }
                if (!success) {
                    this.changeStateTo(1);
                    boolean bl = false;
                    return bl;
                }
            } else if (attachSettings.isDynamic16()) {
                String jar = this.getLibsDir() + "/jfluid-server-15.jar";
                String pid = String.valueOf(attachSettings.getPid());
                String options = String.valueOf(attachSettings.getPort());
                boolean success = false;
                try {
                    NetBeansProfiler.loadAgentIntoTargetJVM(jar, options, pid);
                    if (this.prepareInstrumentation(profilingSettings)) {
                        success = this.getTargetAppRunner().initiateSession(2, false) && this.getTargetAppRunner().attachToTargetVM();
                    }
                }
                catch (AgentInitializationException ex) {
                    ProfilerDialogs.displayError((String)(ex.getMessage() + "\n" + Bundle.NetBeansProfiler_AgentFailed()));
                    ProfilerLogger.log((Exception)ex);
                }
                catch (Exception ex) {
                    ProfilerDialogs.displayError((String)ex.getMessage());
                    ProfilerLogger.log((Exception)ex);
                }
                if (!success) {
                    this.changeStateTo(1);
                    boolean bl = false;
                    return bl;
                }
            } else {
                throw new IllegalArgumentException("Invalid settings " + attachSettings);
            }
            boolean bl = this.connectToApp();
            return bl;
        }
        finally {
            ph.finish();
        }
    }

    private static void loadAgentIntoTargetJVM(String jar, String options, String pid) throws AttachNotSupportedException, IOException, AgentLoadException, AgentInitializationException {
        VirtualMachine virtualMachine = VirtualMachine.attach(pid);
        virtualMachine.loadAgent(jar, options);
    }

    public void checkAndUpdateState() {
        boolean targetVMAlive = this.getTargetAppRunner().targetJVMIsAlive();
        if (!targetVMAlive) {
            this.changeStateTo(1);
            return;
        }
        boolean running = this.getTargetAppRunner().targetAppIsRunning();
        if (!running) {
            this.changeStateTo(16);
            return;
        }
        boolean suspended = this.getTargetAppRunner().targetAppSuspended();
        if (suspended) {
            this.changeStateTo(8);
        }
    }

    public boolean cleanForProfilingOnPort(int port) {
        if (this.isProfilingRunningOnPort(port)) {
            ProfilerLogger.severe((String)(">>> Profiling session already running on port " + port + ", will cause collision when starting another agent on the same port."));
            return false;
        }
        if (!this.shutdownAgent("localhost", port)) {
            ProfilerLogger.severe((String)(">>> Profiler agent already profiling on port " + port + " (communicating with another IDE?), will cause collision when starting another agent on the same port."));
            return false;
        }
        File agentFile = NetBeansProfiler.getInfoFile(port);
        if (agentFile.exists()) {
            boolean fileDeleted = this.waitForDeleteAgentFile(agentFile);
            if (!fileDeleted) {
                ProfilerLogger.severe((String)(">>> Profiler agent identification file cannot be deleted for port " + port + ", will cause failure starting a server for profiling on the same port."));
            }
            return fileDeleted;
        }
        return true;
    }

    public boolean connectToStartedApp(ProfilingSettings profilingSettings, SessionSettings sessionSettings) {
        return this.connectToStartedApp(profilingSettings, sessionSettings, new AtomicBoolean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectToStartedApp(ProfilingSettings profilingSettings, final SessionSettings sessionSettings, final AtomicBoolean cancel) {
        this.profilingMode = 1;
        this.lastProfilingSettings = profilingSettings;
        this.lastSessionSettings = sessionSettings;
        this.lastMode = 1;
        ProgressHandle ph = ProgressHandle.createHandle((String)Bundle.NetBeansProfiler_StartingSession());
        try {
            ph.setInitialDelay(500);
            ph.start();
            if (this.getTargetAppRunner().targetJVMIsAlive()) {
                this.getTargetAppRunner().terminateTargetJVM();
            }
            ProfilerEngineSettings sSettings = this.getTargetAppRunner().getProfilerEngineSettings();
            sessionSettings.applySettings(sSettings);
            profilingSettings.applySettings(sSettings);
            sSettings.setInstrumentObjectInit(false);
            NetBeansProfiler.logActionConfig("connectToStartedApp", profilingSettings, sessionSettings, null, (GenericFilter)sSettings.getInstrumentationFilter());
            if (this.prepareProfilingSession(profilingSettings, sessionSettings)) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        if (NetBeansProfiler.this.tryInitiateSession(sessionSettings, cancel)) {
                            NetBeansProfiler.this.connectToApp();
                        }
                    }
                });
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ph.finish();
        }
    }

    private boolean prepareProfilingSession(ProfilingSettings profilingSettings, SessionSettings sessionSettings) {
        this.changeStateTo(2);
        this.cleanupBeforeProfiling(this.getTargetAppRunner().getProfilerEngineSettings());
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        this.setLockContentionMonitoringEnabled(profilingSettings.getLockContentionMonitoringEnabled());
        if (this.shouldOpenWindowsOnProfilingStart()) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NetBeansProfiler.this.openWindowsOnProfilingStart();
                }
            });
        }
        if (sessionSettings.getRemoteHost().isEmpty() && !CalibrationDataFileIO.validateCalibrationInput((String)sessionSettings.getJavaVersionString(), (String)sessionSettings.getJavaExecutable())) {
            ProfilerDialogs.displayError((String)Bundle.NetBeansProfiler_MustCalibrateFirstShortMsg(), null, (String)Bundle.NetBeansProfiler_MustCalibrateFirstMsg());
            this.changeStateTo(1);
            return false;
        }
        return this.prepareInstrumentation(profilingSettings);
    }

    private boolean tryInitiateSession(SessionSettings sessionSettings, AtomicBoolean cancel) {
        if (!this.targetAppRunner.initiateSession(sessionSettings.getRemoteHost().isEmpty() ? 0 : 1, false, cancel) || !this.targetAppRunner.connectToStartedVMAndStartTA()) {
            this.changeStateTo(1);
            return false;
        }
        return true;
    }

    private boolean connectToApp() {
        if (this.getTargetAppRunner().targetAppIsRunning()) {
            this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)this.getTargetAppRunner().getProfilerEngineSettings().getTargetJDKVersionString()));
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NetBeansProfiler.this.getMonitor().monitorVM(NetBeansProfiler.this.getTargetAppRunner());
                }
            });
            return true;
        }
        this.changeStateTo(1);
        return false;
    }

    public void detachFromApp() {
        TargetAppRunner runner = this.getTargetAppRunner();
        if (runner == null || !runner.targetJVMIsAlive()) {
            return;
        }
        this.changeStateTo(128);
        runner.prepareDetachFromTargetJVM();
        if (runner.getProfilingSessionStatus().currentInstrType != 0) {
            try {
                runner.getProfilerClient().removeAllInstrumentation(false);
            }
            catch (InstrumentationException e) {
                ProfilerDialogs.displayError((String)e.getMessage());
            }
        }
        runner.detachFromTargetJVM();
    }

    public void instrumentSelectedRoots(ClientUtils.SourceCodeSelection[] rootMethods) throws ClassNotFoundException, InstrumentationException, BadLocationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        ProfilerClient client = this.getTargetAppRunner().getProfilerClient();
        if (rootMethods.length == 0) {
            ClientUtils.SourceCodeSelection selection = new ClientUtils.SourceCodeSelection(1);
            rootMethods = new ClientUtils.SourceCodeSelection[]{selection};
        }
        client.initiateRecursiveCPUProfInstrumentation(rootMethods);
    }

    public void log(int severity, String message) {
        switch (severity) {
            case 1: {
                LOGGER.log(Level.INFO, message);
                break;
            }
            case 2: {
                LOGGER.log(Level.WARNING, message);
                break;
            }
            case 8: 
            case 16: {
                LOGGER.log(Level.SEVERE, message);
                break;
            }
            default: {
                LOGGER.log(Level.FINEST, message);
            }
        }
    }

    public void modifyCurrentProfiling(final ProfilingSettings profilingSettings) {
        this.lastProfilingSettings = profilingSettings;
        if (!this.targetAppRunner.targetJVMIsAlive()) {
            return;
        }
        ProfilerEngineSettings sharedSettings = this.getTargetAppRunner().getProfilerEngineSettings();
        profilingSettings.applySettings(sharedSettings);
        sharedSettings.setInstrumentObjectInit(true);
        NetBeansProfiler.logActionConfig("modifyCurrentProfiling", profilingSettings, null, null, (GenericFilter)sharedSettings.getInstrumentationFilter());
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        this.setLockContentionMonitoringEnabled(profilingSettings.getLockContentionMonitoringEnabled());
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                NetBeansProfiler.this.changeStateTo(128);
                NetBeansProfiler.this.getTargetAppRunner().getAppStatusHandler().pauseLiveUpdates();
                ResultsManager.getDefault().reset();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AppStatusHandler.AsyncDialog waitDialog = NetBeansProfiler.this.getTargetAppRunner().getAppStatusHandler().getAsyncDialogInstance(Bundle.NetBeansProfiler_ModifyingInstrumentationMsg(), true, null);
                waitDialog.display();
                try {
                    NetBeansProfiler.this.prepareInstrumentation(profilingSettings);
                    NetBeansProfiler.this.changeStateTo(4);
                }
                finally {
                    waitDialog.close();
                    NetBeansProfiler.this.getTargetAppRunner().getAppStatusHandler().resumeLiveUpdates();
                }
            }
        });
    }

    public void notifyException(int severity, Exception e) {
        switch (severity) {
            case 1: {
                LOGGER.log(Level.INFO, null, e);
                break;
            }
            case 2: {
                LOGGER.log(Level.WARNING, null, e);
                break;
            }
            default: {
                LOGGER.log(Level.SEVERE, null, e);
            }
        }
    }

    public void openJavaSource(String className, String methodName, String methodSig) {
    }

    public boolean processesProfilingPoints() {
        ProfilingPointsProcessor ppp = this.getProfilingPointsManager();
        if (ppp != null) {
            return ppp.getSupportedProfilingPoints().length > 0;
        }
        return false;
    }

    public boolean profileClass(final ProfilingSettings profilingSettings, final SessionSettings sessionSettings) {
        this.profilingMode = 1;
        this.lastProfilingSettings = profilingSettings;
        this.lastSessionSettings = sessionSettings;
        this.lastMode = 1;
        if (this.getTargetAppRunner().targetJVMIsAlive()) {
            this.getTargetAppRunner().terminateTargetJVM();
        }
        final ProfilerEngineSettings sSettings = this.getTargetAppRunner().getProfilerEngineSettings();
        sessionSettings.applySettings(sSettings);
        profilingSettings.applySettings(sSettings);
        sSettings.setRemoteHost("");
        sSettings.setInstrumentObjectInit(false);
        NetBeansProfiler.logActionConfig("profileClass", profilingSettings, sessionSettings, null, (GenericFilter)sSettings.getInstrumentationFilter());
        this.changeStateTo(2);
        this.cleanupBeforeProfiling(sSettings);
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        this.setLockContentionMonitoringEnabled(profilingSettings.getLockContentionMonitoringEnabled());
        if (this.shouldOpenWindowsOnProfilingStart()) {
            this.openWindowsOnProfilingStart();
        }
        final Frame mainWindow = WindowManager.getDefault().getMainWindow();
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                Cursor cursor = mainWindow.getCursor();
                mainWindow.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    if (!NetBeansProfiler.this.runCalibration(true, sessionSettings.getJavaExecutable(), sessionSettings.getJavaVersionString(), sessionSettings.getSystemArchitecture())) {
                        ProfilerDialogs.displayError((String)Bundle.ProfilerModule_CalibrationFailedMessage());
                        NetBeansProfiler.this.changeStateTo(1);
                        return;
                    }
                    boolean success = NetBeansProfiler.this.prepareInstrumentation(profilingSettings);
                    boolean bl = success = success && NetBeansProfiler.this.getTargetAppRunner().startTargetVM() && NetBeansProfiler.this.getTargetAppRunner().initiateSession(0, false) && NetBeansProfiler.this.getTargetAppRunner().connectToStartedVMAndStartTA();
                    if (!success) {
                        NetBeansProfiler.this.changeStateTo(1);
                        return;
                    }
                    if (NetBeansProfiler.this.getTargetAppRunner().targetAppIsRunning()) {
                        NetBeansProfiler.this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)sSettings.getTargetJDKVersionString()));
                        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                NetBeansProfiler.this.getMonitor().monitorVM(NetBeansProfiler.this.getTargetAppRunner());
                            }
                        });
                    } else {
                        NetBeansProfiler.this.changeStateTo(1);
                    }
                }
                finally {
                    mainWindow.setCursor(cursor);
                }
            }
        });
        return true;
    }

    protected boolean shouldOpenWindowsOnProfilingStart() {
        return true;
    }

    public boolean runConfiguredCalibration() {
        this.calibrating = true;
        boolean result = this.targetAppRunner.calibrateInstrumentationCode();
        this.calibrating = false;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runCalibration(boolean checkForSaved, String jvmExecutable, String jdkString, int architecture) {
        this.calibrating = true;
        ProfilerEngineSettings pes = this.getTargetAppRunner().getProfilerEngineSettings();
        int savedPort = pes.getPortNo();
        InstrumentationFilter savedInstrFilter = pes.getInstrumentationFilter();
        String savedJVMExeFile = pes.getTargetJVMExeFile();
        String savedJDKVersionString = pes.getTargetJDKVersionString();
        int savedArch = pes.getSystemArchitecture();
        String savedCP = pes.getMainClassPath();
        if (jvmExecutable != null) {
            pes.setTargetJVMExeFile(jvmExecutable);
            pes.setTargetJDKVersionString(jdkString);
            pes.setSystemArchitecture(architecture);
        }
        pes.setPortNo(this.ideSettings.getCalibrationPortNo());
        pes.setInstrumentationFilter(new GenericFilter());
        pes.setMainClassPath("");
        boolean result = false;
        if (checkForSaved) {
            result = this.getTargetAppRunner().readSavedCalibrationData();
            if (!result) {
                ProfilerDialogs.displayInfo((String)Bundle.NetBeansProfiler_InitialCalibrationMsg());
                result = this.getTargetAppRunner().calibrateInstrumentationCode();
            }
            if (!Boolean.getBoolean("profiler.disableFTSRecalibration")) {
                boolean shouldCalibrate = false;
                this.getTargetAppRunner().getProfilingSessionStatus().beginTrans(false);
                try {
                    shouldCalibrate = Platform.isLinux() && "jdk16".equals(pes.getTargetJDKVersionString()) && this.getTargetAppRunner().getProfilingSessionStatus().methodEntryExitCallTime[1] > 20000.0;
                }
                finally {
                    this.getTargetAppRunner().getProfilingSessionStatus().endTrans();
                }
                if (shouldCalibrate) {
                    result = this.getTargetAppRunner().calibrateInstrumentationCode();
                }
            }
        } else {
            result = this.getTargetAppRunner().calibrateInstrumentationCode();
        }
        this.calibrating = false;
        pes.setPortNo(savedPort);
        pes.setInstrumentationFilter((GenericFilter)savedInstrFilter);
        pes.setTargetJDKVersionString(savedJDKVersionString);
        pes.setSystemArchitecture(savedArch);
        pes.setTargetJVMExeFile(savedJVMExeFile);
        pes.setMainClassPath(savedCP);
        return result;
    }

    public void setProfiledProject(Lookup.Provider project, FileObject singleFile) {
        this.profiledProject = project;
        this.profiledSingleFile = singleFile;
    }

    public Lookup.Provider getProfiledProject() {
        return this.profiledProject;
    }

    public FileObject getProfiledSingleFile() {
        return this.profiledSingleFile;
    }

    public boolean prepareInstrumentation(ProfilingSettings profilingSettings) {
        this.teardownDispatcher();
        this.setupDispatcher(profilingSettings);
        profilingSettings.setInstrumentationMarkerMethods(new ClientUtils.SourceCodeSelection[0]);
        return this.prepareInstrumentationImpl(profilingSettings);
    }

    private synchronized ProfilingMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new ProfilingMonitor();
            this.monitor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("serverState") || evt.getPropertyName().equals("serverProgress")) {
                        NetBeansProfiler.this.fireServerStateChanged(((ProfilingMonitor)evt.getSource()).getServerState(), ((ProfilingMonitor)evt.getSource()).getServerProgress());
                    }
                }
            });
        }
        return this.monitor;
    }

    private boolean prepareInstrumentationImpl(ProfilingSettings profilingSettings) {
        try {
            return super.prepareInstrumentation(profilingSettings);
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            ProfilerDialogs.displayWarning((String)e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (InstrumentationException e) {
            ProfilerDialogs.displayError((String)e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (BadLocationException e) {
            ProfilerDialogs.displayError((String)e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (ClassNotFoundException e) {
            ProfilerDialogs.displayError((String)e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            ProfilerDialogs.displayError((String)e.getMessage());
        }
        catch (ClassFormatError e) {
            ProfilerDialogs.displayError((String)e.getMessage());
        }
        return false;
    }

    public void shutdown() {
        this.getMonitor().stopUpdateThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownBlockedAgent(String host, int port, int agentId) {
        int state = this.getAgentState(host, port, agentId);
        if (state == 2) {
            Socket clientSocket = null;
            ObjectOutputStream socketOut = null;
            ObjectInputStream socketIn = null;
            try {
                clientSocket = new Socket(host, port);
                clientSocket.setSoTimeout(100);
                clientSocket.setTcpNoDelay(true);
                socketOut = new ObjectOutputStream(clientSocket.getOutputStream());
                socketIn = new ObjectInputStream(clientSocket.getInputStream());
                WireIO wio = new WireIO(socketOut, socketIn);
                wio.sendSimpleCommand(12);
                Object o = wio.receiveCommandOrResponse();
                if (o instanceof Response && ((Response)o).isOK()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (socketIn != null) {
                        socketIn.close();
                    }
                    if (socketOut != null) {
                        socketOut.close();
                    }
                    if (clientSocket != null) {
                        clientSocket.close();
                    }
                }
                catch (IOException e) {
                    ProfilerLogger.log((Exception)e);
                }
            }
        }
        return false;
    }

    public void stopApp() {
        TargetAppRunner runner = this.getTargetAppRunner();
        if (runner == null || !runner.targetJVMIsAlive()) {
            return;
        }
        this.changeStateTo(128);
        runner.terminateTargetJVM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getAgentProperties(int port) {
        File f = NetBeansProfiler.getInfoFile(port);
        if (!f.exists()) {
            return null;
        }
        BufferedInputStream bis = null;
        try {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(f);
            bis = new BufferedInputStream(fis);
            props.load(bis);
            bis.close();
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            Properties properties = null;
            return properties;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static File getInfoFile(int port) {
        String homeDir = System.getProperty("user.home");
        return new File(homeDir + File.separator + ".nbprofiler" + File.separator + port);
    }

    private boolean isProfilingRunningOnPort(int port) {
        return this.profilingState == 4 && port == this.getTargetAppRunner().getProfilerEngineSettings().getPortNo();
    }

    private void changeStateTo(int newState) {
        if (this.profilingState == newState) {
            return;
        }
        int oldProfilingState = this.profilingState;
        this.profilingState = newState;
        this.fireProfilingStateChange(oldProfilingState, this.profilingState);
        if (newState == 1 || newState == 16) {
            this.cleanupAfterProfiling();
        }
        if (newState == 4 && "jdk15".equals(this.getTargetAppRunner().getProfilerEngineSettings().getTargetJDKVersionString()) && this.lastProfilingSettings.getProfilingType() == 128) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilerDialogs.displayWarning((String)Bundle.NetBeansProfiler_MemorySamplingJava5());
                }
            });
        }
    }

    protected void cleanupAfterProfiling() {
        this.teardownDispatcher();
        ClassRepository.cleanup();
    }

    private void cleanupBeforeProfiling(ProfilerEngineSettings sharedSettings) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetBeansProfiler.this.getThreadsManager().reset();
                NetBeansProfiler.this.getVMTelemetryManager().reset();
            }
        });
        ResultsManager.getDefault().reset();
        ClassRepository.clearCache();
        ClassRepository.initClassPaths((String)sharedSettings.getWorkingDir(), (String[])sharedSettings.getVMClassPaths());
    }

    private void openWindowsOnProfilingStart() {
    }

    public boolean startEx(final ProfilingSettings profilingSettings, final SessionSettings sessionSettings, final AtomicBoolean cancel) {
        final boolean[] rslt = new boolean[1];
        final CountDownLatch latch = new CountDownLatch(1);
        if (!(!sessionSettings.getRemoteHost().isEmpty() || CalibrationDataFileIO.validateCalibrationInput((String)sessionSettings.getJavaVersionString(), (String)sessionSettings.getJavaExecutable()) && this.runCalibration(true, sessionSettings.getJavaExecutable(), sessionSettings.getJavaVersionString(), sessionSettings.getSystemArchitecture()))) {
            ProfilerDialogs.displayError((String)Bundle.ProfilerModule_CalibrationFailedMessage());
            return false;
        }
        new SwingWorker(false){
            private volatile ProgressDisplayer pd;

            protected void doInBackground() {
                if (this.isCancelled()) {
                    return;
                }
                NetBeansProfiler.this.connectToStartedApp(profilingSettings, sessionSettings, cancel);
            }

            protected void done() {
                if (this.pd != null) {
                    this.pd.close();
                    this.pd = null;
                }
                rslt[0] = true;
                latch.countDown();
            }

            protected void nonResponding() {
                final 11 thiz = this;
                this.pd = ProfilerProgressDisplayer.getDefault().showProgress(Bundle.MSG_StartingProfilerClient(), new ProgressDisplayer.ProgressController(){

                    public boolean cancel() {
                        thiz.cancel();
                        return true;
                    }
                });
            }

            protected void cancelled() {
                if (this.pd != null) {
                    this.pd.close();
                    this.pd = null;
                }
                rslt[0] = false;
                cancel.set(true);
                latch.countDown();
            }

            protected int getWarmup() {
                return 1500;
            }
        }.execute();
        try {
            latch.await();
            return rslt[0];
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupDispatcher(ProfilingSettings profilingSettings) {
        this.lastProfilingSettings = profilingSettings;
        Object object = this.setupLock;
        synchronized (object) {
            ProfilingPointsProcessor ppp;
            Lookup.Provider project = this.getProfiledProject();
            CCTProvider cctProvider = null;
            Collection cctListeners = null;
            switch (profilingSettings.getProfilingType()) {
                case 8: 
                case 16: 
                case 32: 
                case 64: 
                case 256: {
                    cctProvider = (CCTProvider)Lookup.getDefault().lookup(CPUCCTProvider.class);
                    cctListeners = Lookup.getDefault().lookupAll(CPUCCTProvider.Listener.class);
                    break;
                }
                case 2: 
                case 4: {
                    cctProvider = (CCTProvider)Lookup.getDefault().lookup(MemoryCCTProvider.class);
                    cctListeners = Lookup.getDefault().lookupAll(MemoryCCTProvider.Listener.class);
                }
            }
            if (cctProvider != null && cctListeners != null && cctListeners.size() > 0) {
                for (CCTProvider.Listener cctListener : cctListeners) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Adding listener {0} to the provider {1}", new Object[]{cctListener.getClass().getName(), cctProvider.getClass().getName()});
                    }
                    cctProvider.addListener(cctListener);
                }
            } else if (LOGGER.isLoggable(Level.WARNING)) {
                if (cctProvider == null) {
                    LOGGER.warning("Could not find a CCT provider in lookup!");
                } else if (cctListeners == null || cctListeners.isEmpty()) {
                    LOGGER.warning("Could not find listeners in lookup!");
                }
            }
            for (SessionListener sl : Lookup.getDefault().lookupAll(SessionListener.class)) {
                sl.onStartup(profilingSettings, project);
            }
            ProfilerClient client = this.getTargetAppRunner().getProfilerClient();
            CCTResultsFilter filter = (CCTResultsFilter)Lookup.getDefault().lookup(CCTResultsFilter.class);
            if (filter != null) {
                filter.reset();
                filter.setEvaluators(Lookup.getDefault().lookupAll(CCTResultsFilter.EvaluatorProvider.class));
            }
            FlatProfileBuilder fpb = (FlatProfileBuilder)Lookup.getDefault().lookup(FlatProfileBuilder.class);
            TimeCollector tc = (TimeCollector)Lookup.getDefault().lookup(TimeCollector.class);
            fpb.setContext(client, tc, filter);
            Collection listeners = null;
            switch (profilingSettings.getProfilingType()) {
                case 8: 
                case 16: 
                case 64: 
                case 256: {
                    listeners = Lookup.getDefault().lookupAll(CPUProfilingResultListener.class);
                    for (CPUProfilingResultListener listener : listeners) {
                        ProfilingResultsDispatcher.getDefault().addListener(listener);
                        listener.startup(this.getTargetAppRunner().getProfilerClient());
                    }
                    break;
                }
                case 2: 
                case 4: {
                    listeners = Lookup.getDefault().lookupAll(MemoryProfilingResultsListener.class);
                    for (MemoryProfilingResultsListener listener : listeners) {
                        ProfilingResultsDispatcher.getDefault().addListener(listener);
                        listener.startup(this.getTargetAppRunner().getProfilerClient());
                    }
                    break;
                }
                default: {
                    listeners = Lookup.getDefault().lookupAll(LockProfilingResultListener.class);
                    for (LockProfilingResultListener listener : listeners) {
                        ProfilingResultsDispatcher.getDefault().addListener(listener);
                        listener.startup(this.getTargetAppRunner().getProfilerClient());
                    }
                }
            }
            if ((ppp = this.getProfilingPointsManager()) != null) {
                ppp.init((Object)this.getProfiledProject());
            }
            ProfilingResultsDispatcher.getDefault().startup(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shutdownAgent(String host, int port) {
        if (port == -1) {
            return false;
        }
        Socket clientSocket = null;
        ObjectOutputStream socketOut = null;
        ObjectInputStream socketIn = null;
        try {
            clientSocket = new Socket(host, port);
            clientSocket.setSoTimeout(100);
            clientSocket.setTcpNoDelay(true);
            socketOut = new ObjectOutputStream(clientSocket.getOutputStream());
            socketIn = new ObjectInputStream(clientSocket.getInputStream());
            WireIO wio = new WireIO(socketOut, socketIn);
            wio.sendSimpleCommand(12);
            try {
                Object object = wio.receiveCommandOrResponse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerLogger.warning((String)(">>> An existing Profiler agent listening on port " + port + " was terminated to allow starting new profiling session on the same port."));
            boolean bl = true;
            return bl;
        }
        catch (SocketTimeoutException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (socketIn != null) {
                    socketIn.close();
                }
                if (socketOut != null) {
                    socketOut.close();
                }
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownDispatcher() {
        Object object = this.setupLock;
        synchronized (object) {
            ProfilingResultsDispatcher.getDefault().shutdown();
            ProfilerClient client = this.getTargetAppRunner().getProfilerClient();
            client.registerFlatProfileProvider(null);
            for (SessionListener sl : Lookup.getDefault().lookupAll(SessionListener.class)) {
                sl.onShutdown();
            }
            FlatProfileBuilder fpb = (FlatProfileBuilder)Lookup.getDefault().lookup(FlatProfileBuilder.class);
            fpb.setContext(null, null, null);
        }
    }

    private ProfilingPointsProcessor getProfilingPointsManager() {
        return (ProfilingPointsProcessor)Lookup.getDefault().lookup(ProfilingPointsProcessor.class);
    }

    private boolean waitForDeleteAgentFile(File agentFile) {
        if (agentFile.delete()) {
            return true;
        }
        for (int i = 0; i < 5; ++i) {
            if (agentFile.delete()) {
                return true;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private static void logActionConfig(String actionTitle, ProfilingSettings ps, SessionSettings ss, AttachSettings as, GenericFilter f) {
        assert (actionTitle != null);
        assert (ps != null);
        assert (f != null);
        Object[] objectArray = new Object[5];
        objectArray[0] = actionTitle;
        objectArray[1] = ps.debug();
        Object object = ss != null ? "Session" : (objectArray[2] = as != null ? "Attach" : null);
        objectArray[3] = ss != null ? ss.debug() : (as != null ? as.debug() : null);
        objectArray[4] = f.toString();
        LOGGER.log(Level.CONFIG, "*** Profiler Action = {0}\n>>> Profiling Settings = \n{1}\n>>> {2} Settings = \n{3}\n>>> Instrumentation Filter = \n{4}", objectArray);
    }

    private final class IDEAppStatusHandler
    implements AppStatusHandler {
        private IDEAppStatusHandler() {
        }

        public AppStatusHandler.AsyncDialog getAsyncDialogInstance(String message, boolean showProgress, Runnable cancelHandler) {
            return new ProgressPanel(message, showProgress, cancelHandler);
        }

        public boolean confirmWaitForConnectionReply() {
            return !ProfilerDialogs.displayConfirmation((String)Bundle.NetBeansProfiler_TargetAppNotRespondingMsg(), (String)Bundle.NetBeansProfiler_TargetAppNotRespondingDialogTitle());
        }

        public void displayError(String msg) {
            LOGGER.log(Level.WARNING, "IDEAppStatusHandler - error: {)}", msg);
            ProfilerDialogs.displayError((String)msg);
        }

        public void displayErrorAndWaitForConfirm(String msg) {
            LOGGER.log(Level.WARNING, "IDEAppStatusHandler - errorAndWaitForConfirm: {0}", msg);
            ProfilerDialogs.displayError((String)msg);
        }

        public void displayErrorWithDetailsAndWaitForConfirm(String shortMsg, String detailsMsg) {
            ProfilerDialogs.displayError((String)shortMsg, null, (String)detailsMsg);
        }

        public void displayNotification(String msg) {
            StatusDisplayer.getDefault().setStatusText(msg);
        }

        public void displayNotificationAndWaitForConfirm(String msg) {
            ProfilerDialogs.displayInfo((String)msg);
        }

        public void displayNotificationWithDetailsAndWaitForConfirm(String shortMsg, String detailsMsg) {
            ProfilerDialogs.displayInfo((String)shortMsg, null, (String)detailsMsg);
        }

        public void displayWarning(String msg) {
            LOGGER.log(Level.WARNING, "IDEAppStatusHandler - warning: {0}", msg);
            ProfilerDialogs.displayWarning((String)msg);
        }

        public void displayWarningAndWaitForConfirm(String msg) {
            LOGGER.log(Level.WARNING, "IDEAppStatusHandler - warningAndWaitForConfirm: {0}", msg);
            ProfilerDialogs.displayWarning((String)msg);
        }

        public void handleShutdown() {
            if (NetBeansProfiler.this.getTargetAppRunner().getProfilerClient().getCurrentInstrType() == 0 || !ResultsManager.getDefault().resultsAvailable()) {
                ProfilerDialogs.displayInfoDNSA((String)Bundle.NetBeansProfiler_TerminateVMOnExitMsg(), null, null, (String)"NetBeansProfiler.handleShutdown.noResults", (boolean)false);
            } else if (ProfilerDialogs.displayConfirmationDNSA((String)Bundle.NetBeansProfiler_TakeSnapshotOnExitMsg(), (String)Bundle.NetBeansProfiler_TakeSnapshotOnExitDialogTitle(), null, (String)"NetBeansProfiler.handleShutdown", (boolean)false)) {
                ResultsManager.getDefault().takeSnapshot();
            }
        }

        public void pauseLiveUpdates() {
        }

        public void resultsAvailable() {
            ProfilingSettings ps = NetBeansProfiler.this.getLastProfilingSettings();
            if (ps != null && ps.getProfilingType() == 64) {
                return;
            }
            ResultsManager.getDefault().resultsBecameAvailable();
        }

        public void resumeLiveUpdates() {
        }

        public void takeSnapshot() {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    ResultsManager.getDefault().takeSnapshot();
                }
            });
        }
    }

    public static final class ProgressPanel
    implements AppStatusHandler.AsyncDialog {
        private static final int MINIMUM_WIDTH = 350;
        private volatile boolean opened;
        private volatile boolean closed;
        private JDialog dialog;
        private final String message;
        private final boolean showProgress;
        private final Runnable cancelHandler;

        private ProgressPanel(String message, boolean showProgress, Runnable cancelHandler) {
            this.message = message;
            this.showProgress = showProgress;
            this.cancelHandler = cancelHandler;
        }

        public void close() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!opened) {
                        closed = true;
                    } else {
                        this.closeImpl();
                    }
                }
            });
        }

        public void display() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.initUI();
                    if (!closed) {
                        dialog.setVisible(true);
                    }
                }
            });
        }

        private void initUI() {
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            this.dialog = new JDialog(mainWindow, Bundle.NetBeansProfiler_ProgressDialogCaption(), true);
            JPanel panel = new JPanel(new BorderLayout(5, 5));
            panel.setBorder(new EmptyBorder(15, 15, 15, 10));
            panel.add((Component)new JLabel(this.message), "North");
            if (this.showProgress) {
                JProgressBar progress = new JProgressBar();
                progress.setIndeterminate(true);
                panel.add((Component)progress, "South");
            }
            if (this.cancelHandler != null) {
                JButton cancelButton = new JButton(){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        this.close();
                        cancelHandler.run();
                    }
                };
                Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)Bundle.NetBeansProfiler_CancelBtn());
                JPanel buttonPanel = new JPanel(new BorderLayout(0, 0));
                buttonPanel.setBorder(new EmptyBorder(5, 15, 10, 10));
                buttonPanel.add((Component)cancelButton, "East");
                this.dialog.add((Component)panel, "North");
                this.dialog.add((Component)buttonPanel, "South");
            } else {
                this.dialog.add((Component)panel, "North");
            }
            Dimension ps = panel.getPreferredSize();
            panel.setPreferredSize(new Dimension(Math.max(ps.width, 350), ps.height));
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(mainWindow);
            this.dialog.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L && dialog.isShowing()) {
                        dialog.removeHierarchyListener(this);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                opened = true;
                                if (closed) {
                                    this.closeImpl();
                                }
                            }
                        });
                    }
                }
            });
            this.dialog.setDefaultCloseOperation(0);
        }

        private void closeImpl() {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }
}

