/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopup;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.lib.profiler.utils.formatting.DefaultMethodNameFormatter;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.impl.Bundle;
import org.netbeans.modules.profiler.v2.impl.ClassMethodSelector;
import org.openide.util.ImageUtilities;

public final class ClassMethodList {
    public static void showClasses(ProfilerSession session, Set<ClientUtils.SourceCodeSelection> selection, Component invoker) {
        UI.forClasses(session, selection).show(invoker);
    }

    public static void showMethods(ProfilerSession session, Set<ClientUtils.SourceCodeSelection> selection, Component invoker) {
        UI.forMethods(session, selection).show(invoker);
    }

    private ClassMethodList() {
    }

    private static class UI {
        private JPanel panel;

        static UI forClasses(ProfilerSession session, Set<ClientUtils.SourceCodeSelection> selection) {
            return new UI(session, selection, false);
        }

        static UI forMethods(ProfilerSession session, Set<ClientUtils.SourceCodeSelection> selection) {
            return new UI(session, selection, true);
        }

        void show(Component invoker) {
            int resizeMode = 12;
            ProfilerPopup.createRelative((Component)invoker, (Component)this.panel, (int)6, (int)resizeMode).show();
        }

        private UI(final ProfilerSession session, final Set<ClientUtils.SourceCodeSelection> selection, final boolean methods) {
            JPanel content = new JPanel(new BorderLayout());
            JLabel hint = new JLabel(methods ? Bundle.ClassMethodList_selectedMethods() : Bundle.ClassMethodList_selectedClasses(), 10);
            hint.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            content.add((Component)hint, "North");
            class XListModel
            extends AbstractListModel<ClientUtils.SourceCodeSelection> {
                XListModel() {
                }

                @Override
                public int getSize() {
                    return selection.size();
                }

                @Override
                public ClientUtils.SourceCodeSelection getElementAt(int index) {
                    return (ClientUtils.SourceCodeSelection)new ArrayList(selection).get(index);
                }

                public void refresh() {
                    super.fireContentsChanged(this, 0, this.getSize());
                }
            }
            final XListModel xmodel = new XListModel();
            final JList list = new JList(xmodel){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dim = super.getPreferredScrollableViewportSize();
                    dim.width = 420;
                    return dim;
                }
            };
            list.setBackground(UIUtils.getProfilerResultsBackground());
            int format = methods ? 3 : 1;
            DefaultMethodNameFormatter formatter = new DefaultMethodNameFormatter(format);
            final JavaNameRenderer renderer = new JavaNameRenderer();
            list.setCellRenderer(new ListCellRenderer(){
                final /* synthetic */ MethodNameFormatter val$formatter;
                {
                    this.val$formatter = methodNameFormatter;
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    renderer.setValue((Object)this.val$formatter.formatMethodName((ClientUtils.SourceCodeSelection)value).toFormatted(), index);
                    JComponent c = renderer.getComponent();
                    if (isSelected) {
                        c.setForeground(list.getSelectionForeground());
                        c.setBackground(list.getSelectionBackground());
                    } else {
                        c.setForeground(list.getForeground());
                        c.setBackground((index & 1) == 0 ? list.getBackground() : UIUtils.getDarker((Color)list.getBackground()));
                    }
                    return c;
                }
            });
            String iconMask = methods ? "LanguageIcons.Method" : "LanguageIcons.Class";
            Image baseIcon = Icons.getImage((String)iconMask);
            Image addBadge = Icons.getImage((String)"GeneralIcons.BadgeAdd");
            Image addImage = ImageUtilities.mergeImages((Image)baseIcon, (Image)addBadge, (int)0, (int)0);
            SmallButton addB = new SmallButton(ImageUtilities.image2Icon((Image)addImage)){
                {
                    super(icon);
                }

                protected void fireActionPerformed(ActionEvent e) {
                    HashSet<ClientUtils.SourceCodeSelection> sel = null;
                    if (methods) {
                        List<SourceMethodInfo> mtd = ClassMethodSelector.selectMethods(session);
                        if (!mtd.isEmpty()) {
                            sel = new HashSet<ClientUtils.SourceCodeSelection>();
                            for (SourceMethodInfo smi : mtd) {
                                sel.add(new ClientUtils.SourceCodeSelection(smi.getClassName(), smi.getName(), smi.getSignature()));
                            }
                        }
                    } else {
                        List<SourceClassInfo> cls = ClassMethodSelector.selectClasses(session);
                        if (!cls.isEmpty()) {
                            sel = new HashSet();
                            for (SourceClassInfo sci : cls) {
                                sel.add(new ClientUtils.SourceCodeSelection(sci.getQualifiedName(), "*", null));
                            }
                        }
                    }
                    if (sel != null) {
                        selection.addAll(sel);
                        xmodel.refresh();
                    }
                }
            };
            addB.setToolTipText(methods ? Bundle.ClassMethodList_addMethod() : Bundle.ClassMethodList_addClass());
            Image removeBadge = Icons.getImage((String)"GeneralIcons.BadgeRemove");
            Image removeImage = ImageUtilities.mergeImages((Image)baseIcon, (Image)removeBadge, (int)0, (int)0);
            SmallButton removeB = new SmallButton(ImageUtilities.image2Icon((Image)removeImage)){
                {
                    super(icon);
                }

                protected void fireActionPerformed(ActionEvent e) {
                    selection.removeAll(list.getSelectedValuesList());
                    xmodel.refresh();
                    list.clearSelection();
                    this.setEnabled(false);
                }
            };
            removeB.setToolTipText(methods ? Bundle.ClassMethodList_removeMethods() : Bundle.ClassMethodList_removeClasses());
            removeB.setEnabled(false);
            list.setSelectionMode(2);
            list.addListSelectionListener(new ListSelectionListener(){
                final /* synthetic */ JButton val$removeB;
                final /* synthetic */ JList val$list;
                {
                    this.val$removeB = jButton;
                    this.val$list = jList;
                }

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    this.val$removeB.setEnabled(this.val$list.getSelectedValue() != null);
                }
            });
            JScrollPane scroll = new JScrollPane(list);
            hint.setLabelFor(scroll);
            content.add((Component)scroll, "Center");
            JPanel buttons = new JPanel(null);
            buttons.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
            buttons.setLayout(new BoxLayout(buttons, 1));
            buttons.add((Component)addB);
            buttons.add((Component)removeB);
            content.add((Component)buttons, "East");
            this.panel = content;
        }
    }
}

