/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.CatalogUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class JaxWsCatalogPanel
extends JPanel {
    static final String GENERATE_JAXWS_CATALOG = "generate_jax_ws_catalog";
    private JCheckBox notAskAgain;
    private JLabel textLabel;

    public JaxWsCatalogPanel() {
        this.initComponents();
    }

    boolean notAskAgain() {
        return this.notAskAgain.isSelected();
    }

    private static boolean generateJaxWsCatalog(String projectRoot) {
        Preferences prefs = NbPreferences.forModule(JaxWsCatalogPanel.class);
        if (prefs == null || prefs.get(GENERATE_JAXWS_CATALOG, null) == null) {
            JaxWsCatalogPanel panel = new JaxWsCatalogPanel();
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(JaxWsCatalogPanel.class, (String)"TTL_GenerateJaxWsCatalog", (Object)projectRoot), true, 0, null, null);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (panel.notAskAgain() && prefs != null) {
                if (NotifyDescriptor.YES_OPTION.equals(result)) {
                    prefs.put(GENERATE_JAXWS_CATALOG, "true");
                } else if (NotifyDescriptor.NO_OPTION.equals(result)) {
                    prefs.put(GENERATE_JAXWS_CATALOG, "false");
                }
            }
            return NotifyDescriptor.YES_OPTION.equals(result);
        }
        return "true".equals(prefs.get(GENERATE_JAXWS_CATALOG, null));
    }

    static void generateJaxWsCatalog(Project project, JAXWSClientSupport clientSupport) throws IOException {
        FileObject wsdlFolder;
        if (JaxWsCatalogPanel.generateJaxWsCatalog(project.getProjectDirectory().getName()) && (wsdlFolder = clientSupport.getWsdlFolder(true)) != null) {
            JaxWsModel jaxWsModel;
            FileObject jaxWsCatalog = WSUtils.retrieveJaxWsCatalogFromResource((FileObject)wsdlFolder.getParent());
            FileObject catalog = project.getProjectDirectory().getFileObject("catalog.xml");
            if (catalog != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null) {
                CatalogUtils.copyCatalogEntriesForAllClients((FileObject)catalog, (FileObject)jaxWsCatalog, (JaxWsModel)jaxWsModel);
                for (Client client : jaxWsModel.getClients()) {
                    FileObject wsdlSourceFolder = clientSupport.getLocalWsdlFolderForClient(client.getName(), false);
                    if (wsdlSourceFolder == null) continue;
                    WSUtils.copyFiles((FileObject)wsdlSourceFolder, (FileObject)wsdlFolder);
                }
            }
        }
    }

    private void initComponents() {
        this.textLabel = new JLabel();
        this.notAskAgain = new JCheckBox();
        this.textLabel.setText(NbBundle.getMessage(JaxWsCatalogPanel.class, (String)"MSG_CreateJaxWs"));
        this.notAskAgain.setText(NbBundle.getMessage(JaxWsCatalogPanel.class, (String)"MSG_DontAskAgain"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.notAskAgain).addComponent(this.textLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.textLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.notAskAgain).addContainerGap(17, Short.MAX_VALUE)));
    }
}

