/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.launch;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.VirtualMachine;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jshell.launch.NIOStreams;
import org.netbeans.modules.jshell.launch.ShellAgent;
import org.netbeans.modules.jshell.launch.ShellDebuggerUtils;
import org.openide.util.Exceptions;

public final class JShellConnection
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(JShellConnection.class.getName());
    private static final int WRITE_TIMEOUT = 10000;
    private static final AtomicInteger connId = new AtomicInteger(0);
    private final Project project;
    private final SocketAddress listenAddress;
    private final int id = connId.incrementAndGet();
    private final Session debuggerSession;
    private final ShellAgent theAgent;
    private volatile SocketChannel controlSocket;
    private volatile boolean closed;
    private final ObjectReference agentHandle;
    private OutputStream ostm;
    private InputStream istm;

    public Project getProject() {
        return this.project;
    }

    JShellConnection(ShellAgent agent, SocketChannel controlSocket) throws IOException {
        this.listenAddress = agent.getHandshakeAddress();
        this.project = agent.getProject();
        this.theAgent = agent;
        this.controlSocket = controlSocket;
        this.ostm = NIOStreams.createOutputStream(controlSocket, 10000);
        this.istm = new CloseInputStream(NIOStreams.createInputStream(controlSocket, this::disconnected));
        this.debuggerSession = agent.getDebuggerSession();
        LOG.log(Level.FINE, "Allocated connection: {0}", this);
        this.agentHandle = ShellDebuggerUtils.getWorkerHandle(this.debuggerSession, ((InetSocketAddress)controlSocket.getRemoteAddress()).getPort());
    }

    private void disconnected(SocketChannel dummy) {
        LOG.log(Level.FINE, "Detected disconnect: {0}", this);
        this.theAgent.disconnect(this, true);
    }

    public SocketAddress getLocalAddress() {
        return this.listenAddress;
    }

    public int getId() {
        return this.id;
    }

    public ObjectReference getAgentHandle() {
        return this.agentHandle;
    }

    public int getRemoteAgentId() {
        try {
            return ((InetSocketAddress)this.controlSocket.getRemoteAddress()).getPort();
        }
        catch (IOException ex) {
            return -1;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JShellConnection[").append("id = ").append(this.id).append(", session = ").append(this.debuggerSession).append(", handshake = ").append(this.listenAddress).append(", control = ").append(this.controlSocket).append("]");
        return sb.toString();
    }

    public ShellAgent getMachineAgent() {
        return this.theAgent;
    }

    @Override
    public void close() {
        this.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutDown() {
        try {
            LOG.log(Level.FINE, "notifyShutdown: closing control socket: {0}", this.controlSocket);
            if (this.controlSocket != null) {
                this.controlSocket.close();
            }
            this.ostm.close();
            this.istm.close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            JShellConnection jShellConnection = this;
            synchronized (jShellConnection) {
                this.closed = true;
                this.notify();
            }
        }
    }

    synchronized boolean acceptSocketAndKey(int key, SocketChannel socket, ObjectInputStream istm) throws IOException {
        if (this.closed) {
            return false;
        }
        if (this.id != key) {
            return false;
        }
        this.ostm = Channels.newOutputStream(socket);
        this.istm = istm;
        this.controlSocket = socket;
        this.notify();
        return true;
    }

    public boolean isInitialized() {
        return this.debuggerSession != null || this.controlSocket != null;
    }

    public synchronized boolean isValid() {
        if (this.closed) {
            return false;
        }
        return this.controlSocket != null && this.controlSocket.isConnected() && this.controlSocket.isOpen();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Session getDebuggerSession() {
        return this.getMachineAgent().getDebuggerSession();
    }

    public VirtualMachine getVirtualMachine() {
        return this.getMachineAgent().getDebuggerMachine();
    }

    public boolean wasConnected() {
        return this.controlSocket != null;
    }

    public OutputStream getAgentInput() {
        return this.controlSocket != null ? this.ostm : null;
    }

    public InputStream getAgentOutput() {
        return this.controlSocket != null ? this.istm : null;
    }

    public void interrupt() {
    }

    private class CloseInputStream
    extends FilterInputStream {
        private boolean closed;

        public CloseInputStream(InputStream in) {
            super(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            CloseInputStream closeInputStream = this;
            synchronized (closeInputStream) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            try {
                super.close();
            }
            finally {
                LOG.log(Level.FINE, "Requested to close connection: {0}", this);
                JShellConnection.this.theAgent.disconnect(JShellConnection.this, false);
            }
        }
    }
}

