/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.project;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.wizards.ImportWizard;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ImportAction
implements ActionListener,
HelpCtx.Provider {
    private static final Logger LOG = Logger.getLogger(ImportAction.class.getName());
    private final List<File> roots;

    public ImportAction(List<File> rootFiles) {
        this.roots = rootFiles;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.subversion.ui.project.ImportAction");
    }

    private boolean isEnabled() {
        if (this.roots.size() == 1) {
            if (!this.isCacheReady()) {
                LOG.log(Level.FINE, "Cache not ready yet");
                return false;
            }
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            File dir = this.lookupImportDirectory(this.roots.iterator().next());
            if (dir != null && dir.isDirectory()) {
                FileInformation status = cache.getCachedStatus(dir);
                if (!(SvnUtils.isManaged(dir) || status != null && (status.getStatus() & 0xFFFFFFFE) != 0)) {
                    boolean b;
                    FileObject fo = FileUtil.toFileObject((File)dir);
                    Project p = FileOwnerQuery.getOwner((FileObject)fo);
                    if (p == null) {
                        return true;
                    }
                    FileObject projectDir = p.getProjectDirectory();
                    boolean bl = b = !FileUtil.isParentOf((FileObject)projectDir, (FileObject)fo);
                    if (!b) {
                        this.notifyImportImpossible(NbBundle.getMessage(ImportAction.class, (String)"MSG_NoSubproject"));
                    }
                    return b;
                }
                LOG.log(Level.FINE, "Already versioned: {0} - {1}", new Object[]{dir, status});
            } else {
                LOG.log(Level.FINE, "Root not folder: {0}", dir);
            }
        } else if (this.roots.isEmpty()) {
            this.notifyImportImpossible(NbBundle.getMessage(ImportAction.class, (String)"MSG_EmptySelection"));
        } else {
            this.notifyImportImpossible(NbBundle.getMessage(ImportAction.class, (String)"MSG_TooManyRoots"));
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.performAction();
    }

    protected void performAction() {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Utils.logVCSActionEvent((String)"SVN");
        assert (this.roots.size() == 1);
        if (this.roots.size() == 1) {
            File importDirectory = this.lookupImportDirectory(this.roots.iterator().next());
            if (importDirectory == null) {
                LOG.log(Level.FINE, "null dir to import: {0}", this.roots.iterator().next());
            } else {
                LOG.log(Level.FINE, "Starting wizard: {0}", this.roots.iterator().next());
                ArrayList<File> list = new ArrayList<File>(1);
                list.add(importDirectory);
                Context context = new Context(Context.getEmptyList(), list, Context.getEmptyList());
                ImportWizard wizard = new ImportWizard(context);
                wizard.show();
            }
        } else {
            LOG.warning("too many roots in selection.");
        }
    }

    private File lookupImportDirectory(File file) {
        FileObject fo = FileUtil.toFileObject((File)file);
        Project project = null;
        if (fo.isFolder()) {
            try {
                project = ProjectManager.getDefault().findProject(fo);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }
        File importDirectory = null;
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("generic");
            if (groups.length == 1) {
                FileObject root = groups[0].getRootFolder();
                importDirectory = FileUtil.toFile((FileObject)root);
            } else {
                importDirectory = FileUtil.toFile((FileObject)project.getProjectDirectory());
            }
        } else if (file.isDirectory()) {
            importDirectory = file;
        }
        return importDirectory;
    }

    private void notifyImportImpossible(String msg) {
        LOG.log(Level.FINE, "Import impossible: {0}", msg);
        NotifyDescriptor nd = new NotifyDescriptor((Object)msg, NbBundle.getMessage(ImportAction.class, (String)"MSG_ImportNotAllowed"), -1, 2, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }

    private boolean isCacheReady() {
        DialogDescriptor dd = new DialogDescriptor((Object)NbBundle.getMessage(ImportAction.class, (String)"MSG_CacheNotReady"), NbBundle.getMessage(ImportAction.class, (String)"MSG_InitRunning"), true, new Object[]{NbBundle.getMessage(ImportAction.class, (String)"LBL_CancelAction")}, null, 0, null, null);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        final FileStatusCache cache = Subversion.getInstance().getStatusCache();
        if (!cache.ready()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    while (!cache.ready()) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                            break;
                        }
                    }
                    dialog.setVisible(false);
                }
            });
            dialog.setVisible(!cache.ready());
            return cache.ready();
        }
        return true;
    }
}

