/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.javaee.web;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gradle.javaee.GradleJavaEEProjectSettings;
import org.netbeans.modules.javaee.project.api.JavaEEProjectSettings;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.browser.spi.ProjectBrowserProvider;

public final class WebProjectBrowserProvider
implements ProjectBrowserProvider,
PreferenceChangeListener {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Project project;
    private Preferences preferences;

    public WebProjectBrowserProvider(Project project) {
        this.project = project;
    }

    public Collection<WebBrowser> getBrowsers() {
        return WebBrowsers.getInstance().getAll(false, true, true);
    }

    public WebBrowser getActiveBrowser() {
        String selectedBrowser = JavaEEProjectSettings.getBrowserID((Project)this.project);
        if (selectedBrowser == null) {
            return null;
        }
        return BrowserUISupport.getBrowser((String)selectedBrowser);
    }

    public void setActiveBrowser(WebBrowser browser) throws IllegalArgumentException, IOException {
        ProjectManager.mutex().writeAccess(() -> JavaEEProjectSettings.setBrowserID((Project)this.project, (String)browser.getId()));
        this.pcs.firePropertyChange("activeConfiguration", null, null);
    }

    public boolean hasCustomizer() {
        return false;
    }

    public void customize() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.pcs.hasListeners(null)) {
            this.getPreferences().addPreferenceChangeListener(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
        if (!this.pcs.hasListeners(null)) {
            this.getPreferences().removePreferenceChangeListener(this);
            this.preferences = null;
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if ("selected.browser".equals(evt.getKey())) {
            this.pcs.firePropertyChange("activeConfiguration", null, null);
        }
    }

    private Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = ((GradleJavaEEProjectSettings)this.project.getLookup().lookup(GradleJavaEEProjectSettings.class)).getPreferences();
        }
        return this.preferences;
    }
}

