/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.EventQueue;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.InstantRefactoringPerformer;
import org.netbeans.modules.refactoring.java.ui.Bundle;
import org.netbeans.modules.refactoring.java.ui.ContextAnalyzer;
import org.netbeans.modules.refactoring.java.ui.CopyClassRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.InstantRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.InstantRefactoringUIImpl;
import org.netbeans.modules.refactoring.java.ui.MoveClassUI;
import org.netbeans.modules.refactoring.java.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.SafeDeleteUI;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.PasteType;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    private static boolean INSTANT = Boolean.getBoolean("org.netbeans.modules.java.refactoring.instantRename");

    public void doRename(Lookup lookup) {
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (INSTANT && RefactoringUtils.isFromEditor(ec)) {
            this.invokeInstantRename(lookup, ec);
        } else {
            this.doFullRename(lookup);
        }
    }

    private void invokeInstantRename(Lookup lookup, EditorCookie ec) {
        try {
            JavaSource js;
            JEditorPane target = ec.getOpenedPanes()[0];
            int caret = target.getCaretPosition();
            String ident = Utilities.getIdentifier((BaseDocument)Utilities.getDocument((JTextComponent)target), (int)caret);
            if (ident == null) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)Bundle.WARN_CannotPerformHere());
                return;
            }
            DataObject od = (DataObject)target.getDocument().getProperty("stream");
            JavaSource javaSource = js = od != null ? JavaSource.forFileObject((FileObject)od.getPrimaryFile()) : null;
            if (js == null) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)Bundle.WARN_CannotPerformHere());
                return;
            }
            InstantRefactoringUI ui = InstantRefactoringUIImpl.create(js, caret);
            if (ui != null) {
                if (ui.getRegions().isEmpty() || ui.getKeyStroke() == null) {
                    this.doFullRename(lookup);
                } else {
                    RefactoringActionsProvider.doInstantRename(target, js, caret, ui);
                }
            } else {
                Utilities.setStatusBoldText((JTextComponent)target, (String)Bundle.WARN_CannotPerformHere());
            }
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public static void doInstantRename(JTextComponent target, JavaSource js, int caretOffset, InstantRefactoringUI ui) throws BadLocationException {
        new InstantRefactoringPerformer(target, caretOffset, ui);
    }

    private void doFullRename(Lookup lookup) {
        final Runnable task = ContextAnalyzer.createTask(lookup, RenameRefactoringUI.factory(lookup));
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIUtilities.runWhenScanFinished(task, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.renameAction()));
                }
            });
        } else {
            UIUtilities.runWhenScanFinished(task, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.renameAction()));
        }
    }

    static String getActionName(Action action) {
        String arg = (String)action.getValue("Name");
        arg = arg.replace("&", "");
        return arg.replace("...", "");
    }

    public boolean canRename(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        TreePathHandle tph = (TreePathHandle)n.getLookup().lookup(TreePathHandle.class);
        if (tph != null) {
            return JavaRefactoringUtils.isRefactorable(tph.getFileObject());
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob == null) {
            return false;
        }
        FileObject fo = dob.getPrimaryFile();
        if (JavaRefactoringUtils.isRefactorable(fo)) {
            return true;
        }
        return dob instanceof DataFolder && RefactoringUtils.isFileInOpenProject(fo) && JavaRefactoringUtils.isOnSourceClasspath(fo) && !RefactoringUtils.isClasspathRoot(fo);
    }

    public void doCopy(Lookup lookup) {
        Runnable task = ContextAnalyzer.createTask(lookup, CopyClassRefactoringUI.factory(lookup));
        UIUtilities.runWhenScanFinished(task, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.copyAction()));
    }

    public boolean canCopy(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        FileObject fo = RefactoringActionsProvider.getTarget(lookup);
        if (fo != null) {
            if (!fo.isFolder()) {
                return false;
            }
            if (!JavaRefactoringUtils.isOnSourceClasspath(fo) || RefactoringUtils.isIndexedSourceLauncherFile(fo)) {
                return false;
            }
        }
        boolean result = true;
        boolean hasJava = false;
        for (Node n : nodes) {
            DataObject dob = (DataObject)n.getLookup().lookup(DataObject.class);
            if (dob == null || dob.getPrimaryFile().isFolder()) {
                result = false;
                break;
            }
            if (!RefactoringUtils.isJavaFile(dob.getPrimaryFile())) continue;
            hasJava = true;
            if (ClassPath.getClassPath((FileObject)dob.getPrimaryFile(), (String)"classpath/source") != null) continue;
            result = false;
            break;
        }
        return result && hasJava;
    }

    public boolean canFindUsages(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        Node n = (Node)nodes.iterator().next();
        TreePathHandle handle = (TreePathHandle)n.getLookup().lookup(TreePathHandle.class);
        if (handle != null && handle.getFileObject() != null) {
            return true;
        }
        DataObject dob = (DataObject)n.getLookup().lookup(DataObject.class);
        return dob != null && RefactoringUtils.isJavaFile(dob.getPrimaryFile()) && !"package-info".equals(dob.getName());
    }

    public void doFindUsages(Lookup lookup) {
        Runnable task = ContextAnalyzer.createTask(lookup, WhereUsedQueryUI.factory());
        task.run();
    }

    public boolean canDelete(Lookup lookup) {
        if (SourceUtils.isScanInProgress()) {
            return false;
        }
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (RefactoringActionsProvider.isSelectionHeterogeneous(nodes)) {
            return false;
        }
        for (Node n : nodes) {
            TreePathHandle tph = (TreePathHandle)n.getLookup().lookup(TreePathHandle.class);
            if (tph != null) {
                return JavaRefactoringUtils.isRefactorable(tph.getFileObject());
            }
            DataObject dataObject = (DataObject)n.getCookie(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            if (RefactoringActionsProvider.isRefactorableFolder(dataObject)) {
                return true;
            }
            if (JavaRefactoringUtils.isRefactorable(fileObject)) continue;
            return false;
        }
        return !nodes.isEmpty();
    }

    public void doDelete(Lookup lookup) {
        Runnable task = ContextAnalyzer.createTask(lookup, SafeDeleteUI.factory(lookup));
        UIUtilities.runWhenScanFinished(task, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.safeDeleteAction()));
    }

    public static FileObject getTarget(Lookup look) {
        ExplorerContext drop = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (drop == null) {
            return null;
        }
        Node n = drop.getTargetNode();
        if (n == null) {
            return null;
        }
        DataObject dob = (DataObject)n.getCookie(DataObject.class);
        if (dob != null) {
            return dob.getPrimaryFile();
        }
        return null;
    }

    public static PasteType getPaste(Lookup look) {
        ExplorerContext drop = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (drop == null) {
            return null;
        }
        Transferable orig = drop.getTransferable();
        if (orig == null) {
            return null;
        }
        Node n = drop.getTargetNode();
        if (n == null) {
            return null;
        }
        PasteType[] pt = n.getPasteTypes(orig);
        if (pt.length == 1) {
            return null;
        }
        return pt[1];
    }

    static String getName(Lookup look) {
        ExplorerContext ren = (ExplorerContext)look.lookup(ExplorerContext.class);
        if (ren == null) {
            return null;
        }
        return ren.getNewName();
    }

    public boolean canMove(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        ExplorerContext drop = (ExplorerContext)lookup.lookup(ExplorerContext.class);
        FileObject fo = RefactoringActionsProvider.getTarget(lookup);
        if (fo != null) {
            if (!fo.isFolder()) {
                return false;
            }
            if (!JavaRefactoringUtils.isOnSourceClasspath(fo) || RefactoringUtils.isIndexedSourceLauncherFile(fo)) {
                return false;
            }
            HashSet<DataFolder> folders = new HashSet<DataFolder>();
            boolean jdoFound = false;
            for (Node n : nodes) {
                DataObject dob = (DataObject)n.getCookie(DataObject.class);
                if (dob == null) {
                    return false;
                }
                if (!JavaRefactoringUtils.isOnSourceClasspath(dob.getPrimaryFile()) || RefactoringUtils.isIndexedSourceLauncherFile(dob.getPrimaryFile())) {
                    return false;
                }
                if (dob instanceof DataFolder) {
                    if (FileUtil.getRelativePath((FileObject)dob.getPrimaryFile(), (FileObject)fo) != null) {
                        return false;
                    }
                    folders.add((DataFolder)dob);
                    continue;
                }
                if (!RefactoringUtils.isJavaFile(dob.getPrimaryFile())) continue;
                jdoFound = true;
            }
            if (jdoFound) {
                return true;
            }
            for (DataFolder fold : folders) {
                Enumeration e = fold.children(true);
                while (e.hasMoreElements()) {
                    if (!RefactoringUtils.isJavaFile(((DataObject)e.nextElement()).getPrimaryFile())) continue;
                    return true;
                }
            }
            return false;
        }
        boolean result = false;
        block3: for (Node n : nodes) {
            DataObject dob = (DataObject)n.getCookie(DataObject.class);
            if (dob == null) {
                return false;
            }
            if (dob instanceof DataFolder) {
                if (drop == null) {
                    return false;
                }
                if (!JavaRefactoringUtils.isOnSourceClasspath(dob.getPrimaryFile()) || RefactoringUtils.isClasspathRoot(dob.getPrimaryFile()) || RefactoringUtils.isIndexedSourceLauncherFile(dob.getPrimaryFile())) {
                    return false;
                }
                LinkedList<DataFolder> folders = new LinkedList<DataFolder>();
                folders.add((DataFolder)dob);
                while (!folders.isEmpty()) {
                    DataFolder fold = (DataFolder)folders.remove();
                    Enumeration e = fold.children(true);
                    while (e.hasMoreElements()) {
                        if (RefactoringUtils.isJavaFile(((DataObject)e.nextElement()).getPrimaryFile())) {
                            result = true;
                            continue block3;
                        }
                        if (!(e instanceof DataFolder)) continue;
                        folders.add((DataFolder)e);
                    }
                }
            }
            if (!JavaRefactoringUtils.isOnSourceClasspath(dob.getPrimaryFile()) || RefactoringUtils.isIndexedSourceLauncherFile(dob.getPrimaryFile())) {
                return false;
            }
            if (!RefactoringUtils.isJavaFile(dob.getPrimaryFile())) continue;
            result = true;
        }
        return result;
    }

    public void doMove(Lookup lookup) {
        Runnable task = ContextAnalyzer.createTask(lookup, MoveClassUI.factory(lookup));
        UIUtilities.runWhenScanFinished(task, RefactoringActionsProvider.getActionName((Action)RefactoringActionsFactory.moveAction()));
    }

    private static boolean isSelectionHeterogeneous(Collection<? extends Node> nodes) {
        boolean folderSelected = false;
        boolean nonFolderNodeSelected = false;
        for (Node node : nodes) {
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null) continue;
            if (RefactoringActionsProvider.isRefactorableFolder(dataObject)) {
                if (folderSelected || nonFolderNodeSelected) {
                    return true;
                }
                folderSelected = true;
                continue;
            }
            nonFolderNodeSelected = true;
        }
        return false;
    }

    private static boolean isRefactorableFolder(DataObject dataObject) {
        FileObject[] children;
        FileObject fileObject = dataObject.getPrimaryFile();
        if (!(Boolean.TRUE.equals(fileObject.getAttribute("isRemoteAndSlow")) || (children = fileObject.getChildren()) != null && children.length > 0)) {
            return false;
        }
        return dataObject instanceof DataFolder && RefactoringUtils.isFileInOpenProject(fileObject) && JavaRefactoringUtils.isOnSourceClasspath(fileObject) && !RefactoringUtils.isClasspathRoot(fileObject);
    }
}

