/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.actions.ImportModulePanel;
import org.netbeans.modules.php.editor.actions.PopupUtil;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FastImportAction
extends BaseAction {
    private static final String ACTION_NAME = "fast-import";

    public FastImportAction() {
        super(ACTION_NAME);
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        try {
            final Rectangle caretRectangle = target.modelToView(target.getCaretPosition());
            final Font font = target.getFont();
            final Point where = new Point(caretRectangle.x, caretRectangle.y + caretRectangle.height);
            SwingUtilities.convertPointToScreen(where, target);
            final int position = target.getCaretPosition();
            try {
                ParserManager.parse(Collections.singleton(Source.create((Document)target.getDocument())), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        ParserResult info = (ParserResult)resultIterator.getParserResult();
                        if (info != null) {
                            FastImportAction.this.importItem(info, where, caretRectangle, font, position);
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private void importItem(final ParserResult info, final Point where, final Rectangle caretRectangle, final Font font, final int position) {
        PHPParseResult result = (PHPParseResult)info;
        Model model = result.getModel();
        OccurencesSupport occurencesSupport = model.getOccurencesSupport(position);
        Occurence occurence = occurencesSupport.getOccurence();
        if (occurence != null) {
            FileObject baseFo = info.getSnapshot().getSource().getFileObject();
            File baseFile = FileUtil.toFile((FileObject)baseFo);
            File baseFolder = baseFile.getParentFile();
            final LinkedHashSet<CallSite> privileged = new LinkedHashSet<CallSite>();
            final LinkedHashSet denied = new LinkedHashSet();
            Collection<? extends PhpElement> allDeclarations = occurence.getAllDeclarations();
            for (PhpElement phpElement : allDeclarations) {
                String elementInfo;
                FileObject includedFo = phpElement.getFileObject();
                File includedFile = FileUtil.toFile((FileObject)includedFo);
                PhpSourcePath.FileType fileType = PhpSourcePath.getFileType((FileObject)includedFo);
                String relativizeFile = PropertyUtils.relativizeFile((File)baseFolder, (File)includedFile);
                StringBuilder sb = new StringBuilder();
                String properRelativePath = relativizeFile != null && relativizeFile.startsWith(".") ? relativizeFile : "./" + relativizeFile;
                sb.append("\"").append(properRelativePath).append("\";");
                if (fileType.equals((Object)PhpSourcePath.FileType.INTERNAL)) {
                    elementInfo = phpElement.getPhpElementKind() + " " + phpElement.getName();
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(FastImportAction.class, (String)"MSG_NO_IMPORTS_FOR_PLATFORM", (Object)elementInfo));
                    continue;
                }
                if (baseFo == includedFo) {
                    elementInfo = phpElement.getPhpElementKind() + " " + phpElement.getName();
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(FastImportAction.class, (String)"MSG_NO_IMPORTS_FOR_CURRENT_FILE", (Object)elementInfo, (Object)baseFile.getAbsolutePath()));
                    continue;
                }
                LinkedHashSet<CallSite> list = privileged;
                list.add((CallSite)((Object)("require_once " + sb.toString())));
                list.add((CallSite)((Object)("require " + sb.toString())));
                list.add((CallSite)((Object)("include " + sb.toString())));
                list.add((CallSite)((Object)("include_once " + sb.toString())));
            }
            if (privileged.size() > 0 || denied.size() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportModulePanel panel = new ImportModulePanel(new ArrayList<String>(privileged), new ArrayList<String>(denied), font, info, position);
                        PopupUtil.showPopup(panel, "", where.x, where.y, true, caretRectangle.height);
                    }
                });
            }
        }
    }
}

