/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayDimension;
import org.netbeans.modules.php.editor.parser.astnodes.DereferencedArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ArrayDimensionSyntaxSuggestionHint
extends HintRule {
    private static final String HINT_ID = "Array.Dimension.Syntax.Suggestion.Hint";
    private static final Logger LOGGER = Logger.getLogger(ArrayDimensionSyntaxSuggestionHint.class.getName());

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.ArrayDimensionSyntaxSuggestion_Description();
    }

    public String getDisplayName() {
        return Bundle.ArrayDimensionSyntaxSuggestion_DisplayName();
    }

    @Override
    public boolean getDefaultEnabled() {
        return false;
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        BaseDocument doc = context.doc;
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, this, doc);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    boolean isFixAllEnabled() {
        return true;
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final ArrayDimensionSyntaxSuggestionHint suggestion;
        private final BaseDocument document;
        private final List<FixInfo> fixInfos = new ArrayList<FixInfo>();

        public CheckVisitor(FileObject fileObject, ArrayDimensionSyntaxSuggestionHint suggestion, BaseDocument document) {
            this.fileObject = fileObject;
            this.suggestion = suggestion;
            this.document = document;
        }

        public List<Hint> getHints() {
            ArrayList<Hint> hints = new ArrayList<Hint>();
            int originalLineIndex = 0;
            for (FixInfo fixInfo : this.fixInfos) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return Collections.emptyList();
                }
                if (this.document.getLength() <= fixInfo.getOffsetRange().getStart()) continue;
                if (this.suggestion.isFixAllEnabled()) {
                    try {
                        int lineIndex = LineDocumentUtils.getLineIndex((LineDocument)this.document, (int)fixInfo.getOffsetRange().getStart());
                        if (originalLineIndex != lineIndex) {
                            int lineStart = LineDocumentUtils.getLineStart((LineDocument)this.document, (int)fixInfo.getOffsetRange().getStart());
                            int lineEnd = LineDocumentUtils.getLineEnd((LineDocument)this.document, (int)fixInfo.getOffsetRange().getStart());
                            this.addHint(hints, new OffsetRange(lineStart, lineEnd), this.createAllFixes(this.fixInfos));
                            originalLineIndex = lineIndex;
                        }
                    }
                    catch (BadLocationException ex) {
                        String filePath = this.fileObject == null ? "no file" : FileUtil.toFile((FileObject)this.fileObject).getAbsolutePath();
                        LOGGER.log(Level.WARNING, "Invalid offset: {0} {1}", new Object[]{ex.offsetRequested(), filePath});
                    }
                }
                this.addHint(hints, fixInfo.getOffsetRange(), this.createFixes(fixInfo));
            }
            return hints;
        }

        private void addHint(List<Hint> hints, OffsetRange offsetRange, List<HintFix> fixes) {
            hints.add(new Hint((Rule)this.suggestion, Bundle.ArrayDimensionSyntaxSuggestion_Hint_Description(), this.fileObject, offsetRange, fixes, 500));
        }

        private List<HintFix> createFixes(FixInfo fixInfo) {
            ArrayList<HintFix> hintFixes = new ArrayList<HintFix>();
            hintFixes.add(fixInfo.createFix(this.document));
            return hintFixes;
        }

        private List<HintFix> createAllFixes(List<FixInfo> fixInfos) {
            ArrayList<HintFix> hintFixes = new ArrayList<HintFix>();
            ArrayAccessingSyntaxSuggestionFix fix = new ArrayAccessingSyntaxSuggestionFix(fixInfos, this.document, true);
            hintFixes.add(fix);
            return hintFixes;
        }

        @Override
        public void visit(ArrayAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processArrayDimension(node.getDimension());
            super.visit(node);
        }

        @Override
        public void visit(DereferencedArrayAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processArrayDimension(node.getDimension());
            super.visit(node);
        }

        @Override
        public void visit(ExpressionArrayAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processArrayDimension(node.getDimension());
            super.visit(node);
        }

        private void processArrayDimension(ArrayDimension arrayDimension) {
            if (arrayDimension.getType() == ArrayDimension.Type.VARIABLE_HASHTABLE) {
                int startOffset = arrayDimension.getStartOffset();
                int endOffset = arrayDimension.getEndOffset();
                OffsetRange headRange = new OffsetRange(startOffset, startOffset + 1);
                OffsetRange tailRange = new OffsetRange(endOffset - 1, endOffset);
                this.fixInfos.add(new FixInfo(headRange, tailRange, new OffsetRange(startOffset, endOffset)));
            }
        }
    }

    private static final class ArrayAccessingSyntaxSuggestionFix
    implements HintFix {
        private final List<FixInfo> fixInfos;
        private final BaseDocument document;
        private final boolean isAll;

        private ArrayAccessingSyntaxSuggestionFix(List<FixInfo> fixInfos, BaseDocument document) {
            this(fixInfos, document, false);
        }

        private ArrayAccessingSyntaxSuggestionFix(List<FixInfo> fixInfos, BaseDocument document, boolean isAll) {
            this.fixInfos = fixInfos;
            this.document = document;
            this.isAll = isAll;
        }

        public String getDescription() {
            if (this.isAll) {
                return Bundle.ArrayDimensionSyntaxSuggestion_Fix_All_Description();
            }
            assert (!this.fixInfos.isEmpty());
            FixInfo fixInfo = this.fixInfos.get(0);
            String arrayDimension = "";
            if (this.document.getLength() >= fixInfo.getOffsetRange().getEnd()) {
                try {
                    arrayDimension = this.document.getText(fixInfo.getOffsetRange().getStart(), fixInfo.getOffsetRange().getLength());
                }
                catch (BadLocationException ex) {
                    LOGGER.log(Level.WARNING, "Invalid offset: {0}", ex.offsetRequested());
                }
            }
            assert (!arrayDimension.isEmpty());
            return Bundle.ArrayDimensionSyntaxSuggestion_Fix_Description(arrayDimension);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.document);
            for (FixInfo fixInfo : this.fixInfos) {
                OffsetRange headRange = fixInfo.getHeadRange();
                edits.replace(headRange.getStart(), headRange.getLength(), "[", false, 0);
                OffsetRange tailRange = fixInfo.getTailRange();
                edits.replace(tailRange.getStart(), tailRange.getLength(), "]", false, 0);
            }
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class FixInfo {
        private final OffsetRange headRange;
        private final OffsetRange tailRange;
        private final OffsetRange offsetRange;

        public FixInfo(OffsetRange headRange, OffsetRange tailRange, OffsetRange offsetRange) {
            this.headRange = headRange;
            this.tailRange = tailRange;
            this.offsetRange = offsetRange;
        }

        public OffsetRange getHeadRange() {
            return this.headRange;
        }

        public OffsetRange getTailRange() {
            return this.tailRange;
        }

        public OffsetRange getOffsetRange() {
            return this.offsetRange;
        }

        private HintFix createFix(BaseDocument document) {
            return new ArrayAccessingSyntaxSuggestionFix(Collections.singletonList(this), document);
        }
    }
}

