/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.URI;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.editor.bookmarks.BookmarkChange;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.BookmarkManager;
import org.netbeans.modules.editor.bookmarks.FileBookmarksChange;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarksChange;

public final class BookmarkManagerEvent
extends EventObject {
    private final Map<URI, ProjectBookmarksChange> projectBookmarksChanges;
    private final boolean structureChange;
    private Map<BookmarkInfo, BookmarkChange> bookmarkChanges;

    BookmarkManagerEvent(BookmarkManager boookmarkManager, Map<URI, ProjectBookmarksChange> projectBookmarksChanges, boolean structureChange) {
        super(boookmarkManager);
        assert (projectBookmarksChanges != null) : "Null bookmarkChanges";
        this.projectBookmarksChanges = projectBookmarksChanges;
        this.structureChange = structureChange;
    }

    public Collection<ProjectBookmarksChange> getProjectBookmarksChanges() {
        return this.projectBookmarksChanges.values();
    }

    public ProjectBookmarksChange getProjectBookmarksChange(URI projectURI) {
        return this.projectBookmarksChanges.get(projectURI);
    }

    public boolean isStructureChange() {
        return this.structureChange;
    }

    public synchronized BookmarkChange getChange(BookmarkInfo bookmark) {
        if (this.bookmarkChanges == null) {
            this.bookmarkChanges = new HashMap<BookmarkInfo, BookmarkChange>();
            for (ProjectBookmarksChange prjChange : this.projectBookmarksChanges.values()) {
                for (FileBookmarksChange fileChange : prjChange.getFileBookmarksChanges()) {
                    for (BookmarkChange change : fileChange.getBookmarkChanges()) {
                        BookmarkChange o = this.bookmarkChanges.put(change.getBookmark(), change);
                        if (o == null) continue;
                        throw new IllegalStateException("Bookmark contained in multiple changes: " + change.getBookmark());
                    }
                }
            }
        }
        return this.bookmarkChanges.get(bookmark);
    }
}

