/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.Locations;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public abstract class BaseFileManager
implements JavaFileManager {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    public Log log;
    protected Charset charset;
    protected Options options;
    protected Lint lint;
    protected final Locations locations;
    private final HashSet<Path> outputFilesWritten = new HashSet();
    public boolean autoClose;
    private long lastUsedTime = System.currentTimeMillis();
    protected long deferredCloseTimeout = 0L;
    protected static final Set<Option> javacFileManagerOptions = Option.getJavacFileManagerOptions();
    protected String multiReleaseValue;
    private String encodingName;
    private String defaultEncodingName;
    private byte[] byteArrayCache;
    protected final Map<JavaFileObject, ContentCacheEntry> contentCache = new HashMap<JavaFileObject, ContentCacheEntry>();

    protected BaseFileManager(Charset charset) {
        this.charset = charset;
        this.locations = this.createLocations();
    }

    public void setContext(Context context) {
        this.log = Log.instance(context);
        this.lint = Lint.instance(context);
        this.options = Options.instance(context);
        this.locations.update(this.log, this.lint, FSInfo.instance(context));
        this.options.whenReady(this::applyOptions);
    }

    protected void applyOptions(Options options) {
        String s = options.get("fileManager.deferClose");
        if (s != null) {
            try {
                this.deferredCloseTimeout = (int)(Float.parseFloat(s) * 1000.0f);
            }
            catch (NumberFormatException e) {
                this.deferredCloseTimeout = 60000L;
            }
        }
    }

    protected Locations createLocations() {
        return new Locations();
    }

    protected void deferredClose() {
        Thread t = new Thread(this.getClass().getName() + " DeferredClose"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BaseFileManager baseFileManager = BaseFileManager.this;
                    synchronized (baseFileManager) {
                        long now = System.currentTimeMillis();
                        while (now < BaseFileManager.this.lastUsedTime + BaseFileManager.this.deferredCloseTimeout) {
                            BaseFileManager.this.wait(BaseFileManager.this.lastUsedTime + BaseFileManager.this.deferredCloseTimeout - now);
                            now = System.currentTimeMillis();
                        }
                        BaseFileManager.this.deferredCloseTimeout = 0L;
                        BaseFileManager.this.close();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    synchronized void updateLastUsedTime() {
        if (this.deferredCloseTimeout > 0L) {
            this.lastUsedTime = System.currentTimeMillis();
        }
    }

    public void clear() {
        new HashSet<String>(this.options.keySet()).forEach(k -> this.options.remove((String)k));
    }

    protected ClassLoader getClassLoader(URL[] urls) {
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        String classLoaderClass = this.options.get("procloader");
        if (classLoaderClass != null) {
            try {
                Class<ClassLoader> loader = Class.forName(classLoaderClass).asSubclass(ClassLoader.class);
                Class[] constrArgTypes = new Class[]{URL[].class, ClassLoader.class};
                Constructor<ClassLoader> constr = loader.getConstructor(constrArgTypes);
                return constr.newInstance(urls, thisClassLoader);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new URLClassLoader(urls, thisClassLoader);
    }

    public boolean isDefaultBootClassPath() {
        return this.locations.isDefaultBootClassPath();
    }

    public boolean isDefaultSystemModulesPath() {
        return this.locations.isDefaultSystemModulesPath();
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        OptionHelper.GrumpyHelper helper = new OptionHelper.GrumpyHelper(this.log){

            @Override
            public String get(Option option) {
                return BaseFileManager.this.options.get(option);
            }

            @Override
            public void put(String name, String value) {
                BaseFileManager.this.options.put(name, value);
            }

            @Override
            public void remove(String name) {
                BaseFileManager.this.options.remove(name);
            }

            @Override
            public boolean handleFileManagerOption(Option option, String value) {
                return BaseFileManager.this.handleOption(option, value);
            }

            @Override
            public void initialize() {
                BaseFileManager.this.options.initialize();
            }
        };
        Option o = Option.lookup(current, javacFileManagerOptions);
        if (o == null) {
            return false;
        }
        try {
            o.handleOption(helper, current, remaining);
        }
        catch (Option.InvalidValueException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return true;
    }

    @Override
    public int isSupportedOption(String option) {
        Option o = Option.lookup(option, javacFileManagerOptions);
        return o == null ? -1 : (o.hasArg() ? 1 : 0);
    }

    public boolean handleOption(Option option, String value) {
        switch (option) {
            case ENCODING: {
                this.encodingName = value;
                return true;
            }
            case MULTIRELEASE: {
                this.multiReleaseValue = value;
                this.locations.setMultiReleaseValue(value);
                return true;
            }
        }
        return this.locations.handleOption(option, value);
    }

    public boolean handleOptions(Map<Option, String> map) {
        boolean ok = true;
        for (Map.Entry<Option, String> e : map.entrySet()) {
            try {
                ok &= this.handleOption(e.getKey(), e.getValue());
            }
            catch (IllegalArgumentException ex) {
                this.log.error(CompilerProperties.Errors.IllegalArgumentForOption(e.getKey().getPrimaryName(), ex.getMessage()));
                ok = false;
            }
        }
        return ok;
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = Charset.defaultCharset().name();
        }
        return this.defaultEncodingName;
    }

    public String getEncodingName() {
        return this.encodingName != null ? this.encodingName : this.getDefaultEncodingName();
    }

    public CharBuffer decode(ByteBuffer inbuf, boolean ignoreEncodingErrors) {
        CoderResult result;
        CharsetDecoder decoder;
        String encName = this.getEncodingName();
        try {
            decoder = this.getDecoder(encName, ignoreEncodingErrors);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            this.log.error(CompilerProperties.Errors.UnsupportedEncoding(encName));
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float factor = decoder.averageCharsPerByte() * 0.8f + decoder.maxCharsPerByte() * 0.2f;
        CharBuffer dest = CharBuffer.allocate(10 + (int)((float)inbuf.remaining() * factor));
        while (true) {
            result = decoder.decode(inbuf, dest, true);
            dest.flip();
            if (result.isUnderflow()) {
                if (dest.limit() == dest.capacity()) {
                    dest = CharBuffer.allocate(dest.capacity() + 1).put(dest);
                    dest.flip();
                }
                return dest;
            }
            if (result.isOverflow()) {
                int newCapacity = 10 + dest.capacity() + (int)((float)inbuf.remaining() * decoder.maxCharsPerByte());
                dest = CharBuffer.allocate(newCapacity).put(dest);
                continue;
            }
            if (!result.isMalformed() && !result.isUnmappable()) break;
            StringBuilder unmappable = new StringBuilder();
            int len = result.length();
            for (int i = 0; i < len; ++i) {
                unmappable.append(String.format("%02X", inbuf.get()));
            }
            String charsetName = this.charset == null ? encName : this.charset.name();
            this.log.error(dest.limit(), CompilerProperties.Errors.IllegalCharForEncoding(unmappable.toString(), charsetName));
            dest.position(dest.limit());
            dest.limit(dest.capacity());
            dest.put('\ufffd');
        }
        throw new AssertionError(result);
    }

    public CharsetDecoder getDecoder(String encodingName, boolean ignoreEncodingErrors) {
        Charset cs = this.charset == null ? Charset.forName(encodingName) : this.charset;
        CharsetDecoder decoder = cs.newDecoder();
        CodingErrorAction action = ignoreEncodingErrors ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return decoder.onMalformedInput(action).onUnmappableCharacter(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer makeByteBuffer(InputStream in) throws IOException {
        byte[] array;
        BaseFileManager baseFileManager = this;
        synchronized (baseFileManager) {
            array = this.byteArrayCache;
            if (this.byteArrayCache != null) {
                this.byteArrayCache = null;
            } else {
                array = EMPTY_ARRAY;
            }
        }
        com.sun.tools.javac.util.ByteBuffer buf = new com.sun.tools.javac.util.ByteBuffer(array);
        buf.appendStream(in);
        return buf.asByteBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycleByteBuffer(ByteBuffer buf) {
        if (buf.hasArray()) {
            BaseFileManager baseFileManager = this;
            synchronized (baseFileManager) {
                this.byteArrayCache = buf.array();
            }
        }
    }

    public CharBuffer getCachedContent(JavaFileObject file) {
        ContentCacheEntry e = this.contentCache.get(file);
        if (e == null) {
            return null;
        }
        if (!e.isValid(file)) {
            this.contentCache.remove(file);
            return null;
        }
        return e.getValue();
    }

    public void cache(JavaFileObject file, CharBuffer cb) {
        this.contentCache.put(file, new ContentCacheEntry(file, cb));
    }

    public void flushCache(JavaFileObject file) {
        this.contentCache.remove(file);
    }

    public synchronized void resetOutputFilesWritten() {
        this.outputFilesWritten.clear();
    }

    public static JavaFileObject.Kind getKind(Path path) {
        return BaseFileManager.getKind(path.getFileName().toString());
    }

    public static JavaFileObject.Kind getKind(String name) {
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (name.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (name.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    protected static <T> T nullCheck(T o) {
        return Objects.requireNonNull(o);
    }

    protected static <T> Collection<T> nullCheck(Collection<T> it) {
        for (T t : it) {
            Objects.requireNonNull(t);
        }
        return it;
    }

    synchronized void newOutputToPath(Path path) throws IOException {
        Path realPath;
        if (!this.lint.isEnabled(Lint.LintCategory.OUTPUT_FILE_CLASH)) {
            return;
        }
        try {
            realPath = path.toRealPath(new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            return;
        }
        if (!this.outputFilesWritten.add(realPath)) {
            this.log.warning(CompilerProperties.LintWarnings.OutputFileClash(path));
        }
    }

    protected static class ContentCacheEntry {
        final long timestamp;
        final SoftReference<CharBuffer> ref;

        ContentCacheEntry(JavaFileObject file, CharBuffer cb) {
            this.timestamp = file.getLastModified();
            this.ref = new SoftReference<CharBuffer>(cb);
        }

        boolean isValid(JavaFileObject file) {
            return this.timestamp == file.getLastModified();
        }

        CharBuffer getValue() {
            return this.ref.get();
        }
    }
}

