/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.tomlj.MutableTomlArray;
import org.tomlj.Parser;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseError;
import org.tomlj.TomlPosition;
import org.tomlj.TomlTable;
import org.tomlj.TomlType;
import org.tomlj.TomlVersion;

final class MutableTomlTable
implements TomlTable {
    private final Map<String, Element> properties = new LinkedHashMap<String, Element>();
    private final TomlVersion version;
    private TomlPosition definedAt;

    MutableTomlTable(TomlVersion version, TomlPosition definedAt) {
        this.version = version;
        this.definedAt = definedAt;
    }

    MutableTomlTable(TomlVersion version) {
        this.version = version;
        this.definedAt = null;
    }

    boolean isDefined() {
        return this.definedAt != null;
    }

    void define(TomlPosition position) {
        this.definedAt = position;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Set<List<String>> keyPathSet(boolean includeTables) {
        return this.properties.entrySet().stream().flatMap(entry -> {
            String key = (String)entry.getKey();
            List<String> basePath = Collections.singletonList(key);
            Element element = (Element)entry.getValue();
            if (!(element.value instanceof TomlTable)) {
                return Stream.of(basePath);
            }
            Stream<List> subKeys = ((TomlTable)element.value).keyPathSet(includeTables).stream().map(subPath -> {
                ArrayList<String> path = new ArrayList<String>(subPath.size() + 1);
                path.add(key);
                path.addAll((Collection<String>)subPath);
                return path;
            });
            if (includeTables) {
                return Stream.concat(Stream.of(basePath), subKeys);
            }
            return subKeys;
        }).collect(Collectors.toSet());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, Object>((String)entry.getKey(), ((Element)entry.getValue()).value)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<Map.Entry<List<String>, Object>> entryPathSet(boolean includeTables) {
        return this.properties.entrySet().stream().flatMap(entry -> {
            String key = (String)entry.getKey();
            List<String> entryPath = Collections.singletonList(key);
            Element element = (Element)entry.getValue();
            if (!(element.value instanceof TomlTable)) {
                return Stream.of(new AbstractMap.SimpleEntry<List<String>, Object>(entryPath, element.value));
            }
            Stream<Map.Entry> subEntries = ((TomlTable)element.value).entryPathSet(includeTables).stream().map(subEntry -> {
                List subPath = (List)subEntry.getKey();
                ArrayList<String> path = new ArrayList<String>(subPath.size() + 1);
                path.add(key);
                path.addAll(subPath);
                return new AbstractMap.SimpleEntry(path, subEntry.getValue());
            });
            if (includeTables) {
                return Stream.concat(Stream.of(new AbstractMap.SimpleEntry<List<String>, Object>(entryPath, element.value)), subEntries);
            }
            return subEntries;
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public @Nullable Object get(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        Element element = this.getElement(path);
        return element != null ? element.value : null;
    }

    @Override
    public @Nullable TomlPosition inputPositionOf(List<String> path) {
        if (path.isEmpty()) {
            return TomlPosition.positionAt(1, 1);
        }
        Element element = this.getElement(path);
        return element != null ? element.position : null;
    }

    private Element getElement(List<String> path) {
        MutableTomlTable table = this;
        int depth = path.size();
        assert (depth > 0);
        for (int i = 0; i < depth - 1; ++i) {
            Element element = table.properties.get(path.get(i));
            if (element == null) {
                return null;
            }
            if (!(element.value instanceof MutableTomlTable)) {
                return null;
            }
            table = (MutableTomlTable)element.value;
        }
        return table.properties.get(path.get(depth - 1));
    }

    @Override
    public Map<String, Object> toMap() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Element)e.getValue()).value));
    }

    MutableTomlTable createTable(List<String> path, TomlPosition position) {
        MutableTomlTable subTable;
        if (path.isEmpty()) {
            return this;
        }
        int depth = path.size();
        MutableTomlTable table = this.ensureTable(path.subList((int)0, (int)(depth - 1)), (TomlPosition)position, (boolean)true, (boolean)true).table;
        String key = path.get(depth - 1);
        Element element = table.properties.get(key);
        if (element == null) {
            MutableTomlTable newTable = new MutableTomlTable(this.version, position);
            table.properties.put(key, new Element(newTable, position));
            return newTable;
        }
        if (element.value instanceof MutableTomlTable && !(subTable = (MutableTomlTable)element.value).isDefined()) {
            subTable.define(position);
            table.properties.put(key, new Element(subTable, position));
            return subTable;
        }
        String message = Toml.joinKeyPath(path) + " previously defined at " + element.position;
        throw new TomlParseError(message, position);
    }

    MutableTomlTable createTableArray(List<String> path, TomlPosition position) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("empty path");
        }
        int depth = path.size();
        MutableTomlTable table = this.ensureTable(path.subList((int)0, (int)(depth - 1)), (TomlPosition)position, (boolean)true, (boolean)true).table;
        String key = path.get(depth - 1);
        Element element = table.properties.computeIfAbsent(key, k -> new Element(MutableTomlArray.create(this.version, true), position));
        if (!(element.value instanceof TomlArray)) {
            String message = Toml.joinKeyPath(path) + " is not an array (previously defined at " + element.position + ")";
            throw new TomlParseError(message, position);
        }
        if (!(element.value instanceof MutableTomlArray) || !((MutableTomlArray)element.value).isTableArray()) {
            String message = Toml.joinKeyPath(path) + " previously defined as a literal array at " + element.position;
            throw new TomlParseError(message, position);
        }
        MutableTomlArray array = (MutableTomlArray)element.value;
        MutableTomlTable newTable = new MutableTomlTable(this.version);
        array.append(newTable, position);
        return newTable;
    }

    List<AbstractMap.SimpleEntry<MutableTomlTable, TomlPosition>> set(String keyPath, Object value, TomlPosition position) {
        return this.set(Parser.parseDottedKey(keyPath), value, position);
    }

    List<AbstractMap.SimpleEntry<MutableTomlTable, TomlPosition>> set(List<String> path, Object value, TomlPosition position) {
        int depth = path.size();
        assert (depth > 0);
        if (value instanceof Integer) {
            value = ((Integer)value).longValue();
        }
        assert (TomlType.typeFor(value).isPresent()) : "Unexpected value of type " + value.getClass();
        EnsureTableResult result = this.ensureTable(path.subList(0, depth - 1), position, false, false);
        MutableTomlTable table = result.table;
        Element prevElem = table.properties.putIfAbsent(path.get(depth - 1), new Element(value, position));
        if (prevElem != null) {
            String pathString = Toml.joinKeyPath(path);
            String message = pathString + " previously defined at " + prevElem.position;
            throw new TomlParseError(message, position);
        }
        return result.intermediates;
    }

    private EnsureTableResult ensureTable(List<String> path, TomlPosition position, boolean followTableArrays, boolean followDefinedTables) {
        MutableTomlTable table = this;
        int depth = path.size();
        if (depth == 0) {
            return new EnsureTableResult(table, Collections.emptyList());
        }
        ArrayList<AbstractMap.SimpleEntry<MutableTomlTable, TomlPosition>> elements = new ArrayList<AbstractMap.SimpleEntry<MutableTomlTable, TomlPosition>>();
        for (int i = 0; i < depth; ++i) {
            MutableTomlArray array;
            String message;
            Element element = table.properties.computeIfAbsent(path.get(i), k -> new Element(new MutableTomlTable(this.version), position));
            if (element.value instanceof MutableTomlTable) {
                table = (MutableTomlTable)element.value;
                if (!followDefinedTables && table.definedAt != null) {
                    message = Toml.joinKeyPath(path.subList(0, i + 1)) + " already defined at " + table.definedAt;
                    throw new TomlParseError(message, position);
                }
                elements.add(new AbstractMap.SimpleEntry<MutableTomlTable, TomlPosition>(table, element.position));
                continue;
            }
            if (element.value instanceof TomlTable) {
                message = Toml.joinKeyPath(path.subList(0, i + 1)) + " is not a table (previously defined at " + element.position + ")";
                throw new TomlParseError(message, position);
            }
            if (followTableArrays && element.value instanceof MutableTomlArray && (array = (MutableTomlArray)element.value).isTableArray()) {
                assert (!array.isEmpty());
                table = (MutableTomlTable)array.get(array.size() - 1);
                elements.add(new AbstractMap.SimpleEntry<MutableTomlTable, TomlPosition>(table, element.position));
                continue;
            }
            message = Toml.joinKeyPath(path.subList(0, i + 1)) + " is not a table (previously defined at " + element.position + ")";
            throw new TomlParseError(message, position);
        }
        return new EnsureTableResult(table, elements);
    }

    private static class Element {
        final Object value;
        final TomlPosition position;

        private Element(Object value, TomlPosition position) {
            this.value = value;
            this.position = position;
        }
    }

    private static class EnsureTableResult {
        final MutableTomlTable table;
        final List<AbstractMap.SimpleEntry<MutableTomlTable, TomlPosition>> intermediates;

        private EnsureTableResult(MutableTomlTable table, List<AbstractMap.SimpleEntry<MutableTomlTable, TomlPosition>> intermediates) {
            this.table = table;
            this.intermediates = intermediates;
        }
    }
}

