/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion.provider;

import groovy.lang.MetaMethod;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.swing.text.Document;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.reflection.CachedClass;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.completion.CaretLocation;
import org.netbeans.modules.groovy.editor.api.completion.CompletionHandler;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionContext;
import org.netbeans.modules.groovy.editor.api.completion.util.ContextHelper;
import org.netbeans.modules.groovy.editor.api.elements.ast.ASTMethod;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.completion.ProposalsCollector;
import org.netbeans.modules.groovy.editor.completion.provider.HTMLJavadocParser;
import org.netbeans.modules.groovy.editor.java.JavaElementHandle;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class GroovyCompletionImpl {
    private static final Logger LOG = Logger.getLogger(GroovyCompletionImpl.class.getName());
    private final PropertyChangeListener docListener;
    private String jdkJavaDocBase = null;
    private String groovyJavaDocBase = null;
    private String groovyApiDocBase = null;

    public GroovyCompletionImpl() {
        JavaPlatformManager platformMan = JavaPlatformManager.getDefault();
        JavaPlatform platform = platformMan.getDefaultPlatform();
        List docfolder = platform.getJavadocFolders();
        for (URL url : docfolder) {
            LOG.log(Level.FINEST, "JDK Doc path: {0}", url.toString());
            this.jdkJavaDocBase = url.toString();
        }
        GroovySettings groovySettings = GroovySettings.getInstance();
        this.docListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GroovyCompletionImpl groovyCompletionImpl = GroovyCompletionImpl.this;
                synchronized (groovyCompletionImpl) {
                    GroovyCompletionImpl.this.groovyJavaDocBase = null;
                    GroovyCompletionImpl.this.groovyApiDocBase = null;
                }
            }
        };
        groovySettings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.docListener, (Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionImplResult makeProposals(CodeCompletionContext completionContext) {
        ParserResult parserResult = completionContext.getParserResult();
        String prefix = completionContext.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        int lexOffset = completionContext.getCaretOffset();
        int astOffset = ASTUtils.getAstOffset((Parser.Result)parserResult, lexOffset);
        int anchor = lexOffset - prefix.length();
        LOG.log(Level.FINEST, "complete(...), prefix      : {0}", prefix);
        LOG.log(Level.FINEST, "complete(...), lexOffset   : {0}", lexOffset);
        LOG.log(Level.FINEST, "complete(...), astOffset   : {0}", astOffset);
        Document document = parserResult.getSnapshot().getSource().getDocument(false);
        if (document == null) {
            return null;
        }
        BaseDocument doc = (BaseDocument)document;
        doc.readLock();
        try {
            CompletionContext context = new CompletionContext(parserResult, prefix, anchor, lexOffset, astOffset, doc);
            context.init();
            if (context.location == CaretLocation.ABOVE_PACKAGE || context.location == CaretLocation.INSIDE_COMMENT) {
                CompletionImplResult completionImplResult = new CompletionImplResult(Collections.emptyList(), context);
                return completionImplResult;
            }
            ProposalsCollector proposalsCollector = new ProposalsCollector(context);
            if (ContextHelper.isVariableNameDefinition(context) || ContextHelper.isFieldNameDefinition(context)) {
                proposalsCollector.completeNewVars(context);
            } else {
                ClassNode sn;
                ClassNode realClass = null;
                if (context.rawDseclaringClass != null && context.rawDseclaringClass.getName().equals("java.lang.Class") && context.rawDseclaringClass.getGenericsTypes().length == 1) {
                    realClass = context.rawDseclaringClass.getGenericsTypes()[0].getType();
                    context.setAddSortOverride(510);
                }
                this.makeClassProposals(proposalsCollector, context);
                if (context.declaringClass != null && context.declaringClass.getName().equals("groovy.lang.GString") && (sn = ((GroovyParserResult)parserResult).resolveClassName("java.lang.String")) != null) {
                    context.setDeclaringClass(sn, false);
                    this.makeClassProposals(proposalsCollector, context);
                }
                if (realClass != null) {
                    context.setAddSortOverride(0);
                    context.setDeclaringClass(realClass, true);
                    context.init();
                    this.makeClassProposals(proposalsCollector, context);
                }
            }
            proposalsCollector.completeCamelCase(context);
            CompletionImplResult completionImplResult = new CompletionImplResult(proposalsCollector.getCollectedProposals(), context);
            return completionImplResult;
        }
        finally {
            doc.readUnlock();
        }
    }

    private void makeClassProposals(ProposalsCollector proposalsCollector, CompletionContext context) {
        if (context.location == CaretLocation.INSIDE_PACKAGE) {
            proposalsCollector.completePackages(context);
            return;
        }
        if (context.location != CaretLocation.OUTSIDE_CLASSES && context.location != CaretLocation.INSIDE_STRING) {
            proposalsCollector.completePackages(context);
            proposalsCollector.completeTypes(context);
        }
        if (!context.isBehindImportStatement()) {
            if (context.location != CaretLocation.INSIDE_STRING) {
                proposalsCollector.completeKeywords(context);
                proposalsCollector.completeMethods(context);
            }
            proposalsCollector.completeFields(context);
            proposalsCollector.completeLocalVars(context);
        }
        if (context.location == CaretLocation.INSIDE_CONSTRUCTOR_CALL && (ContextHelper.isAfterComma(context) || ContextHelper.isAfterLeftParenthesis(context))) {
            proposalsCollector.completeNamedParams(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroovyJavadocBase() {
        GroovyCompletionImpl groovyCompletionImpl = this;
        synchronized (groovyCompletionImpl) {
            if (this.groovyJavaDocBase == null) {
                String docroot = GroovySettings.getInstance().getGroovyDoc() + "/";
                this.groovyJavaDocBase = GroovyCompletionImpl.directoryNameToUrl(docroot + "groovy-jdk/");
            }
            return this.groovyJavaDocBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroovyApiDocBase() {
        GroovyCompletionImpl groovyCompletionImpl = this;
        synchronized (groovyCompletionImpl) {
            if (this.groovyApiDocBase == null) {
                String docroot = GroovySettings.getInstance().getGroovyDoc() + "/";
                this.groovyApiDocBase = GroovyCompletionImpl.directoryNameToUrl(docroot + "gapi/");
            }
            return this.groovyApiDocBase;
        }
    }

    private static String directoryNameToUrl(String dirname) {
        if (dirname == null) {
            return "";
        }
        File dirFile = new File(dirname);
        if (dirFile != null && dirFile.exists() && dirFile.isDirectory()) {
            String fileURL = "";
            if (Utilities.isWindows()) {
                dirname = dirname.replace("\\", "/");
                fileURL = "file:/";
            } else {
                fileURL = "file://";
            }
            return fileURL + dirname;
        }
        return "";
    }

    private static void printMethod(MetaMethod mm) {
        LOG.log(Level.FINEST, "--------------------------------------------------");
        LOG.log(Level.FINEST, "getName()           : {0}", mm.getName());
        LOG.log(Level.FINEST, "toString()          : {0}", mm.toString());
        LOG.log(Level.FINEST, "getDescriptor()     : {0}", mm.getDescriptor());
        LOG.log(Level.FINEST, "getSignature()      : {0}", mm.getSignature());
        LOG.log(Level.FINEST, "getDeclaringClass() : {0}", mm.getDeclaringClass());
    }

    public String document(ParserResult info, ElementHandle element) {
        LOG.log(Level.FINEST, "document(), ElementHandle : {0}", element);
        String error = NbBundle.getMessage(CompletionHandler.class, (String)"GroovyCompletion_NoJavaDocFound");
        Object doctext = null;
        if (element instanceof ASTMethod) {
            String className;
            ASTMethod ame = (ASTMethod)element;
            String base = "";
            String javadoc = this.getGroovyJavadocBase();
            if (this.jdkJavaDocBase != null && !ame.isGDK()) {
                base = this.jdkJavaDocBase;
            } else if (javadoc != null && ame.isGDK()) {
                base = javadoc;
            } else {
                LOG.log(Level.FINEST, "Neither JDK nor GDK or error locating: {0}", ame.isGDK());
                return error;
            }
            MetaMethod mm = ame.getMethod();
            GroovyCompletionImpl.printMethod(mm);
            if (ame.isGDK()) {
                className = mm.getDeclaringClass().getName();
            } else {
                CachedClass cc;
                String declName = null;
                if (mm != null && (cc = mm.getDeclaringClass()) != null) {
                    declName = cc.getName();
                }
                className = declName != null ? declName : ame.getClz().getName();
            }
            Object classNamePath = className.replace(".", "/");
            classNamePath = (String)classNamePath + ".html";
            if (!ame.isGDK()) {
                File testFile;
                String apiDoc = this.getGroovyApiDocBase();
                try {
                    URL url = new URL(apiDoc + (String)classNamePath);
                    testFile = new File(url.toURI());
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.FINEST, "MalformedURLException: {0}", ex);
                    return error;
                }
                catch (URISyntaxException uriEx) {
                    LOG.log(Level.FINEST, "URISyntaxException: {0}", uriEx);
                    return error;
                }
                if (testFile != null && testFile.exists()) {
                    base = apiDoc;
                }
            }
            String sig = CompletionHandler.getMethodSignature(ame.getMethod(), true, ame.isGDK());
            String printSig = CompletionHandler.getMethodSignature(ame.getMethod(), false, ame.isGDK());
            String urlName = base + (String)classNamePath + "#" + sig;
            try {
                LOG.log(Level.FINEST, "Trying to load URL = {0}", urlName);
                doctext = HTMLJavadocParser.getJavadocText(new URL(urlName), false, ame.isGDK());
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.FINEST, "document(), URL trouble: {0}", ex);
                return error;
            }
            if (doctext == null) {
                return error;
            }
            doctext = "<h3>" + className + "." + printSig + "</h3><BR>" + (String)doctext;
        }
        return doctext;
    }

    public Documentation documentElement(ParserResult info, ElementHandle handle, Callable<Boolean> cancel) {
        String s;
        if (handle instanceof JavaElementHandle) {
            ElementJavadoc jdoc;
            try {
                jdoc = ((JavaElementHandle)handle).extract(info, new JavaElementHandle.ElementFunction<ElementJavadoc>(){

                    @Override
                    public ElementJavadoc apply(CompilationInfo info, Element el) {
                        return ElementJavadoc.create((CompilationInfo)info, (Element)el);
                    }
                });
            }
            catch (IOException ex) {
                return null;
            }
            if (jdoc != null) {
                Future content = jdoc.getTextAsync();
                try {
                    Boolean b;
                    while ((b = cancel.call()) == null || !b.booleanValue()) {
                        try {
                            return Documentation.create((String)((String)content.get(250L, TimeUnit.MILLISECONDS)), (URL)jdoc.getURL());
                        }
                        catch (TimeoutException timeoutException) {
                        }
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
                return null;
            }
        }
        return (s = this.document(info, handle)) == null ? null : Documentation.create((String)s);
    }

    public static final class CompletionImplResult {
        List<CompletionProposal> proposals;
        CompletionContext groovyContext;

        public CompletionImplResult(List<CompletionProposal> proposals, CompletionContext groovyContext) {
            this.proposals = proposals;
            this.groovyContext = groovyContext;
        }

        public List<CompletionProposal> getProposals() {
            return this.proposals;
        }

        public CompletionContext getGroovyContext() {
            return this.groovyContext;
        }

        public boolean isEmpty() {
            return this.proposals == null || this.proposals.isEmpty();
        }
    }
}

