/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.editor;

import com.sun.source.util.TreePath;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.websvc.rest.editor.AsyncConverter;
import org.netbeans.modules.websvc.rest.editor.AsyncConverterTask;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AsynchronousGenerator
extends AsyncConverter
implements CodeGenerator {
    private final CompilationController controller;
    private final JTextComponent textComponent;

    private AsynchronousGenerator(CompilationController controller, JTextComponent component) {
        this.controller = controller;
        this.textComponent = component;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AsynchronousGenerator.class, (String)"LBL_ConvertMethod");
    }

    public void invoke() {
        if (!this.isApplicable(this.controller.getFileObject())) {
            Toolkit.getDefaultToolkit().beep();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(AsynchronousGenerator.class, (String)"MSG_NotJee7Profile"));
            return;
        }
        int position = this.textComponent.getCaret().getDot();
        TreePath tp = this.controller.getTreeUtilities().pathFor(position);
        Element contextElement = this.controller.getTrees().getElement(tp);
        if (contextElement == null || !this.isApplicable(contextElement)) {
            Toolkit.getDefaultToolkit().beep();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(AsynchronousGenerator.class, (String)"MSG_NotRestMethod"));
            return;
        }
        Element enclosingElement = contextElement.getEnclosingElement();
        TypeElement clazz = (TypeElement)enclosingElement;
        String fqn = clazz.getQualifiedName().toString();
        if (!this.checkRestMethod(fqn, contextElement, this.controller.getFileObject())) {
            Toolkit.getDefaultToolkit().beep();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(AsynchronousGenerator.class, (String)"MSG_NotRestMethod"));
            return;
        }
        if (this.isAsync(contextElement)) {
            Toolkit.getDefaultToolkit().beep();
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(AsynchronousGenerator.class, (String)"MSG_AsyncMethod"));
            return;
        }
        ElementHandle handle = ElementHandle.create((Element)contextElement);
        try {
            this.convertMethod((ElementHandle<Element>)handle, this.controller.getFileObject());
        }
        catch (IOException e) {
            Toolkit.getDefaultToolkit().beep();
            this.getLogger().log(Level.INFO, null, e);
        }
    }

    @Override
    protected Logger getLogger() {
        return Logger.getLogger(AsyncConverterTask.class.getName());
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            ArrayList<AsynchronousGenerator> ret = new ArrayList<AsynchronousGenerator>();
            if (controller != null) {
                try {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    FileObject targetSource = controller.getFileObject();
                    if (targetSource != null) {
                        JTextComponent targetComponent = (JTextComponent)context.lookup(JTextComponent.class);
                        AsynchronousGenerator gen = new AsynchronousGenerator(controller, targetComponent);
                        int position = targetComponent.getCaret().getDot();
                        TreePath tp = controller.getTreeUtilities().pathFor(position);
                        Element contextElement = controller.getTrees().getElement(tp);
                        if (contextElement != null && gen.isApplicable(contextElement)) {
                            ret.add(gen);
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return ret;
        }
    }
}

