/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.details;

import java.awt.Component;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.lib.profiler.charts.axis.TimeAxisUtils;
import org.netbeans.modules.profiler.snaptracer.impl.details.DetailsTableCellRenderer;

final class TimestampRenderer
extends DetailsTableCellRenderer {
    static final long REFERENCE_TIMESTAMP = 1268996399999L;
    private String formatString;
    private Format format;

    TimestampRenderer(TableCellRenderer renderer) {
        super(renderer);
    }

    @Override
    protected Object formatValue(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String valueString = this.format.format(value);
        return " " + valueString + " ";
    }

    @Override
    protected void updateRenderer(Component c, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.updateRenderer(c, table, value, isSelected, hasFocus, row, column);
        if (c instanceof JLabel) {
            ((JLabel)c).setHorizontalAlignment(11);
        }
    }

    boolean updateFormat(TableModel model) {
        long last;
        int rowCount = model.getRowCount();
        long first = rowCount > 0 ? (Long)model.getValueAt(0, 1) : 1268996399999L;
        String newFormatString = TimeAxisUtils.getFormatString((long)1L, (long)first, (long)(last = rowCount > 0 ? (Long)model.getValueAt(rowCount - 1, 1) : 1268996400000L));
        if (!newFormatString.equals(this.formatString)) {
            this.formatString = newFormatString;
            this.format = new SimpleDateFormat(this.formatString);
            return true;
        }
        return false;
    }
}

