/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.db.explorer.dlg.AddConnectionWizard;
import org.netbeans.modules.db.explorer.dlg.ConnectionNamePanel;
import org.openide.util.HelpCtx;

public class ChoosingConnectionNamePanel
implements AddConnectionWizard.Panel {
    private final int stepIndex;
    private ConnectionNamePanel component;
    private AddConnectionWizard pw;
    private static HelpCtx CHOOSING_SCHEMA_PANEL_HELPCTX = new HelpCtx(ChoosingConnectionNamePanel.class);
    private boolean blockEventListener = false;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public ChoosingConnectionNamePanel(int stepIndex) {
        this.stepIndex = stepIndex;
    }

    public Component getComponent() {
        if (this.component == null) {
            if (this.pw == null) {
                return null;
            }
            assert (this.pw != null) : "ChoosingConnectionNamePanel must be initialized.";
            this.component = new ConnectionNamePanel(this.pw, this.pw.getDatabaseConnection().getDisplayName());
            this.component.setName(this.pw.getSteps()[this.stepIndex]);
            this.component.addPropertyChangeListener("ConnectionName", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    ChoosingConnectionNamePanel.this.fireChangeEvent();
                }
            });
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return CHOOSING_SCHEMA_PANEL_HELPCTX;
    }

    public boolean isValid() {
        return this.component != null && !this.component.getConntionName().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        if (this.blockEventListener) {
            return;
        }
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void readSettings(AddConnectionWizard settings) {
        this.pw = settings;
        this.blockEventListener = true;
        ((ConnectionNamePanel)this.getComponent()).setConnectionName(this.pw.getDatabaseConnection().getDisplayName());
        this.blockEventListener = false;
    }

    public void storeSettings(AddConnectionWizard settings) {
        this.pw.getDatabaseConnection().setDisplayName(((ConnectionNamePanel)this.getComponent()).getConntionName());
    }
}

