/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.source.tree.Tree;
import javax.lang.model.type.TypeKind;
import nbjavac.ExactConversionsSupport;

public enum TypeTag {
    BYTE(1, 125, true),
    CHAR(2, 122, true),
    SHORT(4, 124, true),
    LONG(16, 112, true),
    FLOAT(32, 96, true),
    INT(8, 120, true),
    DOUBLE(64, 64, true),
    BOOLEAN(0, 0, true),
    VOID,
    CLASS,
    ARRAY,
    METHOD,
    PACKAGE,
    MODULE,
    TYPEVAR,
    WILDCARD,
    FORALL,
    DEFERRED,
    BOT,
    NONE,
    ERROR,
    UNDETVAR,
    UNINITIALIZED_THIS,
    UNINITIALIZED_OBJECT;

    final int superClasses;
    final int numericClass;
    final boolean isPrimitive;

    private TypeTag() {
        this(0, 0, false);
    }

    private TypeTag(int numericClass, int superClasses, boolean isPrimitive) {
        this.superClasses = superClasses;
        this.numericClass = numericClass;
        this.isPrimitive = isPrimitive;
    }

    public boolean isStrictSubRangeOf(TypeTag tag) {
        return (this.superClasses & tag.numericClass) != 0 && this != tag;
    }

    public boolean isSubRangeOf(TypeTag tag) {
        return (this.superClasses & tag.numericClass) != 0;
    }

    public boolean isInSuperClassesOf(TypeTag tag) {
        return (this.numericClass & tag.superClasses) != 0;
    }

    public boolean isNumeric() {
        return this.numericClass != 0;
    }

    public static int getTypeTagCount() {
        return UNDETVAR.ordinal() + 1;
    }

    public Tree.Kind getKindLiteral() {
        switch (this.ordinal()) {
            case 5: {
                return Tree.Kind.INT_LITERAL;
            }
            case 3: {
                return Tree.Kind.LONG_LITERAL;
            }
            case 4: {
                return Tree.Kind.FLOAT_LITERAL;
            }
            case 6: {
                return Tree.Kind.DOUBLE_LITERAL;
            }
            case 7: {
                return Tree.Kind.BOOLEAN_LITERAL;
            }
            case 1: {
                return Tree.Kind.CHAR_LITERAL;
            }
            case 9: {
                return Tree.Kind.STRING_LITERAL;
            }
            case 18: {
                return Tree.Kind.NULL_LITERAL;
            }
        }
        throw new AssertionError((Object)("unknown literal kind " + (Object)((Object)this)));
    }

    public TypeKind getPrimitiveTypeKind() {
        switch (this.ordinal()) {
            case 7: {
                return TypeKind.BOOLEAN;
            }
            case 0: {
                return TypeKind.BYTE;
            }
            case 2: {
                return TypeKind.SHORT;
            }
            case 5: {
                return TypeKind.INT;
            }
            case 3: {
                return TypeKind.LONG;
            }
            case 1: {
                return TypeKind.CHAR;
            }
            case 4: {
                return TypeKind.FLOAT;
            }
            case 6: {
                return TypeKind.DOUBLE;
            }
            case 8: {
                return TypeKind.VOID;
            }
        }
        throw new AssertionError((Object)("unknown primitive type " + (Object)((Object)this)));
    }

    public boolean checkRange(int value) {
        switch (this.ordinal()) {
            case 7: {
                return 0 <= value && value <= 1;
            }
            case 0: {
                return ExactConversionsSupport.isIntToByteExact(value);
            }
            case 1: {
                return ExactConversionsSupport.isIntToCharExact(value);
            }
            case 2: {
                return ExactConversionsSupport.isIntToShortExact(value);
            }
            case 5: {
                return true;
            }
        }
        throw new AssertionError();
    }

    public static class NumericClasses {
        public static final int BYTE_CLASS = 1;
        public static final int CHAR_CLASS = 2;
        public static final int SHORT_CLASS = 4;
        public static final int INT_CLASS = 8;
        public static final int LONG_CLASS = 16;
        public static final int FLOAT_CLASS = 32;
        public static final int DOUBLE_CLASS = 64;
        static final int BYTE_SUPERCLASSES = 125;
        static final int CHAR_SUPERCLASSES = 122;
        static final int SHORT_SUPERCLASSES = 124;
        static final int INT_SUPERCLASSES = 120;
        static final int LONG_SUPERCLASSES = 112;
        static final int FLOAT_SUPERCLASSES = 96;
    }
}

