/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.DeferredCompletionFailureHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.processing.JavacFiler;
import com.sun.tools.javac.processing.JavacMessager;
import com.sun.tools.javac.processing.JavacRoundEnvironment;
import com.sun.tools.javac.processing.PrintingProcessor;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Iterators;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MatchingUtils;
import com.sun.tools.javac.util.ModuleHelper;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner14;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import nbjavac.ModuleWrapper;
import nbjavac.ServiceLoaderWrapper;

public class JavacProcessingEnvironment
implements ProcessingEnvironment,
Closeable {
    private final Options options;
    private final boolean printProcessorInfo;
    private final boolean printRounds;
    private final boolean verbose;
    private final boolean fatalErrors;
    private final boolean werror;
    private final boolean showResolveErrors;
    private final JavacFiler filer;
    private final JavacMessager messager;
    private final JavacElements elementUtils;
    private final JavacTypes typeUtils;
    private final JavaCompiler compiler;
    private final Modules modules;
    private final Types types;
    private final Annotate annotate;
    private DiscoveredProcessors discoveredProcs;
    private final Map<String, String> processorOptions;
    private final Set<String> unmatchedProcessorOptions;
    private final Set<String> platformAnnotations;
    private Set<Symbol.PackageSymbol> specifiedPackages = Collections.emptySet();
    final Log log;
    JCDiagnostic.Factory diags;
    Source source;
    private ClassLoader processorClassLoader;
    private ServiceLoader<Processor> serviceLoader;
    private final JavaFileManager fileManager;
    private JavacMessages messages;
    private MultiTaskListener taskListener;
    private final Symtab symtab;
    private final DeferredCompletionFailureHandler dcfh;
    private final Names names;
    private final Enter enter;
    private final Symbol.Completer initialCompleter;
    private final Check chk;
    private final Context context;
    private final Preview preview;
    private final TreeScanner treeCleaner = new TreeScanner(){
        JCTree.JCCompilationUnit topLevel;

        @Override
        public void scan(JCTree node) {
            super.scan(node);
            if (node != null) {
                node.type = null;
            }
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit node) {
            if (node.packge != null) {
                if (JavacProcessingEnvironment.this.isPkgInfo(node.sourcefile, JavaFileObject.Kind.SOURCE)) {
                    node.packge.package_info.reset();
                }
                node.packge.reset();
            }
            if (JavacProcessingEnvironment.this.isModuleInfo(node.sourcefile, JavaFileObject.Kind.SOURCE)) {
                node.modle.reset();
                node.modle.completer = sym -> JavacProcessingEnvironment.this.modules.enter(List.of(node), node.modle.module_info);
                node.modle.module_info.reset();
                node.modle.module_info.members_field = Scope.WriteableScope.create(node.modle.module_info);
            }
            node.packge = null;
            this.topLevel = node;
            try {
                super.visitTopLevel(node);
            }
            finally {
                this.topLevel = null;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl node) {
            super.visitClassDef(node);
            List<JCTree> beforeConstructor = List.nil();
            List<JCTree> defs = node.defs;
            while (defs.nonEmpty() && !((JCTree)defs.head).hasTag(JCTree.Tag.METHODDEF)) {
                beforeConstructor = beforeConstructor.prepend((JCTree)defs.head);
                defs = defs.tail;
            }
            if (defs.nonEmpty() && (((JCTree.JCMethodDecl)defs.head).mods.flags & 0x1000000000L) != 0L) {
                defs = defs.tail;
                while (beforeConstructor.nonEmpty()) {
                    defs = defs.prepend((JCTree)beforeConstructor.head);
                    beforeConstructor = beforeConstructor.tail;
                }
                node.defs = defs;
            }
            if (node.sym != null) {
                node.sym.completer = new ImplicitCompleter(this.topLevel);
                java.util.List recordComponents = node.sym.getRecordComponents();
                for (Symbol.RecordComponent rc : recordComponents) {
                    List<JCTree.JCAnnotation> originalAnnos = rc.getOriginalAnnos();
                    originalAnnos.forEach(a -> this.visitAnnotation((JCTree.JCAnnotation)a));
                }
                node.sym.clearPermittedSubclasses();
            }
            node.sym = null;
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl node) {
            if (TreeInfo.isConstructor(node) && node.sym != null && node.sym.owner.isEnum() && node.body != null && node.body.stats.nonEmpty() && TreeInfo.isSuperCall((JCTree)node.body.stats.head) && ((JCTree.JCStatement)node.body.stats.head).pos == node.body.pos) {
                node.body.stats = node.body.stats.tail;
            }
            node.sym = null;
            super.visitMethodDef(node);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl node) {
            node.sym = null;
            super.visitVarDef(node);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass node) {
            node.constructor = null;
            super.visitNewClass(node);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp node) {
            node.operator = null;
            super.visitAssignop(node);
        }

        @Override
        public void visitUnary(JCTree.JCUnary node) {
            node.operator = null;
            super.visitUnary(node);
        }

        @Override
        public void visitBinary(JCTree.JCBinary node) {
            node.operator = null;
            super.visitBinary(node);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess node) {
            node.sym = null;
            super.visitSelect(node);
        }

        @Override
        public void visitIdent(JCTree.JCIdent node) {
            node.sym = null;
            super.visitIdent(node);
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation node) {
            node.attribute = null;
            super.visitAnnotation(node);
        }
    };
    public static final Pattern noMatches = Pattern.compile("(\\P{all})+");

    public static JavacProcessingEnvironment instance(Context context) {
        JavacProcessingEnvironment instance = context.get(JavacProcessingEnvironment.class);
        if (instance == null) {
            instance = new JavacProcessingEnvironment(context);
        }
        return instance;
    }

    protected JavacProcessingEnvironment(Context context) {
        this.context = context;
        context.put(JavacProcessingEnvironment.class, this);
        this.log = Log.instance(context);
        this.source = Source.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.options = Options.instance(context);
        this.printProcessorInfo = this.options.isSet(Option.XPRINTPROCESSORINFO);
        this.printRounds = this.options.isSet(Option.XPRINTROUNDS);
        this.verbose = this.options.isSet(Option.VERBOSE);
        this.compiler = JavaCompiler.instance(context);
        if (this.options.isSet(Option.PROC, "only") || this.options.isSet(Option.XPRINT)) {
            this.compiler.shouldStopPolicyIfNoError = CompileStates.CompileState.PROCESS;
        }
        this.fatalErrors = this.options.isSet("fatalEnterError");
        this.showResolveErrors = this.options.isSet("showResolveErrors");
        this.werror = this.compiler.isWerror(Lint.LintCategory.PROCESSING);
        this.fileManager = context.get(JavaFileManager.class);
        this.platformAnnotations = this.initPlatformAnnotations();
        this.filer = new JavacFiler(context);
        this.messager = new JavacMessager(context, this);
        this.elementUtils = JavacElements.instance(context);
        this.typeUtils = JavacTypes.instance(context);
        this.modules = Modules.instance(context);
        this.types = Types.instance(context);
        this.annotate = Annotate.instance(context);
        this.processorOptions = this.initProcessorOptions();
        this.unmatchedProcessorOptions = this.initUnmatchedProcessorOptions();
        this.messages = JavacMessages.instance(context);
        this.taskListener = MultiTaskListener.instance(context);
        this.symtab = Symtab.instance(context);
        this.dcfh = DeferredCompletionFailureHandler.instance(context);
        this.names = Names.instance(context);
        this.enter = Enter.instance(context);
        this.initialCompleter = ClassFinder.instance(context).getCompleter();
        this.chk = Check.instance(context);
        this.preview = Preview.instance(context);
        this.initProcessorLoader();
    }

    public void setProcessors(Iterable<? extends Processor> processors) {
        Assert.checkNull(this.discoveredProcs);
        this.initProcessorIterator(processors);
    }

    private Set<String> initPlatformAnnotations() {
        String module_prefix = Source.Feature.MODULES.allowedInSource(this.source) ? "java.base/" : "";
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(module_prefix + "java.lang.Deprecated", module_prefix + "java.lang.FunctionalInterface", module_prefix + "java.lang.Override", module_prefix + "java.lang.SafeVarargs", module_prefix + "java.lang.SuppressWarnings", module_prefix + "java.lang.annotation.Documented", module_prefix + "java.lang.annotation.Inherited", module_prefix + "java.lang.annotation.Native", module_prefix + "java.lang.annotation.Repeatable", module_prefix + "java.lang.annotation.Retention", module_prefix + "java.lang.annotation.Target", module_prefix + "java.io.Serial")));
    }

    private void initProcessorLoader() {
        if (this.fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH)) {
            try {
                this.serviceLoader = this.fileManager.getServiceLoader(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, Processor.class);
            }
            catch (IOException e) {
                throw new Abort(e);
            }
        } else {
            ClassLoader classLoader;
            ClassLoader classLoader2 = this.processorClassLoader = this.fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? this.fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH) : this.fileManager.getClassLoader(StandardLocation.CLASS_PATH);
            if (this.options.isSet("accessInternalAPI")) {
                ModuleHelper.addExports(ModuleWrapper.getModule(this.getClass()), ModuleWrapper.getUnnamedModule(this.processorClassLoader));
            }
            if (this.processorClassLoader != null && (classLoader = this.processorClassLoader) instanceof Closeable) {
                Closeable closeable = (Closeable)((Object)classLoader);
                this.compiler.closeables = this.compiler.closeables.prepend(closeable);
            }
        }
    }

    private void initProcessorIterator(Iterable<? extends Processor> processors) {
        Iterator<Processor> processorIterator;
        if (this.options.isSet(Option.XPRINT)) {
            try {
                processorIterator = List.of(new PrintingProcessor()).iterator();
            }
            catch (Throwable t) {
                throw new AssertionError("Problem instantiating PrintingProcessor.", t);
            }
        } else if (processors != null) {
            processorIterator = processors.iterator();
        } else {
            String processorNames = this.options.get(Option.PROCESSOR);
            processorIterator = this.fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH) ? (processorNames == null ? new ServiceIterator(this.serviceLoader, this.log) : new NameServiceIterator(this.serviceLoader, this.log, processorNames)) : (processorNames != null ? new NameProcessIterator(processorNames, this.processorClassLoader, this.log) : new ServiceIterator(this.processorClassLoader, this.log));
        }
        PlatformDescription platformProvider = this.context.get(PlatformDescription.class);
        java.util.List platformProcessors = Collections.emptyList();
        if (platformProvider != null) {
            platformProcessors = platformProvider.getAnnotationProcessors().stream().map(PlatformDescription.PluginInfo::getPlugin).collect(Collectors.toList());
        }
        List iterators = List.of(processorIterator, platformProcessors.iterator());
        Iterator compoundIterator = Iterators.createCompoundIterator(iterators, i -> i);
        this.discoveredProcs = new DiscoveredProcessors(compoundIterator);
    }

    public <S> ServiceLoader<S> getServiceLoader(Class<S> service) {
        if (this.fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH)) {
            try {
                return this.fileManager.getServiceLoader(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, service);
            }
            catch (IOException e) {
                throw new Abort(e);
            }
        }
        return ServiceLoaderWrapper.loadWithClassLoader(service, this.getProcessorClassLoader());
    }

    public boolean atLeastOneProcessor() {
        return this.discoveredProcs.iterator().hasNext();
    }

    private Map<String, String> initProcessorOptions() {
        Set<String> keySet = this.options.keySet();
        LinkedHashMap<String, String> tempOptions = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            if (!key.startsWith("-A") || key.length() <= 2) continue;
            int sepIndex = key.indexOf(61);
            String candidateKey = null;
            String candidateValue = null;
            if (sepIndex == -1) {
                candidateKey = key.substring(2);
            } else if (sepIndex >= 3) {
                candidateKey = key.substring(2, sepIndex);
                candidateValue = sepIndex < key.length() - 1 ? key.substring(sepIndex + 1) : null;
            }
            tempOptions.put(candidateKey, candidateValue);
        }
        PlatformDescription platformProvider = this.context.get(PlatformDescription.class);
        if (platformProvider != null) {
            for (PlatformDescription.PluginInfo<Processor> ap : platformProvider.getAnnotationProcessors()) {
                tempOptions.putAll(ap.getOptions());
            }
        }
        return Collections.unmodifiableMap(tempOptions);
    }

    private Set<String> initUnmatchedProcessorOptions() {
        HashSet<String> unmatchedProcessorOptions = new HashSet<String>();
        unmatchedProcessorOptions.addAll(this.processorOptions.keySet());
        return unmatchedProcessorOptions;
    }

    private void discoverAndRunProcs(Set<TypeElement> annotationsPresent, List<Symbol.ClassSymbol> topLevelClasses, List<Symbol.PackageSymbol> packageInfoFiles, List<Symbol.ModuleSymbol> moduleInfoFiles) {
        HashMap<String, TypeElement> unmatchedAnnotations = new HashMap<String, TypeElement>(annotationsPresent.size());
        for (TypeElement a : annotationsPresent) {
            ModuleElement mod = this.elementUtils.getModuleOf(a);
            String moduleSpec = Source.Feature.MODULES.allowedInSource(this.source) && mod != null ? mod.getQualifiedName() + "/" : "";
            unmatchedAnnotations.put(moduleSpec + a.getQualifiedName().toString(), a);
        }
        if (unmatchedAnnotations.size() == 0) {
            unmatchedAnnotations.put("", null);
        }
        DiscoveredProcessors.ProcessorStateIterator psi = this.discoveredProcs.iterator();
        Set<Symbol.TypeSymbol> rootElements = new LinkedHashSet<Symbol.TypeSymbol>();
        rootElements.addAll(topLevelClasses);
        rootElements.addAll(packageInfoFiles);
        rootElements.addAll(moduleInfoFiles);
        rootElements = Collections.unmodifiableSet(rootElements);
        JavacRoundEnvironment renv = new JavacRoundEnvironment(false, false, rootElements, this);
        while (unmatchedAnnotations.size() > 0 && psi.hasNext()) {
            ProcessorState ps = psi.next();
            HashSet<String> matchedNames = new HashSet<String>();
            LinkedHashSet<TypeElement> typeElements = new LinkedHashSet<TypeElement>();
            for (Map.Entry entry : unmatchedAnnotations.entrySet()) {
                String unmatchedAnnotationName = (String)entry.getKey();
                if (!ps.annotationSupported(unmatchedAnnotationName)) continue;
                matchedNames.add(unmatchedAnnotationName);
                TypeElement te = (TypeElement)entry.getValue();
                if (te == null) continue;
                typeElements.add(te);
            }
            if (matchedNames.size() <= 0 && !ps.contributed) continue;
            boolean processingResult = this.callProcessor(ps.processor, typeElements, renv);
            ps.contributed = true;
            ps.removeSupportedOptions(this.unmatchedProcessorOptions);
            if (this.printProcessorInfo || this.verbose) {
                this.log.printLines("x.print.processor.info", ps.processor.getClass().getName(), ((Object)matchedNames).toString(), processingResult);
            }
            if (!processingResult) continue;
            unmatchedAnnotations.keySet().removeAll(matchedNames);
        }
        unmatchedAnnotations.remove("");
        if (unmatchedAnnotations.size() > 0) {
            unmatchedAnnotations.keySet().removeAll(this.platformAnnotations);
            if (unmatchedAnnotations.size() > 0) {
                this.log.warning(CompilerProperties.LintWarnings.ProcAnnotationsWithoutProcessors(unmatchedAnnotations.keySet()));
            }
        }
        psi.runContributingProcs(renv);
    }

    private boolean callProcessor(Processor proc, Set<? extends TypeElement> tes, RoundEnvironment renv) {
        DeferredCompletionFailureHandler.Handler prevDeferredHandler = this.dcfh.setHandler(this.dcfh.userCodeHandler);
        try {
            boolean bl = proc.process(tes, renv);
            return bl;
        }
        catch (ClassFinder.BadClassFile ex) {
            this.log.error(CompilerProperties.Errors.ProcCantAccess1(ex.sym, ex.getDetailValue()));
            boolean bl = false;
            return bl;
        }
        catch (Symbol.CompletionFailure ex) {
            StringWriter out = new StringWriter();
            ex.printStackTrace(new PrintWriter(out));
            this.log.error(CompilerProperties.Errors.ProcCantAccess(ex.sym, ex.getDetailValue(), out.toString()));
            boolean bl = false;
            return bl;
        }
        catch (ClientCodeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AnnotationProcessingError(t);
        }
        finally {
            this.dcfh.setHandler(prevDeferredHandler);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean doProcessing(List<JCTree.JCCompilationUnit> roots, List<Symbol.ClassSymbol> classSymbols, Iterable<? extends Symbol.PackageSymbol> pckSymbols, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Round round;
        boolean bl4;
        boolean moreToDo;
        Set<JCTree.JCCompilationUnit> treesToClean = Collections.newSetFromMap(new IdentityHashMap());
        for (Env<AttrContext> env : this.enter.getEnvs()) {
            treesToClean.add(env.toplevel);
        }
        LinkedHashSet<Symbol.PackageSymbol> specifiedPackages = new LinkedHashSet<Symbol.PackageSymbol>();
        for (Symbol.PackageSymbol packageSymbol : pckSymbols) {
            specifiedPackages.add(packageSymbol);
        }
        this.specifiedPackages = Collections.unmodifiableSet(specifiedPackages);
        Round round2 = new Round(roots, classSymbols, treesToClean, deferredDiagnosticHandler);
        do {
            void var7_10;
            var7_10.run(false, false);
            bl4 = var7_10.unrecoverableError();
            moreToDo = this.moreToDo();
            var7_10.showDiagnostics(this.showResolveErrors);
            round = var7_10.next(new LinkedHashSet<JavaFileObject>(this.filer.getGeneratedSourceFileObjects()), new LinkedHashMap<Symbol.ModuleSymbol, Map<String, JavaFileObject>>(this.filer.getGeneratedClasses()));
            if (!round.unrecoverableError()) continue;
            bl4 = true;
        } while (moreToDo && !bl4);
        round.run(true, bl4);
        round.showDiagnostics(true);
        this.filer.warnIfUnclosedFiles();
        this.warnIfUnmatchedOptions();
        if (this.messager.errorRaised() || this.werror && round.warningCount() > 0 && round.errorCount() > 0) {
            bl3 = true;
        }
        LinkedHashSet<JavaFileObject> newSourceFiles = new LinkedHashSet<JavaFileObject>(this.filer.getGeneratedSourceFileObjects());
        roots = round.roots;
        boolean bl5 = bl2 = bl3 || this.compiler.errorCount() > 0;
        if (newSourceFiles.size() > 0) {
            roots = roots.appendList(this.compiler.parseFiles(newSourceFiles));
        }
        boolean bl6 = bl = bl2 || this.compiler.errorCount() > 0;
        if (bl && this.compiler.errorCount() == 0) {
            ++this.compiler.log.nerrors;
        }
        if (this.compiler.continueAfterProcessAnnotations()) {
            round.finalCompiler();
            this.compiler.enterTrees(this.compiler.initModules(roots));
        } else {
            this.compiler.todo.clear();
        }
        this.close();
        if (!this.taskListener.isEmpty()) {
            this.taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING));
        }
        return true;
    }

    private void warnIfUnmatchedOptions() {
        if (!this.unmatchedProcessorOptions.isEmpty()) {
            this.log.warning(CompilerProperties.Warnings.ProcUnmatchedProcessorOptions(this.unmatchedProcessorOptions.toString()));
        }
    }

    @Override
    public void close() {
        this.filer.close();
        if (this.discoveredProcs != null) {
            this.discoveredProcs.close();
        }
        this.discoveredProcs = null;
    }

    private List<Symbol.ClassSymbol> getTopLevelClasses(List<? extends JCTree.JCCompilationUnit> units) {
        List<Symbol.ClassSymbol> classes = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : units) {
            for (JCTree node : jCCompilationUnit.defs) {
                if (!node.hasTag(JCTree.Tag.CLASSDEF)) continue;
                Symbol.ClassSymbol sym = ((JCTree.JCClassDecl)node).sym;
                Assert.checkNonNull(sym);
                classes = classes.prepend(sym);
            }
        }
        return classes.reverse();
    }

    private List<Symbol.ClassSymbol> getTopLevelClassesFromClasses(List<? extends Symbol.ClassSymbol> syms) {
        List<Symbol.ClassSymbol> classes = List.nil();
        for (Symbol.ClassSymbol classSymbol : syms) {
            if (this.isPkgInfo(classSymbol)) continue;
            classes = classes.prepend(classSymbol);
        }
        return classes.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFiles(List<? extends JCTree.JCCompilationUnit> units) {
        List<Symbol.PackageSymbol> packages = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : units) {
            if (!this.isPkgInfo(jCCompilationUnit.sourcefile, JavaFileObject.Kind.SOURCE)) continue;
            packages = packages.prepend(jCCompilationUnit.packge);
        }
        return packages.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFilesFromClasses(List<? extends Symbol.ClassSymbol> syms) {
        List<Symbol.PackageSymbol> packages = List.nil();
        for (Symbol.ClassSymbol classSymbol : syms) {
            if (!this.isPkgInfo(classSymbol)) continue;
            packages = packages.prepend((Symbol.PackageSymbol)classSymbol.owner);
        }
        return packages.reverse();
    }

    private List<Symbol.ModuleSymbol> getModuleInfoFiles(List<? extends JCTree.JCCompilationUnit> units) {
        List<Symbol.ModuleSymbol> modules = List.nil();
        block0: for (JCTree.JCCompilationUnit jCCompilationUnit : units) {
            if (!this.isModuleInfo(jCCompilationUnit.sourcefile, JavaFileObject.Kind.SOURCE) || !jCCompilationUnit.defs.nonEmpty()) continue;
            for (JCTree tree : jCCompilationUnit.defs) {
                if (tree.hasTag(JCTree.Tag.IMPORT)) continue;
                if (!tree.hasTag(JCTree.Tag.MODULEDEF)) continue block0;
                modules = modules.prepend(jCCompilationUnit.modle);
                continue block0;
            }
        }
        return modules.reverse();
    }

    private static <T> List<T> join(List<T> list1, List<T> list2) {
        return list1.appendList(list2);
    }

    private boolean isPkgInfo(JavaFileObject fo, JavaFileObject.Kind kind) {
        return fo.isNameCompatible("package-info", kind);
    }

    private boolean isPkgInfo(Symbol.ClassSymbol sym) {
        return this.isPkgInfo(sym.classfile, JavaFileObject.Kind.CLASS) && sym.packge().package_info == sym;
    }

    private boolean isModuleInfo(JavaFileObject fo, JavaFileObject.Kind kind) {
        return fo.isNameCompatible("module-info", kind);
    }

    private boolean moreToDo() {
        return this.filer.newFiles();
    }

    @Override
    public Map<String, String> getOptions() {
        return this.processorOptions;
    }

    @Override
    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public JavacFiler getFiler() {
        return this.filer;
    }

    @Override
    public JavacElements getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public JavacTypes getTypeUtils() {
        return this.typeUtils;
    }

    @Override
    public SourceVersion getSourceVersion() {
        return Source.toSourceVersion(this.source);
    }

    @Override
    public Locale getLocale() {
        return this.messages.getCurrentLocale();
    }

    @Override
    public boolean isPreviewEnabled() {
        return this.preview.isEnabled();
    }

    public Set<Symbol.PackageSymbol> getSpecifiedPackages() {
        return this.specifiedPackages;
    }

    private static Pattern importStringToPattern(boolean allowModules, String s, Processor p, Log log) {
        String pkg;
        String module;
        int slash = s.indexOf(47);
        if (slash == -1) {
            if (s.equals("*")) {
                return MatchingUtils.validImportStringToPattern(s);
            }
            module = allowModules ? ".*/" : "";
            pkg = s;
        } else {
            String moduleName = s.substring(0, slash);
            if (!SourceVersion.isName(moduleName)) {
                return JavacProcessingEnvironment.warnAndNoMatches(s, p, log);
            }
            module = Pattern.quote(moduleName + "/");
            pkg = s.substring(slash + 1);
        }
        if (MatchingUtils.isValidImportString(pkg)) {
            return Pattern.compile(module + MatchingUtils.validImportStringToPatternString(pkg));
        }
        return JavacProcessingEnvironment.warnAndNoMatches(s, p, log);
    }

    private static Pattern warnAndNoMatches(String s, Processor p, Log log) {
        log.warning(CompilerProperties.LintWarnings.ProcMalformedSupportedString(s, p.getClass().getName()));
        return noMatches;
    }

    public Context getContext() {
        return this.context;
    }

    public ClassLoader getProcessorClassLoader() {
        return this.processorClassLoader;
    }

    public String toString() {
        return "javac ProcessingEnvironment";
    }

    public static boolean isValidOptionName(String optionName) {
        for (String s : optionName.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    class DiscoveredProcessors
    implements Iterable<ProcessorState> {
        Iterator<? extends Processor> processorIterator;
        ArrayList<ProcessorState> procStateList;

        public ProcessorStateIterator iterator() {
            return new ProcessorStateIterator(this);
        }

        DiscoveredProcessors(Iterator<? extends Processor> processorIterator) {
            this.processorIterator = processorIterator;
            this.procStateList = new ArrayList();
        }

        public void close() {
            Iterator<? extends Processor> iterator;
            if (this.processorIterator != null && (iterator = this.processorIterator) instanceof ServiceIterator) {
                ServiceIterator serviceIterator = (ServiceIterator)iterator;
                serviceIterator.close();
            }
        }

        class ProcessorStateIterator
        implements Iterator<ProcessorState> {
            DiscoveredProcessors psi;
            Iterator<ProcessorState> innerIter;
            boolean onProcIterator;

            ProcessorStateIterator(DiscoveredProcessors psi) {
                this.psi = psi;
                this.innerIter = psi.procStateList.iterator();
                this.onProcIterator = false;
            }

            @Override
            public ProcessorState next() {
                if (!this.onProcIterator) {
                    if (this.innerIter.hasNext()) {
                        return this.innerIter.next();
                    }
                    this.onProcIterator = true;
                }
                if (this.psi.processorIterator.hasNext()) {
                    ProcessorState ps = new ProcessorState(this.psi.processorIterator.next(), JavacProcessingEnvironment.this.log, JavacProcessingEnvironment.this.source, JavacProcessingEnvironment.this.dcfh, Source.Feature.MODULES.allowedInSource(JavacProcessingEnvironment.this.source), JavacProcessingEnvironment.this);
                    this.psi.procStateList.add(ps);
                    return ps;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.onProcIterator) {
                    return this.psi.processorIterator.hasNext();
                }
                return this.innerIter.hasNext() || this.psi.processorIterator.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void runContributingProcs(RoundEnvironment re) {
                if (!this.onProcIterator) {
                    Set emptyTypeElements = Collections.emptySet();
                    while (this.innerIter.hasNext()) {
                        ProcessorState ps = this.innerIter.next();
                        if (!ps.contributed) continue;
                        JavacProcessingEnvironment.this.callProcessor(ps.processor, emptyTypeElements, re);
                    }
                }
            }
        }
    }

    private class ServiceIterator
    implements Iterator<Processor> {
        Iterator<Processor> iterator;
        Log log;
        ServiceLoader<Processor> loader;

        ServiceIterator(ClassLoader classLoader, Log log) {
            this.log = log;
            try {
                this.loader = ServiceLoaderWrapper.loadWithClassLoader(Processor.class, classLoader);
                this.iterator = this.loader.iterator();
            }
            catch (Throwable t) {
                log.error(CompilerProperties.Errors.ProcServiceProblem);
                throw new Abort(t);
            }
        }

        ServiceIterator(ServiceLoader<Processor> loader, Log log) {
            this.log = log;
            this.loader = loader;
            this.iterator = loader.iterator();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.internalHasNext();
            }
            catch (ServiceConfigurationError sce) {
                this.log.error(CompilerProperties.Errors.ProcBadConfigFile(sce.getLocalizedMessage()));
                throw new Abort(sce);
            }
            catch (UnsupportedClassVersionError ucve) {
                this.log.error(CompilerProperties.Errors.ProcCantLoadClass(ucve.getLocalizedMessage()));
                throw new Abort(ucve);
            }
            catch (ClassFormatError cfe) {
                this.log.error(CompilerProperties.Errors.ProcCantLoadClass(cfe.getLocalizedMessage()));
                throw new Abort(cfe);
            }
            catch (Throwable t) {
                this.log.error(CompilerProperties.Errors.ProcBadConfigFile(t.getLocalizedMessage()));
                throw new Abort(t);
            }
        }

        boolean internalHasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Processor next() {
            try {
                return this.internalNext();
            }
            catch (ServiceConfigurationError sce) {
                this.log.error(CompilerProperties.Errors.ProcBadConfigFile(sce.getLocalizedMessage()));
                throw new Abort(sce);
            }
            catch (Throwable t) {
                this.log.error(CompilerProperties.Errors.ProcBadConfigFile(t.getLocalizedMessage()));
                throw new Abort(t);
            }
        }

        Processor internalNext() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            if (this.loader != null) {
                try {
                    this.loader.reload();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class NameServiceIterator
    extends ServiceIterator {
        private Map<String, Processor> namedProcessorsMap;
        private Iterator<String> processorNames;
        private Processor nextProc;

        public NameServiceIterator(ServiceLoader<Processor> loader, Log log, String theNames) {
            super(loader, log);
            this.namedProcessorsMap = new HashMap<String, Processor>();
            this.processorNames = null;
            this.nextProc = null;
            this.processorNames = Arrays.asList(theNames.split(",")).iterator();
        }

        @Override
        boolean internalHasNext() {
            if (this.nextProc != null) {
                return true;
            }
            if (!this.processorNames.hasNext()) {
                this.namedProcessorsMap = null;
                return false;
            }
            String processorName = this.processorNames.next();
            Processor theProcessor = this.namedProcessorsMap.get(processorName);
            if (theProcessor != null) {
                this.namedProcessorsMap.remove(processorName);
                this.nextProc = theProcessor;
                return true;
            }
            while (this.iterator.hasNext()) {
                theProcessor = (Processor)this.iterator.next();
                String name = theProcessor.getClass().getName();
                if (name.equals(processorName)) {
                    this.nextProc = theProcessor;
                    return true;
                }
                this.namedProcessorsMap.put(name, theProcessor);
            }
            this.log.error(CompilerProperties.Errors.ProcProcessorNotFound(processorName));
            return false;
        }

        @Override
        Processor internalNext() {
            if (this.hasNext()) {
                Processor p = this.nextProc;
                this.nextProc = null;
                return p;
            }
            throw new NoSuchElementException();
        }
    }

    private static class NameProcessIterator
    implements Iterator<Processor> {
        Processor nextProc = null;
        Iterator<String> names;
        ClassLoader processorCL;
        Log log;

        NameProcessIterator(String names, ClassLoader processorCL, Log log) {
            this.names = Arrays.asList(names.split(",")).iterator();
            this.processorCL = processorCL;
            this.log = log;
        }

        @Override
        public boolean hasNext() {
            if (this.nextProc != null) {
                return true;
            }
            if (!this.names.hasNext()) {
                return false;
            }
            Processor processor = this.getNextProcessor(this.names.next());
            if (processor == null) {
                return false;
            }
            this.nextProc = processor;
            return true;
        }

        private Processor getNextProcessor(String processorName) {
            try {
                try {
                    Class<?> processorClass = this.processorCL.loadClass(processorName);
                    this.ensureReadable(processorClass);
                    return (Processor)processorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.error(CompilerProperties.Errors.ProcProcessorNotFound(processorName));
                    return null;
                }
                catch (ClassCastException cce) {
                    this.log.error(CompilerProperties.Errors.ProcProcessorWrongType(processorName));
                    return null;
                }
                catch (Exception e) {
                    this.log.error(CompilerProperties.Errors.ProcProcessorCantInstantiate(processorName));
                    return null;
                }
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new AnnotationProcessingError(t);
            }
        }

        @Override
        public Processor next() {
            if (this.hasNext()) {
                Processor p = this.nextProc;
                this.nextProc = null;
                return p;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void ensureReadable(Class<?> targetClass) {
            try {
                Method getModuleMethod = Class.class.getMethod("getModule", new Class[0]);
                Object thisModule = getModuleMethod.invoke(this.getClass(), new Object[0]);
                Object targetModule = getModuleMethod.invoke(targetClass, new Object[0]);
                Class<?> moduleClass = getModuleMethod.getReturnType();
                Method addReadsMethod = moduleClass.getMethod("addReads", moduleClass);
                addReadsMethod.invoke(thisModule, targetModule);
            }
            catch (NoSuchMethodException getModuleMethod) {
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
        }
    }

    static class ProcessorState {
        public Processor processor;
        public boolean contributed;
        private Set<String> supportedAnnotationStrings;
        private Set<Pattern> supportedAnnotationPatterns;
        private Set<String> supportedOptionNames;

        ProcessorState(Processor p, Log log, Source source, DeferredCompletionFailureHandler dcfh, boolean allowModules, ProcessingEnvironment env) {
            this.processor = p;
            this.contributed = false;
            DeferredCompletionFailureHandler.Handler prevDeferredHandler = dcfh.setHandler(dcfh.userCodeHandler);
            try {
                this.processor.init(env);
                this.checkSourceVersionCompatibility(source, log);
                this.supportedAnnotationStrings = new LinkedHashSet<String>();
                this.supportedAnnotationPatterns = new LinkedHashSet<Pattern>();
                for (String annotationPattern : this.processor.getSupportedAnnotationTypes()) {
                    boolean patternAdded = this.supportedAnnotationStrings.add(annotationPattern);
                    this.supportedAnnotationPatterns.add(JavacProcessingEnvironment.importStringToPattern(allowModules, annotationPattern, this.processor, log));
                    if (patternAdded) continue;
                    log.warning(CompilerProperties.LintWarnings.ProcDuplicateSupportedAnnotation(annotationPattern, p.getClass().getName()));
                }
                if (this.supportedAnnotationPatterns.contains(MatchingUtils.validImportStringToPattern("*")) && this.supportedAnnotationPatterns.size() > 1) {
                    log.warning(CompilerProperties.LintWarnings.ProcRedundantTypesWithWildcard(p.getClass().getName()));
                }
                this.supportedOptionNames = new LinkedHashSet<String>();
                for (String optionName : this.processor.getSupportedOptions()) {
                    boolean optionAdded;
                    if (!this.checkOptionName(optionName, log) || (optionAdded = this.supportedOptionNames.add(optionName))) continue;
                    log.warning(CompilerProperties.LintWarnings.ProcDuplicateOptionName(optionName, p.getClass().getName()));
                }
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new AnnotationProcessingError(t);
            }
            finally {
                dcfh.setHandler(prevDeferredHandler);
            }
        }

        private void checkSourceVersionCompatibility(Source source, Log log) {
            SourceVersion procSourceVersion = this.processor.getSupportedSourceVersion();
            if (procSourceVersion.compareTo(Source.toSourceVersion(source)) < 0) {
                log.warning(CompilerProperties.Warnings.ProcProcessorIncompatibleSourceVersion(procSourceVersion, this.processor.getClass().getName(), source.name));
            }
        }

        private boolean checkOptionName(String optionName, Log log) {
            boolean valid = JavacProcessingEnvironment.isValidOptionName(optionName);
            if (!valid) {
                log.error(CompilerProperties.Errors.ProcProcessorBadOptionName(optionName, this.processor.getClass().getName()));
            }
            return valid;
        }

        public boolean annotationSupported(String annotationName) {
            for (Pattern p : this.supportedAnnotationPatterns) {
                if (!p.matcher(annotationName).matches()) continue;
                return true;
            }
            return false;
        }

        public void removeSupportedOptions(Set<String> unmatchedProcessorOptions) {
            unmatchedProcessorOptions.removeAll(this.supportedOptionNames);
        }
    }

    class Round {
        final int number;
        final Log.DeferredDiagnosticHandler deferredDiagnosticHandler;
        List<JCTree.JCCompilationUnit> roots;
        Set<JCTree.JCCompilationUnit> treesToClean;
        Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> genClassFiles;
        Set<TypeElement> annotationsPresent;
        List<Symbol.ClassSymbol> topLevelClasses;
        List<Symbol.PackageSymbol> packageInfoFiles;
        List<Symbol.ModuleSymbol> moduleInfoFiles;
        private final Predicate<JCDiagnostic> ACCEPT_NON_RECOVERABLE = d -> d.getKind() != Diagnostic.Kind.ERROR || !d.isFlagSet(JCDiagnostic.DiagnosticFlag.RECOVERABLE) || d.isFlagSet(JCDiagnostic.DiagnosticFlag.API);
        private final Predicate<JCDiagnostic> ACCEPT_ALL = d -> true;

        private Round(int number, Set<JCTree.JCCompilationUnit> treesToClean, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
            this.number = number;
            if (number == 1) {
                Assert.checkNonNull(deferredDiagnosticHandler);
                this.deferredDiagnosticHandler = deferredDiagnosticHandler;
            } else {
                this.deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(JavacProcessingEnvironment.this.log);
                JavacProcessingEnvironment.this.compiler.setDeferredDiagnosticHandler(this.deferredDiagnosticHandler);
            }
            this.topLevelClasses = List.nil();
            this.packageInfoFiles = List.nil();
            this.moduleInfoFiles = List.nil();
            this.treesToClean = treesToClean;
        }

        Round(List<JCTree.JCCompilationUnit> roots, List<Symbol.ClassSymbol> classSymbols, Set<JCTree.JCCompilationUnit> treesToClean, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
            this(1, treesToClean, deferredDiagnosticHandler);
            this.roots = roots;
            this.genClassFiles = new HashMap<Symbol.ModuleSymbol, Map<String, JavaFileObject>>();
            this.topLevelClasses = this$0.getTopLevelClasses(roots).prependList(classSymbols.reverse());
            this.packageInfoFiles = this$0.getPackageInfoFiles(roots);
            this.moduleInfoFiles = this$0.getModuleInfoFiles(roots);
            this.findAnnotationsPresent();
        }

        private Round(Round prev, Set<JavaFileObject> newSourceFiles, Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> newClassFiles) {
            this(prev.number + 1, prev.treesToClean, null);
            prev.newRound();
            this.genClassFiles = prev.genClassFiles;
            List<JCTree.JCCompilationUnit> parsedFiles = this$0.compiler.parseFiles(newSourceFiles, true);
            this.roots = prev.roots.appendList(parsedFiles);
            if (this.unrecoverableError()) {
                this$0.compiler.initModules(List.nil());
                return;
            }
            this.roots = this$0.compiler.initModules(this.roots);
            this.enterClassFiles(this.genClassFiles);
            List<Symbol.ClassSymbol> newClasses = this.enterClassFiles(newClassFiles);
            for (Map.Entry<Symbol.ModuleSymbol, Map<String, JavaFileObject>> moduleAndClassFiles : newClassFiles.entrySet()) {
                this.genClassFiles.computeIfAbsent(moduleAndClassFiles.getKey(), m -> new LinkedHashMap()).putAll(moduleAndClassFiles.getValue());
            }
            this.enterTrees(this.roots);
            if (this.unrecoverableError()) {
                return;
            }
            this.topLevelClasses = JavacProcessingEnvironment.join(this$0.getTopLevelClasses(parsedFiles), this$0.getTopLevelClassesFromClasses(newClasses));
            this.packageInfoFiles = JavacProcessingEnvironment.join(this$0.getPackageInfoFiles(parsedFiles), this$0.getPackageInfoFilesFromClasses(newClasses));
            this.moduleInfoFiles = List.nil();
            this.findAnnotationsPresent();
        }

        Round next(Set<JavaFileObject> newSourceFiles, Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> newClassFiles) {
            return new Round(this, newSourceFiles, newClassFiles);
        }

        void finalCompiler() {
            this.newRound();
        }

        int errorCount() {
            return JavacProcessingEnvironment.this.compiler.errorCount();
        }

        int warningCount() {
            return JavacProcessingEnvironment.this.compiler.warningCount();
        }

        boolean unrecoverableError() {
            if (JavacProcessingEnvironment.this.messager.errorRaised()) {
                return true;
            }
            return this.deferredDiagnosticHandler.getDiagnostics().stream().anyMatch(d -> d.getKind() == Diagnostic.Kind.WARNING && JavacProcessingEnvironment.this.werror || d.getKind() == Diagnostic.Kind.ERROR && (JavacProcessingEnvironment.this.fatalErrors || !d.isFlagSet(JCDiagnostic.DiagnosticFlag.RECOVERABLE)));
        }

        void findAnnotationsPresent() {
            ComputeAnnotationSet annotationComputer = new ComputeAnnotationSet(JavacProcessingEnvironment.this.elementUtils);
            this.annotationsPresent = new LinkedHashSet<TypeElement>();
            for (Symbol.ClassSymbol classSym : this.topLevelClasses) {
                annotationComputer.scan((Element)classSym, this.annotationsPresent);
            }
            for (Symbol.PackageSymbol pkgSym : this.packageInfoFiles) {
                annotationComputer.scan((Element)pkgSym, this.annotationsPresent);
            }
            for (Symbol.ModuleSymbol mdlSym : this.moduleInfoFiles) {
                annotationComputer.scan((Element)mdlSym, this.annotationsPresent);
            }
        }

        private List<Symbol.ClassSymbol> enterClassFiles(Map<Symbol.ModuleSymbol, Map<String, JavaFileObject>> modulesAndClassFiles) {
            List<Symbol.ClassSymbol> list = List.nil();
            for (Map.Entry<Symbol.ModuleSymbol, Map<String, JavaFileObject>> moduleAndClassFiles : modulesAndClassFiles.entrySet()) {
                for (Map.Entry<String, JavaFileObject> entry : moduleAndClassFiles.getValue().entrySet()) {
                    Symbol.ClassSymbol cs;
                    Name name = JavacProcessingEnvironment.this.names.fromString(entry.getKey());
                    JavaFileObject file = entry.getValue();
                    if (file.getKind() != JavaFileObject.Kind.CLASS) {
                        throw new AssertionError(file);
                    }
                    if (JavacProcessingEnvironment.this.isPkgInfo(file, JavaFileObject.Kind.CLASS)) {
                        Name packageName = Convert.packagePart(name);
                        Symbol.PackageSymbol p = JavacProcessingEnvironment.this.symtab.enterPackage(moduleAndClassFiles.getKey(), packageName);
                        if (p.package_info == null) {
                            p.package_info = JavacProcessingEnvironment.this.symtab.enterClass(moduleAndClassFiles.getKey(), Convert.shortName(name), p);
                        }
                        cs = p.package_info;
                        cs.reset();
                        if (cs.classfile == null) {
                            cs.classfile = file;
                        }
                        cs.completer = JavacProcessingEnvironment.this.initialCompleter;
                    } else {
                        cs = JavacProcessingEnvironment.this.symtab.enterClass(moduleAndClassFiles.getKey(), name);
                        cs.reset();
                        cs.classfile = file;
                        cs.completer = JavacProcessingEnvironment.this.initialCompleter;
                        if (cs.owner.kind == Kinds.Kind.PCK) {
                            cs.owner.members().enter(cs);
                        }
                    }
                    list = list.prepend(cs);
                }
            }
            return list.reverse();
        }

        private void enterTrees(List<JCTree.JCCompilationUnit> roots) {
            JavacProcessingEnvironment.this.compiler.enterTrees(roots);
        }

        void run(boolean lastRound, boolean errorStatus) {
            this.printRoundInfo(lastRound);
            if (!JavacProcessingEnvironment.this.taskListener.isEmpty()) {
                JavacProcessingEnvironment.this.taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
            }
            try {
                if (lastRound) {
                    JavacProcessingEnvironment.this.filer.setLastRound(true);
                    Set emptyRootElements = Collections.emptySet();
                    JavacRoundEnvironment renv = new JavacRoundEnvironment(true, errorStatus, emptyRootElements, JavacProcessingEnvironment.this);
                    JavacProcessingEnvironment.this.discoveredProcs.iterator().runContributingProcs(renv);
                } else {
                    JavacProcessingEnvironment.this.discoverAndRunProcs(this.annotationsPresent, this.topLevelClasses, this.packageInfoFiles, this.moduleInfoFiles);
                }
            }
            catch (Throwable t) {
                JavacProcessingEnvironment.this.compiler.reportDeferredDiagnosticAndClearHandler();
                throw t;
            }
            finally {
                if (!JavacProcessingEnvironment.this.taskListener.isEmpty()) {
                    JavacProcessingEnvironment.this.taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
                }
            }
        }

        void showDiagnostics(boolean showAll) {
            this.deferredDiagnosticHandler.reportDeferredDiagnostics(showAll ? this.ACCEPT_ALL : this.ACCEPT_NON_RECOVERABLE);
            JavacProcessingEnvironment.this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
            JavacProcessingEnvironment.this.compiler.setDeferredDiagnosticHandler(null);
        }

        private void printRoundInfo(boolean lastRound) {
            if (JavacProcessingEnvironment.this.printRounds || JavacProcessingEnvironment.this.verbose) {
                List<Object> tlc = lastRound ? List.nil() : this.topLevelClasses;
                Set<Object> ap = lastRound ? Collections.emptySet() : this.annotationsPresent;
                JavacProcessingEnvironment.this.log.printLines("x.print.rounds", this.number, "{" + tlc.toString(", ") + "}", ap, lastRound);
            }
        }

        private void newRound() {
            for (Env<AttrContext> env : JavacProcessingEnvironment.this.enter.getEnvs()) {
                this.treesToClean.add(env.toplevel);
            }
            for (JCTree.JCCompilationUnit node : this.treesToClean) {
                JavacProcessingEnvironment.this.treeCleaner.scan(node);
            }
            JavacProcessingEnvironment.this.chk.newRound();
            JavacProcessingEnvironment.this.enter.newRound();
            JavacProcessingEnvironment.this.filer.newRound();
            JavacProcessingEnvironment.this.messager.newRound();
            JavacProcessingEnvironment.this.compiler.newRound();
            JavacProcessingEnvironment.this.modules.newRound();
            JavacProcessingEnvironment.this.types.newRound();
            JavacProcessingEnvironment.this.annotate.newRound();
            JavacProcessingEnvironment.this.elementUtils.newRound();
            boolean foundError = false;
            for (Symbol.ClassSymbol cs : JavacProcessingEnvironment.this.symtab.getAllClasses()) {
                if (cs.kind != Kinds.Kind.ERR) continue;
                foundError = true;
                break;
            }
            if (foundError) {
                for (Symbol.ClassSymbol cs : JavacProcessingEnvironment.this.symtab.getAllClasses()) {
                    if (cs.classfile == null && cs.kind != Kinds.Kind.ERR) continue;
                    Kinds.Kind symKind = cs.kind;
                    cs.reset();
                    if (symKind == Kinds.Kind.ERR) {
                        cs.type = new Type.ClassType(cs.type.getEnclosingType(), null, cs);
                    }
                    if (!cs.isCompleted()) continue;
                    cs.completer = JavacProcessingEnvironment.this.initialCompleter;
                }
            }
        }
    }

    class ImplicitCompleter
    implements Symbol.Completer {
        private final JCTree.JCCompilationUnit topLevel;

        public ImplicitCompleter(JCTree.JCCompilationUnit topLevel) {
            this.topLevel = topLevel;
        }

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            JavacProcessingEnvironment.this.compiler.readSourceFile(this.topLevel, (Symbol.ClassSymbol)sym);
        }
    }

    public static class ComputeAnnotationSet
    extends ElementScanner14<Set<TypeElement>, Set<TypeElement>> {
        final Elements elements;

        public ComputeAnnotationSet(Elements elements) {
            this.elements = elements;
        }

        @Override
        public Set<TypeElement> visitPackage(PackageElement e, Set<TypeElement> p) {
            return p;
        }

        @Override
        public Set<TypeElement> visitType(TypeElement e, Set<TypeElement> p) {
            this.scan(e.getTypeParameters(), p);
            return (Set)super.visitType(e, p);
        }

        @Override
        public Set<TypeElement> visitExecutable(ExecutableElement e, Set<TypeElement> p) {
            this.scan(e.getTypeParameters(), p);
            return (Set)super.visitExecutable(e, p);
        }

        void addAnnotations(Element e, Set<TypeElement> p) {
            for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(e)) {
                Element e2 = annotationMirror.getAnnotationType().asElement();
                p.add((TypeElement)e2);
            }
        }

        @Override
        public Set<TypeElement> scan(Element e, Set<TypeElement> p) {
            this.addAnnotations(e, p);
            return (Set)super.scan(e, p);
        }
    }
}

